/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import org.apache.parquet.variant.Variant;

class VariantUtil {
    static final int BASIC_TYPE_BITS = 2;
    static final int BASIC_TYPE_MASK = 3;
    static final int PRIMITIVE_TYPE_MASK = 63;
    static final int MAX_SHORT_STR_SIZE = 63;
    static final int PRIMITIVE = 0;
    static final int SHORT_STR = 1;
    static final int OBJECT = 2;
    static final int ARRAY = 3;
    static final int NULL = 0;
    static final int TRUE = 1;
    static final int FALSE = 2;
    static final int INT8 = 3;
    static final int INT16 = 4;
    static final int INT32 = 5;
    static final int INT64 = 6;
    static final int DOUBLE = 7;
    static final int DECIMAL4 = 8;
    static final int DECIMAL8 = 9;
    static final int DECIMAL16 = 10;
    static final int DATE = 11;
    static final int TIMESTAMP_TZ = 12;
    static final int TIMESTAMP_NTZ = 13;
    static final int FLOAT = 14;
    static final int BINARY = 15;
    static final int LONG_STR = 16;
    static final int TIME = 17;
    static final int TIMESTAMP_NANOS_TZ = 18;
    static final int TIMESTAMP_NANOS_NTZ = 19;
    static final int UUID = 20;
    static final byte VERSION = 1;
    static final byte VERSION_MASK = 15;
    static final int U8_MAX = 255;
    static final int U16_MAX = 65535;
    static final int U24_MAX = 0xFFFFFF;
    static final int U8_SIZE = 1;
    static final int U16_SIZE = 2;
    static final int U24_SIZE = 3;
    static final int U32_SIZE = 4;
    static final int MAX_DECIMAL4_PRECISION = 9;
    static final int MAX_DECIMAL8_PRECISION = 18;
    static final int MAX_DECIMAL16_PRECISION = 38;
    static final int UUID_SIZE = 16;
    static final byte HEADER_NULL = VariantUtil.primitiveHeader(0);
    static final byte HEADER_LONG_STRING = VariantUtil.primitiveHeader(16);
    static final byte HEADER_TRUE = VariantUtil.primitiveHeader(1);
    static final byte HEADER_FALSE = VariantUtil.primitiveHeader(2);
    static final byte HEADER_INT8 = VariantUtil.primitiveHeader(3);
    static final byte HEADER_INT16 = VariantUtil.primitiveHeader(4);
    static final byte HEADER_INT32 = VariantUtil.primitiveHeader(5);
    static final byte HEADER_INT64 = VariantUtil.primitiveHeader(6);
    static final byte HEADER_DOUBLE = VariantUtil.primitiveHeader(7);
    static final byte HEADER_DECIMAL4 = VariantUtil.primitiveHeader(8);
    static final byte HEADER_DECIMAL8 = VariantUtil.primitiveHeader(9);
    static final byte HEADER_DECIMAL16 = VariantUtil.primitiveHeader(10);
    static final byte HEADER_DATE = VariantUtil.primitiveHeader(11);
    static final byte HEADER_TIMESTAMP_TZ = VariantUtil.primitiveHeader(12);
    static final byte HEADER_TIMESTAMP_NTZ = VariantUtil.primitiveHeader(13);
    static final byte HEADER_TIME = VariantUtil.primitiveHeader(17);
    static final byte HEADER_TIMESTAMP_NANOS_TZ = VariantUtil.primitiveHeader(18);
    static final byte HEADER_TIMESTAMP_NANOS_NTZ = VariantUtil.primitiveHeader(19);
    static final byte HEADER_FLOAT = VariantUtil.primitiveHeader(14);
    static final byte HEADER_BINARY = VariantUtil.primitiveHeader(15);
    static final byte HEADER_UUID = VariantUtil.primitiveHeader(20);

    VariantUtil() {
    }

    static byte primitiveHeader(int type) {
        return (byte)(type << 2 | 0);
    }

    static byte shortStrHeader(int size) {
        return (byte)(size << 2 | 1);
    }

    static byte objectHeader(boolean largeSize, int idSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 6 | idSize - 1 << 4 | offsetSize - 1 << 2 | 2);
    }

    static byte arrayHeader(boolean largeSize, int offsetSize) {
        return (byte)((largeSize ? 1 : 0) << 4 | offsetSize - 1 << 2 | 3);
    }

    static void checkIndex(int pos, int length) {
        if (pos < 0 || pos >= length) {
            throw new IllegalArgumentException(String.format("Invalid byte-array offset (%d). length: %d", pos, length));
        }
    }

    static void writeLong(byte[] bytes, int pos, long value, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            bytes[pos + i] = (byte)(value >>> 8 * i & 0xFFL);
        }
    }

    static long readLong(ByteBuffer buffer, int pos, int numBytes) {
        VariantUtil.checkIndex(pos, buffer.limit());
        VariantUtil.checkIndex(pos + numBytes - 1, buffer.limit());
        long result = 0L;
        for (int i = 0; i < numBytes - 1; ++i) {
            long unsignedByteValue = buffer.get(pos + i) & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        long signedByteValue = buffer.get(pos + numBytes - 1);
        return result |= signedByteValue << 8 * (numBytes - 1);
    }

    static int readUnsigned(ByteBuffer bytes, int pos, int numBytes) {
        VariantUtil.checkIndex(pos, bytes.limit());
        VariantUtil.checkIndex(pos + numBytes - 1, bytes.limit());
        int result = 0;
        for (int i = 0; i < numBytes; ++i) {
            int unsignedByteValue = bytes.get(pos + i) & 0xFF;
            result |= unsignedByteValue << 8 * i;
        }
        if (result < 0) {
            throw new IllegalArgumentException(String.format("Failed to read unsigned int. numBytes: %d", numBytes));
        }
        return result;
    }

    static Variant.Type getType(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        switch (basicType) {
            case 1: {
                return Variant.Type.STRING;
            }
            case 2: {
                return Variant.Type.OBJECT;
            }
            case 3: {
                return Variant.Type.ARRAY;
            }
        }
        switch (typeInfo) {
            case 0: {
                return Variant.Type.NULL;
            }
            case 1: 
            case 2: {
                return Variant.Type.BOOLEAN;
            }
            case 3: {
                return Variant.Type.BYTE;
            }
            case 4: {
                return Variant.Type.SHORT;
            }
            case 5: {
                return Variant.Type.INT;
            }
            case 6: {
                return Variant.Type.LONG;
            }
            case 7: {
                return Variant.Type.DOUBLE;
            }
            case 8: {
                return Variant.Type.DECIMAL4;
            }
            case 9: {
                return Variant.Type.DECIMAL8;
            }
            case 10: {
                return Variant.Type.DECIMAL16;
            }
            case 11: {
                return Variant.Type.DATE;
            }
            case 12: {
                return Variant.Type.TIMESTAMP_TZ;
            }
            case 13: {
                return Variant.Type.TIMESTAMP_NTZ;
            }
            case 14: {
                return Variant.Type.FLOAT;
            }
            case 15: {
                return Variant.Type.BINARY;
            }
            case 16: {
                return Variant.Type.STRING;
            }
            case 17: {
                return Variant.Type.TIME;
            }
            case 18: {
                return Variant.Type.TIMESTAMP_NANOS_TZ;
            }
            case 19: {
                return Variant.Type.TIMESTAMP_NANOS_NTZ;
            }
            case 20: {
                return Variant.Type.UUID;
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown type in Variant. primitive type: %d", typeInfo));
    }

    private static String getTypeDebugString(ByteBuffer value) {
        try {
            return VariantUtil.getType(value).toString();
        }
        catch (Exception e) {
            int basicType = value.get(value.position()) & 3;
            int valueHeader = value.get(value.position()) >> 2 & 0x3F;
            return String.format("unknownType(basicType: %d, valueHeader: %d)", basicType, valueHeader);
        }
    }

    private static IllegalArgumentException unexpectedType(Variant.Type type, ByteBuffer actualValue) {
        String actualType = VariantUtil.getTypeDebugString(actualValue);
        return new IllegalArgumentException(String.format("Cannot read %s value as %s", new Object[]{actualType, type}));
    }

    private static IllegalArgumentException unexpectedType(Variant.Type[] types, ByteBuffer actualValue) {
        String actualType = VariantUtil.getTypeDebugString(actualValue);
        return new IllegalArgumentException(String.format("Cannot read %s value as one of %s", actualType, Arrays.toString((Object[])types)));
    }

    static boolean getBoolean(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 1 && typeInfo != 2) {
            throw VariantUtil.unexpectedType(Variant.Type.BOOLEAN, value);
        }
        return typeInfo == 1;
    }

    static long getLong(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT, Variant.Type.INT, Variant.Type.DATE, Variant.Type.LONG, Variant.Type.TIMESTAMP_TZ, Variant.Type.TIMESTAMP_NTZ, Variant.Type.TIME, Variant.Type.TIMESTAMP_NANOS_TZ, Variant.Type.TIMESTAMP_NANOS_NTZ}, value);
        }
        switch (typeInfo) {
            case 3: {
                return VariantUtil.readLong(value, value.position() + 1, 1);
            }
            case 4: {
                return VariantUtil.readLong(value, value.position() + 1, 2);
            }
            case 5: 
            case 11: {
                return VariantUtil.readLong(value, value.position() + 1, 4);
            }
            case 6: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                return VariantUtil.readLong(value, value.position() + 1, 8);
            }
        }
        throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT, Variant.Type.INT, Variant.Type.DATE, Variant.Type.LONG, Variant.Type.TIMESTAMP_TZ, Variant.Type.TIMESTAMP_NTZ, Variant.Type.TIME, Variant.Type.TIMESTAMP_NANOS_TZ, Variant.Type.TIMESTAMP_NANOS_NTZ}, value);
    }

    static int getInt(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT, Variant.Type.INT, Variant.Type.DATE}, value);
        }
        switch (typeInfo) {
            case 3: {
                return (int)VariantUtil.readLong(value, value.position() + 1, 1);
            }
            case 4: {
                return (int)VariantUtil.readLong(value, value.position() + 1, 2);
            }
            case 5: 
            case 11: {
                return (int)VariantUtil.readLong(value, value.position() + 1, 4);
            }
        }
        throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT, Variant.Type.INT, Variant.Type.DATE}, value);
    }

    static short getShort(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT}, value);
        }
        switch (typeInfo) {
            case 3: {
                return (short)VariantUtil.readLong(value, value.position() + 1, 1);
            }
            case 4: {
                return (short)VariantUtil.readLong(value, value.position() + 1, 2);
            }
        }
        throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.BYTE, Variant.Type.SHORT}, value);
    }

    static byte getByte(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(Variant.Type.BYTE, value);
        }
        switch (typeInfo) {
            case 3: {
                return (byte)VariantUtil.readLong(value, value.position() + 1, 1);
            }
        }
        throw VariantUtil.unexpectedType(Variant.Type.BYTE, value);
    }

    static double getDouble(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 7) {
            throw VariantUtil.unexpectedType(Variant.Type.DOUBLE, value);
        }
        return Double.longBitsToDouble(VariantUtil.readLong(value, value.position() + 1, 8));
    }

    static BigDecimal getDecimalWithOriginalScale(ByteBuffer value) {
        BigDecimal result;
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0) {
            throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.DECIMAL4, Variant.Type.DECIMAL8, Variant.Type.DECIMAL16}, value);
        }
        int scale = value.get(value.position() + 1) & 0xFF;
        switch (typeInfo) {
            case 8: {
                result = BigDecimal.valueOf(VariantUtil.readLong(value, value.position() + 2, 4), scale);
                break;
            }
            case 9: {
                result = BigDecimal.valueOf(VariantUtil.readLong(value, value.position() + 2, 8), scale);
                break;
            }
            case 10: {
                VariantUtil.checkIndex(value.position() + 17, value.limit());
                byte[] bytes = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    bytes[i] = value.get(value.position() + 17 - i);
                }
                result = new BigDecimal(new BigInteger(bytes), scale);
                break;
            }
            default: {
                throw VariantUtil.unexpectedType(new Variant.Type[]{Variant.Type.DECIMAL4, Variant.Type.DECIMAL8, Variant.Type.DECIMAL16}, value);
            }
        }
        return result;
    }

    static BigDecimal getDecimal(ByteBuffer value) {
        return VariantUtil.getDecimalWithOriginalScale(value);
    }

    static float getFloat(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 14) {
            throw VariantUtil.unexpectedType(Variant.Type.FLOAT, value);
        }
        return Float.intBitsToFloat((int)VariantUtil.readLong(value, value.position() + 1, 4));
    }

    static ByteBuffer getBinary(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 15) {
            throw VariantUtil.unexpectedType(Variant.Type.BINARY, value);
        }
        int start = value.position() + 1 + 4;
        int length = VariantUtil.readUnsigned(value, value.position() + 1, 4);
        VariantUtil.checkIndex(start + length - 1, value.limit());
        ByteBuffer result = VariantUtil.slice(value, start);
        result.limit(start + length);
        return result;
    }

    static String getString(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType == 1 || basicType == 0 && typeInfo == 16) {
            int length;
            int start;
            if (basicType == 1) {
                start = value.position() + 1;
                length = typeInfo;
            } else {
                start = value.position() + 1 + 4;
                length = VariantUtil.readUnsigned(value, value.position() + 1, 4);
            }
            VariantUtil.checkIndex(start + length - 1, value.limit());
            if (value.hasArray()) {
                return new String(value.array(), value.arrayOffset() + start, length);
            }
            byte[] valueArray = new byte[length];
            VariantUtil.slice(value, start).get(valueArray);
            return new String(valueArray);
        }
        throw VariantUtil.unexpectedType(Variant.Type.STRING, value);
    }

    static UUID getUUID(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 0 || typeInfo != 20) {
            throw VariantUtil.unexpectedType(Variant.Type.UUID, value);
        }
        int start = value.position() + 1;
        VariantUtil.checkIndex(start + 16 - 1, value.limit());
        ByteBuffer bb = VariantUtil.slice(value, start).order(ByteOrder.BIG_ENDIAN);
        return new UUID(bb.getLong(), bb.getLong());
    }

    static ByteBuffer slice(ByteBuffer value, int start) {
        ByteBuffer newSlice = value.duplicate();
        newSlice.position(start);
        return newSlice;
    }

    static ObjectInfo getObjectInfo(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 2) {
            throw VariantUtil.unexpectedType(Variant.Type.OBJECT, value);
        }
        boolean largeSize = (typeInfo >> 4 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int numElements = VariantUtil.readUnsigned(value, value.position() + 1, sizeBytes);
        int idSize = (typeInfo >> 2 & 3) + 1;
        int offsetSize = (typeInfo & 3) + 1;
        int idStartOffset = 1 + sizeBytes;
        int offsetStartOffset = idStartOffset + numElements * idSize;
        int dataStartOffset = offsetStartOffset + (numElements + 1) * offsetSize;
        return new ObjectInfo(numElements, idSize, offsetSize, idStartOffset, offsetStartOffset, dataStartOffset);
    }

    static ArrayInfo getArrayInfo(ByteBuffer value) {
        VariantUtil.checkIndex(value.position(), value.limit());
        int basicType = value.get(value.position()) & 3;
        int typeInfo = value.get(value.position()) >> 2 & 0x3F;
        if (basicType != 3) {
            throw VariantUtil.unexpectedType(Variant.Type.ARRAY, value);
        }
        boolean largeSize = (typeInfo >> 2 & 1) != 0;
        int sizeBytes = largeSize ? 4 : 1;
        int numElements = VariantUtil.readUnsigned(value, value.position() + 1, sizeBytes);
        int offsetSize = (typeInfo & 3) + 1;
        int offsetStartOffset = 1 + sizeBytes;
        int dataStartOffset = offsetStartOffset + (numElements + 1) * offsetSize;
        return new ArrayInfo(numElements, offsetSize, offsetStartOffset, dataStartOffset);
    }

    static String getMetadataKey(ByteBuffer metadata, int id) {
        int nextOffset;
        int offsetSize = (metadata.get(metadata.position()) >> 6 & 3) + 1;
        int dictSize = VariantUtil.readUnsigned(metadata, metadata.position() + 1, offsetSize);
        if (id >= dictSize) {
            throw new IllegalArgumentException(String.format("Invalid dictionary id: %d. dictionary size: %d", id, dictSize));
        }
        int offsetListPos = metadata.position() + 1 + offsetSize;
        int dataPos = offsetListPos + (dictSize + 1) * offsetSize;
        int offset = VariantUtil.readUnsigned(metadata, offsetListPos + id * offsetSize, offsetSize);
        if (offset > (nextOffset = VariantUtil.readUnsigned(metadata, offsetListPos + (id + 1) * offsetSize, offsetSize))) {
            throw new IllegalStateException(String.format("Invalid offset: %d. next offset: %d", offset, nextOffset));
        }
        VariantUtil.checkIndex(dataPos + nextOffset - 1, metadata.limit());
        if (metadata.hasArray() && !metadata.isReadOnly()) {
            return new String(metadata.array(), metadata.arrayOffset() + dataPos + offset, nextOffset - offset);
        }
        byte[] metadataArray = new byte[nextOffset - offset];
        VariantUtil.slice(metadata, dataPos + offset).get(metadataArray);
        return new String(metadataArray);
    }

    static HashMap<String, Integer> getMetadataMap(ByteBuffer metadata) {
        int pos = metadata.position();
        VariantUtil.checkIndex(pos, metadata.limit());
        int offsetSize = (metadata.get(pos) >> 6 & 3) + 1;
        int dictSize = VariantUtil.readUnsigned(metadata, pos + 1, offsetSize);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int offset = VariantUtil.readUnsigned(metadata, pos + 1 + offsetSize, offsetSize);
        for (int id = 0; id < dictSize; ++id) {
            int stringStart = 1 + (dictSize + 2) * offsetSize;
            int nextOffset = VariantUtil.readUnsigned(metadata, pos + 1 + (id + 2) * offsetSize, offsetSize);
            if (offset > nextOffset) {
                throw new UnsupportedOperationException(String.format("Invalid offset: %d. next offset: %d", offset, nextOffset));
            }
            VariantUtil.checkIndex(pos + stringStart + nextOffset - 1, metadata.limit());
            if (metadata.hasArray() && !metadata.isReadOnly()) {
                result.put(new String(metadata.array(), metadata.arrayOffset() + pos + stringStart + offset, nextOffset - offset), id);
            } else {
                byte[] metadataArray = new byte[nextOffset - offset];
                VariantUtil.slice(metadata, stringStart + offset).get(metadataArray);
                result.put(new String(metadataArray), id);
            }
            offset = nextOffset;
        }
        return result;
    }

    public static int valueSize(ByteBuffer value) {
        int pos = value.position();
        int basicType = value.get(pos) & 3;
        switch (basicType) {
            case 1: {
                int stringSize = value.get(pos) >> 2 & 0x3F;
                return 1 + stringSize;
            }
            case 2: {
                ObjectInfo info = VariantUtil.getObjectInfo(VariantUtil.slice(value, pos));
                return info.dataStartOffset + VariantUtil.readUnsigned(value, pos + info.offsetStartOffset + info.numElements * info.offsetSize, info.offsetSize);
            }
            case 3: {
                ArrayInfo info = VariantUtil.getArrayInfo(VariantUtil.slice(value, pos));
                return info.dataStartOffset + VariantUtil.readUnsigned(value, pos + info.offsetStartOffset + info.numElements * info.offsetSize, info.offsetSize);
            }
        }
        int typeInfo = value.get(pos) >> 2 & 0x3F;
        switch (typeInfo) {
            case 0: 
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: 
            case 11: 
            case 14: {
                return 5;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: {
                return 9;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 18;
            }
            case 15: 
            case 16: {
                return 5 + VariantUtil.readUnsigned(value, pos + 1, 4);
            }
            case 20: {
                return 17;
            }
        }
        throw new UnsupportedOperationException(String.format("Unknown type in Variant. primitive type: %d", typeInfo));
    }

    static class ArrayInfo {
        public final int numElements;
        public final int offsetSize;
        public final int offsetStartOffset;
        public final int dataStartOffset;

        public ArrayInfo(int numElements, int offsetSize, int offsetStartOffset, int dataStartOffset) {
            this.numElements = numElements;
            this.offsetSize = offsetSize;
            this.offsetStartOffset = offsetStartOffset;
            this.dataStartOffset = dataStartOffset;
        }
    }

    static class ObjectInfo {
        public final int numElements;
        public final int idSize;
        public final int offsetSize;
        public final int idStartOffset;
        public final int offsetStartOffset;
        public final int dataStartOffset;

        public ObjectInfo(int numElements, int idSize, int offsetSize, int idStartOffset, int offsetStartOffset, int dataStartOffset) {
            this.numElements = numElements;
            this.idSize = idSize;
            this.offsetSize = offsetSize;
            this.idStartOffset = idStartOffset;
            this.offsetStartOffset = offsetStartOffset;
            this.dataStartOffset = dataStartOffset;
        }
    }
}

