/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

class AngleCollector
extends PDFTextStripper {
    private final Set<Integer> angles = new TreeSet<Integer>();

    AngleCollector() throws IOException {
    }

    Set<Integer> getAngles() {
        return this.angles;
    }

    protected void processTextPosition(TextPosition text) {
        Matrix m = text.getTextMatrix();
        m.concatenate(text.getFont().getFontMatrix());
        int angle = (int)Math.round(Math.toDegrees(Math.atan2(m.getShearY(), m.getScaleY())));
        angle = (angle + 360) % 360;
        this.angles.add(angle);
    }
}

