/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType2;
import org.apache.pdfbox.util.Matrix;

public class AxialShadingContext
implements PaintContext {
    private ColorModel colorModel;
    private PDFunction function;
    private ColorSpace shadingColorSpace;
    private PDFunction shadingTinttransform;
    private float[] coords;
    private float[] domain;
    private boolean[] extend;
    private double x1x0;
    private double y1y0;
    private float d1d0;
    private double denom;
    private static final Log LOG = LogFactory.getLog(AxialShadingContext.class);

    public AxialShadingContext(PDShadingType2 shadingType2, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) {
        this.coords = shadingType2.getCoords().toFloatArray();
        if (ctm != null) {
            float[] coordsTemp = new float[this.coords.length];
            ctm.createAffineTransform().transform(this.coords, 0, coordsTemp, 0, 2);
            coordsTemp[1] = (float)pageHeight - coordsTemp[1];
            coordsTemp[3] = (float)pageHeight - coordsTemp[3];
            xform.transform(coordsTemp, 0, this.coords, 0, 2);
        } else {
            float translateY = (float)xform.getTranslateY();
            this.coords[1] = (float)pageHeight + translateY - this.coords[1];
            this.coords[3] = (float)pageHeight + translateY - this.coords[3];
        }
        try {
            PDColorSpace cs = shadingType2.getColorSpace();
            if (!(cs instanceof PDDeviceRGB)) {
                this.shadingColorSpace = cs.getJavaColorSpace();
                if (cs instanceof PDDeviceN) {
                    this.shadingTinttransform = ((PDDeviceN)cs).getTintTransform();
                } else if (cs instanceof PDSeparation) {
                    this.shadingTinttransform = ((PDSeparation)cs).getTintTransform();
                }
            }
        }
        catch (IOException exception) {
            LOG.error("error while creating colorSpace", exception);
        }
        if (colorModelValue != null) {
            this.colorModel = colorModelValue;
        } else {
            try {
                this.colorModel = shadingType2.getColorSpace().createColorModel(8);
            }
            catch (IOException exception) {
                LOG.error("error while creating colorModel", exception);
            }
        }
        try {
            this.function = shadingType2.getFunction();
        }
        catch (IOException exception) {
            LOG.error("error while creating a function", exception);
        }
        this.domain = shadingType2.getDomain() != null ? shadingType2.getDomain().toFloatArray() : new float[]{0.0f, 1.0f};
        COSArray extendValues = shadingType2.getExtend();
        if (shadingType2.getExtend() != null) {
            this.extend = new boolean[2];
            this.extend[0] = ((COSBoolean)extendValues.get(0)).getValue();
            this.extend[1] = ((COSBoolean)extendValues.get(1)).getValue();
        } else {
            this.extend = new boolean[]{false, false};
        }
        this.x1x0 = this.coords[2] - this.coords[0];
        this.y1y0 = this.coords[3] - this.coords[1];
        this.d1d0 = this.domain[1] - this.domain[0];
        this.denom = Math.pow(this.x1x0, 2.0) + Math.pow(this.y1y0, 2.0);
    }

    public void dispose() {
        this.colorModel = null;
        this.function = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        float[] input = new float[1];
        int[] data = new int[w * h * 3];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                double inputValue = this.x1x0 * (double)((float)(x + i) - this.coords[0]);
                inputValue += this.y1y0 * (double)((float)(y + j) - this.coords[1]);
                if ((inputValue /= this.denom) < (double)this.domain[0]) {
                    if (!this.extend[0]) continue;
                    inputValue = this.domain[0];
                } else if (inputValue > (double)this.domain[1]) {
                    if (!this.extend[1]) continue;
                    inputValue = this.domain[1];
                }
                input[0] = (float)((double)this.domain[0] + (double)this.d1d0 * inputValue);
                float[] values = null;
                int index = (j * w + i) * 3;
                try {
                    values = this.function.eval(input);
                    if (this.shadingColorSpace != null) {
                        if (this.shadingTinttransform != null) {
                            values = this.shadingTinttransform.eval(values);
                        }
                        values = this.shadingColorSpace.toRGB(values);
                    }
                }
                catch (IOException exception) {
                    LOG.error("error while processing a function", exception);
                }
                data[index] = (int)(values[0] * 255.0f);
                data[index + 1] = (int)(values[1] * 255.0f);
                data[index + 2] = (int)(values[2] * 255.0f);
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

