/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.filter.LZWNode;

final class LZWDictionary {
    private Map<Long, byte[]> codeToData = new HashMap<Long, byte[]>();
    private LZWNode root = new LZWNode(0L);
    private byte[] buffer = new byte[8];
    private int bufferNextWrite = 0;
    private long nextCode = 258L;
    private int codeSize = 9;
    private LZWNode previous = null;
    private LZWNode current = this.root;

    LZWDictionary() {
    }

    public byte[] getData(long code) {
        byte[] result = this.codeToData.get(code);
        if (result == null && code < 256L) {
            this.addRootNode((byte)code);
            result = this.codeToData.get(code);
        }
        return result;
    }

    public void visit(byte[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.visit(data[i]);
        }
    }

    public void visit(byte data) throws IOException {
        if (this.buffer.length == this.bufferNextWrite) {
            byte[] nextBuffer = new byte[2 * this.buffer.length];
            System.arraycopy(this.buffer, 0, nextBuffer, 0, this.buffer.length);
            this.buffer = nextBuffer;
        }
        this.buffer[this.bufferNextWrite++] = data;
        this.previous = this.current;
        this.current = this.current.getNode(data);
        if (this.current == null) {
            long code = this.previous == this.root ? (long)(data & 0xFF) : this.nextCode++;
            this.current = new LZWNode(code);
            this.previous.setNode(data, this.current);
            byte[] sav = new byte[this.bufferNextWrite];
            System.arraycopy(this.buffer, 0, sav, 0, this.bufferNextWrite);
            this.codeToData.put(code, sav);
            this.bufferNextWrite = 0;
            this.current = this.root;
            this.visit(data);
            this.resetCodeSize();
        }
    }

    public long getNextCode() {
        return this.nextCode;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    private void resetCodeSize() {
        this.codeSize = this.nextCode < 512L ? 9 : (this.nextCode < 1024L ? 10 : (this.nextCode < 2048L ? 11 : 12));
    }

    public void clear() {
        this.bufferNextWrite = 0;
        this.current = this.root;
        this.previous = null;
    }

    public LZWNode getNode(byte[] data) {
        LZWNode result = this.root.getNode(data);
        if (result == null && data.length == 1) {
            result = this.addRootNode(data[0]);
        }
        return result;
    }

    private LZWNode addRootNode(byte b) {
        long code = b & 0xFF;
        LZWNode result = new LZWNode(code);
        this.root.setNode(b, result);
        this.codeToData.put(code, new byte[]{b});
        return result;
    }
}

