/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.operator.pagedrawer;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfviewer.PageDrawer;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoke
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(Invoke.class);

    @Override
    public void process(PDFOperator operator, List<COSBase> arguments) throws IOException {
        PageDrawer drawer = (PageDrawer)this.context;
        PDPage page = drawer.getPage();
        COSName objectName = (COSName)arguments.get(0);
        Map<String, PDXObject> xobjects = drawer.getResources().getXObjects();
        PDXObject xobject = xobjects.get(objectName.getName());
        if (xobject == null) {
            LOG.warn("Can't find the XObject for '" + objectName.getName() + "'");
        } else if (xobject instanceof PDXObjectImage) {
            PDXObjectImage image = (PDXObjectImage)xobject;
            try {
                BufferedImage awtImage;
                if (image.getImageMask()) {
                    image.setStencilColor(drawer.getGraphicsState().getNonStrokingColor());
                }
                if ((awtImage = image.getRGBImage()) == null) {
                    LOG.warn("getRGBImage returned NULL");
                    return;
                }
                int imageWidth = awtImage.getWidth();
                int imageHeight = awtImage.getHeight();
                double pageHeight = drawer.getPageSize().getHeight();
                LOG.debug("imageWidth: " + imageWidth + "\t\timageHeight: " + imageHeight);
                Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
                float yScaling = ctm.getYScale();
                float angle = (float)Math.acos(ctm.getValue(0, 0) / ctm.getXScale());
                if (ctm.getValue(0, 1) < 0.0f && ctm.getValue(1, 0) > 0.0f) {
                    angle = -1.0f * angle;
                }
                ctm.setValue(2, 1, (float)(pageHeight - (double)ctm.getYPosition() - Math.cos(angle) * (double)yScaling));
                ctm.setValue(2, 0, (float)((double)ctm.getXPosition() - Math.sin(angle) * (double)yScaling));
                ctm.setValue(0, 1, -1.0f * ctm.getValue(0, 1));
                ctm.setValue(1, 0, -1.0f * ctm.getValue(1, 0));
                AffineTransform ctmAT = ctm.createAffineTransform();
                ctmAT.scale(1.0f / (float)imageWidth, 1.0f / (float)imageHeight);
                drawer.drawImage(awtImage, ctmAT);
            }
            catch (Exception e) {
                e.printStackTrace();
                LOG.error(e, e);
            }
        } else if (xobject instanceof PDXObjectForm) {
            this.context.getGraphicsStack().push((PDGraphicsState)this.context.getGraphicsState().clone());
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream formContentstream = form.getCOSStream();
            PDResources pdResources = form.getResources();
            Matrix matrix = form.getMatrix();
            if (matrix != null) {
                Matrix xobjectCTM = matrix.multiply(this.context.getGraphicsState().getCurrentTransformationMatrix());
                this.context.getGraphicsState().setCurrentTransformationMatrix(xobjectCTM);
            }
            this.getContext().processSubStream(page, pdResources, formContentstream);
            this.context.setGraphicsState(this.context.getGraphicsStack().pop());
        }
    }
}

