/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox.schema;

import java.lang.reflect.Constructor;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.schema.XmpSchemaException;
import org.apache.xmpbox.type.PropertiesDescription;
import org.apache.xmpbox.type.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPSchemaFactory {
    private String namespace;
    private Class<? extends XMPSchema> schemaClass;
    private PropertiesDescription propDef;
    private String nsName;

    public XMPSchemaFactory(String namespace, Class<? extends XMPSchema> schemaClass, PropertiesDescription propDef) {
        this.namespace = namespace;
        this.schemaClass = schemaClass;
        this.propDef = propDef;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public PropertyType getPropertyType(String name) {
        return this.propDef.getPropertyType(name);
    }

    public XMPSchema createXMPSchema(XMPMetadata metadata, String prefix) throws XmpSchemaException {
        Object[] schemaArgs;
        Class[] argsClass;
        XMPSchema schema = null;
        if (this.schemaClass == XMPSchema.class) {
            argsClass = new Class[]{XMPMetadata.class, String.class, String.class};
            schemaArgs = new Object[]{metadata, this.namespace, this.nsName};
        } else if (prefix != null && !"".equals(prefix)) {
            argsClass = new Class[]{XMPMetadata.class, String.class};
            schemaArgs = new Object[]{metadata, prefix};
        } else {
            argsClass = new Class[]{XMPMetadata.class};
            schemaArgs = new Object[]{metadata};
        }
        try {
            Constructor<? extends XMPSchema> schemaConstructor = this.schemaClass.getConstructor(argsClass);
            schema = schemaConstructor.newInstance(schemaArgs);
            if (schema != null) {
                metadata.addSchema(schema);
            }
            return schema;
        }
        catch (Exception e) {
            throw new XmpSchemaException("Cannot Instanciate specified Object Schema", e);
        }
    }

    public PropertiesDescription getPropertyDefinition() {
        return this.propDef;
    }
}

