/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamWrapper;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class SinglePageValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty() && !vPath.isExpectedType(PDPage.class)) {
            throw new ValidationException("Page validation required at least a PDPage");
        }
        PDPage page = (PDPage)vPath.peek();
        this.validateActions(context, page);
        this.validateAnnotation(context, page);
        this.validateColorSpaces(context, page);
        this.validateResources(context, page);
        this.validateGraphicObjects(context, page);
        this.validateGroupTransparency(context, page);
        this.validateContent(context, page);
    }

    protected void validateActions(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page.getCOSDictionary(), "actions-process");
    }

    protected void validateColorSpaces(PreflightContext context, PDPage page) throws ValidationException {
        Map<String, PDColorSpace> colorSpaces;
        PDResources resources = page.getResources();
        if (resources != null && (colorSpaces = resources.getColorSpaces()) != null) {
            PreflightConfiguration config = context.getConfig();
            ColorSpaceHelperFactory colorSpaceFactory = config.getColorSpaceHelperFact();
            for (PDColorSpace pdCS : colorSpaces.values()) {
                ColorSpaceHelper csHelper = colorSpaceFactory.getColorSpaceHelper(context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
                csHelper.validate();
            }
        }
    }

    protected void validateGraphicObjects(PreflightContext context, PDPage page) throws ValidationException {
        COSBase thumbBase = page.getCOSDictionary().getItem("Thumb");
        if (thumbBase != null) {
            try {
                if (thumbBase instanceof COSObject) {
                    thumbBase = ((COSObject)thumbBase).getObject();
                }
                PDXObject thumbImg = PDXObjectImage.createXObject(thumbBase);
                ContextHelper.validateElement(context, thumbImg, "graphic-process");
            }
            catch (IOException e) {
                context.addValidationError(new ValidationResult.ValidationError("2.1", "Unable to read Thumb image : " + e.getMessage()));
            }
        }
    }

    protected void validateResources(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page.getResources(), "resources-process");
    }

    protected void validateContent(PreflightContext context, PDPage page) throws ValidationException {
        try {
            ContentStreamWrapper csWrapper = new ContentStreamWrapper(context, page);
            csWrapper.validPageContentStream();
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("-1", e.getMessage()));
        }
    }

    protected void validateAnnotation(PreflightContext context, PDPage page) throws ValidationException {
        try {
            List<PDAnnotation> lAnnots = page.getAnnotations();
            for (PDAnnotation object : lAnnots) {
                if (!(object instanceof PDAnnotation)) continue;
                COSDictionary cosAnnot = object.getDictionary();
                ContextHelper.validateElement(context, cosAnnot, "annotations-process");
            }
        }
        catch (IOException e) {
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            throw new ValidationException("Unable to access Annotation", e);
        }
    }

    protected void validateGroupTransparency(PreflightContext context, PDPage page) throws ValidationException {
        String sVal;
        COSBase baseGroup = page.getCOSDictionary().getItem("Group");
        COSDictionary groupDictionary = COSUtils.getAsDictionary(baseGroup, context.getDocument().getDocument());
        if (groupDictionary != null && "Transparency".equals(sVal = groupDictionary.getNameAsString(COSName.S))) {
            context.addValidationError(new ValidationResult.ValidationError("2.2.1", "Group has a transparency S entry or the S entry is null."));
            return;
        }
    }
}

