/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.Filter;

public class JBIG2Filter
implements Filter {
    private static final Log LOG = LogFactory.getLog(JBIG2Filter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JBIG2");
        if (!readers.hasNext()) {
            LOG.error("Can't find an ImageIO plugin to decode the JBIG2 encoded datastream.");
            return;
        }
        ImageReader reader = readers.next();
        COSDictionary decodeP = (COSDictionary)options.getDictionaryObject(COSName.DECODE_PARMS);
        COSInteger bits = (COSInteger)options.getDictionaryObject(COSName.BITS_PER_COMPONENT);
        COSStream st = null;
        if (decodeP != null) {
            st = (COSStream)decodeP.getDictionaryObject(COSName.JBIG2_GLOBALS);
        }
        if (st != null) {
            reader.setInput(ImageIO.createImageInputStream(new SequenceInputStream(st.getFilteredStream(), compressedData)));
        } else {
            reader.setInput(ImageIO.createImageInputStream(compressedData));
        }
        BufferedImage bi = reader.read(0);
        reader.dispose();
        if (bi != null) {
            DataBuffer dBuf;
            if (bi.getColorModel().getPixelSize() != bits.intValue()) {
                if (bits.intValue() != 1) {
                    LOG.error("Do not know how to deal with JBIG2 with more than 1 bit");
                    return;
                }
                BufferedImage packedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 12);
                Graphics graphics = packedImage.getGraphics();
                graphics.drawImage(bi, 0, 0, null);
                graphics.dispose();
                bi = packedImage;
            }
            if ((dBuf = bi.getData().getDataBuffer()).getDataType() == 0) {
                result.write(((DataBufferByte)dBuf).getData());
            } else {
                LOG.error("Image data buffer not of type byte but type " + dBuf.getDataType());
            }
        } else {
            LOG.error("Something went wrong when decoding the JBIG2 encoded datastream.");
        }
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        System.err.println("Warning: JBIG2.encode is not implemented yet, skipping this stream.");
    }
}

