/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.metadata;

import java.util.List;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.XMPSchema;

public class RDFAboutAttributeConcordanceValidation {
    public void validateRDFAboutAttributes(XMPMetadata metadata) throws ValidationException, DifferentRDFAboutException {
        List<XMPSchema> schemas = metadata.getAllSchemas();
        if (schemas.size() == 0) {
            throw new ValidationException("Schemas not found in the given metadata representation");
        }
        String about = schemas.get(0).getAboutValue();
        for (XMPSchema xmpSchema : schemas) {
            this.checkRdfAbout(about, xmpSchema);
        }
    }

    private void checkRdfAbout(String about, XMPSchema xmpSchema) throws DifferentRDFAboutException {
        if (!about.equals(xmpSchema.getAboutValue())) {
            throw new DifferentRDFAboutException();
        }
    }

    public static class DifferentRDFAboutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DifferentRDFAboutException() {
            super("all rdf:about in RDF:rdf must have the same value");
        }
    }
}

