/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.persistence.util.COSObjectKey;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ICCProfileWrapper;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogValidationProcess
extends AbstractProcess {
    protected PDDocumentCatalog catalog;
    protected List<String> listICC = new ArrayList<String>();

    public CatalogValidationProcess() {
        this.listICC.add("FOGRA43");
        this.listICC.add("CGATS TR 006");
        this.listICC.add("CGATS TR006");
        this.listICC.add("FOGRA39");
        this.listICC.add("JC200103");
        this.listICC.add("FOGRA27");
        this.listICC.add("EUROSB104");
        this.listICC.add("FOGRA45");
        this.listICC.add("FOGRA46");
        this.listICC.add("FOGRA41");
        this.listICC.add("CGATS TR 001");
        this.listICC.add("CGATS TR 003");
        this.listICC.add("CGATS TR 005");
        this.listICC.add("CGATS TR001");
        this.listICC.add("CGATS TR003");
        this.listICC.add("CGATS TR005");
        this.listICC.add("FOGRA28");
        this.listICC.add("JCW2003");
        this.listICC.add("EUROSB204");
        this.listICC.add("FOGRA47");
        this.listICC.add("FOGRA44");
        this.listICC.add("FOGRA29");
        this.listICC.add("JC200104");
        this.listICC.add("FOGRA40");
        this.listICC.add("FOGRA30");
        this.listICC.add("FOGRA42");
        this.listICC.add("IFRA26");
        this.listICC.add("JCN2002");
        this.listICC.add("CGATS TR 002");
        this.listICC.add("CGATS TR002");
        this.listICC.add("FOGRA33");
        this.listICC.add("FOGRA37");
        this.listICC.add("FOGRA31");
        this.listICC.add("FOGRA35");
        this.listICC.add("FOGRA32");
        this.listICC.add("FOGRA34");
        this.listICC.add("FOGRA36");
        this.listICC.add("FOGRA38");
        this.listICC.add("sRGB");
        this.listICC.add("sRGB IEC61966-2.1");
        this.listICC.add("Adobe RGB (1998)");
        this.listICC.add("bg-sRGB");
        this.listICC.add("sYCC");
        this.listICC.add("scRGB");
        this.listICC.add("scRGB-nl");
        this.listICC.add("scYCC-nl");
        this.listICC.add("ROMM RGB");
        this.listICC.add("RIMM RGB");
        this.listICC.add("ERIMM RGB");
        this.listICC.add("eciRGB");
        this.listICC.add("opRGB");
    }

    protected boolean isStandardICCCharacterization(String name) {
        for (String iccStandard : this.listICC) {
            if (!iccStandard.contains(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfbox = ctx.getDocument();
        this.catalog = pdfbox.getDocumentCatalog();
        if (this.catalog == null) {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.14", "There are no Catalog entry in the Document."));
        } else {
            this.validateActions(ctx);
            this.validateLang(ctx);
            this.validateNames(ctx);
            this.validateOCProperties(ctx);
            this.validateOutputIntent(ctx);
        }
    }

    protected void validateActions(PreflightContext ctx) throws ValidationException {
        ContextHelper.validateElement(ctx, this.catalog.getCOSDictionary(), "actions-process");
        COSBase aa = this.catalog.getCOSDictionary().getItem("AA");
        if (aa != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.2", "The AA field is forbidden for the Catalog  when the PDF is a PDF/A"));
        }
    }

    protected void validateLang(PreflightContext ctx) throws ValidationException {
        String lang = this.catalog.getLanguage();
        if (lang != null && !"".equals(lang) && !lang.matches("[A-Za-z]{1,8}(-[A-Za-z]{1,8})*")) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.0.8"));
        }
    }

    protected void validateNames(PreflightContext ctx) throws ValidationException {
        PDEmbeddedFilesNameTreeNode efs;
        PDDocumentNameDictionary names = this.catalog.getNames();
        if (names != null && (efs = names.getEmbeddedFiles()) != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.7", "EmbeddedFile entry is present in the Names dictionary"));
        }
    }

    protected void validateOCProperties(PreflightContext ctx) throws ValidationException {
        if (this.catalog.getOCProperties() != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.4.8", "A Catalog shall not contain the OCPProperties entry."));
        }
    }

    public void validateOutputIntent(PreflightContext ctx) throws ValidationException {
        COSDocument cosDocument = ctx.getDocument().getDocument();
        COSBase cBase = this.catalog.getCOSDictionary().getItem(COSName.getPDFName("OutputIntents"));
        COSArray outputIntents = COSUtils.getAsArray(cBase, cosDocument);
        HashMap<COSObjectKey, Boolean> tmpDestOutputProfile = new HashMap<COSObjectKey, Boolean>();
        for (int i = 0; outputIntents != null && i < outputIntents.size(); ++i) {
            String info;
            COSDictionary outputIntentDict = COSUtils.getAsDictionary(outputIntents.get(i), cosDocument);
            if (outputIntentDict == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "OutputIntent object is null or isn't a dictionary"));
                continue;
            }
            String sValue = outputIntentDict.getNameAsString("S");
            if (!"GTS_PDFA1".equals(sValue)) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.3", "The S entry of the OutputIntent isn't GTS_PDFA1"));
                continue;
            }
            String outputConditionIdentifier = outputIntentDict.getString("OutputConditionIdentifier");
            if (outputConditionIdentifier == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "The OutputIntentCondition is missing"));
                continue;
            }
            COSBase destOutputProfile = outputIntentDict.getItem("DestOutputProfile");
            this.validateICCProfile(destOutputProfile, tmpDestOutputProfile, ctx);
            PreflightConfiguration config = ctx.getConfig();
            if (!config.isLazyValidation() || this.isStandardICCCharacterization(outputConditionIdentifier) || (info = outputIntentDict.getString(COSName.getPDFName("Info"))) != null && !"".equals(info)) continue;
            ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.2", "The Info entry of a OutputIntent dictionary is missing");
            error.setWarning(true);
            this.addValidationError(ctx, error);
        }
    }

    protected void validateICCProfile(COSBase destOutputProfile, Map<COSObjectKey, Boolean> mapDestOutputProfile, PreflightContext ctx) throws ValidationException {
        try {
            if (destOutputProfile == null) {
                return;
            }
            if (destOutputProfile instanceof COSObject) {
                if (mapDestOutputProfile.containsKey(new COSObjectKey((COSObject)destOutputProfile))) {
                    return;
                }
                if (!mapDestOutputProfile.isEmpty()) {
                    this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.5", "More than one ICCProfile is defined"));
                    return;
                }
            }
            mapDestOutputProfile.put(new COSObjectKey((COSObject)destOutputProfile), true);
            COSDocument cosDocument = ctx.getDocument().getDocument();
            PDStream stream = PDStream.createFromCOS(COSUtils.getAsStream(destOutputProfile, cosDocument));
            if (stream == null) {
                this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.2", "OutputIntent object uses a NULL Object"));
                return;
            }
            ICC_Profile iccp = ICC_Profile.getInstance(stream.getByteArray());
            PreflightConfiguration config = ctx.getConfig();
            if (iccp.getMajorVersion() == 2) {
                if (iccp.getMinorVersion() > 64) {
                    ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.6", "Invalid version of the ICCProfile");
                    error.setWarning(config.isLazyValidation());
                    this.addValidationError(ctx, error);
                    return;
                }
            } else if (iccp.getMajorVersion() > 2) {
                ValidationResult.ValidationError error = new ValidationResult.ValidationError("2.1.6", "Invalid version of the ICCProfile");
                error.setWarning(config.isLazyValidation());
                this.addValidationError(ctx, error);
                return;
            }
            if (ctx.getIccProfileWrapper() == null) {
                ctx.setIccProfileWrapper(new ICCProfileWrapper(iccp));
            }
        }
        catch (IllegalArgumentException e) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("2.1.4", "DestOutputProfile isn't a ICCProfile"));
        }
        catch (IOException e) {
            throw new ValidationException("Unable to parse the ICC Profile", e);
        }
    }
}

