/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdfparser.NonSequentialPDFParser;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.persistence.util.COSObjectKey;
import org.apache.pdfbox.preflight.Format;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.SyntaxValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreflightParser
extends NonSequentialPDFParser {
    public static final Charset encoding = Charset.forName("ISO-8859-1");
    protected DataSource originalDocument;
    protected ValidationResult validationResult;
    protected PreflightDocument preflightDocument;
    protected PreflightContext ctx;

    public PreflightParser(File file, RandomAccess rafi) throws IOException {
        super(file, rafi);
        this.setLenient(false);
        this.originalDocument = new FileDataSource(file);
    }

    public PreflightParser(File file) throws IOException {
        this(file, null);
    }

    public PreflightParser(String filename) throws IOException {
        this(new File(filename), null);
    }

    public PreflightParser(DataSource input) throws IOException {
        super(input.getInputStream());
        this.setLenient(false);
        this.originalDocument = input;
    }

    protected static ValidationResult createUnknownErrorResult() {
        ValidationResult.ValidationError error = new ValidationResult.ValidationError("-1");
        ValidationResult result = new ValidationResult(error);
        return result;
    }

    protected void addValidationError(ValidationResult.ValidationError error) {
        if (this.validationResult == null) {
            this.validationResult = new ValidationResult(error.isWarning());
        }
        this.validationResult.addError(error);
    }

    protected void addValidationErrors(List<ValidationResult.ValidationError> errors) {
        for (ValidationResult.ValidationError error : errors) {
            this.addValidationError(error);
        }
    }

    @Override
    public void parse() throws IOException {
        this.parse(Format.PDF_A1B);
    }

    public void parse(Format format) throws IOException {
        this.parse(format, null);
    }

    public void parse(Format format, PreflightConfiguration config) throws IOException {
        this.checkPdfHeader();
        try {
            super.parse();
        }
        catch (IOException e) {
            this.addValidationError(new ValidationResult.ValidationError("1.0", e.getMessage()));
            throw new SyntaxValidationException(e, this.validationResult);
        }
        Format formatToUse = format == null ? Format.PDF_A1B : format;
        this.createPdfADocument(formatToUse, config);
        this.createContext();
    }

    protected void createPdfADocument(Format format, PreflightConfiguration config) throws IOException {
        COSDocument cosDocument = this.getDocument();
        this.preflightDocument = new PreflightDocument(cosDocument, format, config);
    }

    protected void createContext() {
        this.ctx = new PreflightContext(this.originalDocument);
        this.ctx.setDocument(this.preflightDocument);
        this.preflightDocument.setContext(this.ctx);
        this.ctx.setXrefTableResolver(this.xrefTrailerResolver);
    }

    @Override
    public PDDocument getPDDocument() throws IOException {
        this.preflightDocument.setResult(this.validationResult);
        return this.preflightDocument;
    }

    public PreflightDocument getPreflightDocument() throws IOException {
        return (PreflightDocument)this.getPDDocument();
    }

    @Override
    protected void initialParse() throws IOException {
        super.initialParse();
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        for (COSBase trailerEntry : this.getDocument().getTrailer().getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, true);
        }
        Map<COSObjectKey, Long> xrefTable = this.document.getXrefTable();
        for (Map.Entry<COSObjectKey, Long> entry : xrefTable.entrySet()) {
            COSObject co = this.document.getObjectFromPool(entry.getKey());
            if (co.getObject() != null) continue;
            this.parseObjectDynamically(co, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPdfHeader() {
        BufferedReader reader;
        block9: {
            reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPdfFile()), encoding));
                String firstLine = reader.readLine();
                if (firstLine == null || firstLine != null && !firstLine.matches("%PDF-1\\.[1-9]")) {
                    this.addValidationError(new ValidationResult.ValidationError("1.1", "First line must match %PDF-1.\\d"));
                }
                String secondLine = reader.readLine();
                byte[] secondLineAsBytes = secondLine.getBytes(encoding.name());
                if (secondLine != null && secondLineAsBytes.length >= 5) {
                    for (int i = 0; i < secondLineAsBytes.length; ++i) {
                        byte b = secondLineAsBytes[i];
                        if (i == 0 && (char)b != '%') {
                            this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must contains at least 4 bytes greater than 127"));
                        } else {
                            if (i <= 0 || (b & 0xFF) >= 128) continue;
                            this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must contains at least 4 bytes greater than 127"));
                        }
                        break block9;
                    }
                    break block9;
                }
                this.addValidationError(new ValidationResult.ValidationError("1.1", "Second line must contains at least 4 bytes greater than 127"));
            }
            catch (IOException e) {
                try {
                    this.addValidationError(new ValidationResult.ValidationError("1.1", "Unable to read the PDF file : " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly(reader);
            }
        }
        IOUtils.closeQuietly(reader);
    }

    @Override
    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        char c;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.equals("xref")) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by a EOL character"));
            return false;
        }
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.3", "xref must be followed by EOL"));
        }
        this.xrefTrailerResolver.nextXrefObj(startByteOffset);
        do {
            long currObjID = 0L;
            long count = 0L;
            long offset = this.pdfSource.getOffset();
            String line = this.readLine();
            Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)(\\s*)");
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                currObjID = Integer.parseInt(matcher.group(1));
                count = Integer.parseInt(matcher.group(2));
            } else {
                this.addValidationError(new ValidationResult.ValidationError("1.3", "Cross reference subsection header is invalid"));
                this.pdfSource.seek(offset);
                currObjID = this.readObjectNumber();
                count = this.readLong();
            }
            this.skipSpaces();
            int i = 0;
            while ((long)i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek())) {
                if (this.pdfSource.peek() == 116) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Expected xref line but 't' found"));
                    break;
                }
                String currentLine = this.readLine();
                String[] splitString = currentLine.split(" ");
                if (splitString.length < 3) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        this.addValidationError(new ValidationResult.ValidationError("1.3", "offset or genid can't be read as number " + e.getMessage()));
                    }
                } else if (!splitString[2].equals("f")) {
                    this.addValidationError(new ValidationResult.ValidationError("1.3", "Corrupt XRefTable Entry - ObjID:" + currObjID));
                }
                ++currObjID;
                this.skipSpaces();
                ++i;
            }
            this.skipSpaces();
        } while ((c = (char)this.pdfSource.peek()) >= '0' && c <= '9');
        return true;
    }

    @Override
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        this.checkStreamKeyWord();
        COSStream result = super.parseCOSStream(dic, file);
        this.checkEndstreamKeyWord();
        return result;
    }

    protected void checkStreamKeyWord() throws IOException {
        int nextChar;
        String streamV = this.readString();
        if (!streamV.equals("stream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'stream' keyword but found '" + streamV + "'"));
        }
        if (((nextChar = this.pdfSource.read()) != 13 || this.pdfSource.peek() != 10) && nextChar != 10) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' after the stream keyword"));
        }
        this.pdfSource.seek(this.pdfSource.getOffset() - 7L);
    }

    protected void checkEndstreamKeyWord() throws IOException {
        String endstreamV;
        this.pdfSource.seek(this.pdfSource.getOffset() - 10L);
        if (!this.nextIsEOL()) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'EOL' before the endstream keyword"));
        }
        if (!(endstreamV = this.readString()).equals("endstream")) {
            this.addValidationError(new ValidationResult.ValidationError("1.2.2", "Expected 'endstream' keyword but found '" + endstreamV + "'"));
        }
    }

    protected boolean nextIsEOL() throws IOException {
        boolean succeed = false;
        int nextChar = this.pdfSource.read();
        if (nextChar == 13 && this.pdfSource.peek() == 10) {
            this.pdfSource.read();
            succeed = true;
        } else if (nextChar == 13 || nextChar == 10) {
            succeed = true;
        }
        return succeed;
    }

    protected boolean nextIsSpace() throws IOException {
        return 32 == this.pdfSource.read();
    }

    @Override
    protected COSArray parseCOSArray() throws IOException {
        COSArray result = super.parseCOSArray();
        if (result != null && result.size() > 8191) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.2", "Array too long : " + result.size()));
        }
        return result;
    }

    @Override
    protected COSName parseCOSName() throws IOException {
        COSName result = super.parseCOSName();
        if (result != null && result.getName().getBytes().length > 127) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.3", "Name too long"));
        }
        return result;
    }

    @Override
    protected COSString parseCOSString(boolean isDictionary) throws IOException {
        long offset = this.pdfSource.getOffset();
        char nextChar = (char)this.pdfSource.read();
        int count = 0;
        if (nextChar == '<') {
            do {
                if ((nextChar = (char)this.pdfSource.read()) == '>') continue;
                if (Character.digit(nextChar, 16) >= 0) {
                    ++count;
                    continue;
                }
                this.addValidationError(new ValidationResult.ValidationError("1.0.12", "Hexa String must have only Hexadecimal Characters (found '" + nextChar + "')"));
                break;
            } while (nextChar != '>');
        }
        if (count % 2 != 0) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.11", "Hexa string shall contain even number of non white space char"));
        }
        this.pdfSource.seek(offset);
        COSString result = super.parseCOSString(isDictionary);
        if (result.getString().length() > 65535) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.5", "Hexa string is too long"));
        }
        return result;
    }

    @Override
    protected COSBase parseDirObject() throws IOException {
        COSDictionary dic;
        COSBase result = super.parseDirObject();
        if (result instanceof COSNumber) {
            COSNumber number = (COSNumber)result;
            if (number instanceof COSFloat) {
                Double real = number.doubleValue();
                if (real > 32767.0 || real < -32767.0) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Float is too long or too small: " + real));
                }
            } else {
                long numAsLong = number.longValue();
                if (numAsLong > Integer.MAX_VALUE || numAsLong < Integer.MIN_VALUE) {
                    this.addValidationError(new ValidationResult.ValidationError("1.0.6", "Numeric is too long or too small: " + numAsLong));
                }
            }
        }
        if (result instanceof COSDictionary && (dic = (COSDictionary)result).size() > 4095) {
            this.addValidationError(new ValidationResult.ValidationError("1.0.1", "Too Many Entries In Dictionary"));
        }
        return result;
    }

    @Override
    protected COSBase parseObjectDynamically(int objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && offsetOrObjstmObNr == null) {
                this.addValidationError(new ValidationResult.ValidationError("1.0.13", "Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration()));
                throw new SyntaxValidationException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration(), this.validationResult);
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr == 0L) {
                this.addValidationError(new ValidationResult.ValidationError("1.0.14", "Object {" + objKey.getNumber() + ":" + objKey.getGeneration() + "} has an offset of 0"));
            } else if (offsetOrObjstmObNr > 0L) {
                this.setPdfSource(offsetOrObjstmObNr);
                long readObjNr = 0L;
                int readObjGen = 0;
                long offset = this.pdfSource.getOffset();
                String line = this.readLine();
                Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)\\sobj");
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    readObjNr = Integer.parseInt(matcher.group(1));
                    readObjGen = Integer.parseInt(matcher.group(2));
                } else {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Single space expected"));
                    this.pdfSource.seek(offset);
                    readObjNr = this.readObjectNumber();
                    readObjGen = this.readGenerationNumber();
                    this.skipSpaces();
                    for (char c : OBJ_MARKER) {
                        if (this.pdfSource.read() == c) continue;
                        this.addValidationError(new ValidationResult.ValidationError("1.2.1", "Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'"));
                        throw new SyntaxValidationException("Expected pattern '" + new String(OBJ_MARKER) + " but missed at character '" + c + "'", this.validationResult);
                    }
                }
                if (readObjNr != objKey.getNumber() || (long)readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                this.skipSpaces();
                long endObjectOffset = this.pdfSource.getOffset();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    COSStream stream;
                    this.pdfSource.seek(endObjectOffset);
                    if (pb instanceof COSDictionary) {
                        stream = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        if (this.securityHandler != null) {
                            try {
                                this.securityHandler.decryptStream(stream, objNr, objGenNr);
                            }
                            catch (CryptographyException ce) {
                                throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                            }
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectOffset = this.pdfSource.getOffset();
                    endObjectKey = this.readString();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readString();
                    }
                } else if (this.securityHandler != null) {
                    if (pb instanceof COSString) {
                        this.decrypt((COSString)pb, objNr, objGenNr);
                    } else if (pb instanceof COSDictionary) {
                        for (Map.Entry<COSName, COSBase> entry : ((COSDictionary)pb).entrySet()) {
                            if (!(entry.getValue() instanceof COSString)) continue;
                            this.decrypt((COSString)entry.getValue(), objNr, objGenNr);
                        }
                    } else if (pb instanceof COSArray) {
                        COSArray array = (COSArray)pb;
                        int len = array.size();
                        for (int aIdx = 0; aIdx < len; ++aIdx) {
                            if (!(array.get(aIdx) instanceof COSString)) continue;
                            this.decrypt((COSString)array.get(aIdx), objNr, objGenNr);
                        }
                    }
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj'.");
                }
                offset = this.pdfSource.getOffset();
                this.pdfSource.seek(endObjectOffset - 1L);
                if (!this.nextIsEOL()) {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected before the 'endobj' keyword"));
                }
                this.pdfSource.seek(offset);
                if (!this.nextIsEOL()) {
                    this.addValidationError(new ValidationResult.ValidationError("1.2.1", "EOL expected after the 'endobj' keyword"));
                }
                this.releasePdfSourceInputStream();
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof COSStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document, this.forceParsing);
                    parser.parse();
                    Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
                    for (COSObject next : parser.getObjects()) {
                        COSObjectKey stmObjKey = new COSObjectKey(next);
                        if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                        COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    @Override
    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int tmpOffset;
        int offset = super.lastIndexOf(pattern, buf, endOff);
        if (offset > 0 && Arrays.equals(pattern, EOF_MARKER) && (tmpOffset = offset + pattern.length) != buf.length && (buf.length - tmpOffset > 2 || buf[tmpOffset] != 10 && buf[tmpOffset] != 13 && buf[tmpOffset + 1] != 10)) {
            this.addValidationError(new ValidationResult.ValidationError("1.4.10", "File contains data after the last %%EOF sequence"));
        }
        return offset;
    }
}

