/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.GouraudTriangle;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.Vertex;
import org.apache.pdfbox.util.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GouraudShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(GouraudShadingContext.class);
    private ColorModel outputColorModel;
    private PDColorSpace colorSpace;
    protected int numberOfColorComponents;
    protected ArrayList<GouraudTriangle> triangleList;
    protected int bitsPerCoordinate;
    protected int bitsPerColorComponent;
    protected float[] background;
    private ColorSpace shadingColorSpace;
    private PDFunction shadingTinttransform;
    private final boolean hasFunction;
    private final PDShadingResources gouraudShadingType;

    protected GouraudShadingContext(PDShadingResources shadingType, ColorModel colorModelValue, AffineTransform xform, Matrix ctm, int pageHeight) throws IOException {
        xform.scale(1.0, -1.0);
        xform.translate(0.0, -pageHeight);
        this.gouraudShadingType = shadingType;
        this.triangleList = new ArrayList();
        this.colorSpace = shadingType.getColorSpace();
        this.hasFunction = shadingType.getFunction() != null;
        LOG.debug("colorSpace: " + this.colorSpace);
        this.numberOfColorComponents = this.colorSpace.getNumberOfComponents();
        LOG.debug("numberOfColorComponents: " + this.numberOfColorComponents);
        LOG.debug("BBox: " + shadingType.getBBox());
        LOG.debug("Background: " + shadingType.getBackground());
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        try {
            if (!(this.colorSpace instanceof PDDeviceRGB)) {
                this.shadingColorSpace = this.colorSpace.getJavaColorSpace();
                if (this.colorSpace instanceof PDDeviceN) {
                    this.shadingTinttransform = ((PDDeviceN)this.colorSpace).getTintTransform();
                } else if (this.colorSpace instanceof PDSeparation) {
                    this.shadingTinttransform = ((PDSeparation)this.colorSpace).getTintTransform();
                }
            }
        }
        catch (IOException exception) {
            LOG.error("error while creating colorSpace", exception);
        }
    }

    protected Vertex readVertex(ImageInputStream input, byte flag, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRangeTab) throws IOException {
        float[] colorComponentTab = new float[this.numberOfColorComponents];
        long x = input.readBits(this.bitsPerCoordinate);
        long y = input.readBits(this.bitsPerCoordinate);
        double dstX = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
        double dstY = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
        LOG.debug("coord: " + String.format("[%06X,%06X] -> [%f,%f]", x, y, dstX, dstY));
        for (int n = 0; n < this.numberOfColorComponents; ++n) {
            int color = (int)input.readBits(this.bitsPerColorComponent);
            colorComponentTab[n] = this.interpolate(color, maxSrcColor, colRangeTab[n].getMin(), colRangeTab[n].getMax());
            LOG.debug("color[" + n + "]: " + color + "/" + String.format("%02x", color) + "-> color[" + n + "]: " + colorComponentTab[n]);
        }
        return new Vertex(flag, new Point2D.Double(dstX, dstY), colorComponentTab);
    }

    protected void transformVertices(ArrayList<Vertex> vertexList, Matrix ctm, AffineTransform xform, int pageHeight) {
        for (Vertex v : vertexList) {
            LOG.debug(v);
            if (ctm != null) {
                ctm.createAffineTransform().transform(v.point, v.point);
                xform.transform(v.point, v.point);
            } else {
                v.point = new Point2D.Double(v.point.getX(), (double)pageHeight + xform.getTranslateY() - v.point.getY());
            }
            LOG.debug(v);
        }
    }

    @Override
    public void dispose() {
        this.triangleList = null;
        this.outputColorModel = null;
        this.colorSpace = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.outputColorModel;
    }

    private float interpolate(float src, long srcMax, float dstMin, float dstMax) {
        return dstMin + src * (dstMax - dstMin) / (float)srcMax;
    }

    @Override
    public final Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        if (!this.triangleList.isEmpty() || this.background != null) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    float[] values;
                    Point p = new Point(x + col, y + row);
                    GouraudTriangle triangle = null;
                    for (GouraudTriangle tryTriangle : this.triangleList) {
                        if (!tryTriangle.contains(p)) continue;
                        triangle = tryTriangle;
                        break;
                    }
                    if (triangle != null) {
                        double[] weights = triangle.getWeights(p);
                        values = new float[this.numberOfColorComponents];
                        for (int i = 0; i < this.numberOfColorComponents; ++i) {
                            values[i] = (float)((double)triangle.colorA[i] * weights[0] + (double)triangle.colorB[i] * weights[1] + (double)triangle.colorC[i] * weights[2]);
                        }
                    } else {
                        if (this.background == null) continue;
                        values = this.background;
                    }
                    if (this.hasFunction) {
                        try {
                            values = this.gouraudShadingType.evalFunction(values);
                        }
                        catch (IOException exception) {
                            LOG.error("error while processing a function", exception);
                        }
                    }
                    if (this.shadingColorSpace != null) {
                        if (this.shadingTinttransform != null) {
                            try {
                                values = this.shadingTinttransform.eval(values);
                            }
                            catch (IOException exception) {
                                LOG.error("error while processing a function", exception);
                            }
                        }
                        values = this.shadingColorSpace.toRGB(values);
                    }
                    int index = (row * w + col) * 4;
                    data[index] = (int)(values[0] * 255.0f);
                    data[index + 1] = (int)(values[1] * 255.0f);
                    data[index + 2] = (int)(values[2] * 255.0f);
                    data[index + 3] = 255;
                }
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

