/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorState;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.xobject.CompositeImage;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;

public abstract class PDXObjectImage
extends PDXObject {
    private static final Log LOG = LogFactory.getLog(PDXObjectImage.class);
    public static final String SUB_TYPE = "Image";
    private String suffix;
    private PDColorState stencilColor;

    public PDXObjectImage(PDStream imageStream, String fileSuffix) {
        super(imageStream);
        this.suffix = fileSuffix;
    }

    public PDXObjectImage(PDDocument doc, String fileSuffix) {
        super(doc);
        this.getCOSStream().setName(COSName.SUBTYPE, SUB_TYPE);
        this.suffix = fileSuffix;
    }

    public static PDXObject createThumbnailXObject(COSBase xobject) throws IOException {
        PDXObject retval = PDXObjectImage.commonXObjectCreation(xobject, true);
        return retval;
    }

    public abstract BufferedImage getRGBImage() throws IOException;

    public PDXObjectImage getSMaskImage() throws IOException {
        COSStream cosStream = this.getPDStream().getStream();
        COSBase smask = cosStream.getDictionaryObject(COSName.SMASK);
        if (smask == null) {
            return null;
        }
        return (PDXObjectImage)PDXObject.createXObject(smask);
    }

    public BufferedImage applyMasks(BufferedImage baseImage) throws IOException {
        if (this.getImageMask()) {
            return this.imageMask(baseImage);
        }
        if (this.getMask() != null) {
            return this.mask(baseImage);
        }
        PDXObjectImage smask = this.getSMaskImage();
        if (smask != null) {
            BufferedImage smaskBI = smask.getRGBImage();
            if (smaskBI != null) {
                COSArray decodeArray = smask.getDecode();
                CompositeImage compositeImage = new CompositeImage(baseImage, smaskBI);
                BufferedImage rgbImage = compositeImage.createMaskedImage(decodeArray);
                return rgbImage;
            }
            LOG.warn("masking getRGBImage returned NULL");
        }
        return baseImage;
    }

    public boolean hasMask() throws IOException {
        return this.getImageMask() || this.getMask() != null || this.getSMaskImage() != null;
    }

    public BufferedImage imageMask(BufferedImage baseImage) throws IOException {
        BufferedImage stencilMask = new BufferedImage(baseImage.getWidth(), baseImage.getHeight(), 2);
        Graphics2D graphics = (Graphics2D)stencilMask.getGraphics();
        if (this.getStencilColor() != null) {
            graphics.setColor(this.getStencilColor().getJavaColor());
        } else {
            LOG.debug("no stencil color for PixelMap found, using Color.BLACK instead.");
            graphics.setColor(Color.BLACK);
        }
        graphics.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
        COSArray decode = this.getDecode();
        if (decode != null && decode.getInt(0) == 1) {
            graphics.setComposite(AlphaComposite.DstOut);
        } else {
            graphics.setComposite(AlphaComposite.DstIn);
        }
        graphics.drawImage(baseImage, null, 0, 0);
        graphics.dispose();
        return stencilMask;
    }

    public BufferedImage mask(BufferedImage baseImage) throws IOException {
        COSBase mask = this.getMask();
        if (mask instanceof COSStream) {
            PDXObjectImage maskImageRef = (PDXObjectImage)PDXObject.createXObject((COSStream)mask);
            BufferedImage maskImage = maskImageRef.getRGBImage();
            if (maskImage == null) {
                LOG.warn("masking getRGBImage returned NULL");
                return baseImage;
            }
            BufferedImage newImage = new BufferedImage(maskImage.getWidth(), maskImage.getHeight(), 2);
            Graphics2D graphics = (Graphics2D)newImage.getGraphics();
            graphics.drawImage(baseImage, 0, 0, maskImage.getWidth(), maskImage.getHeight(), 0, 0, baseImage.getWidth(), baseImage.getHeight(), null);
            graphics.setComposite(AlphaComposite.DstIn);
            graphics.drawImage(maskImage, null, 0, 0);
            graphics.dispose();
            return newImage;
        }
        LOG.warn("Colour key masking isn't supported");
        return baseImage;
    }

    public abstract void write2OutputStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2file(String filename) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename + "." + this.suffix);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2file(File file) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int getHeight() {
        return this.getCOSStream().getInt(COSName.HEIGHT, -1);
    }

    public void setHeight(int height) {
        this.getCOSStream().setInt(COSName.HEIGHT, height);
    }

    public int getWidth() {
        return this.getCOSStream().getInt(COSName.WIDTH, -1);
    }

    public void setWidth(int width) {
        this.getCOSStream().setInt(COSName.WIDTH, width);
    }

    public int getBitsPerComponent() {
        return this.getCOSStream().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.getCOSStream().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.getCOSStream().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
        PDColorSpace retval = null;
        if (cs != null) {
            retval = PDColorSpaceFactory.createColorSpace(cs);
            if (retval == null) {
                LOG.info("About to return NULL from createColorSpace branch");
            }
        } else {
            COSBase filter = this.getCOSStream().getDictionaryObject(COSName.FILTER);
            if (COSName.CCITTFAX_DECODE.equals(filter) || COSName.CCITTFAX_DECODE_ABBREVIATION.equals(filter)) {
                retval = new PDDeviceGray();
            } else if (COSName.JBIG2_DECODE.equals(filter)) {
                retval = new PDDeviceGray();
            } else if (this.getImageMask()) {
                retval = new PDDeviceGray();
            } else {
                LOG.info("About to return NULL from unhandled branch. filter = " + filter);
            }
        }
        return retval;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.getCOSStream().setItem(COSName.COLORSPACE, base);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean getImageMask() {
        return this.getCOSStream().getBoolean(COSName.IMAGE_MASK, false);
    }

    public void setStencilColor(PDColorState stencilColorValue) {
        this.stencilColor = stencilColorValue;
    }

    public PDColorState getStencilColor() {
        return this.stencilColor;
    }

    public COSArray getDecode() {
        COSBase decode = this.getCOSStream().getDictionaryObject(COSName.DECODE);
        if (decode != null && decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    public COSBase getMask() {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask != null) {
            return mask;
        }
        return null;
    }
}

