/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmpbox.XMPMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    private boolean isValid = false;
    private List<ValidationError> lErrors = new ArrayList<ValidationError>();
    private XMPMetadata xmpMetaData = null;

    public ValidationResult(boolean isValid) {
        this.isValid = isValid;
    }

    public ValidationResult(ValidationError error) {
        this.isValid = false;
        if (error != null) {
            this.lErrors.add(error);
        }
    }

    public ValidationResult(List<ValidationError> errors) {
        this.isValid = false;
        this.lErrors = errors;
    }

    public void mergeResult(ValidationResult otherResult) {
        if (otherResult != null) {
            this.lErrors.addAll(otherResult.getErrorsList());
            this.isValid &= otherResult.isValid();
        }
    }

    public XMPMetadata getXmpMetaData() {
        return this.xmpMetaData;
    }

    void setXmpMetaData(XMPMetadata xmpMetaData) {
        this.xmpMetaData = xmpMetaData;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void addError(ValidationError error) {
        if (error != null) {
            this.isValid &= error.isWarning();
            this.lErrors.add(error);
        }
    }

    public void addErrors(List<ValidationError> errors) {
        if (errors != null) {
            for (ValidationError validationError : errors) {
                this.addError(validationError);
            }
        }
    }

    public List<ValidationError> getErrorsList() {
        return this.lErrors;
    }

    public static class ValidationError {
        private String errorCode;
        private String details;
        private boolean isWarning = false;

        public ValidationError(String errorCode) {
            this.errorCode = errorCode;
            this.details = errorCode.startsWith("1.0") ? "Syntax error" : (errorCode.startsWith("1.1") ? "Body Syntax error" : (errorCode.startsWith("1.2") ? "Body Syntax error" : (errorCode.startsWith("1.3") ? "CrossRef Syntax error" : (errorCode.startsWith("1.4") ? "Trailer Syntax error" : (errorCode.startsWith("2.1") ? "Invalid Graphis object" : (errorCode.startsWith("2.2") ? "Invalid Graphis transparency" : (errorCode.startsWith("2.3") ? "Unexpected key in Graphic object definition" : (errorCode.startsWith("2.4") ? "Invalid Color space" : (errorCode.startsWith("3.1") ? "Invalid Font definition" : (errorCode.startsWith("3.2") ? "Font damaged" : (errorCode.startsWith("3.3") ? "Glyph error" : (errorCode.startsWith("4.1") ? "Transparency error" : (errorCode.startsWith("5.1") ? "Missing field in an annotation definition" : (errorCode.startsWith("5.2") ? "Forbidden field in an annotation definition" : (errorCode.startsWith("5.3") ? "Invalid field value in an annotation definition" : (errorCode.startsWith("6.1") ? "Invalid action definition" : (errorCode.startsWith("6.2") ? "Action is forbidden" : (errorCode.startsWith("7") ? "Error on MetaData" : "Unknown error"))))))))))))))))));
        }

        public ValidationError(String errorCode, String details) {
            this(errorCode);
            if (details != null) {
                StringBuilder sb = new StringBuilder(this.details.length() + details.length() + 2);
                sb.append(this.details).append(", ").append(details);
                this.details = sb.toString();
            }
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            this.details = details;
        }

        public boolean isWarning() {
            return this.isWarning;
        }

        public void setWarning(boolean isWarning) {
            this.isWarning = isWarning;
        }

        public int hashCode() {
            return this.errorCode.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ValidationError) {
                ValidationError ve = (ValidationError)o;
                if (this.errorCode == null && ve.errorCode != null) {
                    return false;
                }
                if (!this.errorCode.equals(ve.errorCode)) {
                    return false;
                }
                if (!this.details.equals(ve.details)) {
                    return false;
                }
                return this.isWarning == ve.isWarning;
            }
            return false;
        }
    }
}

