/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.io.RandomAccessBuffer;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.EndstreamOutputStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.apache.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.apache.pdfbox.persistence.util.COSObjectKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSequentialPDFParser
extends PDFParser {
    private static final byte[] XREF = new byte[]{120, 114, 101, 102};
    private static final int E = 101;
    private static final int N = 110;
    private static final int X = 120;
    public static final String SYSPROP_PARSEMINIMAL = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    protected static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] STARTXREF_MARKER = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private final File pdfFile;
    private long fileLen;
    private final RandomAccessBufferedFileInputStream raStream;
    private boolean isLenient = true;
    protected SecurityHandler securityHandler = null;
    private String keyStoreFilename = null;
    private String alias = null;
    private String password = "";
    private int readTrailBytes = 2048;
    private boolean parseMinimalCatalog = "true".equals(System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal"));
    private boolean initialParseDone = false;
    private boolean allPagesParsed = false;
    private static final Log LOG = LogFactory.getLog(NonSequentialPDFParser.class);
    private boolean isTmpPDFFile = false;
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private COSDictionary pagesDictionary = null;
    private boolean inGetLength = false;
    private final int streamCopyBufLen = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public NonSequentialPDFParser(String filename) throws IOException {
        this(new File(filename), null);
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf) throws IOException {
        this(file, raBuf, "");
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = file;
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(file, raBuf, decryptionPassword);
    }

    private void init(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        String eofLookupRangeStr = System.getProperty(SYSPROP_EOFLOOKUPRANGE);
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'");
            }
        }
        this.setDocument(raBuf == null ? new COSDocument(new RandomAccessBuffer(), false) : new COSDocument(raBuf, false));
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
        this.password = decryptionPassword;
    }

    public NonSequentialPDFParser(InputStream input) throws IOException {
        this(input, null, "");
    }

    public NonSequentialPDFParser(InputStream input, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = this.createTmpFile(input);
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(this.pdfFile, raBuf, decryptionPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTmpFile(InputStream input) throws IOException {
        File file;
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".pdf");
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(input, fos);
            this.isTmpPDFFile = true;
            file = tmpFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fos);
        return file;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected void initialParse() throws IOException {
        COSObject catalogObj;
        COSBase trailerEncryptItem;
        this.setPdfSource(this.getStartxrefOffset());
        this.parseStartXref();
        long startXrefOffset = this.document.getStartXref();
        if (this.isLenient) {
            startXrefOffset -= this.calculateFixingOffset(startXrefOffset);
            this.document.setStartXref(startXrefOffset);
        }
        long prev = startXrefOffset;
        while (prev > -1L) {
            long fixingOffset;
            COSDictionary trailer;
            this.setPdfSource(prev);
            this.skipSpaces();
            if (this.pdfSource.peek() == 120) {
                long fixingOffset2;
                this.parseXrefTable(prev);
                long trailerOffset = this.pdfSource.getOffset();
                while (this.isLenient && this.pdfSource.peek() != 116) {
                    if (this.pdfSource.getOffset() == trailerOffset) {
                        LOG.warn("Expected trailer object at position " + trailerOffset + ", keep trying");
                    }
                    this.readLine();
                }
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    this.setPdfSource(streamOffset);
                    this.skipSpaces();
                    this.parseXrefObjStream(prev, false);
                }
                prev = trailer.getInt(COSName.PREV);
                if (!this.isLenient || prev <= -1L || (fixingOffset2 = this.calculateFixingOffset(prev)) == 0L) continue;
                trailer.setLong(COSName.PREV, prev -= fixingOffset2);
                continue;
            }
            prev = this.parseXrefObjStream(prev, true);
            if (!this.isLenient || prev <= -1L || (fixingOffset = this.calculateFixingOffset(prev)) == 0L) continue;
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            trailer.setLong(COSName.PREV, prev -= fixingOffset);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        COSDictionary trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        if (this.isLenient) {
            this.checkXrefOffsets();
        }
        if ((trailerEncryptItem = this.document.getTrailer().getItem(COSName.ENCRYPT)) != null && !(trailerEncryptItem instanceof COSNull)) {
            if (trailerEncryptItem instanceof COSObject) {
                COSObject trailerEncryptObj = (COSObject)trailerEncryptItem;
                this.parseObjectDynamically(trailerEncryptObj, true);
            }
            try {
                PDEncryptionDictionary encParameters = new PDEncryptionDictionary(this.document.getEncryptionDictionary());
                DecryptionMaterial decryptionMaterial = null;
                if (this.keyStoreFilename != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(this.keyStoreFilename), this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.alias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(encParameters.getFilter());
                this.securityHandler.prepareForDecryption(encParameters, this.document.getDocumentID(), decryptionMaterial);
                AccessPermission permission = this.securityHandler.getCurrentAccessPermission();
                if (!permission.canExtractContent()) {
                    LOG.warn("PDF file '" + this.pdfFile.getPath() + "' does not allow extracting content.");
                }
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption: " + e.getMessage());
            }
        }
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        COSObject root = (COSObject)this.xrefTrailerResolver.getTrailer().getItem(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        this.parseObjectDynamically(root, false);
        if (!this.parseMinimalCatalog && (catalogObj = this.document.getCatalog()) != null && catalogObj.getObject() instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)catalogObj.getObject(), null);
            this.allPagesParsed = true;
            this.document.setDecrypted();
        }
        this.readVersionInTrailer(trailer);
        this.initialParseDone = true;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readPattern(OBJ_MARKER);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict, this.getDocument().getScratchFile());
        this.parseXrefStream(xrefStream, (int)objByteOffset, isStandalone);
        return dict.getLong(COSName.PREV);
    }

    private final long getPdfSourceOffset() {
        return this.pdfSource.getOffset();
    }

    protected final void setPdfSource(long fileOffset) throws IOException {
        this.pdfSource.seek(fileOffset);
    }

    protected final void releasePdfSourceInputStream() throws IOException {
    }

    private final void closeFileStream() throws IOException {
        if (this.pdfSource != null) {
            this.pdfSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        this.fileLen = this.pdfFile.length();
        FileInputStream fIn = null;
        try {
            int readBytes;
            fIn = new FileInputStream(this.pdfFile);
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            fIn.skip(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = fIn.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException ioe) {}
            }
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
        }
        if ((bufOff = this.lastIndexOf(STARTXREF_MARKER, buf, bufOff)) < 0) {
            throw new IOException("Missing 'startxref' marker.");
        }
        return skipBytes + (long)bufOff;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    protected final void readPattern(char[] pattern) throws IOException {
        this.skipSpaces();
        for (char c : pattern) {
            if (this.pdfSource.read() == c) continue;
            throw new IOException("Expected pattern '" + new String(pattern) + "' but missed at character '" + c + "' at offset " + this.pdfSource.getOffset());
        }
        this.skipSpaces();
    }

    private COSDictionary getPagesObject() throws IOException {
        if (this.pagesDictionary != null) {
            return this.pagesDictionary;
        }
        COSObject pages = (COSObject)this.document.getCatalog().getItem(COSName.PAGES);
        if (pages == null) {
            throw new IOException("Missing PAGES entry in document catalog.");
        }
        COSBase object = this.parseObjectDynamically(pages, false);
        if (!(object instanceof COSDictionary)) {
            throw new IOException("PAGES not a dictionary object, but: " + object.getClass().getSimpleName());
        }
        this.pagesDictionary = (COSDictionary)object;
        return this.pagesDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            this.parseHeader();
            this.pdfSource.seek(0L);
            if (!this.initialParseDone) {
                this.initialParse();
            }
            int pageCount = this.getPageNumber();
            if (!this.allPagesParsed) {
                for (int pNr = 0; pNr < pageCount; ++pNr) {
                    this.getPage(pNr);
                }
                this.allPagesParsed = true;
                this.document.setDecrypted();
            }
            exceptionOccurred = false;
        }
        finally {
            try {
                this.closeFileStream();
            }
            catch (IOException ioe) {}
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                try {
                    this.document.close();
                    this.document = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getPdfFile() {
        return this.pdfFile;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) throws IllegalArgumentException {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    protected void deleteTempFile() {
        if (this.isTmpPDFFile) {
            try {
                if (!this.pdfFile.delete()) {
                    LOG.warn("Temporary file '" + this.pdfFile.getName() + "' can't be deleted");
                }
            }
            catch (SecurityException e) {
                LOG.warn("Temporary file '" + this.pdfFile.getName() + "' can't be deleted", e);
            }
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public PDDocument getPDDocument() throws IOException {
        PDDocument pdDocument = super.getPDDocument();
        if (this.securityHandler != null) {
            pdDocument.setSecurityHandler(this.securityHandler);
        }
        return pdDocument;
    }

    public int getPageNumber() throws IOException {
        int pageCount = this.getPagesObject().getInt(COSName.COUNT);
        if (pageCount < 0) {
            throw new IOException("No page number specified.");
        }
        return pageCount;
    }

    public PDPage getPage(int pageNr) throws IOException {
        this.getPagesObject();
        COSArray kids = (COSArray)this.pagesDictionary.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            throw new IOException("Missing 'Kids' entry in pages dictionary.");
        }
        COSObject pageObj = this.getPageObject(pageNr, kids, 0);
        if (pageObj == null) {
            throw new IOException("Page " + pageNr + " not found.");
        }
        COSDictionary pageDict = (COSDictionary)pageObj.getObject();
        if (this.parseMinimalCatalog && !this.allPagesParsed) {
            COSDictionary resDict = (COSDictionary)pageDict.getDictionaryObject(COSName.RESOURCES);
            this.parseDictObjects(resDict, new COSName[0]);
        }
        return new PDPage(pageDict);
    }

    private COSObject getPageObject(int num, COSArray startKids, int startPageCount) throws IOException {
        int curPageCount = startPageCount;
        for (COSObject obj : startKids) {
            COSDictionary dic;
            int count;
            COSBase base = obj.getObject();
            if (base == null) {
                base = this.parseObjectDynamically(obj, false);
                obj.setObject(base);
            }
            if ((count = (dic = (COSDictionary)base).getInt(COSName.COUNT)) >= 0 && curPageCount + count <= num) {
                curPageCount += count;
                continue;
            }
            COSArray kids = (COSArray)dic.getDictionaryObject(COSName.KIDS);
            if (kids != null) {
                COSObject ans = this.getPageObject(num, kids, curPageCount);
                if (ans == null) continue;
                return ans;
            }
            if (curPageCount == num) {
                return obj;
            }
            ++curPageCount;
        }
        return null;
    }

    private final long getObjectId(COSObject obj) {
        return obj.getObjectNumber().longValue() << 32 | obj.getGenerationNumber().longValue();
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            long objId;
            if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) continue;
            toBeParsedList.add(newObject);
        }
    }

    private final void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    private void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSStream) {
                    this.addNewToList(toBeParsedList, ((COSStream)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    Iterator<COSBase> arrIter = ((COSArray)baseObj).iterator();
                    while (arrIter.hasNext()) {
                        this.addNewToList(toBeParsedList, arrIter.next(), addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey(-fileOffset.longValue(), 0L));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference: " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue(), requireExistingNotCompressedObj);
    }

    protected COSBase parseObjectDynamically(int objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(COSNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.setPdfSource(offsetOrObjstmObNr);
                long readObjNr = this.readObjectNumber();
                long readObjGen = this.readGenerationNumber();
                this.readPattern(OBJ_MARKER);
                if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                COSBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    COSStream stream;
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof COSDictionary) {
                        stream = this.parseCOSStream((COSDictionary)pb, this.getDocument().getScratchFile());
                        if (this.securityHandler != null) {
                            try {
                                this.securityHandler.decryptStream(stream, objNr, objGenNr);
                            }
                            catch (CryptographyException ce) {
                                throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                            }
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readLine();
                    }
                } else if (this.securityHandler != null) {
                    if (pb instanceof COSString) {
                        this.decrypt((COSString)pb, objNr, objGenNr);
                    } else if (pb instanceof COSDictionary) {
                        for (Map.Entry<COSName, COSBase> entry : ((COSDictionary)pb).entrySet()) {
                            if (!(entry.getValue() instanceof COSString)) continue;
                            this.decrypt((COSString)entry.getValue(), objNr, objGenNr);
                        }
                    } else if (pb instanceof COSArray) {
                        COSArray array = (COSArray)pb;
                        int len = array.size();
                        for (int aIdx = 0; aIdx < len; ++aIdx) {
                            if (!(array.get(aIdx) instanceof COSString)) continue;
                            this.decrypt((COSString)array.get(aIdx), objNr, objGenNr);
                        }
                    }
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    if (endObjectKey.endsWith(" obj") && this.isLenient) {
                        LOG.warn("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
                    } else {
                        throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
                    }
                }
                this.releasePdfSourceInputStream();
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof COSStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document, this.forceParsing);
                    parser.parse();
                    Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
                    for (COSObject next : parser.getObjects()) {
                        COSObjectKey stmObjKey = new COSObjectKey(next);
                        if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                        COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    protected final void decrypt(COSString str, long objNr, long objGenNr) throws IOException {
        try {
            this.securityHandler.decryptString(str, objNr, objGenNr);
        }
        catch (CryptographyException ce) {
            throw new IOException("Error decrypting string: " + ce.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        COSNumber retVal;
        block10: {
            if (lengthBaseObj == null) {
                return null;
            }
            if (this.inGetLength) {
                throw new IOException("Loop while reading length from " + lengthBaseObj);
            }
            retVal = null;
            try {
                this.inGetLength = true;
                if (lengthBaseObj instanceof COSNumber) {
                    retVal = (COSNumber)lengthBaseObj;
                    break block10;
                }
                if (lengthBaseObj instanceof COSObject) {
                    COSObject lengthObj = (COSObject)lengthBaseObj;
                    if (lengthObj.getObject() == null) {
                        long curFileOffset = this.getPdfSourceOffset();
                        this.releasePdfSourceInputStream();
                        this.parseObjectDynamically(lengthObj, true);
                        this.setPdfSource(curFileOffset);
                        if (lengthObj.getObject() == null) {
                            throw new IOException("Length object content was not read.");
                        }
                    }
                    if (!(lengthObj.getObject() instanceof COSNumber)) {
                        throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                    }
                    retVal = (COSNumber)lengthObj.getObject();
                    break block10;
                }
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            finally {
                this.inGetLength = false;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected COSStream parseCOSStream(COSDictionary dic, RandomAccess file) throws IOException {
        COSStream stream = new COSStream(dic, file);
        OutputStream out = null;
        try {
            String endStream;
            COSNumber streamLengthObj;
            this.readString();
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            if ((streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH))) == null) {
                throw new IOException("Missing length for stream.");
            }
            boolean useReadUntilEnd = false;
            if (this.validateStreamLength(streamLengthObj.longValue())) {
                out = stream.createFilteredStream(streamLengthObj);
                long remainBytes = streamLengthObj.longValue();
                int bytesRead = 0;
                while (remainBytes > 0L) {
                    int readBytes = this.pdfSource.read(this.streamCopyBuf, 0, remainBytes > 8192L ? 8192 : (int)remainBytes);
                    if (readBytes <= 0) {
                        useReadUntilEnd = true;
                        out.close();
                        this.pdfSource.unread(bytesRead);
                        break;
                    }
                    out.write(this.streamCopyBuf, 0, readBytes);
                    remainBytes -= (long)readBytes;
                    bytesRead += readBytes;
                }
            } else {
                useReadUntilEnd = true;
            }
            if (useReadUntilEnd) {
                out = stream.createFilteredStream(streamLengthObj);
                this.readUntilEndStream(new EndstreamOutputStream(out));
            }
            if (!(endStream = this.readString()).equals("endstream")) {
                throw new IOException("Error reading stream using length value. Expected='endstream' actual='" + endStream + "' at offset " + this.pdfSource.getOffset());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return stream;
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.pdfSource.getOffset();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            LOG.error("The end of the stream is out of range, using workaround to read the stream");
        } else {
            this.pdfSource.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.checkBytesAtOffset("endstream".getBytes("ISO-8859-1"))) {
                streamLengthIsValid = false;
                LOG.error("The end of the stream doesn't point to the correct offset, using workaround to read the stream");
            }
            this.pdfSource.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.pdfSource.read(this.streamCopyBuf, charMatchCount, 8192 - charMatchCount)) > 0) {
            int contentBytes;
            int bIdx;
            int startingMatchCount = charMatchCount;
            int maxQuicktestIdx = bufSize - 5;
            for (bIdx = charMatchCount; bIdx < bufSize; ++bIdx) {
                byte ch;
                int quickTestIdx;
                if (charMatchCount == 0 && (quickTestIdx = bIdx + 5) < maxQuicktestIdx && ((ch = this.streamCopyBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                    continue;
                }
                ch = this.streamCopyBuf[bIdx];
                if (ch == keyw[charMatchCount]) {
                    if (++charMatchCount != keyw.length) continue;
                    ++bIdx;
                    break;
                }
                if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                    keyw = ENDOBJ;
                    ++charMatchCount;
                    continue;
                }
                charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                keyw = ENDSTREAM;
            }
            if ((contentBytes = Math.max(0, bIdx - charMatchCount)) > 0) {
                out.write(this.streamCopyBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.pdfSource.unread(this.streamCopyBuf, contentBytes, bufSize - contentBytes - keyw.length + startingMatchCount);
                break;
            }
            System.arraycopy(keyw, 0, this.streamCopyBuf, 0, charMatchCount);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateFixingOffset(long startXRefOffset) throws IOException {
        this.setPdfSource(startXRefOffset);
        if (this.pdfSource.peek() == 120 && this.calculateFixingOffset(startXRefOffset, XREF) == 0L) {
            return 0L;
        }
        int nextValue = this.pdfSource.peek();
        if (nextValue > 47 && nextValue < 57) {
            long originOffset = this.pdfSource.getOffset();
            try {
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readPattern(OBJ_MARKER);
                this.setPdfSource(startXRefOffset);
                long l = 0L;
                return l;
            }
            catch (IOException exception) {
                this.setPdfSource(startXRefOffset);
            }
            finally {
                this.pdfSource.seek(originOffset);
            }
        }
        return this.calculateFixingOffset(startXRefOffset, XREF);
    }

    private long calculateFixingOffset(long objectOffset, long objectID, long genID) throws IOException {
        String objString = Long.toString(objectID) + " " + Long.toString(genID) + " obj";
        return this.calculateFixingOffset(objectOffset, objString.getBytes("ISO-8859-1"));
    }

    private boolean checkBytesAtOffset(byte[] string) throws IOException {
        boolean bytesMatching = false;
        if (this.pdfSource.peek() == string[0]) {
            int numberOfBytes;
            int readMore;
            int length = string.length;
            byte[] bytesRead = new byte[length];
            for (numberOfBytes = this.pdfSource.read(bytesRead, 0, length); numberOfBytes < length && (readMore = this.pdfSource.read(bytesRead, numberOfBytes, length - numberOfBytes)) >= 0; numberOfBytes += readMore) {
            }
            if (Arrays.equals(string, bytesRead)) {
                bytesMatching = true;
            }
            this.pdfSource.unread(bytesRead, 0, numberOfBytes);
        }
        return bytesMatching;
    }

    private long calculateFixingOffset(long objectOffset, byte[] string) throws IOException {
        if (objectOffset < 0L) {
            LOG.error("Invalid object offset " + objectOffset + " for object " + new String(string));
            return 0L;
        }
        long originOffset = this.pdfSource.getOffset();
        this.pdfSource.seek(objectOffset);
        if (this.checkBytesAtOffset(string)) {
            this.pdfSource.seek(originOffset);
            return 0L;
        }
        long currentOffset = objectOffset;
        for (int i = 1; i < 20; ++i) {
            currentOffset = objectOffset - (long)(i * 10);
            if (currentOffset <= 0L) continue;
            this.pdfSource.seek(currentOffset);
            for (int j = 0; j < 10; ++j) {
                if (this.checkBytesAtOffset(string)) {
                    this.pdfSource.seek(originOffset);
                    LOG.debug("Fixed reference for object " + new String(string) + " " + objectOffset + " -> " + (objectOffset - currentOffset));
                    return objectOffset - currentOffset;
                }
                ++currentOffset;
                this.pdfSource.read();
            }
        }
        this.pdfSource.seek(objectOffset);
        currentOffset = objectOffset;
        do {
            if (this.checkBytesAtOffset(string)) {
                this.pdfSource.seek(originOffset);
                if (currentOffset != 0L) {
                    LOG.debug("Fixed reference for object " + new String(string) + " " + objectOffset + " -> " + (objectOffset - currentOffset));
                }
                return objectOffset - currentOffset;
            }
            ++currentOffset;
            if (this.pdfSource.read() != -1) continue;
            throw new IOException("Premature end of file while dereferencing object " + new String(string) + " at offset " + objectOffset);
        } while (currentOffset < objectOffset + 200L);
        this.pdfSource.seek(originOffset);
        LOG.error("Can't find the object " + new String(string) + " at offset " + objectOffset);
        return 0L;
    }

    private void checkXrefOffsets() throws IOException {
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            for (COSObjectKey objectKey : xrefOffset.keySet()) {
                Long objectOffset = xrefOffset.get(objectKey);
                if (objectOffset == null || objectOffset <= 0L) continue;
                long objectNr = objectKey.getNumber();
                long objectGen = objectKey.getGeneration();
                long fixingOffset = this.calculateFixingOffset(objectOffset, objectNr, objectGen);
                if (fixingOffset == 0L) continue;
                long newOffset = objectOffset - fixingOffset;
                xrefOffset.put(objectKey, newOffset);
                LOG.debug("Fixed reference for object " + objectNr + " " + objectGen + " " + objectOffset + " -> " + newOffset);
            }
        }
    }
}

