/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.xobject;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.RenderingIntents;
import org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;

public class XObjImageValidator
extends AbstractXObjValidator {
    protected PDXObjectImage xImage = null;

    public XObjImageValidator(PreflightContext context, PDXObjectImage xobj) {
        super(context, xobj.getCOSStream());
        this.xImage = xobj;
    }

    protected void checkMandatoryFields() {
        boolean res = this.xobject.getItem(COSName.WIDTH) != null;
        boolean bl = res = res && this.xobject.getItem(COSName.HEIGHT) != null;
        if (!res) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.1.7"));
        }
    }

    protected void checkAlternates() throws ValidationException {
        if (this.xobject.getItem("Alternates") != null) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3", "Unexpected 'Alternates' Key"));
        }
    }

    protected void checkInterpolate() throws ValidationException {
        if (this.xobject.getItem("Interpolate") != null && this.xobject.getBoolean("Interpolate", true)) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected 'true' value for 'Interpolate' Key"));
        }
    }

    protected void checkIntent() throws ValidationException {
        String s;
        if (this.xobject.getItem("Intent") != null && !RenderingIntents.contains(s = this.xobject.getNameAsString("Intent"))) {
            this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "Unexpected value '" + s + "' for Intent key in image"));
        }
    }

    protected void checkColorSpaceAndImageMask() throws ValidationException {
        COSBase csImg = this.xobject.getItem(COSName.COLORSPACE);
        COSBase bitsPerComp = this.xobject.getItem("BitsPerComponent");
        COSBase mask = this.xobject.getItem(COSName.MASK);
        if (this.isImageMaskTrue()) {
            Integer bitsPerCompValue;
            if (csImg != null || mask != null) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.3", "ImageMask entry is true, ColorSpace and Mask are forbidden."));
            }
            if ((bitsPerCompValue = COSUtils.getAsInteger(bitsPerComp, this.cosDocument)) != null && bitsPerCompValue != 1) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.3.2", "ImageMask entry is true, BitsPerComponent must be absent or 1."));
            }
        } else {
            try {
                PreflightConfiguration config = this.context.getConfig();
                ColorSpaceHelperFactory csFact = config.getColorSpaceHelperFact();
                PDColorSpace pdCS = PDColorSpaceFactory.createColorSpace(csImg);
                ColorSpaceHelper csh = csFact.getColorSpaceHelper(this.context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_PATTERN);
                csh.validate();
            }
            catch (IOException e) {
                this.context.addValidationError(new ValidationResult.ValidationError("2.4.4"));
            }
        }
    }

    private boolean isImageMaskTrue() {
        COSBase imgMask = this.xobject.getItem("ImageMask");
        if (imgMask != null && imgMask instanceof COSBoolean) {
            return ((COSBoolean)imgMask).getValue();
        }
        return false;
    }

    public void validate() throws ValidationException {
        super.validate();
        this.checkAlternates();
        this.checkInterpolate();
        this.checkIntent();
        this.checkColorSpaceAndImageMask();
    }
}

