/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmpbox.type;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmpbox.type.AbstractField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexPropertyContainer {
    private List<AbstractField> properties = new ArrayList<AbstractField>();

    protected AbstractField getFirstEquivalentProperty(String localName, Class<? extends AbstractField> type) {
        List<AbstractField> list = this.getPropertiesByLocalName(localName);
        if (list != null) {
            for (AbstractField abstractField : list) {
                if (!abstractField.getClass().equals(type)) continue;
                return abstractField;
            }
        }
        return null;
    }

    public void addProperty(AbstractField obj) {
        if (this.containsProperty(obj)) {
            this.removeProperty(obj);
        }
        this.properties.add(obj);
    }

    public List<AbstractField> getAllProperties() {
        return this.properties;
    }

    public List<AbstractField> getPropertiesByLocalName(String localName) {
        List<AbstractField> absFields = this.getAllProperties();
        if (absFields != null) {
            ArrayList<AbstractField> list = new ArrayList<AbstractField>();
            for (AbstractField abstractField : absFields) {
                if (!abstractField.getPropertyName().equals(localName)) continue;
                list.add(abstractField);
            }
            if (list.size() == 0) {
                return null;
            }
            return list;
        }
        return null;
    }

    public boolean isSameProperty(AbstractField prop1, AbstractField prop2) {
        if (prop1.getClass().equals(prop2.getClass())) {
            String pn1 = prop1.getPropertyName();
            String pn2 = prop2.getPropertyName();
            if (pn1 == null) {
                return pn2 == null;
            }
            if (pn1.equals(pn2)) {
                return prop1.equals(prop2);
            }
        }
        return false;
    }

    public boolean containsProperty(AbstractField property) {
        for (AbstractField tmp : this.getAllProperties()) {
            if (!this.isSameProperty(tmp, property)) continue;
            return true;
        }
        return false;
    }

    public void removeProperty(AbstractField property) {
        if (this.containsProperty(property)) {
            this.properties.remove(property);
        }
    }
}

