/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.metrics;

import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.metrics.ClusterMetricsChanged;
import org.apache.pekko.cluster.metrics.ClusterMetricsCollector$GossipTick$;
import org.apache.pekko.cluster.metrics.ClusterMetricsCollector$MetricsTick$;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension$;
import org.apache.pekko.cluster.metrics.MetricsCollector;
import org.apache.pekko.cluster.metrics.MetricsCollector$;
import org.apache.pekko.cluster.metrics.MetricsGossip;
import org.apache.pekko.cluster.metrics.MetricsGossip$;
import org.apache.pekko.cluster.metrics.MetricsGossipEnvelope;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Set;
import scala.collection.SortedSetOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tErAB\u001d;\u0011\u0003QDI\u0002\u0004Gu!\u0005!h\u0012\u0005\u0006\u001d\u0006!\t\u0001U\u0004\u0006#\u0006A\tI\u0015\u0004\u0006)\u0006A\t)\u0016\u0005\u0006\u001d\u0012!\t!\u001a\u0005\bM\u0012\t\t\u0011\"\u0011h\u0011\u001d\u0001H!!A\u0005\u0002EDq!\u001e\u0003\u0002\u0002\u0013\u0005a\u000fC\u0004}\t\u0005\u0005I\u0011I?\t\u0013\u0005%A!!A\u0005\u0002\u0005-\u0001\"CA\u000b\t\u0005\u0005I\u0011IA\f\u0011%\tI\u0002BA\u0001\n\u0003\nY\u0002C\u0005\u0002\u001e\u0011\t\t\u0011\"\u0003\u0002 \u001d9\u0011qE\u0001\t\u0002\u0006%baBA\u0016\u0003!\u0005\u0015Q\u0006\u0005\u0007\u001d>!\t!a\f\t\u000f\u0019|\u0011\u0011!C!O\"9\u0001oDA\u0001\n\u0003\t\b\u0002C;\u0010\u0003\u0003%\t!!\r\t\u000fq|\u0011\u0011!C!{\"I\u0011\u0011B\b\u0002\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003+y\u0011\u0011!C!\u0003/A\u0011\"!\u0007\u0010\u0003\u0003%\t%a\u0007\t\u0013\u0005uq\"!A\u0005\n\u0005}aA\u0002$;\u0001i\nI\u0004\u0003\u0004O3\u0011\u0005\u0011Q\n\u0005\t{e\u0011\r\u0011\"\u0001\u0002R!A\u00111L\r!\u0002\u0013\t\u0019\u0006\u0003\u0005<3\t\u0007I\u0011AA/\u0011!\t)'\u0007Q\u0001\n\u0005}\u0003\"CA43\u0001\u0007I\u0011AA5\u0011%\ti(\u0007a\u0001\n\u0003\ty\b\u0003\u0005\u0002\nf\u0001\u000b\u0015BA6\u0011%\tY)\u0007a\u0001\n\u0003\ti\tC\u0005\u0002\u0016f\u0001\r\u0011\"\u0001\u0002\u0018\"A\u00111T\r!B\u0013\ty\tC\u0005\u0002\u001ef\u0011\r\u0011\"\u0001\u0002 \"A\u0011qU\r!\u0002\u0013\t\t\u000bC\u0005\u0002*f\u0011\r\u0011\"\u0001\u0002,\"A\u00111W\r!\u0002\u0013\ti\u000bC\u0005\u00026f\u0011\r\u0011\"\u0001\u0002,\"A\u0011qW\r!\u0002\u0013\ti\u000bC\u0004\u0002:f!\t%a/\t\u000f\u0005u\u0016\u0004\"\u0001\u0002@\"9\u0011qY\r\u0005B\u0005m\u0006bBAe3\u0011\u0005\u00111\u001a\u0005\b\u0003/LB\u0011AAm\u0011\u001d\ti.\u0007C\u0001\u0003?Dq!a=\u001a\t\u0003\tY\fC\u0004\u0002vf!\t!a>\t\u000f\t\r\u0011\u0004\"\u0001\u0002<\"9!QA\r\u0005\u0002\t\u001d\u0001b\u0002B\u00073\u0011\u0005!q\u0002\u0005\b\u0005'IB\u0011\u0001B\u000b\u0011\u001d\u0011Y\"\u0007C\u0001\u0005;AqAa\f\u001a\t\u0003\tY,A\fDYV\u001cH/\u001a:NKR\u0014\u0018nY:D_2dWm\u0019;pe*\u00111\bP\u0001\b[\u0016$(/[2t\u0015\tid(A\u0004dYV\u001cH/\u001a:\u000b\u0005}\u0002\u0015!\u00029fW.|'BA!C\u0003\u0019\t\u0007/Y2iK*\t1)A\u0002pe\u001e\u0004\"!R\u0001\u000e\u0003i\u0012qc\u00117vgR,'/T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u0014\u0005\u0005A\u0005CA%M\u001b\u0005Q%\"A&\u0002\u000bM\u001c\u0017\r\\1\n\u00055S%AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005!\u0015aC'fiJL7m\u001d+jG.\u0004\"a\u0015\u0003\u000e\u0003\u0005\u00111\"T3ue&\u001c7\u000fV5dWN!A\u0001\u0013,Z!\tIu+\u0003\u0002Y\u0015\n9\u0001K]8ek\u000e$\bC\u0001.c\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_\u001f\u00061AH]8pizJ\u0011aS\u0005\u0003C*\u000bq\u0001]1dW\u0006<W-\u0003\u0002dI\na1+\u001a:jC2L'0\u00192mK*\u0011\u0011M\u0013\u000b\u0002%\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fA\u0001\\1oO*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t!\u000f\u0005\u0002Jg&\u0011AO\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0003oj\u0004\"!\u0013=\n\u0005eT%aA!os\"91\u0010CA\u0001\u0002\u0004\u0011\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001\u007f!\u0011y\u0018QA<\u000e\u0005\u0005\u0005!bAA\u0002\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u000e\u0005M\u0001cA%\u0002\u0010%\u0019\u0011\u0011\u0003&\u0003\u000f\t{w\u000e\\3b]\"91PCA\u0001\u0002\u00049\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003I\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002Q\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u0005\t\u0004S\u0006\r\u0012bAA\u0013U\n1qJ\u00196fGR\f!bR8tg&\u0004H+[2l!\t\u0019vB\u0001\u0006H_N\u001c\u0018\u000e\u001d+jG.\u001cBa\u0004%W3R\u0011\u0011\u0011\u0006\u000b\u0004o\u0006M\u0002bB>\u0014\u0003\u0003\u0005\rA\u001d\u000b\u0005\u0003\u001b\t9\u0004C\u0004|+\u0005\u0005\t\u0019A<\u0014\reA\u00151HA$!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!}\u0005)\u0011m\u0019;pe&!\u0011QIA \u0005\u0015\t5\r^8s!\u0011\ti$!\u0013\n\t\u0005-\u0013q\b\u0002\r\u0003\u000e$xN\u001d'pO\u001eLgn\u001a\u000b\u0003\u0003\u001f\u0002\"!R\r\u0016\u0005\u0005M\u0003\u0003BA+\u0003/j\u0011\u0001P\u0005\u0004\u00033b$aB\"mkN$XM]\u0001\tG2,8\u000f^3sAU\u0011\u0011q\f\t\u0004\u000b\u0006\u0005\u0014bAA2u\t92\t\\;ti\u0016\u0014X*\u001a;sS\u000e\u001cX\t\u001f;f]NLwN\\\u0001\t[\u0016$(/[2tA\u0005)an\u001c3fgV\u0011\u00111\u000e\t\u0007\u0003[\n\u0019(a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003\u0003\t\u0011\"[7nkR\f'\r\\3\n\t\u0005U\u0014q\u000e\u0002\n'>\u0014H/\u001a3TKR\u0004B!!\u0010\u0002z%!\u00111PA \u0005\u001d\tE\r\u001a:fgN\f\u0011B\\8eKN|F%Z9\u0015\t\u0005\u0005\u0015q\u0011\t\u0004\u0013\u0006\r\u0015bAAC\u0015\n!QK\\5u\u0011!Y\b%!AA\u0002\u0005-\u0014A\u00028pI\u0016\u001c\b%\u0001\u0007mCR,7\u000f^$pgNL\u0007/\u0006\u0002\u0002\u0010B\u0019Q)!%\n\u0007\u0005M%HA\u0007NKR\u0014\u0018nY:H_N\u001c\u0018\u000e]\u0001\u0011Y\u0006$Xm\u001d;H_N\u001c\u0018\u000e]0%KF$B!!!\u0002\u001a\"A1pIA\u0001\u0002\u0004\ty)A\u0007mCR,7\u000f^$pgNL\u0007\u000fI\u0001\nG>dG.Z2u_J,\"!!)\u0011\u0007\u0015\u000b\u0019+C\u0002\u0002&j\u0012\u0001#T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u0002\u0015\r|G\u000e\\3di>\u0014\b%\u0001\u0006h_N\u001c\u0018\u000e\u001d+bg.,\"!!,\u0011\t\u0005u\u0012qV\u0005\u0005\u0003c\u000byDA\u0006DC:\u001cW\r\u001c7bE2,\u0017aC4pgNL\u0007\u000fV1tW\u0002\n!b]1na2,G+Y:l\u0003-\u0019\u0018-\u001c9mKR\u000b7o\u001b\u0011\u0002\u0011A\u0014Xm\u0015;beR$\"!!!\u0002\u000fI,7-Z5wKV\u0011\u0011\u0011\u0019\t\u0007\u0013\u0006\rw/!!\n\u0007\u0005\u0015'JA\bQCJ$\u0018.\u00197Gk:\u001cG/[8o\u0003!\u0001xn\u001d;Ti>\u0004\u0018!C1eI6+WNY3s)\u0011\t\t)!4\t\u000f\u0005=g\u00061\u0001\u0002R\u00061Q.Z7cKJ\u0004B!!\u0016\u0002T&\u0019\u0011Q\u001b\u001f\u0003\r5+WNY3s\u00031\u0011X-\\8wK6+WNY3s)\u0011\t\t)a7\t\u000f\u0005=w\u00061\u0001\u0002R\u0006a!/Z2fSZ,7\u000b^1uKR!\u0011\u0011QAq\u0011\u001d\t\u0019\u000f\ra\u0001\u0003K\fQa\u001d;bi\u0016\u0004B!a:\u0002n:!\u0011QKAu\u0013\r\tY\u000fP\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0003_\f\tPA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0002lr\naa]1na2,\u0017!\u0004:fG\u0016Lg/Z$pgNL\u0007\u000f\u0006\u0003\u0002\u0002\u0006e\bbBA~e\u0001\u0007\u0011Q`\u0001\tK:4X\r\\8qKB\u0019Q)a@\n\u0007\t\u0005!HA\u000bNKR\u0014\u0018nY:H_N\u001c\u0018\u000e]#om\u0016dw\u000e]3\u0002\r\u001d|7o]5q\u0003!9wn]:jaR{G\u0003BAA\u0005\u0013AqAa\u00035\u0001\u0004\t9(A\u0004bI\u0012\u0014Xm]:\u0002\u001bI,\u0007\u000f\\=H_N\u001c\u0018\u000e\u001d+p)\u0011\t\tI!\u0005\t\u000f\t-Q\u00071\u0001\u0002x\u0005Q1/\u001a8e\u000f>\u001c8/\u001b9\u0015\r\u0005\u0005%q\u0003B\r\u0011\u001d\u0011YA\u000ea\u0001\u0003oBq!a?7\u0001\u0004\ti0\u0001\ttK2,7\r\u001e*b]\u0012|WNT8eKR!!q\u0004B\u0013!\u0015I%\u0011EA<\u0013\r\u0011\u0019C\u0013\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\t\u001dr\u00071\u0001\u0003*\u0005I\u0011\r\u001a3sKN\u001cXm\u001d\t\u0007\u0003[\u0012Y#a\u001e\n\t\t5\u0012q\u000e\u0002\u000b\u0013:$W\r_3e'\u0016\f\u0018a\u00029vE2L7\u000f\u001b")
public class ClusterMetricsCollector
implements Actor,
ActorLogging {
    private final Cluster cluster;
    private final ClusterMetricsExtension metrics;
    private SortedSet<Address> nodes;
    private MetricsGossip latestGossip;
    private final MetricsCollector collector;
    private final Cancellable gossipTask;
    private final Cancellable sampleTask;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private ActorContext context;
    private ActorRef self;

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public ClusterMetricsExtension metrics() {
        return this.metrics;
    }

    public SortedSet<Address> nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet<Address> x$1) {
        this.nodes = x$1;
    }

    public MetricsGossip latestGossip() {
        return this.latestGossip;
    }

    public void latestGossip_$eq(MetricsGossip x$1) {
        this.latestGossip = x$1;
    }

    public MetricsCollector collector() {
        return this.collector;
    }

    public Cancellable gossipTask() {
        return this.gossipTask;
    }

    public Cancellable sampleTask() {
        return this.sampleTask;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
        this.cluster().ClusterLogger().logInfo("Metrics collection has started successfully");
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterMetricsCollector $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                block13: {
                    block15: {
                        Member m;
                        block14: {
                            A1 = x1;
                            if (ClusterMetricsCollector$GossipTick$.MODULE$.equals(A1)) {
                                this.$outer.gossip();
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (ClusterMetricsCollector$MetricsTick$.MODULE$.equals(A1)) {
                                this.$outer.sample();
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof MetricsGossipEnvelope) {
                                MetricsGossipEnvelope metricsGossipEnvelope = (MetricsGossipEnvelope)A1;
                                this.$outer.receiveGossip(metricsGossipEnvelope);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.CurrentClusterState) {
                                ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                                this.$outer.receiveState(currentClusterState);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.MemberUp) {
                                ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                                Member m2 = memberUp.member();
                                this.$outer.addMember(m2);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.MemberWeaklyUp) {
                                ClusterEvent.MemberWeaklyUp memberWeaklyUp = (ClusterEvent.MemberWeaklyUp)A1;
                                Member m3 = memberWeaklyUp.member();
                                this.$outer.addMember(m3);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.MemberRemoved) {
                                ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                                Member m4 = memberRemoved.member();
                                this.$outer.removeMember(m4);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.MemberExited) {
                                ClusterEvent.MemberExited memberExited = (ClusterEvent.MemberExited)A1;
                                Member m5 = memberExited.member();
                                this.$outer.removeMember(m5);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof ClusterEvent.UnreachableMember) {
                                ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                                Member m6 = unreachableMember.member();
                                this.$outer.removeMember(m6);
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (!(A1 instanceof ClusterEvent.ReachableMember)) break block13;
                            ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                            m = reachableMember.member();
                            MemberStatus memberStatus = m.status();
                            MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
                            if (!(memberStatus == null ? up$ != null : !memberStatus.equals(up$))) break block14;
                            MemberStatus memberStatus2 = m.status();
                            MemberStatus.WeaklyUp$ weaklyUp$ = MemberStatus.WeaklyUp$.MODULE$;
                            if (memberStatus2 != null ? !memberStatus2.equals(weaklyUp$) : weaklyUp$ != null) break block15;
                        }
                        this.$outer.addMember(m);
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)BoxedUnit.UNIT;
                }
                if (A1 instanceof ClusterEvent.MemberEvent) {
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (ClusterMetricsCollector$GossipTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (ClusterMetricsCollector$MetricsTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof MetricsGossipEnvelope) {
                    return true;
                }
                if (object instanceof ClusterEvent.CurrentClusterState) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    return true;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    return true;
                }
                return object instanceof ClusterEvent.MemberEvent;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void postStop() {
        this.cluster().unsubscribe(this.self());
        this.gossipTask().cancel();
        this.sampleTask().cancel();
        this.collector().close();
    }

    public void addMember(Member member) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$plus((Object)member.address())));
    }

    public void removeMember(Member member) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$minus((Object)member.address())));
        this.latestGossip_$eq(this.latestGossip().remove(member.address()));
        this.publish();
    }

    public void receiveState(ClusterEvent.CurrentClusterState state) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)((SortedSetOps)state.members().diff((Set)state.unreachable())).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                block3: {
                    A1 A1;
                    block2: {
                        A1 = x1;
                        MemberStatus memberStatus = A1.status();
                        MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
                        if (!(memberStatus == null ? up$ != null : !memberStatus.equals(up$))) break block2;
                        MemberStatus memberStatus2 = A1.status();
                        MemberStatus.WeaklyUp$ weaklyUp$ = MemberStatus.WeaklyUp$.MODULE$;
                        if (memberStatus2 != null ? !memberStatus2.equals(weaklyUp$) : weaklyUp$ != null) break block3;
                    }
                    return (B1)A1.address();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Member x1) {
                block3: {
                    block2: {
                        Member member = x1;
                        MemberStatus memberStatus = member.status();
                        MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
                        if (!(memberStatus == null ? up$ != null : !memberStatus.equals(up$))) break block2;
                        MemberStatus memberStatus2 = member.status();
                        MemberStatus.WeaklyUp$ weaklyUp$ = MemberStatus.WeaklyUp$.MODULE$;
                        if (memberStatus2 != null ? !memberStatus2.equals(weaklyUp$) : weaklyUp$ != null) break block3;
                    }
                    return true;
                }
                return false;
            }
        }, Member$.MODULE$.addressOrdering())));
    }

    public void sample() {
        this.latestGossip_$eq(this.latestGossip().$colon$plus(this.collector().sample()));
        this.publish();
    }

    public void receiveGossip(MetricsGossipEnvelope envelope) {
        MetricsGossip otherGossip = envelope.gossip().filter((scala.collection.immutable.Set<Address>)this.nodes());
        this.latestGossip_$eq(this.latestGossip().merge(otherGossip));
        if (!envelope.reply()) {
            this.replyGossipTo(envelope.from());
            return;
        }
    }

    public void gossip() {
        this.selectRandomNode((IndexedSeq<Address>)this.nodes().$minus((Object)this.cluster().selfAddress()).toVector()).foreach((Function1 & Serializable)address -> {
            this.gossipTo(address);
            return BoxedUnit.UNIT;
        });
    }

    public void gossipTo(Address address) {
        this.sendGossip(address, new MetricsGossipEnvelope(this.cluster().selfAddress(), this.latestGossip(), false));
    }

    public void replyGossipTo(Address address) {
        this.sendGossip(address, new MetricsGossipEnvelope(this.cluster().selfAddress(), this.latestGossip(), true));
    }

    public void sendGossip(Address address, MetricsGossipEnvelope envelope) {
        ActorSelection$.MODULE$.toScala(this.context().actorSelection(this.self().path().toStringWithAddress(address))).$bang((Object)envelope, this.self());
    }

    public Option<Address> selectRandomNode(IndexedSeq<Address> addresses) {
        if (addresses.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(addresses.apply(ThreadLocalRandom.current().nextInt(addresses.size())));
    }

    public void publish() {
        this.context().system().eventStream().publish((Object)new ClusterMetricsChanged(this.latestGossip().nodes()));
    }

    public ClusterMetricsCollector() {
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.metrics = (ClusterMetricsExtension)ClusterMetricsExtension$.MODULE$.apply(this.context().system());
        this.nodes = (SortedSet)SortedSet$.MODULE$.empty((Object)Member$.MODULE$.addressOrdering());
        this.latestGossip = MetricsGossip$.MODULE$.empty();
        this.collector = MetricsCollector$.MODULE$.apply(this.context().system());
        this.gossipTask = this.cluster().scheduler().scheduleWithFixedDelay(this.metrics().settings().PeriodicTasksInitialDelay().max(this.metrics().settings().CollectorGossipInterval()), this.metrics().settings().CollectorGossipInterval(), this.self(), (Object)ClusterMetricsCollector$GossipTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.sampleTask = this.cluster().scheduler().scheduleWithFixedDelay(this.metrics().settings().PeriodicTasksInitialDelay().max(this.metrics().settings().CollectorSampleInterval()), this.metrics().settings().CollectorSampleInterval(), this.self(), (Object)ClusterMetricsCollector$MetricsTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        Statics.releaseFence();
    }
}

