/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.metrics;

import com.typesafe.config.Config;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.cluster.metrics.ClusterMetricsEvent;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension$;
import org.apache.pekko.cluster.metrics.ClusterMetricsSettings;
import org.apache.pekko.cluster.metrics.ClusterMetricsStrategy;
import org.apache.pekko.cluster.metrics.ClusterMetricsSupervisor;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-4AAE\n\u0001=!A1\u0006\u0001B\u0001B\u0003%A\u0006C\u00030\u0001\u0011\u0005\u0001\u0007C\u00045\u0001\t\u0007I\u0011A\u001b\t\re\u0002\u0001\u0015!\u00037\u0011!Q\u0004A1A\u0005\u0002MY\u0004BB \u0001A\u0003%A\bC\u0004A\u0001\t\u0007I\u0011A!\t\r\u0015\u0003\u0001\u0015!\u0003C\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015i\u0005\u0001\"\u0001O\u000f\u0015\t6\u0003#\u0001S\r\u0015\u00112\u0003#\u0001T\u0011\u0015yC\u0002\"\u0001[\u0011\u0015YF\u0002\"\u0011]\u0011\u0015iF\u0002\"\u0011_\u0011\u0015iF\u0002\"\u0011d\u0011\u0015AG\u0002\"\u0011j\u0005]\u0019E.^:uKJlU\r\u001e:jGN,\u0005\u0010^3og&|gN\u0003\u0002\u0015+\u00059Q.\u001a;sS\u000e\u001c(B\u0001\f\u0018\u0003\u001d\u0019G.^:uKJT!\u0001G\r\u0002\u000bA,7n[8\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!:\u0012!B1di>\u0014\u0018B\u0001\u0016(\u0005%)\u0005\u0010^3og&|g.\u0001\u0004tsN$X-\u001c\t\u0003M5J!AL\u0014\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\rqJg.\u001b;?)\t\t4\u0007\u0005\u00023\u00015\t1\u0003C\u0003,\u0005\u0001\u0007A&\u0001\u0005tKR$\u0018N\\4t+\u00051\u0004C\u0001\u001a8\u0013\tA4C\u0001\fDYV\u001cH/\u001a:NKR\u0014\u0018nY:TKR$\u0018N\\4t\u0003%\u0019X\r\u001e;j]\u001e\u001c\b%\u0001\u0005tiJ\fG/Z4z+\u0005a\u0004C\u0001\u0014>\u0013\tqtE\u0001\nTkB,'O^5t_J\u001cFO]1uK\u001eL\u0018!C:ue\u0006$XmZ=!\u0003)\u0019X\u000f]3sm&\u001cxN]\u000b\u0002\u0005B\u0011aeQ\u0005\u0003\t\u001e\u0012\u0001\"Q2u_J\u0014VMZ\u0001\fgV\u0004XM\u001d<jg>\u0014\b%A\u0005tk\n\u001c8M]5cKR\u0011\u0001j\u0013\t\u0003A%K!AS\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0019&\u0001\rAQ\u0001\u0010[\u0016$(/[2t\u0019&\u001cH/\u001a8fe\u0006YQO\\:vEN\u001c'/\u001b2f)\tAu\nC\u0003Q\u0015\u0001\u0007!)\u0001\tnKR\u0014\u0018nY:MSN$XM\u001c;fe\u000692\t\\;ti\u0016\u0014X*\u001a;sS\u000e\u001cX\t\u001f;f]NLwN\u001c\t\u0003e1\u0019B\u0001D\u0010U/B\u0019a%V\u0019\n\u0005Y;#aC#yi\u0016t7/[8o\u0013\u0012\u0004\"A\n-\n\u0005e;#aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#\u0001*\u0002\r1|wn[;q+\u0005\u0011\u0016aA4fiR\u0011\u0011g\u0018\u0005\u0006W=\u0001\r\u0001\u0019\t\u0003M\u0005L!AY\u0014\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0003c\u0011DQa\u000b\tA\u0002\u0015\u0004\"A\n4\n\u0005\u001d<#AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014\u0018aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0005ER\u0007\"B\u0016\u0012\u0001\u0004a\u0003")
public class ClusterMetricsExtension
implements Extension {
    private final ExtendedActorSystem system;
    private final ClusterMetricsSettings settings;
    private final SupervisorStrategy strategy;
    private final ActorRef supervisor;

    public static ClusterMetricsExtension createExtension(ExtendedActorSystem system) {
        return ClusterMetricsExtension$.MODULE$.createExtension(system);
    }

    public static ClusterMetricsExtension get(ClassicActorSystemProvider system) {
        return ClusterMetricsExtension$.MODULE$.get(system);
    }

    public static ClusterMetricsExtension get(ActorSystem system) {
        return ClusterMetricsExtension$.MODULE$.get(system);
    }

    public static ClusterMetricsExtension$ lookup() {
        return ClusterMetricsExtension$.MODULE$.lookup();
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ClusterMetricsExtension$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return ClusterMetricsExtension$.MODULE$.apply(system);
    }

    public ClusterMetricsSettings settings() {
        return this.settings;
    }

    public SupervisorStrategy strategy() {
        return this.strategy;
    }

    public ActorRef supervisor() {
        return this.supervisor;
    }

    public void subscribe(ActorRef metricsListener) {
        this.system.eventStream().subscribe(metricsListener, ClusterMetricsEvent.class);
    }

    public void unsubscribe(ActorRef metricsListenter) {
        this.system.eventStream().unsubscribe(metricsListenter, ClusterMetricsEvent.class);
    }

    public ClusterMetricsExtension(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new ClusterMetricsSettings(system.settings().config());
        this.strategy = (SupervisorStrategy)system.dynamicAccess().createInstanceFor(this.settings().SupervisorStrategyProvider(), (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)this.settings().SupervisorStrategyConfiguration()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SupervisorStrategy.class)).getOrElse((Function0 & Serializable)() -> {
            LoggingAdapter log = Logging$.MODULE$.apply((ActorSystem)$this.system, ClusterMetricsExtension.class, LogSource$.MODULE$.fromAnyClass());
            log.error(new StringBuilder(61).append("Configured strategy provider ").append(this.settings().SupervisorStrategyProvider()).append(" failed to load, using default ").append(ClusterMetricsStrategy.class.getName()).append(".").toString());
            return new ClusterMetricsStrategy(this.settings().SupervisorStrategyConfiguration());
        });
        this.supervisor = system.systemActorOf(Props$.MODULE$.apply(ClusterMetricsSupervisor.class, (Seq)Nil$.MODULE$).withDispatcher(this.settings().MetricsDispatcher()).withDeploy(Deploy$.MODULE$.local()), this.settings().SupervisorName());
    }
}

