/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pekko.actor.Actor$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.PoisonPill$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.sharding.ClusterSharding$;
import org.apache.pekko.cluster.sharding.ClusterShardingGuardian;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$;
import org.apache.pekko.cluster.sharding.ShardCoordinator;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.cluster.sharding.internal.LeastShardAllocationStrategy;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.pattern.AskSupport;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.convert.AsScalaExtensions;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.AbstractPartialFunction;

@ScalaSignature(bytes="\u0006\u0005\tmt!\u0002\u0014(\u0011\u0003\u0011d!\u0002\u001b(\u0011\u0003)\u0004BB&\u0002\t\u0003\u0011I\u0006C\u0004\u0003\\\u0005!\tE!\u0018\t\u000f\tm\u0013\u0001\"\u0011\u0003h!9!\u0011O\u0001\u0005B\tM\u0004b\u0002B;\u0003\u0011\u0005#q\u000f\u0004\u0005i\u001d\u00021\t\u0003\u0005H\u000f\t\u0005\t\u0015!\u0003I\u0011\u0015Yu\u0001\"\u0001M\u0011\u001dquA1A\u0005\n=CaAV\u0004!\u0002\u0013\u0001\u0006b\u0002\u0016\b\u0005\u0004%Ia\u0016\u0005\u00079\u001e\u0001\u000b\u0011\u0002-\t\u000fu;!\u0019!C\u0005=\"1qo\u0002Q\u0001\n}Cq\u0001_\u0004C\u0002\u0013%a\f\u0003\u0004z\u000f\u0001\u0006Ia\u0018\u0005\tu\u001eA)\u0019!C\u0005w\")Ap\u0002C\u0001{\"1Ap\u0002C\u0001\u0003\u001bB\u0001\"a\u0017\b\t\u0003Y\u0013Q\f\u0005\u0007y\u001e!\t!!!\t\rq<A\u0011AAG\u0011\u0019ax\u0001\"\u0001\u0002\u0018\"9\u0011QV\u0004\u0005\n\u0005=\u0006B\u0002?\b\t\u0003\t\u0019\f\u0003\u0004}\u000f\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u000b<A\u0011AAd\u0011\u001d\t)m\u0002C\u0001\u00033DqA!\u0001\b\t\u0013\u0011\u0019\u0001C\u0004\u0002F\u001e!\tA!\u0003\t\u000f\u0005\u0015w\u0001\"\u0001\u0003\u001a!9!1E\u0004\u0005\u0002\t\u0015\u0002b\u0002B\u001c\u000f\u0011\u0005!\u0011\b\u0005\b\u0005\u007f9A\u0011\u0001B!\u0011\u001d\u0011)e\u0002C\u0001\u0005\u000fBqA!\u0014\b\t\u0003\u0011y%A\bDYV\u001cH/\u001a:TQ\u0006\u0014H-\u001b8h\u0015\tA\u0013&\u0001\u0005tQ\u0006\u0014H-\u001b8h\u0015\tQ3&A\u0004dYV\u001cH/\u001a:\u000b\u00051j\u0013!\u00029fW.|'B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001e\u001c\u0001\u0001\u0005\u00024\u00035\tqEA\bDYV\u001cH/\u001a:TQ\u0006\u0014H-\u001b8h'\u0015\ta\u0007\u0010B*!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fMB\u0019Q\b\u0011\"\u000e\u0003yR!aP\u0016\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\u0005s$aC#yi\u0016t7/[8o\u0013\u0012\u0004\"aM\u0004\u0014\u0007\u001d1D\t\u0005\u0002>\u000b&\u0011aI\u0010\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016l\u0007CA\u001fJ\u0013\tQeHA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.\u0001\u0004=S:LGO\u0010\u000b\u0003\u00056CQaR\u0005A\u0002!\u000b1\u0001\\8h+\u0005\u0001\u0006CA)U\u001b\u0005\u0011&BA*,\u0003\u0015)g/\u001a8u\u0013\t)&K\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u000b\u00021B\u0011\u0011LW\u0007\u0002S%\u00111,\u000b\u0002\b\u00072,8\u000f^3s\u0003!\u0019G.^:uKJ\u0004\u0013a\u0002:fO&|gn]\u000b\u0002?B!\u0001mZ5u\u001b\u0005\t'B\u00012d\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003I\u0016\fA!\u001e;jY*\ta-\u0001\u0003kCZ\f\u0017B\u00015b\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003UFt!a[8\u0011\u00051DT\"A7\u000b\u00059\f\u0014A\u0002\u001fs_>$h(\u0003\u0002qq\u00051\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001\b\b\u0005\u0002>k&\u0011aO\u0010\u0002\t\u0003\u000e$xN\u001d*fM\u0006A!/Z4j_:\u001c\b%A\u0004qe>D\u0018.Z:\u0002\u0011A\u0014x\u000e_5fg\u0002\n\u0001bZ;be\u0012L\u0017M\\\u000b\u0002i\u0006)1\u000f^1siRqAO`A\u0001\u0003\u0017\t)\"a\n\u00022\u0005\r\u0003\"B@\u0014\u0001\u0004I\u0017\u0001\u0003;za\u0016t\u0015-\\3\t\u000f\u0005\r1\u00031\u0001\u0002\u0006\u0005YQM\u001c;jif\u0004&o\u001c9t!\ri\u0014qA\u0005\u0004\u0003\u0013q$!\u0002)s_B\u001c\bbBA\u0007'\u0001\u0007\u0011qB\u0001\tg\u0016$H/\u001b8hgB\u00191'!\u0005\n\u0007\u0005MqEA\fDYV\u001cH/\u001a:TQ\u0006\u0014H-\u001b8h'\u0016$H/\u001b8hg\"9\u0011qC\nA\u0002\u0005e\u0011aD3yiJ\f7\r^#oi&$\u00180\u00133\u0011\t\u0005m\u0011\u0011\u0005\b\u0004g\u0005u\u0011bAA\u0010O\u0005Y1\u000b[1sIJ+w-[8o\u0013\u0011\t\u0019#!\n\u0003\u001f\u0015CHO]1di\u0016sG/\u001b;z\u0013\u0012T1!a\b(\u0011\u001d\tIc\u0005a\u0001\u0003W\ta\"\u001a=ue\u0006\u001cGo\u00155be\u0012LE\r\u0005\u0003\u0002\u001c\u00055\u0012\u0002BA\u0018\u0003K\u0011a\"\u0012=ue\u0006\u001cGo\u00155be\u0012LE\rC\u0004\u00024M\u0001\r!!\u000e\u0002%\u0005dGn\\2bi&|gn\u0015;sCR,w-\u001f\t\u0005\u0003o\tiDD\u00024\u0003sI1!a\u000f(\u0003A\u0019\u0006.\u0019:e\u0007>|'\u000fZ5oCR|'/\u0003\u0003\u0002@\u0005\u0005#aF*iCJ$\u0017\t\u001c7pG\u0006$\u0018n\u001c8TiJ\fG/Z4z\u0015\r\tYd\n\u0005\b\u0003\u000b\u001a\u0002\u0019AA$\u0003IA\u0017M\u001c3PM\u001a\u001cFo\u001c9NKN\u001c\u0018mZ3\u0011\u0007]\nI%C\u0002\u0002La\u00121!\u00118z)5!\u0018qJA)\u0003'\n)&a\u0016\u0002Z!)q\u0010\u0006a\u0001S\"9\u00111\u0001\u000bA\u0002\u0005\u0015\u0001bBA\f)\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003S!\u0002\u0019AA\u0016\u0011\u001d\t\u0019\u0004\u0006a\u0001\u0003kAq!!\u0012\u0015\u0001\u0004\t9%A\u0007j]R,'O\\1m'R\f'\u000f\u001e\u000b\u0010i\u0006}\u0013\u0011MA5\u0003W\ni'a\u001c\u0002r!)q0\u0006a\u0001S\"9\u00111A\u000bA\u0002\u0005\r\u0004CB\u001c\u0002f%\f)!C\u0002\u0002ha\u0012\u0011BR;oGRLwN\\\u0019\t\u000f\u00055Q\u00031\u0001\u0002\u0010!9\u0011qC\u000bA\u0002\u0005e\u0001bBA\u0015+\u0001\u0007\u00111\u0006\u0005\b\u0003g)\u0002\u0019AA\u001b\u0011\u001d\t)%\u0006a\u0001\u0003\u000fB3!FA;!\u0011\t9(! \u000e\u0005\u0005e$bAA>W\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eF\u0006u\u0003\u0007\u000b))a\"\u0002\n\u0006-\u0005\"B@\u0017\u0001\u0004I\u0007bBA\u0002-\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u001b1\u0002\u0019AA\b\u0011\u001d\t9B\u0006a\u0001\u00033Aq!!\u000b\u0017\u0001\u0004\tY\u0003F\u0005u\u0003\u001f\u000b\t*a%\u0002\u0016\")qp\u0006a\u0001S\"9\u00111A\fA\u0002\u0005\u0015\u0001bBA\f/\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003S9\u0002\u0019AA\u0016)5!\u0018\u0011TAN\u0003;\u000by*!+\u0002,\")q\u0010\u0007a\u0001S\"9\u00111\u0001\rA\u0002\u0005\u0015\u0001bBA\u00071\u0001\u0007\u0011q\u0002\u0005\b\u0003CC\u0002\u0019AAR\u0003AiWm]:bO\u0016,\u0005\u0010\u001e:bGR|'\u000f\u0005\u0003\u0002\u001c\u0005\u0015\u0016\u0002BAT\u0003K\u0011\u0001#T3tg\u0006<W-\u0012=ue\u0006\u001cGo\u001c:\t\u000f\u0005M\u0002\u00041\u0001\u00026!9\u0011Q\t\rA\u0002\u0005\u001d\u0013\u0001H3yiJ\f7\r^#oi&$\u00180\u00133Ge>lW\t\u001f;sC\u000e$xN\u001d\u000b\u0005\u00033\t\t\fC\u0004\u0002\"f\u0001\r!a)\u0015\u0013Q\f),a.\u0002:\u0006m\u0006\"B@\u001b\u0001\u0004I\u0007bBA\u00025\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u001bQ\u0002\u0019AA\b\u0011\u001d\t\tK\u0007a\u0001\u0003G#r\u0001^A`\u0003\u0003\f\u0019\rC\u0003\u00007\u0001\u0007\u0011\u000eC\u0004\u0002\u0004m\u0001\r!!\u0002\t\u000f\u0005\u00056\u00041\u0001\u0002$\u0006Q1\u000f^1siB\u0013x\u000e_=\u0015\u0013Q\fI-a3\u0002V\u0006]\u0007\"B@\u001d\u0001\u0004I\u0007bBAg9\u0001\u0007\u0011qZ\u0001\u0005e>dW\r\u0005\u00038\u0003#L\u0017bAAjq\t1q\n\u001d;j_:Dq!a\u0006\u001d\u0001\u0004\tI\u0002C\u0004\u0002*q\u0001\r!a\u000b\u0015\u0017Q\fY.!8\u0002`\u0006u\u0018q \u0005\u0006\u007fv\u0001\r!\u001b\u0005\b\u0003\u001bl\u0002\u0019AAh\u0011\u001d\t\t/\ba\u0001\u0003G\f!\u0002Z1uC\u000e+g\u000e^3s!\u00159\u0014\u0011[As!\u0011\t9/a>\u000f\t\u0005%\u00181\u001f\b\u0005\u0003W\f\tP\u0004\u0003\u0002n\u0006=X\"A\u0017\n\u00051j\u0013B\u0001\u0016,\u0013\r\t)0K\u0001\u0010\u00072,8\u000f^3s'\u0016$H/\u001b8hg&!\u0011\u0011`A~\u0005)!\u0015\r^1DK:$XM\u001d\u0006\u0004\u0003kL\u0003bBA\f;\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003Si\u0002\u0019AA\u0016\u0003%\u0001(o\u001c=z\u001d\u0006lW\rF\u0003j\u0005\u000b\u00119\u0001C\u0003\u0000=\u0001\u0007\u0011\u000eC\u0004\u0002bz\u0001\r!a9\u0015\u000fQ\u0014YA!\u0004\u0003\u0018!)qp\ba\u0001S\"9\u0011QZ\u0010A\u0002\t=\u0001#\u0002B\t\u0005'IW\"A2\n\u0007\tU1M\u0001\u0005PaRLwN\\1m\u0011\u001d\t\tk\ba\u0001\u0003G#\u0012\u0002\u001eB\u000e\u0005;\u0011yB!\t\t\u000b}\u0004\u0003\u0019A5\t\u000f\u00055\u0007\u00051\u0001\u0003\u0010!9\u0011\u0011\u001d\u0011A\u0002\t=\u0001bBAQA\u0001\u0007\u00111U\u0001\u000fg\"\f'\u000f\u001a+za\u0016t\u0015-\\3t+\t\u00119\u0003E\u0003\u0003*\tM\u0012.\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003%IW.\\;uC\ndWMC\u0002\u00032a\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Da\u000b\u0003\u0007M+G/A\thKR\u001c\u0006.\u0019:e)f\u0004XMT1nKN,\"Aa\u000f\u0011\u000b\tE!QH5\n\u0007\tU2-A\u0006tQ\u0006\u0014HMU3hS>tGc\u0001;\u0003D!)qp\ta\u0001S\u0006\u00012\u000f[1sIJ+w-[8o!J|\u00070\u001f\u000b\u0006i\n%#1\n\u0005\u0006\u007f\u0012\u0002\r!\u001b\u0005\b\u0003C$\u0003\u0019AAs\u0003y!WMZ1vYR\u001c\u0006.\u0019:e\u00032dwnY1uS>t7\u000b\u001e:bi\u0016<\u0017\u0010\u0006\u0003\u00026\tE\u0003bBA\u0007K\u0001\u0007\u0011q\u0002\t\u0004{\tU\u0013b\u0001B,}\t\u0019R\t\u001f;f]NLwN\\%e!J|g/\u001b3feR\t!'A\u0002hKR$2A\u0011B0\u0011\u001995\u00011\u0001\u0003bA\u0019QHa\u0019\n\u0007\t\u0015dHA\u0006BGR|'oU=ti\u0016lGc\u0001\"\u0003j!1q\t\u0002a\u0001\u0005W\u00022!\u0010B7\u0013\r\u0011yG\u0010\u0002\u001b\u00072\f7o]5d\u0003\u000e$xN]*zgR,W\u000e\u0015:pm&$WM]\u0001\u0007Y>|7.\u001e9\u0016\u0003I\nqb\u0019:fCR,W\t\u001f;f]NLwN\u001c\u000b\u0004\u0005\ne\u0004\"B$\u0007\u0001\u0004A\u0005")
public class ClusterSharding
implements Extension {
    private ActorRef guardian;
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final Cluster cluster;
    private final ConcurrentHashMap<String, ActorRef> regions;
    private final ConcurrentHashMap<String, ActorRef> proxies;
    private volatile boolean bitmap$0;

    public static ClusterSharding createExtension(ExtendedActorSystem system) {
        return new ClusterSharding(system);
    }

    public static ClusterSharding$ lookup() {
        return ClusterSharding$.MODULE$;
    }

    public static ClusterSharding get(ClassicActorSystemProvider system) {
        return (ClusterSharding)ExtensionId.get$((ExtensionId)ClusterSharding$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static ClusterSharding get(ActorSystem system) {
        return (ClusterSharding)ExtensionId.get$((ExtensionId)ClusterSharding$.MODULE$, (ActorSystem)system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return ExtensionId.apply$((ExtensionId)ClusterSharding$.MODULE$, (ClassicActorSystemProvider)system);
    }

    public static Extension apply(ActorSystem system) {
        return ExtensionId.apply$((ExtensionId)ClusterSharding$.MODULE$, (ActorSystem)system);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private Cluster cluster() {
        return this.cluster;
    }

    private ConcurrentHashMap<String, ActorRef> regions() {
        return this.regions;
    }

    private ConcurrentHashMap<String, ActorRef> proxies() {
        return this.proxies;
    }

    private ActorRef guardian$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                String guardianName = this.system.settings().config().getString("pekko.cluster.sharding.guardian-name");
                String dispatcher = this.system.settings().config().getString("pekko.cluster.sharding.use-dispatcher");
                this.guardian = this.system.systemActorOf(Props$.MODULE$.apply(ClassTag$.MODULE$.apply(ClusterShardingGuardian.class)).withDispatcher(dispatcher), guardianName);
                this.bitmap$0 = true;
            }
        }
        return this.guardian;
    }

    private ActorRef guardian() {
        if (!this.bitmap$0) {
            return this.guardian$lzycompute();
        }
        return this.guardian;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable)x$1 -> entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public ActorRef internalStart(String typeName, Function1<String, Props> entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        String string = settings.stateStoreMode();
        String string2 = ClusterShardingSettings$.MODULE$.StateStoreModePersistence();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().warning("Cluster Sharding has been set to use the deprecated `persistence` state store mode.");
        }
        if (settings.shouldHostShard(this.cluster())) {
            ActorRef actorRef = this.regions().get(typeName);
            if (actorRef == null) {
                void ask_actorRef;
                Timeout timeout = this.system.settings().CreationTimeout();
                ClusterShardingGuardian.Start startMsg = new ClusterShardingGuardian.Start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, handOffStopMessage);
                ActorRef actorRef2 = this.guardian();
                package$ ask_this = package$.MODULE$;
                Object var15_13 = null;
                actorRef2 = null;
                ActorRef qual$1 = AskSupport.ask$((AskSupport)ask_this, (ActorRef)ask_actorRef);
                ActorRef x$3 = Actor$.MODULE$.noSender();
                ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.internalAsk$extension(qual$1, (Object)startMsg, timeout, x$3).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
                this.regions().put(typeName, shardRegion);
                return shardRegion;
            }
            return actorRef;
        }
        this.log().debug("Starting Shard Region Proxy [{}] (no actors will be hosted on this node)...", (Object)typeName);
        return this.startProxy(typeName, settings.role(), (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, extractEntityId, extractShardId, allocationStrategy, PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), extractEntityId, extractShardId);
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor, ShardCoordinator.ShardAllocationStrategy allocationStrategy, Object handOffStopMessage) {
        return this.internalStart(typeName, (Function1<String, Props>)(Function1 & Serializable)x$2 -> entityProps, settings, (PartialFunction<Object, Tuple2<String, Object>>)new AbstractPartialFunction<Object, Tuple2<String, Object>>(null, messageExtractor){
            private String cache;
            private final ShardRegion.MessageExtractor messageExtractor$2;

            private String cache() {
                return this.cache;
            }

            private void cache_$eq(String x$1) {
                this.cache = x$1;
            }

            public boolean isDefinedAt(Object msg) {
                this.cache_$eq(this.messageExtractor$2.entityId(msg));
                return this.cache() != null;
            }

            public Tuple2<String, Object> apply(Object x) {
                return new Tuple2((Object)this.cache(), this.messageExtractor$2.entityMessage(x));
            }
            {
                this.messageExtractor$2 = messageExtractor$2;
            }
        }, (Function1<Object, String>)(Function1 & Serializable)msg -> messageExtractor.shardId(msg), allocationStrategy, handOffStopMessage);
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractEntityIdFromExtractor(ShardRegion.MessageExtractor messageExtractor) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public ActorRef start(String typeName, Props entityProps, ClusterShardingSettings settings, ShardRegion.MessageExtractor messageExtractor) {
        ShardCoordinator.ShardAllocationStrategy allocationStrategy = this.defaultShardAllocationStrategy(settings);
        return this.start(typeName, entityProps, settings, messageExtractor, allocationStrategy, (Object)PoisonPill$.MODULE$);
    }

    public ActorRef start(String typeName, Props entityProps, ShardRegion.MessageExtractor messageExtractor) {
        return this.start(typeName, entityProps, ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Option<String> role, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        return this.startProxy(typeName, role, (Option<String>)None$.MODULE$, extractEntityId, extractShardId);
    }

    /*
     * WARNING - void declaration
     */
    public ActorRef startProxy(String typeName, Option<String> role, Option<String> dataCenter, PartialFunction<Object, Tuple2<String, Object>> extractEntityId, Function1<Object, String> extractShardId) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, dataCenter));
        if (actorRef == null) {
            void ask_actorRef;
            Timeout timeout = this.system.settings().CreationTimeout();
            ClusterShardingSettings settings = ClusterShardingSettings$.MODULE$.apply((ActorSystem)this.system).withRole(role);
            ClusterShardingGuardian.StartProxy startMsg = new ClusterShardingGuardian.StartProxy(typeName, dataCenter, settings, extractEntityId, extractShardId);
            ActorRef actorRef2 = this.guardian();
            package$ ask_this = package$.MODULE$;
            Object var13_11 = null;
            actorRef2 = null;
            ActorRef qual$1 = AskSupport.ask$((AskSupport)ask_this, (ActorRef)ask_actorRef);
            ActorRef x$3 = Actor$.MODULE$.noSender();
            ActorRef shardRegion = ((ClusterShardingGuardian.Started)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.internalAsk$extension(qual$1, (Object)startMsg, timeout, x$3).mapTo(ClassTag$.MODULE$.apply(ClusterShardingGuardian.Started.class)), (Duration)timeout.duration())).shardRegion();
            this.proxies().put(this.proxyName(typeName, dataCenter), shardRegion);
            return shardRegion;
        }
        return actorRef;
    }

    private String proxyName(String typeName, Option<String> dataCenter) {
        if (None$.MODULE$.equals(dataCenter)) {
            return new StringBuilder(5).append(typeName).append("Proxy").toString();
        }
        if (dataCenter instanceof Some) {
            String t = (String)((Some)dataCenter).value();
            return new StringBuilder(6).append(typeName).append("Proxy").append("-").append(t).toString();
        }
        throw new MatchError(dataCenter);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, role, Optional.empty(), messageExtractor);
    }

    public ActorRef startProxy(String typeName, Optional<String> role, Optional<String> dataCenter, ShardRegion.MessageExtractor messageExtractor) {
        return this.startProxy(typeName, (Option<String>)Option$.MODULE$.apply(role.orElse(null)), (Option<String>)Option$.MODULE$.apply(dataCenter.orElse(null)), (PartialFunction<Object, Tuple2<String, Object>>)new /* invalid duplicate definition of identical inner class */, (Function1<Object, String>)(Function1 & Serializable)msg -> messageExtractor.shardId(msg));
    }

    public scala.collection.immutable.Set<String> shardTypeNames() {
        return AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Set)this.regions().keySet()).asScala().toSet();
    }

    public Set<String> getShardTypeNames() {
        return this.regions().keySet();
    }

    public ActorRef shardRegion(String typeName) {
        ActorRef actorRef = this.regions().get(typeName);
        if (actorRef == null) {
            ActorRef actorRef2 = this.proxies().get(this.proxyName(typeName, (Option<String>)None$.MODULE$));
            if (actorRef2 == null) {
                throw new IllegalStateException(new StringBuilder(54).append("Shard type [").append(typeName).append("] must be started first. Started ").append(this.regions().keySet()).append(" proxies ").append(this.proxies().keySet()).toString());
            }
            return actorRef2;
        }
        return actorRef;
    }

    public ActorRef shardRegionProxy(String typeName, String dataCenter) {
        ActorRef actorRef = this.proxies().get(this.proxyName(typeName, (Option<String>)new Some((Object)dataCenter)));
        if (actorRef == null) {
            throw new IllegalStateException(new StringBuilder(35).append("Shard type [").append(typeName).append("] must be started first").toString());
        }
        return actorRef;
    }

    public ShardCoordinator.ShardAllocationStrategy defaultShardAllocationStrategy(ClusterShardingSettings settings) {
        if (settings.tuningParameters().leastShardAllocationAbsoluteLimit() > 0) {
            int absoluteLimit = settings.tuningParameters().leastShardAllocationAbsoluteLimit();
            double relativeLimit = settings.tuningParameters().leastShardAllocationRelativeLimit();
            return new LeastShardAllocationStrategy(absoluteLimit, relativeLimit);
        }
        int threshold = settings.tuningParameters().leastShardAllocationRebalanceThreshold();
        int maxSimultaneousRebalance = settings.tuningParameters().leastShardAllocationMaxSimultaneousRebalance();
        return new ShardCoordinator.LeastShardAllocationStrategy(threshold, maxSimultaneousRebalance);
    }

    public ClusterSharding(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, ClusterSharding.class, LogSource$.MODULE$.fromClass());
        this.cluster = (Cluster)ExtensionId.apply$((ExtensionId)Cluster$.MODULE$, (ActorSystem)system);
        this.regions = new ConcurrentHashMap();
        this.proxies = new ConcurrentHashMap();
    }
}

