/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.convert.AsScalaExtensions;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@InternalApi
public final class ConfigUtil$ {
    public static final ConfigUtil$ MODULE$ = new ConfigUtil$();
    private static final String PekkoPrefix = "org.apache.pekko";
    private static final String AkkaPrefix = "akka";

    private String PekkoPrefix() {
        return PekkoPrefix;
    }

    private String AkkaPrefix() {
        return AkkaPrefix;
    }

    public Config addAkkaConfig(Config cfg, String akkaVersion) {
        return this.adaptPekkoToAkkaConfig(cfg).withValue("akka.version", ConfigValueFactory.fromAnyRef((Object)akkaVersion));
    }

    public Config adaptPekkoToAkkaConfig(Config cfg) {
        scala.collection.mutable.Set innerSet = (scala.collection.mutable.Set)((IterableOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Set)cfg.entrySet()).asScala().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ConfigUtil$.$anonfun$adaptPekkoToAkkaConfig$1(e)))).map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)entry.getKey()).replace("pekko", "akka")), (Object)MODULE$.adjustPackageNameToAkkaIfNecessary((ConfigValue)entry.getValue())));
        ObjectRef newConfig = ObjectRef.create((Object)cfg);
        innerSet.foreach((Function1 & Serializable)x0$1 -> {
            ConfigUtil$.$anonfun$adaptPekkoToAkkaConfig$3(newConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Config)newConfig.elem;
    }

    public Config adaptAkkaToPekkoConfig(Config cfg) {
        scala.collection.mutable.Set innerSet = (scala.collection.mutable.Set)((IterableOps)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)package.JavaConverters$.MODULE$, (Set)cfg.entrySet()).asScala().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)ConfigUtil$.$anonfun$adaptAkkaToPekkoConfig$1(e)))).map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)entry.getKey()).replace("akka", "pekko")), (Object)MODULE$.adjustPackageNameToPekkoIfNecessary((ConfigValue)entry.getValue())));
        ObjectRef newConfig = ObjectRef.create((Object)cfg);
        innerSet.foreach((Function1 & Serializable)x0$1 -> {
            ConfigUtil$.$anonfun$adaptAkkaToPekkoConfig$3(newConfig, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Config)newConfig.elem;
    }

    public boolean supportsAkkaConfig(Config cfg) {
        return cfg.getStringList("pekko.remote.accept-protocol-names").contains("akka");
    }

    public String getAkkaVersion(Config cfg) {
        if (cfg.hasPath("akka.version")) {
            return cfg.getString("akka.version");
        }
        return cfg.getString("pekko.remote.akka.version");
    }

    public boolean isStrictAkkaConfig(Config cfg) {
        String string = cfg.getString("pekko.remote.protocol-name");
        String string2 = "akka";
        return string != null && string.equals(string2) && cfg.getBoolean("pekko.remote.enforce-strict-config-prefix-check-on-join");
    }

    private ConfigValue adjustPackageNameToAkkaIfNecessary(ConfigValue cv) {
        ConfigValueType configValueType = cv.valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        if (!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null)) {
            String str = cv.unwrapped().toString();
            if (str.startsWith(this.PekkoPrefix())) {
                return ConfigValueFactory.fromAnyRef((Object)str.replace(this.PekkoPrefix(), this.AkkaPrefix()));
            }
            return cv;
        }
        return cv;
    }

    private ConfigValue adjustPackageNameToPekkoIfNecessary(ConfigValue cv) {
        ConfigValueType configValueType = cv.valueType();
        ConfigValueType configValueType2 = ConfigValueType.STRING;
        if (!(configValueType != null ? !configValueType.equals(configValueType2) : configValueType2 != null)) {
            String str = cv.unwrapped().toString();
            if (str.startsWith(this.AkkaPrefix())) {
                return ConfigValueFactory.fromAnyRef((Object)str.replace(this.AkkaPrefix(), this.PekkoPrefix()));
            }
            return cv;
        }
        return cv;
    }

    public static final /* synthetic */ boolean $anonfun$adaptPekkoToAkkaConfig$1(Map.Entry e) {
        if (((String)e.getKey()).startsWith("pekko.")) {
            ConfigValueType configValueType = ((ConfigValue)e.getValue()).valueType();
            ConfigValueType configValueType2 = ConfigValueType.OBJECT;
            if (configValueType == null ? configValueType2 != null : !configValueType.equals(configValueType2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$adaptPekkoToAkkaConfig$3(ObjectRef newConfig$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            ConfigValue value = (ConfigValue)x0$1._2();
            newConfig$1.elem = ((Config)newConfig$1.elem).withValue(key, value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$adaptAkkaToPekkoConfig$1(Map.Entry e) {
        if (((String)e.getKey()).startsWith("akka.")) {
            ConfigValueType configValueType = ((ConfigValue)e.getValue()).valueType();
            ConfigValueType configValueType2 = ConfigValueType.OBJECT;
            if (configValueType == null ? configValueType2 != null : !configValueType.equals(configValueType2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$adaptAkkaToPekkoConfig$3(ObjectRef newConfig$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            String key = (String)x0$1._1();
            ConfigValue value = (ConfigValue)x0$1._2();
            newConfig$2.elem = ((Config)newConfig$2.elem).withValue(key, value);
            return;
        }
        throw new MatchError(null);
    }

    private ConfigUtil$() {
    }
}

