/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.kubernetes;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.kubernetes.JsonFormat$;
import org.apache.pekko.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import org.apache.pekko.discovery.kubernetes.PodList;
import org.apache.pekko.discovery.kubernetes.Settings;
import org.apache.pekko.discovery.kubernetes.Settings$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.pki.kubernetes.PemManagersProvider$;
import org.apache.pekko.stream.Materializer$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\teq!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004B\u0002\u001b\u0002\t\u0003iRG\u0002\u0003r\u0003\u0001\u0011\b\"CA\u0005\t\t\u0005\t\u0015!\u0003U\u0011\u0019\u0011D\u0001\"\u0001\u0002\f\u0019)!&\b\u0001\u0002\u0014!Q\u0011QD\u0004\u0003\u0002\u0003\u0006I!a\b\t\u0015\u0005\u0015rA!A!\u0002\u0017\t9\u0003\u0003\u00043\u000f\u0011\u0005\u00111\u0007\u0005\n\u0003{9!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0014\bA\u0003%\u0011\u0011\t\u0005\u0007e\u001d!\t!!\u0015\t\u0013\u0005]sA1A\u0005\n\u0005e\u0003\u0002CA4\u000f\u0001\u0006I!a\u0017\t\u0013\u0005%tA1A\u0005\n\u0005-\u0004\u0002CAA\u000f\u0001\u0006I!!\u001c\t\u0013\u0005\ruA1A\u0005\n\u0005\u0015\u0005\u0002CAG\u000f\u0001\u0006I!a\"\t\u000f\u0005=u\u0001\"\u0011\u0002\u0012\"I\u0011qX\u0004C\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0003\u0007<\u0001\u0015!\u0003U\u0011!\u0001wA1A\u0005\n\u0005\u0005\u0007bBAc\u000f\u0001\u0006I\u0001\u0016\u0005\b\u0003\u000f<A\u0011BAe\u0011\u001d\t\u0019n\u0002C\u0005\u0003+Dq!a?\b\t\u0013\ti0A\u000fLk\n,'O\\3uKN\f\u0005/[*feZL7-\u001a#jg\u000e|g/\u001a:z\u0015\tqr$\u0001\u0006lk\n,'O\\3uKNT!\u0001I\u0011\u0002\u0013\u0011L7oY8wKJL(B\u0001\u0012$\u0003\u0015\u0001Xm[6p\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001A\u0011\u0011&A\u0007\u0002;\ti2*\u001e2fe:,G/Z:Ba&\u001cVM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018p\u0005\u0002\u0002YA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0002\u000fQ\f'oZ3ugR9aGS(`C\u000eD\u0007cA\u001c=}5\t\u0001H\u0003\u0002:u\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003w9\n!bY8mY\u0016\u001cG/[8o\u0013\ti\u0004HA\u0002TKF\u0004\"aP$\u000f\u0005\u0001+eBA!E\u001d\t\u00115)D\u0001$\u0013\t\u00113%\u0003\u0002!C%\u0011aiH\u0001\u0011'\u0016\u0014h/[2f\t&\u001c8m\u001c<fefL!\u0001S%\u0003\u001dI+7o\u001c7wK\u0012$\u0016M]4fi*\u0011ai\b\u0005\u0006\u0017\u000e\u0001\r\u0001T\u0001\ba>$G*[:u!\tIS*\u0003\u0002O;\t9\u0001k\u001c3MSN$\b\"\u0002)\u0004\u0001\u0004\t\u0016\u0001\u00039peRt\u0015-\\3\u0011\u00075\u0012F+\u0003\u0002T]\t1q\n\u001d;j_:\u0004\"!\u0016/\u000f\u0005YS\u0006CA,/\u001b\u0005A&BA-(\u0003\u0019a$o\\8u}%\u00111LL\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\]!)\u0001m\u0001a\u0001)\u0006a\u0001o\u001c3OC6,7\u000f]1dK\")!m\u0001a\u0001)\u0006I\u0001o\u001c3E_6\f\u0017N\u001c\u0005\u0006I\u000e\u0001\r!Z\u0001\u0006e\u0006<\u0018\n\u001d\t\u0003[\u0019L!a\u001a\u0018\u0003\u000f\t{w\u000e\\3b]\")\u0011n\u0001a\u0001#\u0006i1m\u001c8uC&tWM\u001d(b[\u0016D#aA6\u0011\u00051|W\"A7\u000b\u00059\f\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001/\u001c\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018N\u0001\fLk\n,'O\\3uKN\f\u0005/[#yG\u0016\u0004H/[8o'\r!1\u000f \t\u0003ift!!^<\u000f\u0005]3\u0018\"A\u0018\n\u0005at\u0013a\u00029bG.\fw-Z\u0005\u0003un\u0014\u0001CU;oi&lW-\u0012=dKB$\u0018n\u001c8\u000b\u0005at\u0003cA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tqaY8oiJ|GNC\u0002\u0002\u00049\nA!\u001e;jY&\u0019\u0011q\u0001@\u0003\u00199{7\u000b^1dWR\u0013\u0018mY3\u0002\u00075\u001cx\r\u0006\u0003\u0002\u000e\u0005E\u0001cAA\b\t5\t\u0011\u0001\u0003\u0004\u0002\n\u0019\u0001\r\u0001V\n\u0004\u000f\u0005U\u0001\u0003BA\f\u00033i\u0011aH\u0005\u0004\u00037y\"\u0001E*feZL7-\u001a#jg\u000e|g/\u001a:z\u0003!\u0019X\r\u001e;j]\u001e\u001c\bcA\u0015\u0002\"%\u0019\u00111E\u000f\u0003\u0011M+G\u000f^5oON\faa]=ti\u0016l\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u0012%A\u0003bGR|'/\u0003\u0003\u00022\u0005-\"aC!di>\u00148+_:uK6$B!!\u000e\u0002<Q!\u0011qGA\u001d!\tIs\u0001C\u0004\u0002&)\u0001\u001d!a\n\t\u000f\u0005u!\u00021\u0001\u0002 \u0005!\u0001\u000e\u001e;q+\t\t\t\u0005\u0005\u0003\u0002D\u0005-SBAA#\u0015\u0011\t9%!\u0013\u0002\u0011M\u001c\u0017\r\\1eg2T1!!\u0010\"\u0013\u0011\ti%!\u0012\u0003\u000f!#H\u000f]#yi\u0006)\u0001\u000e\u001e;qAQ\u0011\u00111\u000b\u000b\u0005\u0003o\t)\u0006C\u0004\u0002&5\u0001\u001d!a\n\u0002\u00071|w-\u0006\u0002\u0002\\A!\u0011QLA2\u001b\t\tyFC\u0002\u0002b\u0005\nQ!\u001a<f]RLA!!\u001a\u0002`\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n!b]:m\u0007>tG/\u001a=u+\t\ti\u0007\u0005\u0003\u0002p\u0005uTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0007M\u001cHN\u0003\u0003\u0002x\u0005e\u0014a\u00018fi*\u0011\u00111P\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u007f\n\tH\u0001\u0006T'2\u001buN\u001c;fqR\f1b]:m\u0007>tG/\u001a=uA\u0005\u00012\r\\5f]R\u001c6\u000f\\\"p]R,\u0007\u0010^\u000b\u0003\u0003\u000f\u0003B!a\u0011\u0002\n&!\u00111RA#\u0005YAE\u000f\u001e9t\u0007>tg.Z2uS>t7i\u001c8uKb$\u0018!E2mS\u0016tGoU:m\u0007>tG/\u001a=uA\u00051An\\8lkB$b!a%\u0002&\u0006=\u0006CBAK\u00037\u000by*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u0018\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001e\u0006]%A\u0002$viV\u0014X\rE\u0002@\u0003CK1!a)J\u0005!\u0011Vm]8mm\u0016$\u0007bBAT)\u0001\u0007\u0011\u0011V\u0001\u0006cV,'/\u001f\t\u0005\u0003/\tY+C\u0002\u0002.~\u0011a\u0001T8pWV\u0004\bbBAY)\u0001\u0007\u00111W\u0001\u000fe\u0016\u001cx\u000e\u001c<f)&lWm\\;u!\u0011\t),a/\u000e\u0005\u0005]&\u0002BA]\u0003/\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003{\u000b9L\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u0011\u0005\u0004\u0018\u000eV8lK:,\u0012\u0001V\u0001\nCBLGk\\6f]\u0002\nQ\u0002]8e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013a\u0007:fC\u0012\u001cuN\u001c4jOZ\u000b'O\u0012:p[\u001aKG.Z:zgR,W\u000eF\u0003R\u0003\u0017\fy\r\u0003\u0004\u0002Nf\u0001\r\u0001V\u0001\u0005a\u0006$\b\u000e\u0003\u0004\u0002Rf\u0001\r\u0001V\u0001\u0005]\u0006lW-\u0001\bpaRLwN\u001c+p\rV$XO]3\u0016\t\u0005]\u0017q\u001c\u000b\u0007\u00033\f\t0a>\u0011\r\u0005U\u00151TAn!\u0011\ti.a8\r\u0001\u00119\u0011\u0011\u001d\u000eC\u0002\u0005\r(!\u0001+\u0012\t\u0005\u0015\u00181\u001e\t\u0004[\u0005\u001d\u0018bAAu]\t9aj\u001c;iS:<\u0007cA\u0017\u0002n&\u0019\u0011q\u001e\u0018\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002tj\u0001\r!!>\u0002\r=\u0004H/[8o!\u0011i#+a7\t\r\u0005e(\u00041\u0001U\u0003\u001d1\u0017-\u001b7Ng\u001e\f!\u0002]8e%\u0016\fX/Z:u)!\tyP!\u0004\u0003\u0012\tU\u0001\u0003B\u0017S\u0005\u0003\u0001BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0005\u0005\u000f\t)%A\u0003n_\u0012,G.\u0003\u0003\u0003\f\t\u0015!a\u0003%uiB\u0014V-];fgRDaAa\u0004\u001c\u0001\u0004!\u0016!\u0002;pW\u0016t\u0007B\u0002B\n7\u0001\u0007A+A\u0005oC6,7\u000f]1dK\"1!qC\u000eA\u0002Q\u000bQ\u0002\\1cK2\u001cV\r\\3di>\u0014\b")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final Settings settings;
    private final ActorSystem system;
    private final HttpExt http;
    private final LoggingAdapter log;
    private final SSLContext sslContext;
    private final HttpsConnectionContext clientSslContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private SSLContext sslContext() {
        return this.sslContext;
    }

    private HttpsConnectionContext clientSslContext() {
        return this.clientSslContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings.podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings.apiServiceHostEnvName()).append(", ").append(this.settings.apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable)request -> this.http().singleRequest(request, this.clientSslContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(SprayJsonSupport.sprayJsonUnmarshaller$((SprayJsonSupport)JsonFormat$.MODULE$, JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                unmarshalled.failed().foreach((Function1 & Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$4(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable)podList -> {
                Seq<ServiceDiscovery.ResolvedTarget> addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), $this.settings.podDomain(), $this.settings.rawIp(), $this.settings.containerName());
                if (addresses.isEmpty() && podList.items().nonEmpty() && this.log().isInfoEnabled()) {
                    Set containerPortNames = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)podList.items().flatMap((Function1 & Serializable)x$4 -> x$4.spec())).flatMap((Function1 & Serializable)x$5 -> x$5.containers())).flatMap((Function1 & Serializable)x$6 -> x$6.ports())).flatten(Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return new Some((Object)new String(Files.readAllBytes(file), StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.log().error(throwable, "Error reading {} from {}", (Object)name, (Object)path);
                    return None$.MODULE$;
                }
                throw throwable;
            }
        }
        this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
        return None$.MODULE$;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings.apiServiceHostEnvName()).flatMap((Function1 & Serializable)host -> package$.MODULE$.env().get((Object)$this.settings.apiServicePortEnvName()).flatMap((Function1 & Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(portStr))).toOption().map((Function1 & Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    public static final /* synthetic */ void $anonfun$lookup$4(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri uri = Uri$.MODULE$.from("https", x$4, host$1, port, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        .colon.colon x$10 = new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, uri, (Seq)x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(Settings settings, ActorSystem system) {
        this.settings = settings;
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromClass());
        Iterable certificates = PemManagersProvider$.MODULE$.loadCertificates(settings.apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificates);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        this.sslContext = sslContext;
        this.clientSslContext = ConnectionContext$.MODULE$.httpsClient(this.sslContext());
        this.log().debug("Settings {}", (Object)settings);
        this.apiToken = (String)this.readConfigVarFromFilesystem(settings.apiTokenPath(), "api-token").getOrElse((Function0 & Serializable)() -> "");
        this.podNamespace = (String)settings.podNamespace().orElse((Function0 & Serializable)() -> this.readConfigVarFromFilesystem($this.settings.podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable)() -> "default");
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this((Settings)ExtensionId.apply$((ExtensionId)Settings$.MODULE$, (ActorSystem)system), system);
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

