/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.kubernetes;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.kubernetes.JsonFormat$;
import org.apache.pekko.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import org.apache.pekko.discovery.kubernetes.PodList;
import org.apache.pekko.discovery.kubernetes.Settings;
import org.apache.pekko.discovery.kubernetes.Settings$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.javadsl.model.headers.AcceptEncoding;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.coding.Coder;
import org.apache.pekko.http.scaladsl.coding.Coders$;
import org.apache.pekko.http.scaladsl.marshallers.sprayjson.SprayJsonSupport;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncoding;
import org.apache.pekko.http.scaladsl.model.headers.HttpEncodings$;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.pki.kubernetes.PemManagersProvider$;
import org.apache.pekko.stream.Materializer$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t%r!B\u000f\u001f\u0011\u0003Ic!B\u0016\u001f\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!\u0004BB\u001b\u0002\t\u0003qbG\u0002\u0003s\u0003\u0001\u0019\b\"CA\u0006\t\t\u0005\t\u0015!\u0003V\u0011\u0019\u0019D\u0001\"\u0001\u0002\u000e\u0019)1F\b\u0001\u0002\u0016!Q\u0011qD\u0004\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005\u001drA!A!\u0002\u0017\tI\u0003\u0003\u00044\u000f\u0011\u0005\u0011Q\u0007\u0005\n\u0003\u007f9!\u0019!C\u0005\u0003\u0003B\u0001\"!\u0015\bA\u0003%\u00111\t\u0005\u0007g\u001d!\t!a\u0015\t\u0013\u0005esA1A\u0005\n\u0005m\u0003\u0002CA5\u000f\u0001\u0006I!!\u0018\t\u0013\u0005-tA1A\u0005\n\u00055\u0004\u0002CAB\u000f\u0001\u0006I!a\u001c\t\u0013\u0005\u0015uA1A\u0005\n\u0005\u001d\u0005\u0002CAH\u000f\u0001\u0006I!!#\t\u000f\u0005Eu\u0001\"\u0011\u0002\u0014\"I\u0011\u0011Y\u0004C\u0002\u0013%\u00111\u0019\u0005\b\u0003\u000b<\u0001\u0015!\u0003V\u0011!\twA1A\u0005\n\u0005\r\u0007bBAd\u000f\u0001\u0006I!\u0016\u0005\b\u0003\u0013<A\u0011BAf\u0011\u001d\t)n\u0002C\u0005\u0003/Dq!!@\b\t\u0013\ty\u0010C\u0004\u0003\u001c\u001d!IA!\b\u0002;-+(-\u001a:oKR,7/\u00119j'\u0016\u0014h/[2f\t&\u001c8m\u001c<fefT!a\b\u0011\u0002\u0015-,(-\u001a:oKR,7O\u0003\u0002\"E\u0005IA-[:d_Z,'/\u001f\u0006\u0003G\u0011\nQ\u0001]3lW>T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u0001\u0001C\u0001\u0016\u0002\u001b\u0005q\"!H&vE\u0016\u0014h.\u001a;fg\u0006\u0003\u0018nU3sm&\u001cW\rR5tG>4XM]=\u0014\u0005\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002S\u00059A/\u0019:hKR\u001cHcB\u001cL!\u0002\u0014G-\u001b\t\u0004quzT\"A\u001d\u000b\u0005iZ\u0014!C5n[V$\u0018M\u00197f\u0015\tat&\u0001\u0006d_2dWm\u0019;j_:L!AP\u001d\u0003\u0007M+\u0017\u000f\u0005\u0002A\u0011:\u0011\u0011I\u0012\b\u0003\u0005\u0016s!a\u0011#\u000e\u0003\u0011J!a\t\u0013\n\u0005\u0005\u0012\u0013BA$!\u0003A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u00180\u0003\u0002J\u0015\nq!+Z:pYZ,G\rV1sO\u0016$(BA$!\u0011\u0015a5\u00011\u0001N\u0003\u001d\u0001x\u000e\u001a'jgR\u0004\"A\u000b(\n\u0005=s\"a\u0002)pI2K7\u000f\u001e\u0005\u0006#\u000e\u0001\rAU\u0001\ta>\u0014HOT1nKB\u0019afU+\n\u0005Q{#AB(qi&|g\u000e\u0005\u0002W;:\u0011qk\u0017\t\u00031>j\u0011!\u0017\u0006\u00035\"\na\u0001\u0010:p_Rt\u0014B\u0001/0\u0003\u0019\u0001&/\u001a3fM&\u0011al\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005q{\u0003\"B1\u0004\u0001\u0004)\u0016\u0001\u00049pI:\u000bW.Z:qC\u000e,\u0007\"B2\u0004\u0001\u0004)\u0016!\u00039pI\u0012{W.Y5o\u0011\u0015)7\u00011\u0001g\u0003\u0015\u0011\u0018m^%q!\tqs-\u0003\u0002i_\t9!i\\8mK\u0006t\u0007\"\u00026\u0004\u0001\u0004\u0011\u0016!D2p]R\f\u0017N\\3s\u001d\u0006lW\r\u000b\u0002\u0004YB\u0011Q\u000e]\u0007\u0002]*\u0011qNI\u0001\u000bC:tw\u000e^1uS>t\u0017BA9o\u0005-Ie\u000e^3s]\u0006d\u0017\t]5\u0003--+(-\u001a:oKR,7/\u00119j\u000bb\u001cW\r\u001d;j_:\u001c2\u0001\u0002;~!\t)(P\u0004\u0002wq:\u0011\u0001l^\u0005\u0002a%\u0011\u0011pL\u0001\ba\u0006\u001c7.Y4f\u0013\tYHP\u0001\tSk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]*\u0011\u0011p\f\t\u0004}\u0006\u001dQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\bG>tGO]8m\u0015\r\t)aL\u0001\u0005kRLG.C\u0002\u0002\n}\u0014ABT8Ti\u0006\u001c7\u000e\u0016:bG\u0016\f1!\\:h)\u0011\ty!a\u0005\u0011\u0007\u0005EA!D\u0001\u0002\u0011\u0019\tYA\u0002a\u0001+N\u0019q!a\u0006\u0011\t\u0005e\u00111D\u0007\u0002A%\u0019\u0011Q\u0004\u0011\u0003!M+'O^5dK\u0012K7oY8wKJL\u0018\u0001C:fiRLgnZ:\u0011\u0007)\n\u0019#C\u0002\u0002&y\u0011\u0001bU3ui&twm]\u0001\u0007gf\u001cH/Z7\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f#\u0003\u0015\t7\r^8s\u0013\u0011\t\u0019$!\f\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0005\u0003o\ti\u0004\u0006\u0003\u0002:\u0005m\u0002C\u0001\u0016\b\u0011\u001d\t9C\u0003a\u0002\u0003SAq!a\b\u000b\u0001\u0004\t\t#\u0001\u0003iiR\u0004XCAA\"!\u0011\t)%!\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\n\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0004\u0003\u007f\u0011\u0013\u0002BA(\u0003\u000f\u0012q\u0001\u0013;ua\u0016CH/A\u0003iiR\u0004\b\u0005\u0006\u0002\u0002VQ!\u0011\u0011HA,\u0011\u001d\t9#\u0004a\u0002\u0003S\t1\u0001\\8h+\t\ti\u0006\u0005\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019GI\u0001\u0006KZ,g\u000e^\u0005\u0005\u0003O\n\tG\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\u0002\t1|w\rI\u0001\u000bgNd7i\u001c8uKb$XCAA8!\u0011\t\t(a \u000e\u0005\u0005M$\u0002BA;\u0003o\n1a]:m\u0015\u0011\tI(a\u001f\u0002\u00079,GO\u0003\u0002\u0002~\u0005)!.\u0019<bq&!\u0011\u0011QA:\u0005)\u00196\u000bT\"p]R,\u0007\u0010^\u0001\fgNd7i\u001c8uKb$\b%\u0001\tdY&,g\u000e^*tY\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0012\t\u0005\u0003\u000b\nY)\u0003\u0003\u0002\u000e\u0006\u001d#A\u0006%uiB\u001c8i\u001c8oK\u000e$\u0018n\u001c8D_:$X\r\u001f;\u0002#\rd\u0017.\u001a8u'Nd7i\u001c8uKb$\b%\u0001\u0004m_>\\W\u000f\u001d\u000b\u0007\u0003+\u000b9+!-\u0011\r\u0005]\u0015QTAQ\u001b\t\tIJC\u0002\u0002\u001c>\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\ty*!'\u0003\r\u0019+H/\u001e:f!\r\u0001\u00151U\u0005\u0004\u0003KS%\u0001\u0003*fg>dg/\u001a3\t\u000f\u0005%F\u00031\u0001\u0002,\u0006)\u0011/^3ssB!\u0011\u0011DAW\u0013\r\ty\u000b\t\u0002\u0007\u0019>|7.\u001e9\t\u000f\u0005MF\u00031\u0001\u00026\u0006q!/Z:pYZ,G+[7f_V$\b\u0003BA\\\u0003{k!!!/\u000b\t\u0005m\u0016\u0011T\u0001\tIV\u0014\u0018\r^5p]&!\u0011qXA]\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0001\"\u00199j)>\\WM\\\u000b\u0002+\u0006I\u0011\r]5U_.,g\u000eI\u0001\u000ea>$g*Y7fgB\f7-\u001a\u0011\u00027I,\u0017\rZ\"p]\u001aLwMV1s\rJ|WNR5mKNL8\u000f^3n)\u0015\u0011\u0016QZAi\u0011\u0019\ty-\u0007a\u0001+\u0006!\u0001/\u0019;i\u0011\u0019\t\u0019.\u0007a\u0001+\u0006!a.Y7f\u00039y\u0007\u000f^5p]R{g)\u001e;ve\u0016,B!!7\u0002bR1\u00111\\Az\u0003s\u0004b!a&\u0002\u001e\u0006u\u0007\u0003BAp\u0003Cd\u0001\u0001B\u0004\u0002dj\u0011\r!!:\u0003\u0003Q\u000bB!a:\u0002nB\u0019a&!;\n\u0007\u0005-xFA\u0004O_RD\u0017N\\4\u0011\u00079\ny/C\u0002\u0002r>\u00121!\u00118z\u0011\u001d\t)P\u0007a\u0001\u0003o\faa\u001c9uS>t\u0007\u0003\u0002\u0018T\u0003;Da!a?\u001b\u0001\u0004)\u0016a\u00024bS2l5oZ\u0001\u000ba>$'+Z9vKN$H\u0003\u0003B\u0001\u0005\u001f\u0011\u0019Ba\u0006\u0011\t9\u001a&1\u0001\t\u0005\u0005\u000b\u0011Y!\u0004\u0002\u0003\b)!!\u0011BA$\u0003\u0015iw\u000eZ3m\u0013\u0011\u0011iAa\u0002\u0003\u0017!#H\u000f\u001d*fcV,7\u000f\u001e\u0005\u0007\u0005#Y\u0002\u0019A+\u0002\u000bQ|7.\u001a8\t\r\tU1\u00041\u0001V\u0003%q\u0017-\\3ta\u0006\u001cW\r\u0003\u0004\u0003\u001am\u0001\r!V\u0001\u000eY\u0006\u0014W\r\\*fY\u0016\u001cGo\u001c:\u0002\u001d\u0011,7m\u001c3f%\u0016\u001c\bo\u001c8tKR!!q\u0004B\u0013!\u0011\u0011)A!\t\n\t\t\r\"q\u0001\u0002\r\u0011R$\bOU3ta>t7/\u001a\u0005\b\u0005Oa\u0002\u0019\u0001B\u0010\u0003!\u0011Xm\u001d9p]N,\u0007")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final Settings settings;
    private final ActorSystem system;
    private final HttpExt http;
    private final LoggingAdapter log;
    private final SSLContext sslContext;
    private final HttpsConnectionContext clientSslContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private SSLContext sslContext() {
        return this.sslContext;
    }

    private HttpsConnectionContext clientSslContext() {
        return this.clientSslContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings.podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings.apiServiceHostEnvName()).append(", ").append(this.settings.apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable)request -> this.http().singleRequest(request, this.clientSslContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).map((Function1 & Serializable)response -> this.decodeResponse((HttpResponse)response), (ExecutionContext)$this.system.dispatcher()).flatMap((Function1 & Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (!(success != null ? !success.equals(statusCode) : statusCode != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(SprayJsonSupport.sprayJsonUnmarshaller$((SprayJsonSupport)JsonFormat$.MODULE$, JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                unmarshalled.failed().foreach((Function1 & Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$7(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable)podList -> {
                Seq<ServiceDiscovery.ResolvedTarget> addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), $this.settings.podDomain(), $this.settings.rawIp(), $this.settings.containerName());
                if (addresses.isEmpty() && podList.items().nonEmpty() && this.log().isInfoEnabled()) {
                    Set containerPortNames = ((IterableOnceOps)((IterableOps)((IterableOps)((IterableOps)podList.items().flatMap((Function1 & Serializable)x$4 -> x$4.spec())).flatMap((Function1 & Serializable)x$5 -> x$5.containers())).flatMap((Function1 & Serializable)x$6 -> x$6.ports())).flatten(Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return new Some((Object)new String(Files.readAllBytes(file), StandardCharsets.UTF_8));
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    this.log().error(throwable, "Error reading {} from {}", (Object)name, (Object)path);
                    return None$.MODULE$;
                }
                throw throwable;
            }
        }
        this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
        return None$.MODULE$;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings.apiServiceHostEnvName()).flatMap((Function1 & Serializable)host -> package$.MODULE$.env().get((Object)$this.settings.apiServicePortEnvName()).flatMap((Function1 & Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(portStr))).toOption().map((Function1 & Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(this, namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    private HttpResponse decodeResponse(HttpResponse response) {
        Coder coder;
        HttpEncoding httpEncoding = response.encoding();
        HttpEncoding httpEncoding2 = HttpEncodings$.MODULE$.gzip();
        if (!(httpEncoding2 != null ? !httpEncoding2.equals(httpEncoding) : httpEncoding != null)) {
            coder = Coders$.MODULE$.Gzip();
        } else {
            HttpEncoding httpEncoding3 = HttpEncodings$.MODULE$.deflate();
            coder = !(httpEncoding3 != null ? !httpEncoding3.equals(httpEncoding) : httpEncoding != null) ? Coders$.MODULE$.Deflate() : Coders$.MODULE$.NoCoding();
        }
        return (HttpResponse)coder.decodeMessage((HttpMessage)response);
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$7(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(KubernetesApiServiceDiscovery $this, String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri uri = Uri$.MODULE$.from("https", x$4, host$1, port, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        .colon.colon authHeaders = new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        Option acceptEncodingHeader = HttpEncodings$.MODULE$.getForKey((Object)$this.settings.httpRequestAcceptEncoding()).map((Function1 & Serializable)httpEncoding -> AcceptEncoding.create((org.apache.pekko.http.javadsl.model.headers.HttpEncoding)httpEncoding));
        Seq x$10 = (Seq)authHeaders.$plus$plus((IterableOnce)acceptEncodingHeader);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, uri, x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(Settings settings, ActorSystem system) {
        this.settings = settings;
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromClass());
        Iterable certificates = PemManagersProvider$.MODULE$.loadCertificates(settings.apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificates);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance(settings.tlsVersion());
        sslContext.init(km, tm, random);
        this.sslContext = sslContext;
        this.clientSslContext = ConnectionContext$.MODULE$.httpsClient(this.sslContext());
        this.log().debug("Settings {}", (Object)settings);
        this.apiToken = (String)this.readConfigVarFromFilesystem(settings.apiTokenPath(), "api-token").getOrElse((Function0 & Serializable)() -> "");
        this.podNamespace = (String)settings.podNamespace().orElse((Function0 & Serializable)() -> this.readConfigVarFromFilesystem($this.settings.podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable)() -> "default");
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this((Settings)ExtensionId.apply$((ExtensionId)Settings$.MODULE$, (ActorSystem)system), system);
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

