/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2020-2022 Lightbend Inc. <https://www.lightbend.com>
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: MessageFormats.proto

package org.apache.pekko.persistence.serialization;

public final class MessageFormats {
  private MessageFormats() {}
  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      org.apache.pekko.protobufv3.internal.ExtensionRegistry registry) {
    registerAllExtensions(
        (org.apache.pekko.protobufv3.internal.ExtensionRegistryLite) registry);
  }
  public interface PersistentMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PersistentMessage)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     * @return Whether the payload field is set.
     */
    boolean hasPayload();
    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     * @return The payload.
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload();
    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder();

    /**
     * <code>optional int64 sequenceNr = 2;</code>
     * @return Whether the sequenceNr field is set.
     */
    boolean hasSequenceNr();
    /**
     * <code>optional int64 sequenceNr = 2;</code>
     * @return The sequenceNr.
     */
    long getSequenceNr();

    /**
     * <code>optional string persistenceId = 3;</code>
     * @return Whether the persistenceId field is set.
     */
    boolean hasPersistenceId();
    /**
     * <code>optional string persistenceId = 3;</code>
     * @return The persistenceId.
     */
    java.lang.String getPersistenceId();
    /**
     * <code>optional string persistenceId = 3;</code>
     * @return The bytes for persistenceId.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getPersistenceIdBytes();

    /**
     * <pre>
     * not used in new records from Akka 2.4
     * </pre>
     *
     * <code>optional bool deleted = 4;</code>
     * @return Whether the deleted field is set.
     */
    boolean hasDeleted();
    /**
     * <pre>
     * not used in new records from Akka 2.4
     * </pre>
     *
     * <code>optional bool deleted = 4;</code>
     * @return The deleted.
     */
    boolean getDeleted();

    /**
     * <code>optional string sender = 11;</code>
     * @return Whether the sender field is set.
     */
    boolean hasSender();
    /**
     * <code>optional string sender = 11;</code>
     * @return The sender.
     */
    java.lang.String getSender();
    /**
     * <code>optional string sender = 11;</code>
     * @return The bytes for sender.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getSenderBytes();

    /**
     * <code>optional string manifest = 12;</code>
     * @return Whether the manifest field is set.
     */
    boolean hasManifest();
    /**
     * <code>optional string manifest = 12;</code>
     * @return The manifest.
     */
    java.lang.String getManifest();
    /**
     * <code>optional string manifest = 12;</code>
     * @return The bytes for manifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getManifestBytes();

    /**
     * <code>optional string writerUuid = 13;</code>
     * @return Whether the writerUuid field is set.
     */
    boolean hasWriterUuid();
    /**
     * <code>optional string writerUuid = 13;</code>
     * @return The writerUuid.
     */
    java.lang.String getWriterUuid();
    /**
     * <code>optional string writerUuid = 13;</code>
     * @return The bytes for writerUuid.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getWriterUuidBytes();

    /**
     * <code>optional sint64 timestamp = 14;</code>
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();
    /**
     * <code>optional sint64 timestamp = 14;</code>
     * @return The timestamp.
     */
    long getTimestamp();

    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     * @return Whether the metadata field is set.
     */
    boolean hasMetadata();
    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     * @return The metadata.
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getMetadata();
    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getMetadataOrBuilder();
  }
  /**
   * Protobuf type {@code PersistentMessage}
   */
  public  static final class PersistentMessage extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:PersistentMessage)
      PersistentMessageOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PersistentMessage.newBuilder() to construct.
    private PersistentMessage(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PersistentMessage() {
      persistenceId_ = "";
      sender_ = "";
      manifest_ = "";
      writerUuid_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PersistentMessage();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PersistentMessage(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) != 0)) {
                subBuilder = payload_.toBuilder();
              }
              payload_ = input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(payload_);
                payload_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              sequenceNr_ = input.readInt64();
              break;
            }
            case 26: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              persistenceId_ = bs;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000008;
              deleted_ = input.readBool();
              break;
            }
            case 90: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000010;
              sender_ = bs;
              break;
            }
            case 98: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000020;
              manifest_ = bs;
              break;
            }
            case 106: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000040;
              writerUuid_ = bs;
              break;
            }
            case 112: {
              bitField0_ |= 0x00000080;
              timestamp_ = input.readSInt64();
              break;
            }
            case 122: {
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder subBuilder = null;
              if (((bitField0_ & 0x00000100) != 0)) {
                subBuilder = metadata_.toBuilder();
              }
              metadata_ = input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(metadata_);
                metadata_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000100;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentMessage_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder.class);
    }

    private int bitField0_;
    public static final int PAYLOAD_FIELD_NUMBER = 1;
    private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload payload_;
    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     * @return The payload.
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload() {
      return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
    }
    /**
     * <code>optional .PersistentPayload payload = 1;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder() {
      return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
    }

    public static final int SEQUENCENR_FIELD_NUMBER = 2;
    private long sequenceNr_;
    /**
     * <code>optional int64 sequenceNr = 2;</code>
     * @return Whether the sequenceNr field is set.
     */
    public boolean hasSequenceNr() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional int64 sequenceNr = 2;</code>
     * @return The sequenceNr.
     */
    public long getSequenceNr() {
      return sequenceNr_;
    }

    public static final int PERSISTENCEID_FIELD_NUMBER = 3;
    private volatile java.lang.Object persistenceId_;
    /**
     * <code>optional string persistenceId = 3;</code>
     * @return Whether the persistenceId field is set.
     */
    public boolean hasPersistenceId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional string persistenceId = 3;</code>
     * @return The persistenceId.
     */
    public java.lang.String getPersistenceId() {
      java.lang.Object ref = persistenceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          persistenceId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string persistenceId = 3;</code>
     * @return The bytes for persistenceId.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getPersistenceIdBytes() {
      java.lang.Object ref = persistenceId_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        persistenceId_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int DELETED_FIELD_NUMBER = 4;
    private boolean deleted_;
    /**
     * <pre>
     * not used in new records from Akka 2.4
     * </pre>
     *
     * <code>optional bool deleted = 4;</code>
     * @return Whether the deleted field is set.
     */
    public boolean hasDeleted() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * not used in new records from Akka 2.4
     * </pre>
     *
     * <code>optional bool deleted = 4;</code>
     * @return The deleted.
     */
    public boolean getDeleted() {
      return deleted_;
    }

    public static final int SENDER_FIELD_NUMBER = 11;
    private volatile java.lang.Object sender_;
    /**
     * <code>optional string sender = 11;</code>
     * @return Whether the sender field is set.
     */
    public boolean hasSender() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional string sender = 11;</code>
     * @return The sender.
     */
    public java.lang.String getSender() {
      java.lang.Object ref = sender_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          sender_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string sender = 11;</code>
     * @return The bytes for sender.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getSenderBytes() {
      java.lang.Object ref = sender_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sender_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int MANIFEST_FIELD_NUMBER = 12;
    private volatile java.lang.Object manifest_;
    /**
     * <code>optional string manifest = 12;</code>
     * @return Whether the manifest field is set.
     */
    public boolean hasManifest() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional string manifest = 12;</code>
     * @return The manifest.
     */
    public java.lang.String getManifest() {
      java.lang.Object ref = manifest_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          manifest_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string manifest = 12;</code>
     * @return The bytes for manifest.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getManifestBytes() {
      java.lang.Object ref = manifest_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        manifest_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int WRITERUUID_FIELD_NUMBER = 13;
    private volatile java.lang.Object writerUuid_;
    /**
     * <code>optional string writerUuid = 13;</code>
     * @return Whether the writerUuid field is set.
     */
    public boolean hasWriterUuid() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional string writerUuid = 13;</code>
     * @return The writerUuid.
     */
    public java.lang.String getWriterUuid() {
      java.lang.Object ref = writerUuid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          writerUuid_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string writerUuid = 13;</code>
     * @return The bytes for writerUuid.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getWriterUuidBytes() {
      java.lang.Object ref = writerUuid_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        writerUuid_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 14;
    private long timestamp_;
    /**
     * <code>optional sint64 timestamp = 14;</code>
     * @return Whether the timestamp field is set.
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional sint64 timestamp = 14;</code>
     * @return The timestamp.
     */
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int METADATA_FIELD_NUMBER = 15;
    private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload metadata_;
    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     * @return The metadata.
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getMetadata() {
      return metadata_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : metadata_;
    }
    /**
     * <code>optional .PersistentPayload metadata = 15;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getMetadataOrBuilder() {
      return metadata_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : metadata_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasPayload()) {
        if (!getPayload().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasMetadata()) {
        if (!getMetadata().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getPayload());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt64(2, sequenceNr_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 3, persistenceId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeBool(4, deleted_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 11, sender_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 12, manifest_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 13, writerUuid_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeSInt64(14, timestamp_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeMessage(15, getMetadata());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, getPayload());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt64Size(2, sequenceNr_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(3, persistenceId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBoolSize(4, deleted_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(11, sender_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(12, manifest_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(13, writerUuid_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeSInt64Size(14, timestamp_);
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(15, getMetadata());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage other = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage) obj;

      if (hasPayload() != other.hasPayload()) return false;
      if (hasPayload()) {
        if (!getPayload()
            .equals(other.getPayload())) return false;
      }
      if (hasSequenceNr() != other.hasSequenceNr()) return false;
      if (hasSequenceNr()) {
        if (getSequenceNr()
            != other.getSequenceNr()) return false;
      }
      if (hasPersistenceId() != other.hasPersistenceId()) return false;
      if (hasPersistenceId()) {
        if (!getPersistenceId()
            .equals(other.getPersistenceId())) return false;
      }
      if (hasDeleted() != other.hasDeleted()) return false;
      if (hasDeleted()) {
        if (getDeleted()
            != other.getDeleted()) return false;
      }
      if (hasSender() != other.hasSender()) return false;
      if (hasSender()) {
        if (!getSender()
            .equals(other.getSender())) return false;
      }
      if (hasManifest() != other.hasManifest()) return false;
      if (hasManifest()) {
        if (!getManifest()
            .equals(other.getManifest())) return false;
      }
      if (hasWriterUuid() != other.hasWriterUuid()) return false;
      if (hasWriterUuid()) {
        if (!getWriterUuid()
            .equals(other.getWriterUuid())) return false;
      }
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (getTimestamp()
            != other.getTimestamp()) return false;
      }
      if (hasMetadata() != other.hasMetadata()) return false;
      if (hasMetadata()) {
        if (!getMetadata()
            .equals(other.getMetadata())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPayload()) {
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayload().hashCode();
      }
      if (hasSequenceNr()) {
        hash = (37 * hash) + SEQUENCENR_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getSequenceNr());
      }
      if (hasPersistenceId()) {
        hash = (37 * hash) + PERSISTENCEID_FIELD_NUMBER;
        hash = (53 * hash) + getPersistenceId().hashCode();
      }
      if (hasDeleted()) {
        hash = (37 * hash) + DELETED_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashBoolean(
            getDeleted());
      }
      if (hasSender()) {
        hash = (37 * hash) + SENDER_FIELD_NUMBER;
        hash = (53 * hash) + getSender().hashCode();
      }
      if (hasManifest()) {
        hash = (37 * hash) + MANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getManifest().hashCode();
      }
      if (hasWriterUuid()) {
        hash = (37 * hash) + WRITERUUID_FIELD_NUMBER;
        hash = (53 * hash) + getWriterUuid().hashCode();
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getTimestamp());
      }
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PersistentMessage}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PersistentMessage)
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentMessage_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPayloadFieldBuilder();
          getMetadataFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (payloadBuilder_ == null) {
          payload_ = null;
        } else {
          payloadBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        sequenceNr_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        persistenceId_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        deleted_ = false;
        bitField0_ = (bitField0_ & ~0x00000008);
        sender_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        manifest_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        writerUuid_ = "";
        bitField0_ = (bitField0_ & ~0x00000040);
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000080);
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentMessage_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage build() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage result = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (payloadBuilder_ == null) {
            result.payload_ = payload_;
          } else {
            result.payload_ = payloadBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sequenceNr_ = sequenceNr_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.persistenceId_ = persistenceId_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.deleted_ = deleted_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          to_bitField0_ |= 0x00000010;
        }
        result.sender_ = sender_;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          to_bitField0_ |= 0x00000020;
        }
        result.manifest_ = manifest_;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          to_bitField0_ |= 0x00000040;
        }
        result.writerUuid_ = writerUuid_;
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.timestamp_ = timestamp_;
          to_bitField0_ |= 0x00000080;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          if (metadataBuilder_ == null) {
            result.metadata_ = metadata_;
          } else {
            result.metadata_ = metadataBuilder_.build();
          }
          to_bitField0_ |= 0x00000100;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.getDefaultInstance()) return this;
        if (other.hasPayload()) {
          mergePayload(other.getPayload());
        }
        if (other.hasSequenceNr()) {
          setSequenceNr(other.getSequenceNr());
        }
        if (other.hasPersistenceId()) {
          bitField0_ |= 0x00000004;
          persistenceId_ = other.persistenceId_;
          onChanged();
        }
        if (other.hasDeleted()) {
          setDeleted(other.getDeleted());
        }
        if (other.hasSender()) {
          bitField0_ |= 0x00000010;
          sender_ = other.sender_;
          onChanged();
        }
        if (other.hasManifest()) {
          bitField0_ |= 0x00000020;
          manifest_ = other.manifest_;
          onChanged();
        }
        if (other.hasWriterUuid()) {
          bitField0_ |= 0x00000040;
          writerUuid_ = other.writerUuid_;
          onChanged();
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasPayload()) {
          if (!getPayload().isInitialized()) {
            return false;
          }
        }
        if (hasMetadata()) {
          if (!getMetadata().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload payload_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> payloadBuilder_;
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       * @return Whether the payload field is set.
       */
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       * @return The payload.
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload() {
        if (payloadBuilder_ == null) {
          return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
        } else {
          return payloadBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public Builder setPayload(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (payloadBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          payload_ = value;
          onChanged();
        } else {
          payloadBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public Builder setPayload(
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder builderForValue) {
        if (payloadBuilder_ == null) {
          payload_ = builderForValue.build();
          onChanged();
        } else {
          payloadBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public Builder mergePayload(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (payloadBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              payload_ != null &&
              payload_ != org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance()) {
            payload_ =
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.newBuilder(payload_).mergeFrom(value).buildPartial();
          } else {
            payload_ = value;
          }
          onChanged();
        } else {
          payloadBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public Builder clearPayload() {
        if (payloadBuilder_ == null) {
          payload_ = null;
          onChanged();
        } else {
          payloadBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder getPayloadBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPayloadFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder() {
        if (payloadBuilder_ != null) {
          return payloadBuilder_.getMessageOrBuilder();
        } else {
          return payload_ == null ?
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
        }
      }
      /**
       * <code>optional .PersistentPayload payload = 1;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> 
          getPayloadFieldBuilder() {
        if (payloadBuilder_ == null) {
          payloadBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder>(
                  getPayload(),
                  getParentForChildren(),
                  isClean());
          payload_ = null;
        }
        return payloadBuilder_;
      }

      private long sequenceNr_ ;
      /**
       * <code>optional int64 sequenceNr = 2;</code>
       * @return Whether the sequenceNr field is set.
       */
      public boolean hasSequenceNr() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional int64 sequenceNr = 2;</code>
       * @return The sequenceNr.
       */
      public long getSequenceNr() {
        return sequenceNr_;
      }
      /**
       * <code>optional int64 sequenceNr = 2;</code>
       * @param value The sequenceNr to set.
       * @return This builder for chaining.
       */
      public Builder setSequenceNr(long value) {
        bitField0_ |= 0x00000002;
        sequenceNr_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 sequenceNr = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearSequenceNr() {
        bitField0_ = (bitField0_ & ~0x00000002);
        sequenceNr_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object persistenceId_ = "";
      /**
       * <code>optional string persistenceId = 3;</code>
       * @return Whether the persistenceId field is set.
       */
      public boolean hasPersistenceId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional string persistenceId = 3;</code>
       * @return The persistenceId.
       */
      public java.lang.String getPersistenceId() {
        java.lang.Object ref = persistenceId_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            persistenceId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string persistenceId = 3;</code>
       * @return The bytes for persistenceId.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getPersistenceIdBytes() {
        java.lang.Object ref = persistenceId_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          persistenceId_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string persistenceId = 3;</code>
       * @param value The persistenceId to set.
       * @return This builder for chaining.
       */
      public Builder setPersistenceId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        persistenceId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string persistenceId = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPersistenceId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        persistenceId_ = getDefaultInstance().getPersistenceId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string persistenceId = 3;</code>
       * @param value The bytes for persistenceId to set.
       * @return This builder for chaining.
       */
      public Builder setPersistenceIdBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        persistenceId_ = value;
        onChanged();
        return this;
      }

      private boolean deleted_ ;
      /**
       * <pre>
       * not used in new records from Akka 2.4
       * </pre>
       *
       * <code>optional bool deleted = 4;</code>
       * @return Whether the deleted field is set.
       */
      public boolean hasDeleted() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * not used in new records from Akka 2.4
       * </pre>
       *
       * <code>optional bool deleted = 4;</code>
       * @return The deleted.
       */
      public boolean getDeleted() {
        return deleted_;
      }
      /**
       * <pre>
       * not used in new records from Akka 2.4
       * </pre>
       *
       * <code>optional bool deleted = 4;</code>
       * @param value The deleted to set.
       * @return This builder for chaining.
       */
      public Builder setDeleted(boolean value) {
        bitField0_ |= 0x00000008;
        deleted_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * not used in new records from Akka 2.4
       * </pre>
       *
       * <code>optional bool deleted = 4;</code>
       * @return This builder for chaining.
       */
      public Builder clearDeleted() {
        bitField0_ = (bitField0_ & ~0x00000008);
        deleted_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object sender_ = "";
      /**
       * <code>optional string sender = 11;</code>
       * @return Whether the sender field is set.
       */
      public boolean hasSender() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional string sender = 11;</code>
       * @return The sender.
       */
      public java.lang.String getSender() {
        java.lang.Object ref = sender_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            sender_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sender = 11;</code>
       * @return The bytes for sender.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getSenderBytes() {
        java.lang.Object ref = sender_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sender_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string sender = 11;</code>
       * @param value The sender to set.
       * @return This builder for chaining.
       */
      public Builder setSender(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        sender_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sender = 11;</code>
       * @return This builder for chaining.
       */
      public Builder clearSender() {
        bitField0_ = (bitField0_ & ~0x00000010);
        sender_ = getDefaultInstance().getSender();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sender = 11;</code>
       * @param value The bytes for sender to set.
       * @return This builder for chaining.
       */
      public Builder setSenderBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        sender_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object manifest_ = "";
      /**
       * <code>optional string manifest = 12;</code>
       * @return Whether the manifest field is set.
       */
      public boolean hasManifest() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional string manifest = 12;</code>
       * @return The manifest.
       */
      public java.lang.String getManifest() {
        java.lang.Object ref = manifest_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            manifest_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string manifest = 12;</code>
       * @return The bytes for manifest.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getManifestBytes() {
        java.lang.Object ref = manifest_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          manifest_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string manifest = 12;</code>
       * @param value The manifest to set.
       * @return This builder for chaining.
       */
      public Builder setManifest(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        manifest_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string manifest = 12;</code>
       * @return This builder for chaining.
       */
      public Builder clearManifest() {
        bitField0_ = (bitField0_ & ~0x00000020);
        manifest_ = getDefaultInstance().getManifest();
        onChanged();
        return this;
      }
      /**
       * <code>optional string manifest = 12;</code>
       * @param value The bytes for manifest to set.
       * @return This builder for chaining.
       */
      public Builder setManifestBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        manifest_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object writerUuid_ = "";
      /**
       * <code>optional string writerUuid = 13;</code>
       * @return Whether the writerUuid field is set.
       */
      public boolean hasWriterUuid() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional string writerUuid = 13;</code>
       * @return The writerUuid.
       */
      public java.lang.String getWriterUuid() {
        java.lang.Object ref = writerUuid_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            writerUuid_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string writerUuid = 13;</code>
       * @return The bytes for writerUuid.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getWriterUuidBytes() {
        java.lang.Object ref = writerUuid_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          writerUuid_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>optional string writerUuid = 13;</code>
       * @param value The writerUuid to set.
       * @return This builder for chaining.
       */
      public Builder setWriterUuid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
        writerUuid_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string writerUuid = 13;</code>
       * @return This builder for chaining.
       */
      public Builder clearWriterUuid() {
        bitField0_ = (bitField0_ & ~0x00000040);
        writerUuid_ = getDefaultInstance().getWriterUuid();
        onChanged();
        return this;
      }
      /**
       * <code>optional string writerUuid = 13;</code>
       * @param value The bytes for writerUuid to set.
       * @return This builder for chaining.
       */
      public Builder setWriterUuidBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000040;
        writerUuid_ = value;
        onChanged();
        return this;
      }

      private long timestamp_ ;
      /**
       * <code>optional sint64 timestamp = 14;</code>
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional sint64 timestamp = 14;</code>
       * @return The timestamp.
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <code>optional sint64 timestamp = 14;</code>
       * @param value The timestamp to set.
       * @return This builder for chaining.
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000080;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional sint64 timestamp = 14;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000080);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload metadata_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> metadataBuilder_;
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       * @return Whether the metadata field is set.
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       * @return The metadata.
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public Builder setMetadata(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public Builder setMetadata(
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public Builder mergeMetadata(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0) &&
              metadata_ != null &&
              metadata_ != org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance()) {
            metadata_ =
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.newBuilder(metadata_).mergeFrom(value).buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null ?
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : metadata_;
        }
      }
      /**
       * <code>optional .PersistentPayload metadata = 15;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> 
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder>(
                  getMetadata(),
                  getParentForChildren(),
                  isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:PersistentMessage)
    }

    // @@protoc_insertion_point(class_scope:PersistentMessage)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PersistentMessage>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PersistentMessage>() {
      @java.lang.Override
      public PersistentMessage parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new PersistentMessage(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PersistentMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PersistentMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PersistentPayloadOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PersistentPayload)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required int32 serializerId = 1;</code>
     * @return Whether the serializerId field is set.
     */
    boolean hasSerializerId();
    /**
     * <code>required int32 serializerId = 1;</code>
     * @return The serializerId.
     */
    int getSerializerId();

    /**
     * <code>required bytes payload = 2;</code>
     * @return Whether the payload field is set.
     */
    boolean hasPayload();
    /**
     * <code>required bytes payload = 2;</code>
     * @return The payload.
     */
    org.apache.pekko.protobufv3.internal.ByteString getPayload();

    /**
     * <code>optional bytes payloadManifest = 3;</code>
     * @return Whether the payloadManifest field is set.
     */
    boolean hasPayloadManifest();
    /**
     * <code>optional bytes payloadManifest = 3;</code>
     * @return The payloadManifest.
     */
    org.apache.pekko.protobufv3.internal.ByteString getPayloadManifest();
  }
  /**
   * Protobuf type {@code PersistentPayload}
   */
  public  static final class PersistentPayload extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:PersistentPayload)
      PersistentPayloadOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PersistentPayload.newBuilder() to construct.
    private PersistentPayload(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PersistentPayload() {
      payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      payloadManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PersistentPayload();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PersistentPayload(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              serializerId_ = input.readInt32();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              payload_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              payloadManifest_ = input.readBytes();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentPayload_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentPayload_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder.class);
    }

    private int bitField0_;
    public static final int SERIALIZERID_FIELD_NUMBER = 1;
    private int serializerId_;
    /**
     * <code>required int32 serializerId = 1;</code>
     * @return Whether the serializerId field is set.
     */
    public boolean hasSerializerId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required int32 serializerId = 1;</code>
     * @return The serializerId.
     */
    public int getSerializerId() {
      return serializerId_;
    }

    public static final int PAYLOAD_FIELD_NUMBER = 2;
    private org.apache.pekko.protobufv3.internal.ByteString payload_;
    /**
     * <code>required bytes payload = 2;</code>
     * @return Whether the payload field is set.
     */
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required bytes payload = 2;</code>
     * @return The payload.
     */
    public org.apache.pekko.protobufv3.internal.ByteString getPayload() {
      return payload_;
    }

    public static final int PAYLOADMANIFEST_FIELD_NUMBER = 3;
    private org.apache.pekko.protobufv3.internal.ByteString payloadManifest_;
    /**
     * <code>optional bytes payloadManifest = 3;</code>
     * @return Whether the payloadManifest field is set.
     */
    public boolean hasPayloadManifest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional bytes payloadManifest = 3;</code>
     * @return The payloadManifest.
     */
    public org.apache.pekko.protobufv3.internal.ByteString getPayloadManifest() {
      return payloadManifest_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasSerializerId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasPayload()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt32(1, serializerId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBytes(2, payload_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, payloadManifest_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt32Size(1, serializerId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(2, payload_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeBytesSize(3, payloadManifest_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload other = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload) obj;

      if (hasSerializerId() != other.hasSerializerId()) return false;
      if (hasSerializerId()) {
        if (getSerializerId()
            != other.getSerializerId()) return false;
      }
      if (hasPayload() != other.hasPayload()) return false;
      if (hasPayload()) {
        if (!getPayload()
            .equals(other.getPayload())) return false;
      }
      if (hasPayloadManifest() != other.hasPayloadManifest()) return false;
      if (hasPayloadManifest()) {
        if (!getPayloadManifest()
            .equals(other.getPayloadManifest())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSerializerId()) {
        hash = (37 * hash) + SERIALIZERID_FIELD_NUMBER;
        hash = (53 * hash) + getSerializerId();
      }
      if (hasPayload()) {
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayload().hashCode();
      }
      if (hasPayloadManifest()) {
        hash = (37 * hash) + PAYLOADMANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getPayloadManifest().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PersistentPayload}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PersistentPayload)
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentPayload_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentPayload_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        serializerId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        payloadManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentPayload_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload build() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload result = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.serializerId_ = serializerId_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.payload_ = payload_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.payloadManifest_ = payloadManifest_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance()) return this;
        if (other.hasSerializerId()) {
          setSerializerId(other.getSerializerId());
        }
        if (other.hasPayload()) {
          setPayload(other.getPayload());
        }
        if (other.hasPayloadManifest()) {
          setPayloadManifest(other.getPayloadManifest());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasSerializerId()) {
          return false;
        }
        if (!hasPayload()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int serializerId_ ;
      /**
       * <code>required int32 serializerId = 1;</code>
       * @return Whether the serializerId field is set.
       */
      public boolean hasSerializerId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required int32 serializerId = 1;</code>
       * @return The serializerId.
       */
      public int getSerializerId() {
        return serializerId_;
      }
      /**
       * <code>required int32 serializerId = 1;</code>
       * @param value The serializerId to set.
       * @return This builder for chaining.
       */
      public Builder setSerializerId(int value) {
        bitField0_ |= 0x00000001;
        serializerId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 serializerId = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearSerializerId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        serializerId_ = 0;
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString payload_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>required bytes payload = 2;</code>
       * @return Whether the payload field is set.
       */
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required bytes payload = 2;</code>
       * @return The payload.
       */
      public org.apache.pekko.protobufv3.internal.ByteString getPayload() {
        return payload_;
      }
      /**
       * <code>required bytes payload = 2;</code>
       * @param value The payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayload(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        payload_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required bytes payload = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearPayload() {
        bitField0_ = (bitField0_ & ~0x00000002);
        payload_ = getDefaultInstance().getPayload();
        onChanged();
        return this;
      }

      private org.apache.pekko.protobufv3.internal.ByteString payloadManifest_ = org.apache.pekko.protobufv3.internal.ByteString.EMPTY;
      /**
       * <code>optional bytes payloadManifest = 3;</code>
       * @return Whether the payloadManifest field is set.
       */
      public boolean hasPayloadManifest() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional bytes payloadManifest = 3;</code>
       * @return The payloadManifest.
       */
      public org.apache.pekko.protobufv3.internal.ByteString getPayloadManifest() {
        return payloadManifest_;
      }
      /**
       * <code>optional bytes payloadManifest = 3;</code>
       * @param value The payloadManifest to set.
       * @return This builder for chaining.
       */
      public Builder setPayloadManifest(org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        payloadManifest_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes payloadManifest = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPayloadManifest() {
        bitField0_ = (bitField0_ & ~0x00000004);
        payloadManifest_ = getDefaultInstance().getPayloadManifest();
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:PersistentPayload)
    }

    // @@protoc_insertion_point(class_scope:PersistentPayload)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PersistentPayload>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PersistentPayload>() {
      @java.lang.Override
      public PersistentPayload parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new PersistentPayload(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PersistentPayload> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PersistentPayload> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AtomicWriteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AtomicWrite)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> 
        getPayloadList();
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getPayload(int index);
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    int getPayloadCount();
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder> 
        getPayloadOrBuilderList();
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder getPayloadOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code AtomicWrite}
   */
  public  static final class AtomicWrite extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:AtomicWrite)
      AtomicWriteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AtomicWrite.newBuilder() to construct.
    private AtomicWrite(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AtomicWrite() {
      payload_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new AtomicWrite();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private AtomicWrite(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                payload_ = new java.util.ArrayList<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage>();
                mutable_bitField0_ |= 0x00000001;
              }
              payload_.add(
                  input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.PARSER, extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          payload_ = java.util.Collections.unmodifiableList(payload_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtomicWrite_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtomicWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.class, org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.Builder.class);
    }

    public static final int PAYLOAD_FIELD_NUMBER = 1;
    private java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> payload_;
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> getPayloadList() {
      return payload_;
    }
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    public java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder> 
        getPayloadOrBuilderList() {
      return payload_;
    }
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    public int getPayloadCount() {
      return payload_.size();
    }
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getPayload(int index) {
      return payload_.get(index);
    }
    /**
     * <code>repeated .PersistentMessage payload = 1;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder getPayloadOrBuilder(
        int index) {
      return payload_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getPayloadCount(); i++) {
        if (!getPayload(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < payload_.size(); i++) {
        output.writeMessage(1, payload_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < payload_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(1, payload_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite other = (org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite) obj;

      if (!getPayloadList()
          .equals(other.getPayloadList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPayloadCount() > 0) {
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayloadList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AtomicWrite}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AtomicWrite)
        org.apache.pekko.persistence.serialization.MessageFormats.AtomicWriteOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtomicWrite_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtomicWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.class, org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getPayloadFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (payloadBuilder_ == null) {
          payload_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          payloadBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtomicWrite_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite build() {
        org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite result = new org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite(this);
        int from_bitField0_ = bitField0_;
        if (payloadBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            payload_ = java.util.Collections.unmodifiableList(payload_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.payload_ = payload_;
        } else {
          result.payload_ = payloadBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite.getDefaultInstance()) return this;
        if (payloadBuilder_ == null) {
          if (!other.payload_.isEmpty()) {
            if (payload_.isEmpty()) {
              payload_ = other.payload_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePayloadIsMutable();
              payload_.addAll(other.payload_);
            }
            onChanged();
          }
        } else {
          if (!other.payload_.isEmpty()) {
            if (payloadBuilder_.isEmpty()) {
              payloadBuilder_.dispose();
              payloadBuilder_ = null;
              payload_ = other.payload_;
              bitField0_ = (bitField0_ & ~0x00000001);
              payloadBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getPayloadFieldBuilder() : null;
            } else {
              payloadBuilder_.addAllMessages(other.payload_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getPayloadCount(); i++) {
          if (!getPayload(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> payload_ =
        java.util.Collections.emptyList();
      private void ensurePayloadIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          payload_ = new java.util.ArrayList<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage>(payload_);
          bitField0_ |= 0x00000001;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder> payloadBuilder_;

      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> getPayloadList() {
        if (payloadBuilder_ == null) {
          return java.util.Collections.unmodifiableList(payload_);
        } else {
          return payloadBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public int getPayloadCount() {
        if (payloadBuilder_ == null) {
          return payload_.size();
        } else {
          return payloadBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage getPayload(int index) {
        if (payloadBuilder_ == null) {
          return payload_.get(index);
        } else {
          return payloadBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder setPayload(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage value) {
        if (payloadBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePayloadIsMutable();
          payload_.set(index, value);
          onChanged();
        } else {
          payloadBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder setPayload(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder builderForValue) {
        if (payloadBuilder_ == null) {
          ensurePayloadIsMutable();
          payload_.set(index, builderForValue.build());
          onChanged();
        } else {
          payloadBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder addPayload(org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage value) {
        if (payloadBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePayloadIsMutable();
          payload_.add(value);
          onChanged();
        } else {
          payloadBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder addPayload(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage value) {
        if (payloadBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePayloadIsMutable();
          payload_.add(index, value);
          onChanged();
        } else {
          payloadBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder addPayload(
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder builderForValue) {
        if (payloadBuilder_ == null) {
          ensurePayloadIsMutable();
          payload_.add(builderForValue.build());
          onChanged();
        } else {
          payloadBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder addPayload(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder builderForValue) {
        if (payloadBuilder_ == null) {
          ensurePayloadIsMutable();
          payload_.add(index, builderForValue.build());
          onChanged();
        } else {
          payloadBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder addAllPayload(
          java.lang.Iterable<? extends org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage> values) {
        if (payloadBuilder_ == null) {
          ensurePayloadIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, payload_);
          onChanged();
        } else {
          payloadBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder clearPayload() {
        if (payloadBuilder_ == null) {
          payload_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          payloadBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public Builder removePayload(int index) {
        if (payloadBuilder_ == null) {
          ensurePayloadIsMutable();
          payload_.remove(index);
          onChanged();
        } else {
          payloadBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder getPayloadBuilder(
          int index) {
        return getPayloadFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder getPayloadOrBuilder(
          int index) {
        if (payloadBuilder_ == null) {
          return payload_.get(index);  } else {
          return payloadBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder> 
           getPayloadOrBuilderList() {
        if (payloadBuilder_ != null) {
          return payloadBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(payload_);
        }
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder addPayloadBuilder() {
        return getPayloadFieldBuilder().addBuilder(
            org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder addPayloadBuilder(
          int index) {
        return getPayloadFieldBuilder().addBuilder(
            index, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.getDefaultInstance());
      }
      /**
       * <code>repeated .PersistentMessage payload = 1;</code>
       */
      public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder> 
           getPayloadBuilderList() {
        return getPayloadFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder> 
          getPayloadFieldBuilder() {
        if (payloadBuilder_ == null) {
          payloadBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessage.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentMessageOrBuilder>(
                  payload_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          payload_ = null;
        }
        return payloadBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:AtomicWrite)
    }

    // @@protoc_insertion_point(class_scope:AtomicWrite)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<AtomicWrite>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<AtomicWrite>() {
      @java.lang.Override
      public AtomicWrite parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new AtomicWrite(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<AtomicWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<AtomicWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.AtomicWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AtLeastOnceDeliverySnapshotOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AtLeastOnceDeliverySnapshot)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required int64 currentDeliveryId = 1;</code>
     * @return Whether the currentDeliveryId field is set.
     */
    boolean hasCurrentDeliveryId();
    /**
     * <code>required int64 currentDeliveryId = 1;</code>
     * @return The currentDeliveryId.
     */
    long getCurrentDeliveryId();

    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> 
        getUnconfirmedDeliveriesList();
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getUnconfirmedDeliveries(int index);
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    int getUnconfirmedDeliveriesCount();
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder> 
        getUnconfirmedDeliveriesOrBuilderList();
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder getUnconfirmedDeliveriesOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code AtLeastOnceDeliverySnapshot}
   */
  public  static final class AtLeastOnceDeliverySnapshot extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:AtLeastOnceDeliverySnapshot)
      AtLeastOnceDeliverySnapshotOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use AtLeastOnceDeliverySnapshot.newBuilder() to construct.
    private AtLeastOnceDeliverySnapshot(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private AtLeastOnceDeliverySnapshot() {
      unconfirmedDeliveries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new AtLeastOnceDeliverySnapshot();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private AtLeastOnceDeliverySnapshot(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              currentDeliveryId_ = input.readInt64();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                unconfirmedDeliveries_ = new java.util.ArrayList<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery>();
                mutable_bitField0_ |= 0x00000002;
              }
              unconfirmedDeliveries_.add(
                  input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.PARSER, extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          unconfirmedDeliveries_ = java.util.Collections.unmodifiableList(unconfirmedDeliveries_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.class, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.Builder.class);
    }

    public interface UnconfirmedDeliveryOrBuilder extends
        // @@protoc_insertion_point(interface_extends:AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)
        org.apache.pekko.protobufv3.internal.MessageOrBuilder {

      /**
       * <code>required int64 deliveryId = 1;</code>
       * @return Whether the deliveryId field is set.
       */
      boolean hasDeliveryId();
      /**
       * <code>required int64 deliveryId = 1;</code>
       * @return The deliveryId.
       */
      long getDeliveryId();

      /**
       * <code>required string destination = 2;</code>
       * @return Whether the destination field is set.
       */
      boolean hasDestination();
      /**
       * <code>required string destination = 2;</code>
       * @return The destination.
       */
      java.lang.String getDestination();
      /**
       * <code>required string destination = 2;</code>
       * @return The bytes for destination.
       */
      org.apache.pekko.protobufv3.internal.ByteString
          getDestinationBytes();

      /**
       * <code>required .PersistentPayload payload = 3;</code>
       * @return Whether the payload field is set.
       */
      boolean hasPayload();
      /**
       * <code>required .PersistentPayload payload = 3;</code>
       * @return The payload.
       */
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload();
      /**
       * <code>required .PersistentPayload payload = 3;</code>
       */
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder();
    }
    /**
     * Protobuf type {@code AtLeastOnceDeliverySnapshot.UnconfirmedDelivery}
     */
    public  static final class UnconfirmedDelivery extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)
        UnconfirmedDeliveryOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use UnconfirmedDelivery.newBuilder() to construct.
      private UnconfirmedDelivery(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private UnconfirmedDelivery() {
        destination_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new UnconfirmedDelivery();
      }

      @java.lang.Override
      public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private UnconfirmedDelivery(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
            org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000001;
                deliveryId_ = input.readInt64();
                break;
              }
              case 18: {
                org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                destination_ = bs;
                break;
              }
              case 26: {
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) != 0)) {
                  subBuilder = payload_.toBuilder();
                }
                payload_ = input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(payload_);
                  payload_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.class, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder.class);
      }

      private int bitField0_;
      public static final int DELIVERYID_FIELD_NUMBER = 1;
      private long deliveryId_;
      /**
       * <code>required int64 deliveryId = 1;</code>
       * @return Whether the deliveryId field is set.
       */
      public boolean hasDeliveryId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required int64 deliveryId = 1;</code>
       * @return The deliveryId.
       */
      public long getDeliveryId() {
        return deliveryId_;
      }

      public static final int DESTINATION_FIELD_NUMBER = 2;
      private volatile java.lang.Object destination_;
      /**
       * <code>required string destination = 2;</code>
       * @return Whether the destination field is set.
       */
      public boolean hasDestination() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required string destination = 2;</code>
       * @return The destination.
       */
      public java.lang.String getDestination() {
        java.lang.Object ref = destination_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          org.apache.pekko.protobufv3.internal.ByteString bs = 
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            destination_ = s;
          }
          return s;
        }
      }
      /**
       * <code>required string destination = 2;</code>
       * @return The bytes for destination.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getDestinationBytes() {
        java.lang.Object ref = destination_;
        if (ref instanceof java.lang.String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          destination_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }

      public static final int PAYLOAD_FIELD_NUMBER = 3;
      private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload payload_;
      /**
       * <code>required .PersistentPayload payload = 3;</code>
       * @return Whether the payload field is set.
       */
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>required .PersistentPayload payload = 3;</code>
       * @return The payload.
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload() {
        return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
      }
      /**
       * <code>required .PersistentPayload payload = 3;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder() {
        return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasDeliveryId()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasDestination()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasPayload()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getPayload().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(1, deliveryId_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 2, destination_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(3, getPayload());
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeInt64Size(1, deliveryId_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(2, destination_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += org.apache.pekko.protobufv3.internal.CodedOutputStream
            .computeMessageSize(3, getPayload());
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)) {
          return super.equals(obj);
        }
        org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery other = (org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery) obj;

        if (hasDeliveryId() != other.hasDeliveryId()) return false;
        if (hasDeliveryId()) {
          if (getDeliveryId()
              != other.getDeliveryId()) return false;
        }
        if (hasDestination() != other.hasDestination()) return false;
        if (hasDestination()) {
          if (!getDestination()
              .equals(other.getDestination())) return false;
        }
        if (hasPayload() != other.hasPayload()) return false;
        if (hasPayload()) {
          if (!getPayload()
              .equals(other.getPayload())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDeliveryId()) {
          hash = (37 * hash) + DELIVERYID_FIELD_NUMBER;
          hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
              getDeliveryId());
        }
        if (hasDestination()) {
          hash = (37 * hash) + DESTINATION_FIELD_NUMBER;
          hash = (53 * hash) + getDestination().hashCode();
        }
        if (hasPayload()) {
          hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
          hash = (53 * hash) + getPayload().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          java.nio.ByteBuffer data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          java.nio.ByteBuffer data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          org.apache.pekko.protobufv3.internal.ByteString data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(byte[] data)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          byte[] data,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseDelimitedFrom(
          java.io.InputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parseFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code AtLeastOnceDeliverySnapshot.UnconfirmedDelivery}
       */
      public static final class Builder extends
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder {
        public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptor() {
          return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor;
        }

        @java.lang.Override
        protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.class, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder.class);
        }

        // Construct using org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getPayloadFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          deliveryId_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000001);
          destination_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          if (payloadBuilder_ == null) {
            payload_ = null;
          } else {
            payloadBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
            getDescriptorForType() {
          return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor;
        }

        @java.lang.Override
        public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getDefaultInstanceForType() {
          return org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.getDefaultInstance();
        }

        @java.lang.Override
        public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery build() {
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery buildPartial() {
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery result = new org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.deliveryId_ = deliveryId_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.destination_ = destination_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            if (payloadBuilder_ == null) {
              result.payload_ = payload_;
            } else {
              result.payload_ = payloadBuilder_.build();
            }
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
          if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery) {
            return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery other) {
          if (other == org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.getDefaultInstance()) return this;
          if (other.hasDeliveryId()) {
            setDeliveryId(other.getDeliveryId());
          }
          if (other.hasDestination()) {
            bitField0_ |= 0x00000002;
            destination_ = other.destination_;
            onChanged();
          }
          if (other.hasPayload()) {
            mergePayload(other.getPayload());
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasDeliveryId()) {
            return false;
          }
          if (!hasDestination()) {
            return false;
          }
          if (!hasPayload()) {
            return false;
          }
          if (!getPayload().isInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
            parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private long deliveryId_ ;
        /**
         * <code>required int64 deliveryId = 1;</code>
         * @return Whether the deliveryId field is set.
         */
        public boolean hasDeliveryId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required int64 deliveryId = 1;</code>
         * @return The deliveryId.
         */
        public long getDeliveryId() {
          return deliveryId_;
        }
        /**
         * <code>required int64 deliveryId = 1;</code>
         * @param value The deliveryId to set.
         * @return This builder for chaining.
         */
        public Builder setDeliveryId(long value) {
          bitField0_ |= 0x00000001;
          deliveryId_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required int64 deliveryId = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearDeliveryId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          deliveryId_ = 0L;
          onChanged();
          return this;
        }

        private java.lang.Object destination_ = "";
        /**
         * <code>required string destination = 2;</code>
         * @return Whether the destination field is set.
         */
        public boolean hasDestination() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required string destination = 2;</code>
         * @return The destination.
         */
        public java.lang.String getDestination() {
          java.lang.Object ref = destination_;
          if (!(ref instanceof java.lang.String)) {
            org.apache.pekko.protobufv3.internal.ByteString bs =
                (org.apache.pekko.protobufv3.internal.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              destination_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>required string destination = 2;</code>
         * @return The bytes for destination.
         */
        public org.apache.pekko.protobufv3.internal.ByteString
            getDestinationBytes() {
          java.lang.Object ref = destination_;
          if (ref instanceof String) {
            org.apache.pekko.protobufv3.internal.ByteString b = 
                org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            destination_ = b;
            return b;
          } else {
            return (org.apache.pekko.protobufv3.internal.ByteString) ref;
          }
        }
        /**
         * <code>required string destination = 2;</code>
         * @param value The destination to set.
         * @return This builder for chaining.
         */
        public Builder setDestination(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          destination_ = value;
          onChanged();
          return this;
        }
        /**
         * <code>required string destination = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearDestination() {
          bitField0_ = (bitField0_ & ~0x00000002);
          destination_ = getDefaultInstance().getDestination();
          onChanged();
          return this;
        }
        /**
         * <code>required string destination = 2;</code>
         * @param value The bytes for destination to set.
         * @return This builder for chaining.
         */
        public Builder setDestinationBytes(
            org.apache.pekko.protobufv3.internal.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          destination_ = value;
          onChanged();
          return this;
        }

        private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload payload_;
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> payloadBuilder_;
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         * @return Whether the payload field is set.
         */
        public boolean hasPayload() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         * @return The payload.
         */
        public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getPayload() {
          if (payloadBuilder_ == null) {
            return payload_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
          } else {
            return payloadBuilder_.getMessage();
          }
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public Builder setPayload(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
          if (payloadBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            payload_ = value;
            onChanged();
          } else {
            payloadBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public Builder setPayload(
            org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder builderForValue) {
          if (payloadBuilder_ == null) {
            payload_ = builderForValue.build();
            onChanged();
          } else {
            payloadBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public Builder mergePayload(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
          if (payloadBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0) &&
                payload_ != null &&
                payload_ != org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance()) {
              payload_ =
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.newBuilder(payload_).mergeFrom(value).buildPartial();
            } else {
              payload_ = value;
            }
            onChanged();
          } else {
            payloadBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public Builder clearPayload() {
          if (payloadBuilder_ == null) {
            payload_ = null;
            onChanged();
          } else {
            payloadBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder getPayloadBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getPayloadFieldBuilder().getBuilder();
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getPayloadOrBuilder() {
          if (payloadBuilder_ != null) {
            return payloadBuilder_.getMessageOrBuilder();
          } else {
            return payload_ == null ?
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : payload_;
          }
        }
        /**
         * <code>required .PersistentPayload payload = 3;</code>
         */
        private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
            org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> 
            getPayloadFieldBuilder() {
          if (payloadBuilder_ == null) {
            payloadBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder>(
                    getPayload(),
                    getParentForChildren(),
                    isClean());
            payload_ = null;
          }
          return payloadBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)
      }

      // @@protoc_insertion_point(class_scope:AtLeastOnceDeliverySnapshot.UnconfirmedDelivery)
      private static final org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery();
      }

      public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<UnconfirmedDelivery>
          PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<UnconfirmedDelivery>() {
        @java.lang.Override
        public UnconfirmedDelivery parsePartialFrom(
            org.apache.pekko.protobufv3.internal.CodedInputStream input,
            org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
            throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
          return new UnconfirmedDelivery(input, extensionRegistry);
        }
      };

      public static org.apache.pekko.protobufv3.internal.Parser<UnconfirmedDelivery> parser() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Parser<UnconfirmedDelivery> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int CURRENTDELIVERYID_FIELD_NUMBER = 1;
    private long currentDeliveryId_;
    /**
     * <code>required int64 currentDeliveryId = 1;</code>
     * @return Whether the currentDeliveryId field is set.
     */
    public boolean hasCurrentDeliveryId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required int64 currentDeliveryId = 1;</code>
     * @return The currentDeliveryId.
     */
    public long getCurrentDeliveryId() {
      return currentDeliveryId_;
    }

    public static final int UNCONFIRMEDDELIVERIES_FIELD_NUMBER = 2;
    private java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> unconfirmedDeliveries_;
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> getUnconfirmedDeliveriesList() {
      return unconfirmedDeliveries_;
    }
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    public java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder> 
        getUnconfirmedDeliveriesOrBuilderList() {
      return unconfirmedDeliveries_;
    }
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    public int getUnconfirmedDeliveriesCount() {
      return unconfirmedDeliveries_.size();
    }
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getUnconfirmedDeliveries(int index) {
      return unconfirmedDeliveries_.get(index);
    }
    /**
     * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder getUnconfirmedDeliveriesOrBuilder(
        int index) {
      return unconfirmedDeliveries_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCurrentDeliveryId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getUnconfirmedDeliveriesCount(); i++) {
        if (!getUnconfirmedDeliveries(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeInt64(1, currentDeliveryId_);
      }
      for (int i = 0; i < unconfirmedDeliveries_.size(); i++) {
        output.writeMessage(2, unconfirmedDeliveries_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt64Size(1, currentDeliveryId_);
      }
      for (int i = 0; i < unconfirmedDeliveries_.size(); i++) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, unconfirmedDeliveries_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot other = (org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot) obj;

      if (hasCurrentDeliveryId() != other.hasCurrentDeliveryId()) return false;
      if (hasCurrentDeliveryId()) {
        if (getCurrentDeliveryId()
            != other.getCurrentDeliveryId()) return false;
      }
      if (!getUnconfirmedDeliveriesList()
          .equals(other.getUnconfirmedDeliveriesList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCurrentDeliveryId()) {
        hash = (37 * hash) + CURRENTDELIVERYID_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getCurrentDeliveryId());
      }
      if (getUnconfirmedDeliveriesCount() > 0) {
        hash = (37 * hash) + UNCONFIRMEDDELIVERIES_FIELD_NUMBER;
        hash = (53 * hash) + getUnconfirmedDeliveriesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AtLeastOnceDeliverySnapshot}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AtLeastOnceDeliverySnapshot)
        org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshotOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.class, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getUnconfirmedDeliveriesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        currentDeliveryId_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (unconfirmedDeliveriesBuilder_ == null) {
          unconfirmedDeliveries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          unconfirmedDeliveriesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_AtLeastOnceDeliverySnapshot_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot build() {
        org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot result = new org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.currentDeliveryId_ = currentDeliveryId_;
          to_bitField0_ |= 0x00000001;
        }
        if (unconfirmedDeliveriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            unconfirmedDeliveries_ = java.util.Collections.unmodifiableList(unconfirmedDeliveries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.unconfirmedDeliveries_ = unconfirmedDeliveries_;
        } else {
          result.unconfirmedDeliveries_ = unconfirmedDeliveriesBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.getDefaultInstance()) return this;
        if (other.hasCurrentDeliveryId()) {
          setCurrentDeliveryId(other.getCurrentDeliveryId());
        }
        if (unconfirmedDeliveriesBuilder_ == null) {
          if (!other.unconfirmedDeliveries_.isEmpty()) {
            if (unconfirmedDeliveries_.isEmpty()) {
              unconfirmedDeliveries_ = other.unconfirmedDeliveries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureUnconfirmedDeliveriesIsMutable();
              unconfirmedDeliveries_.addAll(other.unconfirmedDeliveries_);
            }
            onChanged();
          }
        } else {
          if (!other.unconfirmedDeliveries_.isEmpty()) {
            if (unconfirmedDeliveriesBuilder_.isEmpty()) {
              unconfirmedDeliveriesBuilder_.dispose();
              unconfirmedDeliveriesBuilder_ = null;
              unconfirmedDeliveries_ = other.unconfirmedDeliveries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              unconfirmedDeliveriesBuilder_ = 
                org.apache.pekko.protobufv3.internal.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getUnconfirmedDeliveriesFieldBuilder() : null;
            } else {
              unconfirmedDeliveriesBuilder_.addAllMessages(other.unconfirmedDeliveries_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCurrentDeliveryId()) {
          return false;
        }
        for (int i = 0; i < getUnconfirmedDeliveriesCount(); i++) {
          if (!getUnconfirmedDeliveries(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long currentDeliveryId_ ;
      /**
       * <code>required int64 currentDeliveryId = 1;</code>
       * @return Whether the currentDeliveryId field is set.
       */
      public boolean hasCurrentDeliveryId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required int64 currentDeliveryId = 1;</code>
       * @return The currentDeliveryId.
       */
      public long getCurrentDeliveryId() {
        return currentDeliveryId_;
      }
      /**
       * <code>required int64 currentDeliveryId = 1;</code>
       * @param value The currentDeliveryId to set.
       * @return This builder for chaining.
       */
      public Builder setCurrentDeliveryId(long value) {
        bitField0_ |= 0x00000001;
        currentDeliveryId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int64 currentDeliveryId = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCurrentDeliveryId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        currentDeliveryId_ = 0L;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> unconfirmedDeliveries_ =
        java.util.Collections.emptyList();
      private void ensureUnconfirmedDeliveriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          unconfirmedDeliveries_ = new java.util.ArrayList<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery>(unconfirmedDeliveries_);
          bitField0_ |= 0x00000002;
         }
      }

      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder> unconfirmedDeliveriesBuilder_;

      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> getUnconfirmedDeliveriesList() {
        if (unconfirmedDeliveriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(unconfirmedDeliveries_);
        } else {
          return unconfirmedDeliveriesBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public int getUnconfirmedDeliveriesCount() {
        if (unconfirmedDeliveriesBuilder_ == null) {
          return unconfirmedDeliveries_.size();
        } else {
          return unconfirmedDeliveriesBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery getUnconfirmedDeliveries(int index) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          return unconfirmedDeliveries_.get(index);
        } else {
          return unconfirmedDeliveriesBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder setUnconfirmedDeliveries(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery value) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.set(index, value);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder setUnconfirmedDeliveries(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder builderForValue) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.set(index, builderForValue.build());
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder addUnconfirmedDeliveries(org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery value) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.add(value);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder addUnconfirmedDeliveries(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery value) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.add(index, value);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder addUnconfirmedDeliveries(
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder builderForValue) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.add(builderForValue.build());
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder addUnconfirmedDeliveries(
          int index, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder builderForValue) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.add(index, builderForValue.build());
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder addAllUnconfirmedDeliveries(
          java.lang.Iterable<? extends org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery> values) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          ensureUnconfirmedDeliveriesIsMutable();
          org.apache.pekko.protobufv3.internal.AbstractMessageLite.Builder.addAll(
              values, unconfirmedDeliveries_);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder clearUnconfirmedDeliveries() {
        if (unconfirmedDeliveriesBuilder_ == null) {
          unconfirmedDeliveries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public Builder removeUnconfirmedDeliveries(int index) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          ensureUnconfirmedDeliveriesIsMutable();
          unconfirmedDeliveries_.remove(index);
          onChanged();
        } else {
          unconfirmedDeliveriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder getUnconfirmedDeliveriesBuilder(
          int index) {
        return getUnconfirmedDeliveriesFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder getUnconfirmedDeliveriesOrBuilder(
          int index) {
        if (unconfirmedDeliveriesBuilder_ == null) {
          return unconfirmedDeliveries_.get(index);  } else {
          return unconfirmedDeliveriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public java.util.List<? extends org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder> 
           getUnconfirmedDeliveriesOrBuilderList() {
        if (unconfirmedDeliveriesBuilder_ != null) {
          return unconfirmedDeliveriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(unconfirmedDeliveries_);
        }
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder addUnconfirmedDeliveriesBuilder() {
        return getUnconfirmedDeliveriesFieldBuilder().addBuilder(
            org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.getDefaultInstance());
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder addUnconfirmedDeliveriesBuilder(
          int index) {
        return getUnconfirmedDeliveriesFieldBuilder().addBuilder(
            index, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.getDefaultInstance());
      }
      /**
       * <code>repeated .AtLeastOnceDeliverySnapshot.UnconfirmedDelivery unconfirmedDeliveries = 2;</code>
       */
      public java.util.List<org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder> 
           getUnconfirmedDeliveriesBuilderList() {
        return getUnconfirmedDeliveriesFieldBuilder().getBuilderList();
      }
      private org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder> 
          getUnconfirmedDeliveriesFieldBuilder() {
        if (unconfirmedDeliveriesBuilder_ == null) {
          unconfirmedDeliveriesBuilder_ = new org.apache.pekko.protobufv3.internal.RepeatedFieldBuilderV3<
              org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDelivery.Builder, org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot.UnconfirmedDeliveryOrBuilder>(
                  unconfirmedDeliveries_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          unconfirmedDeliveries_ = null;
        }
        return unconfirmedDeliveriesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:AtLeastOnceDeliverySnapshot)
    }

    // @@protoc_insertion_point(class_scope:AtLeastOnceDeliverySnapshot)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<AtLeastOnceDeliverySnapshot>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<AtLeastOnceDeliverySnapshot>() {
      @java.lang.Override
      public AtLeastOnceDeliverySnapshot parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new AtLeastOnceDeliverySnapshot(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<AtLeastOnceDeliverySnapshot> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<AtLeastOnceDeliverySnapshot> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.AtLeastOnceDeliverySnapshot getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PersistentStateChangeEventOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PersistentStateChangeEvent)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return Whether the stateIdentifier field is set.
     */
    boolean hasStateIdentifier();
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The stateIdentifier.
     */
    java.lang.String getStateIdentifier();
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The bytes for stateIdentifier.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getStateIdentifierBytes();

    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return Whether the timeout field is set.
     */
    boolean hasTimeout();
    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return The timeout.
     */
    java.lang.String getTimeout();
    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return The bytes for timeout.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getTimeoutBytes();

    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return Whether the timeoutNanos field is set.
     */
    boolean hasTimeoutNanos();
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return The timeoutNanos.
     */
    long getTimeoutNanos();
  }
  /**
   * Protobuf type {@code PersistentStateChangeEvent}
   */
  public  static final class PersistentStateChangeEvent extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:PersistentStateChangeEvent)
      PersistentStateChangeEventOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PersistentStateChangeEvent.newBuilder() to construct.
    private PersistentStateChangeEvent(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PersistentStateChangeEvent() {
      stateIdentifier_ = "";
      timeout_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PersistentStateChangeEvent();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PersistentStateChangeEvent(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              stateIdentifier_ = bs;
              break;
            }
            case 18: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              timeout_ = bs;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              timeoutNanos_ = input.readInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentStateChangeEvent_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentStateChangeEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.Builder.class);
    }

    private int bitField0_;
    public static final int STATEIDENTIFIER_FIELD_NUMBER = 1;
    private volatile java.lang.Object stateIdentifier_;
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return Whether the stateIdentifier field is set.
     */
    public boolean hasStateIdentifier() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The stateIdentifier.
     */
    public java.lang.String getStateIdentifier() {
      java.lang.Object ref = stateIdentifier_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          stateIdentifier_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The bytes for stateIdentifier.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getStateIdentifierBytes() {
      java.lang.Object ref = stateIdentifier_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stateIdentifier_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int TIMEOUT_FIELD_NUMBER = 2;
    private volatile java.lang.Object timeout_;
    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return Whether the timeout field is set.
     */
    public boolean hasTimeout() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return The timeout.
     */
    public java.lang.String getTimeout() {
      java.lang.Object ref = timeout_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          timeout_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     *not used in new records from Akka 2.4.5
     * </pre>
     *
     * <code>optional string timeout = 2;</code>
     * @return The bytes for timeout.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getTimeoutBytes() {
      java.lang.Object ref = timeout_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        timeout_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int TIMEOUTNANOS_FIELD_NUMBER = 3;
    private long timeoutNanos_;
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return Whether the timeoutNanos field is set.
     */
    public boolean hasTimeoutNanos() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return The timeoutNanos.
     */
    public long getTimeoutNanos() {
      return timeoutNanos_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStateIdentifier()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stateIdentifier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 2, timeout_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt64(3, timeoutNanos_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stateIdentifier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(2, timeout_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt64Size(3, timeoutNanos_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent other = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent) obj;

      if (hasStateIdentifier() != other.hasStateIdentifier()) return false;
      if (hasStateIdentifier()) {
        if (!getStateIdentifier()
            .equals(other.getStateIdentifier())) return false;
      }
      if (hasTimeout() != other.hasTimeout()) return false;
      if (hasTimeout()) {
        if (!getTimeout()
            .equals(other.getTimeout())) return false;
      }
      if (hasTimeoutNanos() != other.hasTimeoutNanos()) return false;
      if (hasTimeoutNanos()) {
        if (getTimeoutNanos()
            != other.getTimeoutNanos()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStateIdentifier()) {
        hash = (37 * hash) + STATEIDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getStateIdentifier().hashCode();
      }
      if (hasTimeout()) {
        hash = (37 * hash) + TIMEOUT_FIELD_NUMBER;
        hash = (53 * hash) + getTimeout().hashCode();
      }
      if (hasTimeoutNanos()) {
        hash = (37 * hash) + TIMEOUTNANOS_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getTimeoutNanos());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PersistentStateChangeEvent}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PersistentStateChangeEvent)
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEventOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentStateChangeEvent_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentStateChangeEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        stateIdentifier_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        timeout_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        timeoutNanos_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentStateChangeEvent_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent build() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent result = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.stateIdentifier_ = stateIdentifier_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.timeout_ = timeout_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timeoutNanos_ = timeoutNanos_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent.getDefaultInstance()) return this;
        if (other.hasStateIdentifier()) {
          bitField0_ |= 0x00000001;
          stateIdentifier_ = other.stateIdentifier_;
          onChanged();
        }
        if (other.hasTimeout()) {
          bitField0_ |= 0x00000002;
          timeout_ = other.timeout_;
          onChanged();
        }
        if (other.hasTimeoutNanos()) {
          setTimeoutNanos(other.getTimeoutNanos());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStateIdentifier()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object stateIdentifier_ = "";
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return Whether the stateIdentifier field is set.
       */
      public boolean hasStateIdentifier() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return The stateIdentifier.
       */
      public java.lang.String getStateIdentifier() {
        java.lang.Object ref = stateIdentifier_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stateIdentifier_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return The bytes for stateIdentifier.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getStateIdentifierBytes() {
        java.lang.Object ref = stateIdentifier_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stateIdentifier_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @param value The stateIdentifier to set.
       * @return This builder for chaining.
       */
      public Builder setStateIdentifier(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        stateIdentifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStateIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stateIdentifier_ = getDefaultInstance().getStateIdentifier();
        onChanged();
        return this;
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @param value The bytes for stateIdentifier to set.
       * @return This builder for chaining.
       */
      public Builder setStateIdentifierBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        stateIdentifier_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object timeout_ = "";
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @return Whether the timeout field is set.
       */
      public boolean hasTimeout() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @return The timeout.
       */
      public java.lang.String getTimeout() {
        java.lang.Object ref = timeout_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            timeout_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @return The bytes for timeout.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getTimeoutBytes() {
        java.lang.Object ref = timeout_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          timeout_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @param value The timeout to set.
       * @return This builder for chaining.
       */
      public Builder setTimeout(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        timeout_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimeout() {
        bitField0_ = (bitField0_ & ~0x00000002);
        timeout_ = getDefaultInstance().getTimeout();
        onChanged();
        return this;
      }
      /**
       * <pre>
       *not used in new records from Akka 2.4.5
       * </pre>
       *
       * <code>optional string timeout = 2;</code>
       * @param value The bytes for timeout to set.
       * @return This builder for chaining.
       */
      public Builder setTimeoutBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        timeout_ = value;
        onChanged();
        return this;
      }

      private long timeoutNanos_ ;
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return Whether the timeoutNanos field is set.
       */
      public boolean hasTimeoutNanos() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return The timeoutNanos.
       */
      public long getTimeoutNanos() {
        return timeoutNanos_;
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @param value The timeoutNanos to set.
       * @return This builder for chaining.
       */
      public Builder setTimeoutNanos(long value) {
        bitField0_ |= 0x00000004;
        timeoutNanos_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimeoutNanos() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeoutNanos_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:PersistentStateChangeEvent)
    }

    // @@protoc_insertion_point(class_scope:PersistentStateChangeEvent)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PersistentStateChangeEvent>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PersistentStateChangeEvent>() {
      @java.lang.Override
      public PersistentStateChangeEvent parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new PersistentStateChangeEvent(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PersistentStateChangeEvent> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PersistentStateChangeEvent> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentStateChangeEvent getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PersistentFSMSnapshotOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PersistentFSMSnapshot)
      org.apache.pekko.protobufv3.internal.MessageOrBuilder {

    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return Whether the stateIdentifier field is set.
     */
    boolean hasStateIdentifier();
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The stateIdentifier.
     */
    java.lang.String getStateIdentifier();
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The bytes for stateIdentifier.
     */
    org.apache.pekko.protobufv3.internal.ByteString
        getStateIdentifierBytes();

    /**
     * <code>required .PersistentPayload data = 2;</code>
     * @return Whether the data field is set.
     */
    boolean hasData();
    /**
     * <code>required .PersistentPayload data = 2;</code>
     * @return The data.
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getData();
    /**
     * <code>required .PersistentPayload data = 2;</code>
     */
    org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getDataOrBuilder();

    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return Whether the timeoutNanos field is set.
     */
    boolean hasTimeoutNanos();
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return The timeoutNanos.
     */
    long getTimeoutNanos();
  }
  /**
   * Protobuf type {@code PersistentFSMSnapshot}
   */
  public  static final class PersistentFSMSnapshot extends
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:PersistentFSMSnapshot)
      PersistentFSMSnapshotOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PersistentFSMSnapshot.newBuilder() to construct.
    private PersistentFSMSnapshot(org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PersistentFSMSnapshot() {
      stateIdentifier_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.UnusedPrivateParameter unused) {
      return new PersistentFSMSnapshot();
    }

    @java.lang.Override
    public final org.apache.pekko.protobufv3.internal.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PersistentFSMSnapshot(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      org.apache.pekko.protobufv3.internal.UnknownFieldSet.Builder unknownFields =
          org.apache.pekko.protobufv3.internal.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              org.apache.pekko.protobufv3.internal.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              stateIdentifier_ = bs;
              break;
            }
            case 18: {
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) != 0)) {
                subBuilder = data_.toBuilder();
              }
              data_ = input.readMessage(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(data_);
                data_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              timeoutNanos_ = input.readInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentFSMSnapshot_descriptor;
    }

    @java.lang.Override
    protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentFSMSnapshot_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.Builder.class);
    }

    private int bitField0_;
    public static final int STATEIDENTIFIER_FIELD_NUMBER = 1;
    private volatile java.lang.Object stateIdentifier_;
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return Whether the stateIdentifier field is set.
     */
    public boolean hasStateIdentifier() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The stateIdentifier.
     */
    public java.lang.String getStateIdentifier() {
      java.lang.Object ref = stateIdentifier_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.apache.pekko.protobufv3.internal.ByteString bs = 
            (org.apache.pekko.protobufv3.internal.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          stateIdentifier_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string stateIdentifier = 1;</code>
     * @return The bytes for stateIdentifier.
     */
    public org.apache.pekko.protobufv3.internal.ByteString
        getStateIdentifierBytes() {
      java.lang.Object ref = stateIdentifier_;
      if (ref instanceof java.lang.String) {
        org.apache.pekko.protobufv3.internal.ByteString b = 
            org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stateIdentifier_ = b;
        return b;
      } else {
        return (org.apache.pekko.protobufv3.internal.ByteString) ref;
      }
    }

    public static final int DATA_FIELD_NUMBER = 2;
    private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload data_;
    /**
     * <code>required .PersistentPayload data = 2;</code>
     * @return Whether the data field is set.
     */
    public boolean hasData() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>required .PersistentPayload data = 2;</code>
     * @return The data.
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getData() {
      return data_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : data_;
    }
    /**
     * <code>required .PersistentPayload data = 2;</code>
     */
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getDataOrBuilder() {
      return data_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : data_;
    }

    public static final int TIMEOUTNANOS_FIELD_NUMBER = 3;
    private long timeoutNanos_;
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return Whether the timeoutNanos field is set.
     */
    public boolean hasTimeoutNanos() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional int64 timeoutNanos = 3;</code>
     * @return The timeoutNanos.
     */
    public long getTimeoutNanos() {
      return timeoutNanos_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStateIdentifier()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasData()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getData().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.apache.pekko.protobufv3.internal.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.writeString(output, 1, stateIdentifier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getData());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt64(3, timeoutNanos_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += org.apache.pekko.protobufv3.internal.GeneratedMessageV3.computeStringSize(1, stateIdentifier_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeMessageSize(2, getData());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += org.apache.pekko.protobufv3.internal.CodedOutputStream
          .computeInt64Size(3, timeoutNanos_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot)) {
        return super.equals(obj);
      }
      org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot other = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot) obj;

      if (hasStateIdentifier() != other.hasStateIdentifier()) return false;
      if (hasStateIdentifier()) {
        if (!getStateIdentifier()
            .equals(other.getStateIdentifier())) return false;
      }
      if (hasData() != other.hasData()) return false;
      if (hasData()) {
        if (!getData()
            .equals(other.getData())) return false;
      }
      if (hasTimeoutNanos() != other.hasTimeoutNanos()) return false;
      if (hasTimeoutNanos()) {
        if (getTimeoutNanos()
            != other.getTimeoutNanos()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStateIdentifier()) {
        hash = (37 * hash) + STATEIDENTIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getStateIdentifier().hashCode();
      }
      if (hasData()) {
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + getData().hashCode();
      }
      if (hasTimeoutNanos()) {
        hash = (37 * hash) + TIMEOUTNANOS_FIELD_NUMBER;
        hash = (53 * hash) + org.apache.pekko.protobufv3.internal.Internal.hashLong(
            getTimeoutNanos());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        java.nio.ByteBuffer data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        java.nio.ByteBuffer data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.ByteString data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(byte[] data)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        byte[] data,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseDelimitedFrom(
        java.io.InputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parseFrom(
        org.apache.pekko.protobufv3.internal.CodedInputStream input,
        org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return org.apache.pekko.protobufv3.internal.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PersistentFSMSnapshot}
     */
    public static final class Builder extends
        org.apache.pekko.protobufv3.internal.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PersistentFSMSnapshot)
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshotOrBuilder {
      public static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentFSMSnapshot_descriptor;
      }

      @java.lang.Override
      protected org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentFSMSnapshot_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.class, org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.Builder.class);
      }

      // Construct using org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          org.apache.pekko.protobufv3.internal.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (org.apache.pekko.protobufv3.internal.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getDataFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        stateIdentifier_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (dataBuilder_ == null) {
          data_ = null;
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        timeoutNanos_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.internal_static_PersistentFSMSnapshot_descriptor;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot getDefaultInstanceForType() {
        return org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.getDefaultInstance();
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot build() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot buildPartial() {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot result = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.stateIdentifier_ = stateIdentifier_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (dataBuilder_ == null) {
            result.data_ = data_;
          } else {
            result.data_ = dataBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timeoutNanos_ = timeoutNanos_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          org.apache.pekko.protobufv3.internal.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          org.apache.pekko.protobufv3.internal.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(org.apache.pekko.protobufv3.internal.Message other) {
        if (other instanceof org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot) {
          return mergeFrom((org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot other) {
        if (other == org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot.getDefaultInstance()) return this;
        if (other.hasStateIdentifier()) {
          bitField0_ |= 0x00000001;
          stateIdentifier_ = other.stateIdentifier_;
          onChanged();
        }
        if (other.hasData()) {
          mergeData(other.getData());
        }
        if (other.hasTimeoutNanos()) {
          setTimeoutNanos(other.getTimeoutNanos());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasStateIdentifier()) {
          return false;
        }
        if (!hasData()) {
          return false;
        }
        if (!getData().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object stateIdentifier_ = "";
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return Whether the stateIdentifier field is set.
       */
      public boolean hasStateIdentifier() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return The stateIdentifier.
       */
      public java.lang.String getStateIdentifier() {
        java.lang.Object ref = stateIdentifier_;
        if (!(ref instanceof java.lang.String)) {
          org.apache.pekko.protobufv3.internal.ByteString bs =
              (org.apache.pekko.protobufv3.internal.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stateIdentifier_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return The bytes for stateIdentifier.
       */
      public org.apache.pekko.protobufv3.internal.ByteString
          getStateIdentifierBytes() {
        java.lang.Object ref = stateIdentifier_;
        if (ref instanceof String) {
          org.apache.pekko.protobufv3.internal.ByteString b = 
              org.apache.pekko.protobufv3.internal.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stateIdentifier_ = b;
          return b;
        } else {
          return (org.apache.pekko.protobufv3.internal.ByteString) ref;
        }
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @param value The stateIdentifier to set.
       * @return This builder for chaining.
       */
      public Builder setStateIdentifier(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        stateIdentifier_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearStateIdentifier() {
        bitField0_ = (bitField0_ & ~0x00000001);
        stateIdentifier_ = getDefaultInstance().getStateIdentifier();
        onChanged();
        return this;
      }
      /**
       * <code>required string stateIdentifier = 1;</code>
       * @param value The bytes for stateIdentifier to set.
       * @return This builder for chaining.
       */
      public Builder setStateIdentifierBytes(
          org.apache.pekko.protobufv3.internal.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        stateIdentifier_ = value;
        onChanged();
        return this;
      }

      private org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload data_;
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> dataBuilder_;
      /**
       * <code>required .PersistentPayload data = 2;</code>
       * @return Whether the data field is set.
       */
      public boolean hasData() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       * @return The data.
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload getData() {
        if (dataBuilder_ == null) {
          return data_ == null ? org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : data_;
        } else {
          return dataBuilder_.getMessage();
        }
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public Builder setData(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (dataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          dataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public Builder setData(
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder builderForValue) {
        if (dataBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          dataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public Builder mergeData(org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload value) {
        if (dataBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              data_ != null &&
              data_ != org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance()) {
            data_ =
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.newBuilder(data_).mergeFrom(value).buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          dataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public Builder clearData() {
        if (dataBuilder_ == null) {
          data_ = null;
          onChanged();
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder getDataBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDataFieldBuilder().getBuilder();
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      public org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder getDataOrBuilder() {
        if (dataBuilder_ != null) {
          return dataBuilder_.getMessageOrBuilder();
        } else {
          return data_ == null ?
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.getDefaultInstance() : data_;
        }
      }
      /**
       * <code>required .PersistentPayload data = 2;</code>
       */
      private org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
          org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder> 
          getDataFieldBuilder() {
        if (dataBuilder_ == null) {
          dataBuilder_ = new org.apache.pekko.protobufv3.internal.SingleFieldBuilderV3<
              org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayload.Builder, org.apache.pekko.persistence.serialization.MessageFormats.PersistentPayloadOrBuilder>(
                  getData(),
                  getParentForChildren(),
                  isClean());
          data_ = null;
        }
        return dataBuilder_;
      }

      private long timeoutNanos_ ;
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return Whether the timeoutNanos field is set.
       */
      public boolean hasTimeoutNanos() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return The timeoutNanos.
       */
      public long getTimeoutNanos() {
        return timeoutNanos_;
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @param value The timeoutNanos to set.
       * @return This builder for chaining.
       */
      public Builder setTimeoutNanos(long value) {
        bitField0_ |= 0x00000004;
        timeoutNanos_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional int64 timeoutNanos = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearTimeoutNanos() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeoutNanos_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.apache.pekko.protobufv3.internal.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:PersistentFSMSnapshot)
    }

    // @@protoc_insertion_point(class_scope:PersistentFSMSnapshot)
    private static final org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot();
    }

    public static org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final org.apache.pekko.protobufv3.internal.Parser<PersistentFSMSnapshot>
        PARSER = new org.apache.pekko.protobufv3.internal.AbstractParser<PersistentFSMSnapshot>() {
      @java.lang.Override
      public PersistentFSMSnapshot parsePartialFrom(
          org.apache.pekko.protobufv3.internal.CodedInputStream input,
          org.apache.pekko.protobufv3.internal.ExtensionRegistryLite extensionRegistry)
          throws org.apache.pekko.protobufv3.internal.InvalidProtocolBufferException {
        return new PersistentFSMSnapshot(input, extensionRegistry);
      }
    };

    public static org.apache.pekko.protobufv3.internal.Parser<PersistentFSMSnapshot> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.protobufv3.internal.Parser<PersistentFSMSnapshot> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.apache.pekko.persistence.serialization.MessageFormats.PersistentFSMSnapshot getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PersistentMessage_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_PersistentMessage_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PersistentPayload_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_PersistentPayload_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AtomicWrite_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_AtomicWrite_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AtLeastOnceDeliverySnapshot_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_AtLeastOnceDeliverySnapshot_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PersistentStateChangeEvent_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_PersistentStateChangeEvent_fieldAccessorTable;
  private static final org.apache.pekko.protobufv3.internal.Descriptors.Descriptor
    internal_static_PersistentFSMSnapshot_descriptor;
  private static final 
    org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable
      internal_static_PersistentFSMSnapshot_fieldAccessorTable;

  public static org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\024MessageFormats.proto\"\343\001\n\021PersistentMes" +
      "sage\022#\n\007payload\030\001 \001(\0132\022.PersistentPayloa" +
      "d\022\022\n\nsequenceNr\030\002 \001(\003\022\025\n\rpersistenceId\030\003" +
      " \001(\t\022\017\n\007deleted\030\004 \001(\010\022\016\n\006sender\030\013 \001(\t\022\020\n" +
      "\010manifest\030\014 \001(\t\022\022\n\nwriterUuid\030\r \001(\t\022\021\n\tt" +
      "imestamp\030\016 \001(\022\022$\n\010metadata\030\017 \001(\0132\022.Persi" +
      "stentPayload\"S\n\021PersistentPayload\022\024\n\014ser" +
      "ializerId\030\001 \002(\005\022\017\n\007payload\030\002 \002(\014\022\027\n\017payl" +
      "oadManifest\030\003 \001(\014\"2\n\013AtomicWrite\022#\n\007payl" +
      "oad\030\001 \003(\0132\022.PersistentMessage\"\356\001\n\033AtLeas" +
      "tOnceDeliverySnapshot\022\031\n\021currentDelivery" +
      "Id\030\001 \002(\003\022O\n\025unconfirmedDeliveries\030\002 \003(\0132" +
      "0.AtLeastOnceDeliverySnapshot.Unconfirme" +
      "dDelivery\032c\n\023UnconfirmedDelivery\022\022\n\ndeli" +
      "veryId\030\001 \002(\003\022\023\n\013destination\030\002 \002(\t\022#\n\007pay" +
      "load\030\003 \002(\0132\022.PersistentPayload\"\\\n\032Persis" +
      "tentStateChangeEvent\022\027\n\017stateIdentifier\030" +
      "\001 \002(\t\022\017\n\007timeout\030\002 \001(\t\022\024\n\014timeoutNanos\030\003" +
      " \001(\003\"h\n\025PersistentFSMSnapshot\022\027\n\017stateId" +
      "entifier\030\001 \002(\t\022 \n\004data\030\002 \002(\0132\022.Persisten" +
      "tPayload\022\024\n\014timeoutNanos\030\003 \001(\003B.\n*org.ap" +
      "ache.pekko.persistence.serializationH\001"
    };
    descriptor = org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new org.apache.pekko.protobufv3.internal.Descriptors.FileDescriptor[] {
        });
    internal_static_PersistentMessage_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_PersistentMessage_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_PersistentMessage_descriptor,
        new java.lang.String[] { "Payload", "SequenceNr", "PersistenceId", "Deleted", "Sender", "Manifest", "WriterUuid", "Timestamp", "Metadata", });
    internal_static_PersistentPayload_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_PersistentPayload_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_PersistentPayload_descriptor,
        new java.lang.String[] { "SerializerId", "Payload", "PayloadManifest", });
    internal_static_AtomicWrite_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_AtomicWrite_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_AtomicWrite_descriptor,
        new java.lang.String[] { "Payload", });
    internal_static_AtLeastOnceDeliverySnapshot_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_AtLeastOnceDeliverySnapshot_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_AtLeastOnceDeliverySnapshot_descriptor,
        new java.lang.String[] { "CurrentDeliveryId", "UnconfirmedDeliveries", });
    internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor =
      internal_static_AtLeastOnceDeliverySnapshot_descriptor.getNestedTypes().get(0);
    internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_AtLeastOnceDeliverySnapshot_UnconfirmedDelivery_descriptor,
        new java.lang.String[] { "DeliveryId", "Destination", "Payload", });
    internal_static_PersistentStateChangeEvent_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_PersistentStateChangeEvent_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_PersistentStateChangeEvent_descriptor,
        new java.lang.String[] { "StateIdentifier", "Timeout", "TimeoutNanos", });
    internal_static_PersistentFSMSnapshot_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_PersistentFSMSnapshot_fieldAccessorTable = new
      org.apache.pekko.protobufv3.internal.GeneratedMessageV3.FieldAccessorTable(
        internal_static_PersistentFSMSnapshot_descriptor,
        new java.lang.String[] { "StateIdentifier", "Data", "TimeoutNanos", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
