/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.protobufv3.internal;

import org.apache.pekko.protobufv3.internal.CheckReturnValue;
import org.apache.pekko.protobufv3.internal.MapFieldSchema;
import org.apache.pekko.protobufv3.internal.MapFieldSchemaLite;
import org.apache.pekko.protobufv3.internal.Protobuf;

@CheckReturnValue
final class MapFieldSchemas {
    private static final MapFieldSchema FULL_SCHEMA = MapFieldSchemas.loadSchemaForFullRuntime();
    private static final MapFieldSchema LITE_SCHEMA = new MapFieldSchemaLite();

    static MapFieldSchema full() {
        return FULL_SCHEMA;
    }

    static MapFieldSchema lite() {
        return LITE_SCHEMA;
    }

    private static MapFieldSchema loadSchemaForFullRuntime() {
        if (Protobuf.assumeLiteRuntime) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName("org.apache.pekko.protobufv3.internal.MapFieldSchemaFull");
            return (MapFieldSchema)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private MapFieldSchemas() {
    }
}

