/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.remote.transport.netty;

import com.typesafe.config.Config;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatchers;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pekko.ConfigurationException;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.dispatch.Dispatchers;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.event.MarkerLoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.transport.AssociationHandle;
import org.apache.pekko.remote.transport.Transport;
import org.apache.pekko.remote.transport.netty.ClientHandler;
import org.apache.pekko.remote.transport.netty.NettyFutureBridge$;
import org.apache.pekko.remote.transport.netty.NettySSLSupport$;
import org.apache.pekko.remote.transport.netty.NettyTransport$;
import org.apache.pekko.remote.transport.netty.NettyTransportException;
import org.apache.pekko.remote.transport.netty.NettyTransportExceptionNoStack;
import org.apache.pekko.remote.transport.netty.NettyTransportSettings;
import org.apache.pekko.remote.transport.netty.SSLEngineProvider;
import org.apache.pekko.remote.transport.netty.TcpClientHandler;
import org.apache.pekko.remote.transport.netty.TcpServerHandler;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rUqA\u0002\u001e<\u0011\u0003itI\u0002\u0004Jw!\u0005QH\u0013\u0005\u0006#\u0006!\ta\u0015\u0005\b)\u0006\u0011\r\u0011\"\u0001V\u0011\u0019I\u0016\u0001)A\u0005-\")!,\u0001C\u00017\"9!/\u0001b\u0001\n\u0003\u0019\bBB@\u0002A\u0003%A\u000fC\u0004\u0002\u0002\u0005!\t!a\u0001\t\u000f\u0005\u0005\u0011\u0001\"\u0001\u0002R\u0019)\u0011j\u000f\u0001\u0002\\!Q\u0011Q\r\u0006\u0003\u0006\u0004%\t!a\u001a\t\u0015\u0005=$B!A!\u0002\u0013\tI\u0007\u0003\u0006\u0002r)\u0011)\u0019!C\u0001\u0003gB!\"a\u001f\u000b\u0005\u0003\u0005\u000b\u0011BA;\u0011\u0019\t&\u0002\"\u0001\u0002~!1\u0011K\u0003C\u0001\u0003\u000bC\u0011\"!)\u000b\u0005\u0004%\u0019!a)\t\u000f\u0005\u0015&\u0002)A\u0005E\"I\u0011\u0011\u0006\u0006C\u0002\u0013\u0005\u0013q\u0015\u0005\t\u0003SS\u0001\u0015!\u0003\u0002,!1\u00111\u0016\u0006\u0005BUC1\"!,\u000b\u0001\u0004\u0005\r\u0011\"\u0003\u00020\"Y\u0011\u0011\u0017\u0006A\u0002\u0003\u0007I\u0011BAZ\u0011-\tIL\u0003a\u0001\u0002\u0003\u0006K!a\u0003\t\u0017\u0005\r'\u00021AA\u0002\u0013%\u0011Q\u0019\u0005\f\u0003\u000fT\u0001\u0019!a\u0001\n\u0013\tI\r\u0003\u0006\u0002N*\u0001\r\u0011!Q!\n)D\u0011\"!5\u000b\u0005\u0004%I!a5\t\u0011\u0005\u0005(\u0002)A\u0005\u0003+Dq!a9\u000b\t\u0013\t)\u000fC\u0005\u0002x*\u0011\r\u0011\"\u0001\u0002z\"A!q\u0001\u0006!\u0002\u0013\tY\u0010C\u0005\u0003\n)\u0011\r\u0011\"\u0003\u0003\f!A!Q\u0002\u0006!\u0002\u0013\t9\u000fC\u0005\u0003\u0010)\u0011\r\u0011\"\u0003\u0003\f!A!\u0011\u0003\u0006!\u0002\u0013\t9\u000fC\u0005\u0003\u0014)\u0011\r\u0011\"\u0003\u0003\f!A!Q\u0003\u0006!\u0002\u0013\t9\u000fC\u0004\u0003\u0018)!IA!\u0007\t\u0013\t\r\"B1A\u0005\n\t\u0015\u0002\u0002\u0003B%\u0015\u0001\u0006IAa\n\t\u0013\t-#B1A\u0005\n\t5\u0003\u0002\u0003B0\u0015\u0001\u0006IAa\u0014\t\u000f\t\u0005$\u0002\"\u0003\u0003d!I!q\u0010\u0006C\u0002\u0013%!\u0011\u0011\u0005\t\u0005+S\u0001\u0015!\u0003\u0003\u0004\"9!q\u0013\u0006\u0005\n\te\u0005\"\u0003BP\u0015\t\u0007I\u0011\u0002BQ\u0011!\u0011yK\u0003Q\u0001\n\t\r\u0006b\u0002BY\u0015\u0011%!1\u0017\u0005\b\u0005{SA\u0011\tB`\u0011\u001d\u0011)M\u0003C\u0001\u0005\u000fDqAa6\u000b\t\u0003\u0012I\u000e\u0003\u0005\u0003d*!\t!QAX\u0011\u001d\u0011)O\u0003C\u0005\u0005ODqA!<\u000b\t\u0003\u0012y\u000fC\u0004\u0003|*!\tE!@\u0002\u001d9+G\u000f^=Ue\u0006t7\u000f]8si*\u0011A(P\u0001\u0006]\u0016$H/\u001f\u0006\u0003}}\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u000b\u0005\u0001\u000b\u0015A\u0002:f[>$XM\u0003\u0002C\u0007\u0006)\u0001/Z6l_*\u0011A)R\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\u000b1a\u001c:h!\tA\u0015!D\u0001<\u00059qU\r\u001e;z)J\fgn\u001d9peR\u001c\"!A&\u0011\u00051{U\"A'\u000b\u00039\u000bQa]2bY\u0006L!\u0001U'\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A$\u0002-\u0019\u0013\u0018-\\3MK:<G\u000f\u001b$jK2$G*\u001a8hi\",\u0012A\u0016\t\u0003\u0019^K!\u0001W'\u0003\u0007%sG/A\fGe\u0006lW\rT3oORDg)[3mI2+gn\u001a;iA\u0005iqM]1dK\u001a,Hn\u00117pg\u0016$\"\u0001\u00185\u0015\u0005u\u0003\u0007C\u0001'_\u0013\tyVJ\u0001\u0003V]&$\b\"B1\u0006\u0001\b\u0011\u0017AA3d!\t\u0019g-D\u0001e\u0015\t)W*\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001a3\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\b\"B5\u0006\u0001\u0004Q\u0017aB2iC:tW\r\u001c\t\u0003WBl\u0011\u0001\u001c\u0006\u0003S6T!\u0001\u00108\u000b\u0003=\f!![8\n\u0005Ed'aB\"iC:tW\r\\\u0001\u0010k:L\u0017/^3JI\u000e{WO\u001c;feV\tA\u000f\u0005\u0002v{6\taO\u0003\u0002xq\u00061\u0011\r^8nS\u000eT!!Z=\u000b\u0005i\\\u0018\u0001B;uS2T\u0011\u0001`\u0001\u0005U\u00064\u0018-\u0003\u0002\u007fm\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f\u0001#\u001e8jcV,\u0017\nZ\"pk:$XM\u001d\u0011\u00021\u0005$GM]3tg\u001a\u0013x.\\*pG.,G/\u00113ee\u0016\u001c8\u000f\u0006\u0007\u0002\u0006\u0005]\u0011qEA!\u0003\u000b\nY\u0005E\u0003M\u0003\u000f\tY!C\u0002\u0002\n5\u0013aa\u00149uS>t\u0007\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0011)A\u0003bGR|'/\u0003\u0003\u0002\u0016\u0005=!aB!eIJ,7o\u001d\u0005\b\u00033A\u0001\u0019AA\u000e\u0003\u0011\tG\r\u001a:\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t|\u0003\rqW\r^\u0005\u0005\u0003K\tyBA\u0007T_\u000e\\W\r^!eIJ,7o\u001d\u0005\b\u0003SA\u0001\u0019AA\u0016\u0003A\u00198\r[3nK&#WM\u001c;jM&,'\u000f\u0005\u0003\u0002.\u0005mb\u0002BA\u0018\u0003o\u00012!!\rN\u001b\t\t\u0019DC\u0002\u00026I\u000ba\u0001\u0010:p_Rt\u0014bAA\u001d\u001b\u00061\u0001K]3eK\u001aLA!!\u0010\u0002@\t11\u000b\u001e:j]\u001eT1!!\u000fN\u0011\u001d\t\u0019\u0005\u0003a\u0001\u0003W\t!b]=ti\u0016lg*Y7f\u0011\u001d\t9\u0005\u0003a\u0001\u0003\u0013\n\u0001\u0002[8ti:\u000bW.\u001a\t\u0006\u0019\u0006\u001d\u00111\u0006\u0005\b\u0003\u001bB\u0001\u0019AA(\u0003\u0011\u0001xN\u001d;\u0011\t1\u000b9A\u0016\u000b\u000b\u0003\u000b\t\u0019&!\u0016\u0002X\u0005e\u0003bBA\r\u0013\u0001\u0007\u00111\u0004\u0005\b\u0003SI\u0001\u0019AA\u0016\u0011\u001d\t\u0019%\u0003a\u0001\u0003WAq!a\u0012\n\u0001\u0004\tIe\u0005\u0003\u000b\u0017\u0006u\u0003\u0003BA0\u0003Cj\u0011!P\u0005\u0004\u0003Gj$!\u0003+sC:\u001c\bo\u001c:u\u0003!\u0019X\r\u001e;j]\u001e\u001cXCAA5!\rA\u00151N\u0005\u0004\u0003[Z$A\u0006(fiRLHK]1ogB|'\u000f^*fiRLgnZ:\u0002\u0013M,G\u000f^5oON\u0004\u0013AB:zgR,W.\u0006\u0002\u0002vA!\u0011QBA<\u0013\u0011\tI(a\u0004\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nAQ1\u0011qPAA\u0003\u0007\u0003\"\u0001\u0013\u0006\t\u000f\u0005\u0015t\u00021\u0001\u0002j!9\u0011\u0011O\bA\u0002\u0005UDCBA@\u0003\u000f\u000bI\tC\u0004\u0002rA\u0001\r!!\u001e\t\u000f\u0005-\u0005\u00031\u0001\u0002\u000e\u0006!1m\u001c8g!\u0011\ty)!(\u000e\u0005\u0005E%\u0002BAJ\u0003+\u000baaY8oM&<'\u0002BAL\u00033\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0003\u00037\u000b1aY8n\u0013\u0011\ty*!%\u0003\r\r{gNZ5h\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH/F\u0001c\u0003E)\u00070Z2vi&|gnQ8oi\u0016DH\u000fI\u000b\u0003\u0003W\t\u0011c]2iK6,\u0017\nZ3oi&4\u0017.\u001a:!\u0003Mi\u0017\r_5nk6\u0004\u0016-\u001f7pC\u0012\u0014\u0015\u0010^3t\u0003\u001d\u0011w.\u001e8e)>,\"!a\u0003\u0002\u0017\t|WO\u001c3U_~#S-\u001d\u000b\u0004;\u0006U\u0006\"CA\\/\u0005\u0005\t\u0019AA\u0006\u0003\rAH%M\u0001\tE>,h\u000e\u001a+pA!\u001a\u0001$!0\u0011\u00071\u000by,C\u0002\u0002B6\u0013\u0001B^8mCRLG.Z\u0001\u000eg\u0016\u0014h/\u001a:DQ\u0006tg.\u001a7\u0016\u0003)\f\u0011c]3sm\u0016\u00148\t[1o]\u0016dw\fJ3r)\ri\u00161\u001a\u0005\t\u0003oS\u0012\u0011!a\u0001U\u0006q1/\u001a:wKJ\u001c\u0005.\u00198oK2\u0004\u0003fA\u000e\u0002>\u0006\u0019An\\4\u0016\u0005\u0005U\u0007\u0003BAl\u0003;l!!!7\u000b\u0007\u0005m\u0017)A\u0003fm\u0016tG/\u0003\u0003\u0002`\u0006e'\u0001F'be.,'\u000fT8hO&tw-\u00113baR,'/\u0001\u0003m_\u001e\u0004\u0013\u0001F2sK\u0006$X-\u0012<f]Rdun\u001c9He>,\b\u000f\u0006\u0003\u0002h\u0006M\b\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H.A\u0002oS>LA!!=\u0002l\n\tb*[8Fm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\t\r\u0005Uh\u00041\u0001W\u00031qG\u000b\u001b:fC\u0012\u001cu.\u001e8u\u00031\u0019\u0007.\u00198oK2<%o\\;q+\t\tY\u0010\u0005\u0003\u0002~\n\rQBAA\u0000\u0015\r\u0011\t\u0001\\\u0001\u0006OJ|W\u000f]\u0005\u0005\u0005\u000b\tyPA\nEK\u001a\fW\u000f\u001c;DQ\u0006tg.\u001a7He>,\b/A\u0007dQ\u0006tg.\u001a7He>,\b\u000fI\u0001\u0015G2LWM\u001c;Fm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0016\u0005\u0005\u001d\u0018!F2mS\u0016tG/\u0012<f]Rdun\u001c9He>,\b\u000fI\u0001\u001bg\u0016\u0014h/\u001a:Fm\u0016tG\u000fT8paB\u000b'/\u001a8u\u000fJ|W\u000f]\u0001\u001cg\u0016\u0014h/\u001a:Fm\u0016tG\u000fT8paB\u000b'/\u001a8u\u000fJ|W\u000f\u001d\u0011\u00023M,'O^3s\u000bZ,g\u000e\u001e'p_B\u001c\u0005.\u001b7e\u000fJ|W\u000f]\u0001\u001bg\u0016\u0014h/\u001a:Fm\u0016tG\u000fT8pa\u000eC\u0017\u000e\u001c3He>,\b\u000fI\u0001\f]\u0016<\b+\u001b9fY&tW\r\u0006\u0003\u0003\u001c\t\u0005\u0002cA6\u0003\u001e%\u0019!q\u00047\u0003\u001f\rC\u0017M\u001c8fYBK\u0007/\u001a7j]\u0016DQ![\u0014A\u0002)\f!$Y:t_\u000eL\u0017\r^5p]2K7\u000f^3oKJ\u0004&o\\7jg\u0016,\"Aa\n\u0011\u000b\r\u0014IC!\f\n\u0007\t-BMA\u0004Qe>l\u0017n]3\u0011\t\t=\"1\t\b\u0005\u0005c\u0011yD\u0004\u0003\u00034\tub\u0002\u0002B\u001b\u0005wqAAa\u000e\u0003:5\t1)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J1A!\u0011>\u0003%!&/\u00198ta>\u0014H/\u0003\u0003\u0003F\t\u001d#\u0001G!tg>\u001c\u0017.\u0019;j_:,e/\u001a8u\u0019&\u001cH/\u001a8fe*\u0019!\u0011I\u001f\u00027\u0005\u001c8o\\2jCRLwN\u001c'jgR,g.\u001a:Qe>l\u0017n]3!\u0003E\u00198\u000f\\#oO&tW\r\u0015:pm&$WM]\u000b\u0003\u0005\u001f\u0002bA!\u0015\u0003V\teSB\u0001B*\u0015\tQ\u0018)\u0003\u0003\u0003X\tM#!C(qi&|gNV1m!\rA%1L\u0005\u0004\u0005;Z$!E*T\u0019\u0016sw-\u001b8f!J|g/\u001b3fe\u0006\u00112o\u001d7F]\u001eLg.\u001a)s_ZLG-\u001a:!\u0003)\u00198\u000f\u001c%b]\u0012dWM\u001d\u000b\u0005\u0005K\u0012)\b\u0005\u0003\u0003h\tETB\u0001B5\u0015\u0011\u0011YG!\u001c\u0002\u0007M\u001cHNC\u0002\u0003p5\fq\u0001[1oI2,'/\u0003\u0003\u0003t\t%$AC*tY\"\u000bg\u000e\u001a7fe\"9!q\u000f\u0017A\u0002\te\u0014\u0001C5t\u00072LWM\u001c;\u0011\u00071\u0013Y(C\u0002\u0003~5\u0013qAQ8pY\u0016\fg.A\rtKJ4XM\u001d)ja\u0016d\u0017N\\3J]&$\u0018.\u00197ju\u0016\u0014XC\u0001BB!\u0015Y'Q\u0011BE\u0013\r\u00119\t\u001c\u0002\u0013\u0007\"\fgN\\3m\u0013:LG/[1mSj,'\u000f\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y\t\\\u0001\u0007g>\u001c7.\u001a;\n\t\tM%Q\u0012\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\u00025M,'O^3s!&\u0004X\r\\5oK&s\u0017\u000e^5bY&TXM\u001d\u0011\u00023\rd\u0017.\u001a8u!&\u0004X\r\\5oK&s\u0017\u000e^5bY&TXM\u001d\u000b\u0005\u0005\u0007\u0013Y\nC\u0004\u0003\u001e>\u0002\r!a\u0003\u0002\u001bI,Wn\u001c;f\u0003\u0012$'/Z:t\u0003AIgNY8v]\u0012\u0014un\u001c;tiJ\f\u0007/\u0006\u0002\u0003$B!!Q\u0015BV\u001b\t\u00119KC\u0002\u0003*6\f\u0011BY8piN$(/\u00199\n\t\t5&q\u0015\u0002\u0010'\u0016\u0014h/\u001a:C_>$8\u000f\u001e:ba\u0006\t\u0012N\u001c2pk:$'i\\8ugR\u0014\u0018\r\u001d\u0011\u0002#=,HOY8v]\u0012\u0014un\u001c;tiJ\f\u0007\u000f\u0006\u0003\u00036\nm\u0006\u0003\u0002BS\u0005oKAA!/\u0003(\nI!i\\8ugR\u0014\u0018\r\u001d\u0005\b\u0005;\u0013\u0004\u0019AA\u0006\u0003AI7OU3ta>t7/\u001b2mK\u001a{'\u000f\u0006\u0003\u0003z\t\u0005\u0007b\u0002Bbg\u0001\u0007\u00111B\u0001\bC\u0012$'/Z:t\u0003Y\tG\r\u001a:fgN$vnU8dW\u0016$\u0018\t\u001a3sKN\u001cH\u0003\u0002Be\u0005+\u0004Ra\u0019Bf\u0005\u001fL1A!4e\u0005\u00191U\u000f^;sKB!\u0011Q\u0004Bi\u0013\u0011\u0011\u0019.a\b\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fC\u0004\u0002\u001aQ\u0002\r!a\u0003\u0002\r1L7\u000f^3o+\t\u0011Y\u000eE\u0003d\u0005\u0017\u0014i\u000eE\u0004M\u0005?\fYAa\n\n\u0007\t\u0005XJ\u0001\u0004UkBdWMM\u0001\rE>,h\u000eZ!eIJ,7o]\u0001\u0013Kb$(/Y2u\u0011>\u001cH/\u00118e!>\u0014H\u000f\u0006\u0003\u0003j\n-\bC\u0002'\u0003`\u0006-b\u000bC\u0004\u0002\u001a]\u0002\r!a\u0003\u0002\u0013\u0005\u001c8o\\2jCR,G\u0003\u0002By\u0005s\u0004Ra\u0019Bf\u0005g\u0004B!a\u0018\u0003v&\u0019!q_\u001f\u0003#\u0005\u001b8o\\2jCRLwN\u001c%b]\u0012dW\rC\u0004\u0003\u001eb\u0002\r!a\u0003\u0002\u0011MDW\u000f\u001e3po:$\"Aa@\u0011\u000b\r\u0014YM!\u001f)\u0017)\u0019\u0019a!\u0003\u0004\f\r=1\u0011\u0003\t\u0004\u0019\u000e\u0015\u0011bAB\u0004\u001b\nQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u00121QB\u0001+\u00072\f7o]5dAI,Wn\u001c;j]\u001e\u0004\u0013n\u001d\u0011eKB\u0014XmY1uK\u0012d\u0003%^:fA\u0005\u0013H/\u001a:z\u0003\u0015\u0019\u0018N\\2fC\t\u0019\u0019\"\u0001\u0006BW.\f\u0007E\r\u00187]A\u0002")
public class NettyTransport
implements Transport {
    private final NettyTransportSettings settings;
    private final ExtendedActorSystem system;
    private final ExecutionContext executionContext;
    private final String schemeIdentifier;
    private volatile Address boundTo;
    private volatile Channel serverChannel;
    private final MarkerLoggingAdapter log;
    private final DefaultChannelGroup channelGroup;
    private final NioEventLoopGroup clientEventLoopGroup;
    private final NioEventLoopGroup serverEventLoopParentGroup;
    private final NioEventLoopGroup serverEventLoopChildGroup;
    private final Promise<Transport.AssociationEventListener> associationListenerPromise;
    private final SSLEngineProvider sslEngineProvider;
    private final ChannelInitializer<SocketChannel> serverPipelineInitializer;
    private final ServerBootstrap inboundBootstrap;

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, (Option<Object>)None$.MODULE$);
    }

    public static Option<Address> addressFromSocketAddress(SocketAddress addr, String schemeIdentifier, String systemName, Option<String> hostName, Option<Object> port) {
        return NettyTransport$.MODULE$.addressFromSocketAddress(addr, schemeIdentifier, systemName, hostName, port);
    }

    public static AtomicInteger uniqueIdCounter() {
        return NettyTransport$.MODULE$.uniqueIdCounter();
    }

    public static void gracefulClose(Channel channel, ExecutionContext ec) {
        NettyTransport$.MODULE$.gracefulClose(channel, ec);
    }

    public static int FrameLengthFieldLength() {
        return NettyTransport$.MODULE$.FrameLengthFieldLength();
    }

    @Override
    public Future<Object> managementCommand(Object cmd) {
        return Transport.managementCommand$(this, cmd);
    }

    public NettyTransportSettings settings() {
        return this.settings;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public String schemeIdentifier() {
        return this.schemeIdentifier;
    }

    @Override
    public int maximumPayloadBytes() {
        return this.settings().MaxFrameSize();
    }

    private Address boundTo() {
        return this.boundTo;
    }

    private void boundTo_$eq(Address x$1) {
        this.boundTo = x$1;
    }

    private Channel serverChannel() {
        return this.serverChannel;
    }

    private void serverChannel_$eq(Channel x$1) {
        this.serverChannel = x$1;
    }

    private MarkerLoggingAdapter log() {
        return this.log;
    }

    private NioEventLoopGroup createEventLoopGroup(int nThreadCount) {
        return (NioEventLoopGroup)this.settings().UseDispatcherForIo().map(arg_0 -> NettyTransport.$anonfun$createEventLoopGroup$1(this.system().dispatchers(), arg_0)).map((Function1 & Serializable)executor -> new NioEventLoopGroup(0, (Executor)executor)).getOrElse((Function0 & Serializable)() -> new NioEventLoopGroup(nThreadCount, this.system().threadFactory()));
    }

    public DefaultChannelGroup channelGroup() {
        return this.channelGroup;
    }

    private NioEventLoopGroup clientEventLoopGroup() {
        return this.clientEventLoopGroup;
    }

    private NioEventLoopGroup serverEventLoopParentGroup() {
        return this.serverEventLoopParentGroup;
    }

    private NioEventLoopGroup serverEventLoopChildGroup() {
        return this.serverEventLoopChildGroup;
    }

    private ChannelPipeline newPipeline(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addFirst("FlushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(256, true));
        pipeline.addLast("FrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(this.maximumPayloadBytes(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), 0, NettyTransport$.MODULE$.FrameLengthFieldLength(), true));
        pipeline.addLast("FrameEncoder", (ChannelHandler)new LengthFieldPrepender(NettyTransport$.MODULE$.FrameLengthFieldLength()));
        return pipeline;
    }

    private Promise<Transport.AssociationEventListener> associationListenerPromise() {
        return this.associationListenerPromise;
    }

    private SSLEngineProvider sslEngineProvider() {
        return this.sslEngineProvider;
    }

    private SslHandler sslHandler(boolean isClient) {
        SSLEngineProvider sSLEngineProvider = this.sslEngineProvider();
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)sSLEngineProvider)) {
            SSLEngineProvider sslProvider = (SSLEngineProvider)OptionVal$.MODULE$.get$extension((Object)sSLEngineProvider);
            return NettySSLSupport$.MODULE$.apply(sslProvider, isClient);
        }
        throw new IllegalStateException("Expected enable-ssl=on");
    }

    private ChannelInitializer<SocketChannel> serverPipelineInitializer() {
        return this.serverPipelineInitializer;
    }

    private ChannelInitializer<SocketChannel> clientPipelineInitializer(Address remoteAddress) {
        return new ChannelInitializer<SocketChannel>(this, remoteAddress){
            private final /* synthetic */ NettyTransport $outer;
            private final Address remoteAddress$1;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(x$1, this.remoteAddress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.remoteAddress$1 = remoteAddress$1;
            }
        };
    }

    private ServerBootstrap inboundBootstrap() {
        return this.inboundBootstrap;
    }

    private Bootstrap outboundBootstrap(Address remoteAddress) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.clientEventLoopGroup());
        bootstrap.handler((ChannelHandler)new /* invalid duplicate definition of identical inner class */);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)Predef$.MODULE$.int2Integer((int)this.settings().ConnectionTimeout().toMillis()));
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpNodelay()));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(this.settings().TcpKeepalive()));
        this.settings().ReceiveBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$1(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().SendBufferSize().foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$2(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$8 -> x$8 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$4(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        this.settings().WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 > 0).foreach((Function1 & Serializable)sz -> NettyTransport.$anonfun$outboundBootstrap$6(bootstrap, BoxesRunTime.unboxToInt((Object)sz)));
        return bootstrap;
    }

    @Override
    public boolean isResponsibleFor(Address address) {
        return true;
    }

    public Future<InetSocketAddress> addressToSocketAddress(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return Future$.MODULE$.apply((Function0 & Serializable)() -> (InetSocketAddress)package$.MODULE$.blocking((Function0 & Serializable)() -> new InetSocketAddress(InetAddress.getByName(host), port)), this.executionContext());
                }
            }
        }
        return Future$.MODULE$.failed((Throwable)new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString()));
    }

    @Override
    public Future<Tuple2<Address, Promise<Transport.AssociationEventListener>>> listen() {
        int bindPort = this.settings().BindPortSelector();
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Tuple2 tuple2;
            try {
                Address address;
                Channel newServerChannel = this.inboundBootstrap().bind(this.settings().BindHostname(), bindPort).sync().channel();
                newServerChannel.config().setAutoRead(false);
                this.channelGroup().add(newServerChannel);
                this.serverChannel_$eq(newServerChannel);
                None$ port = this.settings().PortSelector() == 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)this.settings().PortSelector()));
                Option<Address> option = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)new Some((Object)this.settings().Hostname()), (Option<Object>)port);
                if (option instanceof Some) {
                    address = (Address)((Some)option).value();
                    Option<Address> option2 = NettyTransport$.MODULE$.addressFromSocketAddress(newServerChannel.localAddress(), this.schemeIdentifier(), this.system().name(), (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (!(option2 instanceof Some)) {
                        if (None$.MODULE$.equals(option2)) {
                            throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                        }
                        throw new MatchError(option2);
                    }
                    Address address2 = (Address)((Some)option2).value();
                    this.boundTo_$eq(address2);
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new NettyTransportException(new StringBuilder(29).append("Unknown local address type [").append(newServerChannel.localAddress().getClass().getName()).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                this.associationListenerPromise().future().foreach((Function1 & Serializable)x$10 -> newServerChannel.config().setAutoRead(true), this.executionContext());
                tuple2 = new Tuple2((Object)address, this.associationListenerPromise());
            }
            catch (Throwable throwable) {
                if (throwable != null && NonFatal$.MODULE$.apply(throwable)) {
                    block10: {
                        this.log().error("failed to bind to host:{} port:{}, shutting down Netty transport", (Object)this.settings().BindHostname(), (Object)BoxesRunTime.boxToInteger((int)bindPort));
                        try {
                            this.shutdown();
                        }
                        catch (Throwable throwable2) {
                            if (throwable2 != null && !NonFatal$.MODULE$.unapply(throwable2).isEmpty()) break block10;
                            throw throwable2;
                        }
                    }
                    throw throwable;
                }
                throw throwable;
            }
            return tuple2;
        }));
    }

    public Address boundAddress() {
        return this.boundTo();
    }

    private Tuple2<String, Object> extractHostAndPort(Address addr) {
        if (addr != null) {
            Option option = addr.host();
            Option option2 = addr.port();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(55).append("Address [").append(addr).append("] must contain both host and port information.").toString());
    }

    @Override
    public Future<AssociationHandle> associate(Address remoteAddress) {
        if (!this.serverChannel().isActive()) {
            return Future$.MODULE$.failed((Throwable)new NettyTransportException("Transport is not bound"));
        }
        Bootstrap bootstrap = this.outboundBootstrap(remoteAddress);
        return Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable)() -> this.extractHostAndPort(remoteAddress))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$associate$2(check$ifrefutable$1)), this.executionContext()).flatMap((Function1 & Serializable)x$11 -> {
            if (x$11 != null) {
                String host = (String)x$11._1();
                int port = x$11._2$mcI$sp();
                return NettyFutureBridge$.MODULE$.apply(bootstrap.connect(host, port)).flatMap((Function1 & Serializable)channel -> (this.settings().EnableSsl() ? NettyFutureBridge$.MODULE$.apply(((SslHandler)channel.pipeline().get(SslHandler.class)).handshakeFuture()) : Future$.MODULE$.successful(channel)).flatMap((Function1 & Serializable)readyChannel -> ((ClientHandler)readyChannel.pipeline().get(ClientHandler.class)).statusFuture().map((Function1 & Serializable)handle -> handle, this.executionContext()), this.executionContext()), this.executionContext());
            }
            throw new MatchError(null);
        }, this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof CancellationException) {
                    throw new NettyTransportExceptionNoStack("Connection was cancelled");
                }
                if (x1 != null && NonFatal$.MODULE$.apply(x1)) {
                    String msg = x1.getCause() == null ? x1.getMessage() : (x1.getCause().getCause() == null ? new StringBuilder(13).append(x1.getMessage()).append(", caused by: ").append(x1.getCause()).toString() : new StringBuilder(26).append(x1.getMessage()).append(", caused by: ").append(x1.getCause()).append(", caused by: ").append(x1.getCause().getCause()).toString());
                    throw new NettyTransportExceptionNoStack(new StringBuilder(2).append(x1.getClass().getName()).append(": ").append(msg).toString(), x1.getCause());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                if (x1 instanceof CancellationException) {
                    return true;
                }
                return x1 != null && NonFatal$.MODULE$.apply(x1);
            }
        }, this.executionContext());
    }

    @Override
    public Future<Object> shutdown() {
        return this.always$2(this.channelGroup().close(ChannelMatchers.isServerChannel())).flatMap((Function1 & Serializable)unbindStatus -> NettyTransport.$anonfun$shutdown$2(this, BoxesRunTime.unboxToBoolean((Object)unbindStatus)), this.executionContext());
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$executionContext$2(Dispatchers eta$0$1$1, String id) {
        return eta$0$1$1.lookup(id);
    }

    public static final /* synthetic */ MessageDispatcher $anonfun$createEventLoopGroup$1(Dispatchers eta$0$1$2, String id) {
        return eta$0$1$2.lookup(id);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(SocketChannel ch) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(false));
        }
        TcpServerHandler handler = new TcpServerHandler(this, (Future<Transport.AssociationEventListener>)this.associationListenerPromise().future(), (LoggingAdapter)this.log());
        pipeline.addLast("ServerHandler", (ChannelHandler)handler);
    }

    public final /* synthetic */ void org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$clientPipelineInitializer$1(SocketChannel ch, Address remoteAddress$1) {
        ChannelPipeline pipeline = this.newPipeline((Channel)ch);
        if (this.settings().EnableSsl()) {
            pipeline.addFirst("SslHandler", (ChannelHandler)this.sslHandler(true));
        }
        TcpClientHandler handler = new TcpClientHandler(this, remoteAddress$1, (LoggingAdapter)this.log());
        pipeline.addLast("clienthandler", (ChannelHandler)handler);
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$1(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$2(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$4(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ Bootstrap $anonfun$outboundBootstrap$6(Bootstrap bootstrap$2, int sz) {
        return (Bootstrap)bootstrap$2.option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(sz));
    }

    public static final /* synthetic */ boolean $anonfun$associate$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ChannelGroup x$12) {
        return true;
    }

    private final Future always$2(ChannelGroupFuture c) {
        return NettyFutureBridge$.MODULE$.apply(c).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$1(x$12)), this.executionContext()).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                return (B1)BoxesRunTime.boxToBoolean((boolean)false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return true;
            }
        }, this.executionContext());
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$5(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus$1, boolean closeStatus) {
        $this.clientEventLoopGroup().shutdownGracefully();
        $this.serverEventLoopParentGroup().shutdownGracefully();
        $this.serverEventLoopChildGroup().shutdownGracefully();
        return lastWriteStatus$1 && unbindStatus$1 && disconnectStatus$1 && closeStatus;
    }

    public static final /* synthetic */ Future $anonfun$shutdown$4(NettyTransport $this, boolean lastWriteStatus$1, boolean unbindStatus$1, boolean disconnectStatus) {
        return $this.always$2($this.channelGroup().close()).map((Function1 & Serializable)closeStatus -> BoxesRunTime.boxToBoolean((boolean)NettyTransport.$anonfun$shutdown$5($this, lastWriteStatus$1, unbindStatus$1, disconnectStatus, BoxesRunTime.unboxToBoolean((Object)closeStatus))), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$3(NettyTransport $this, boolean unbindStatus$1, boolean lastWriteStatus) {
        return $this.always$2($this.channelGroup().disconnect()).flatMap((Function1 & Serializable)disconnectStatus -> NettyTransport.$anonfun$shutdown$4($this, lastWriteStatus, unbindStatus$1, BoxesRunTime.unboxToBoolean((Object)disconnectStatus)), $this.executionContext());
    }

    public static final /* synthetic */ Future $anonfun$shutdown$2(NettyTransport $this, boolean unbindStatus) {
        return $this.always$2($this.channelGroup().writeAndFlush((Object)Unpooled.EMPTY_BUFFER)).flatMap((Function1 & Serializable)lastWriteStatus -> NettyTransport.$anonfun$shutdown$3($this, unbindStatus, BoxesRunTime.unboxToBoolean((Object)lastWriteStatus)), $this.executionContext());
    }

    /*
     * WARNING - void declaration
     */
    public NettyTransport(NettyTransportSettings settings, ExtendedActorSystem system) {
        void var3_3;
        SSLEngineProvider sSLEngineProvider;
        this.settings = settings;
        this.system = system;
        this.executionContext = (ExecutionContext)settings.UseDispatcherForIo().orElse((Function0 & Serializable)() -> {
            String string = ((RARP)ExtensionId.apply$((ExtensionId)RARP$.MODULE$, (ActorSystem)this.system())).provider().remoteSettings().Dispatcher();
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (!"".equals(string)) break;
                    return None$.MODULE$;
                }
            }
            return new Some((Object)string);
        }).map(arg_0 -> NettyTransport.$anonfun$executionContext$2(system.dispatchers(), arg_0)).getOrElse((Function0 & Serializable)() -> this.system().dispatcher());
        this.schemeIdentifier = new StringBuilder(3).append(settings.EnableSsl() ? "ssl." : "").append("tcp").toString();
        this.log = Logging$.MODULE$.withMarker((ActorSystem)system, NettyTransport.class, LogSource$.MODULE$.fromClass());
        this.channelGroup = new DefaultChannelGroup(new StringBuilder(42).append("pekko-netty-transport-driver-channelgroup-").append(NettyTransport$.MODULE$.uniqueIdCounter().getAndIncrement()).toString(), (EventExecutor)GlobalEventExecutor.INSTANCE);
        this.clientEventLoopGroup = this.createEventLoopGroup(settings.ClientSocketWorkerPoolSize() + 1);
        this.serverEventLoopParentGroup = this.createEventLoopGroup(0);
        this.serverEventLoopChildGroup = this.createEventLoopGroup(settings.ServerSocketWorkerPoolSize());
        this.associationListenerPromise = Promise$.MODULE$.apply();
        if (settings.EnableSsl()) {
            sSLEngineProvider = (SSLEngineProvider)system.dynamicAccess().createInstanceFor(settings.SSLEngineProviderClassName(), (Seq)new .colon.colon((Object)new Tuple2(ActorSystem.class, (Object)system), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(SSLEngineProvider.class)).recover((PartialFunction)new Serializable(this){
                private static final long serialVersionUID = 0L;
                private final /* synthetic */ NettyTransport $outer;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    throw new ConfigurationException(new StringBuilder(37).append("Could not create SSLEngineProvider [").append(this.$outer.settings().SSLEngineProviderClassName()).append("]").toString(), x1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }).get();
        } else {
            OptionVal$.MODULE$.None();
            sSLEngineProvider = null;
        }
        this.sslEngineProvider = sSLEngineProvider;
        this.serverPipelineInitializer = new ChannelInitializer<SocketChannel>(this){
            private final /* synthetic */ NettyTransport $outer;

            public final void initChannel(SocketChannel x$1) {
                this.$outer.org$apache$pekko$remote$transport$netty$NettyTransport$$$anonfun$serverPipelineInitializer$1(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group((EventLoopGroup)this.serverEventLoopParentGroup(), (EventLoopGroup)this.serverEventLoopChildGroup());
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler(this.serverPipelineInitializer());
        bootstrap.option(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.option(ChannelOption.SO_BACKLOG, (Object)Predef$.MODULE$.int2Integer(settings.Backlog()));
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpReuseAddr()));
        bootstrap.childOption(ChannelOption.AUTO_READ, (Object)Predef$.MODULE$.boolean2Boolean(false));
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpNodelay()));
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Predef$.MODULE$.boolean2Boolean(settings.TcpKeepalive()));
        settings.ReceiveBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.SendBufferSize().foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferHighWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$6 -> x$6 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        settings.WriteBufferLowWaterMark().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 > 0).foreach((Function1 & Serializable)sz -> bootstrap.childOption(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)sz))));
        this.inboundBootstrap = var3_3;
    }

    public NettyTransport(ExtendedActorSystem system, Config conf) {
        this(new NettyTransportSettings(conf), system);
    }
}

