// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2014-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.scaladsl

import org.apache.pekko.NotUsed
import org.apache.pekko.stream.{ Graph, Shape }

trait GraphApply {
  /**
   * Creates a new [[Graph]] by passing a [[GraphDSL.Builder]] to the given create function.
   */
  def create[S <: Shape]()(buildBlock: GraphDSL.Builder[NotUsed] => S): Graph[S, NotUsed] = {
    val builder = new GraphDSL.Builder
    val s = buildBlock(builder)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graph `g1` and passing its [[Shape]]
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 2.6.16")
  def create[S <: Shape, Mat](g1: Graph[Shape, Mat])(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val s1 = builder.add(g1, Keep.right)
    val s = buildBlock(builder)(s1)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graph `g1` and passing its [[Shape]]
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, S1 <: Shape, Mat](g1: Graph[S1, Mat])(buildBlock: GraphDSL.Builder[Mat] => S1 => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val s1 = builder.add(g1, Keep.right)
    val s = buildBlock(builder)(s1)

    createGraph(s, builder)
  }


  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 3.6.26")
  def create[S <: Shape, Mat, M1, M2](g1: Graph[Shape, M1], g2: Graph[Shape, M2])(combineMat: (M1, M2) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s = buildBlock(builder)(s1, s2)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, S1 <: Shape, S2 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2])(combineMat: (M1, M2) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s = buildBlock(builder)(s1, s2)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 4.6.36")
  def create[S <: Shape, Mat, M1, M2, M3](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3])(combineMat: (M1, M2, M3) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s = buildBlock(builder)(s1, s2, s3)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, S1 <: Shape, S2 <: Shape, S3 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3])(combineMat: (M1, M2, M3) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s = buildBlock(builder)(s1, s2, s3)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 5.6.46")
  def create[S <: Shape, Mat, M1, M2, M3, M4](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4])(combineMat: (M1, M2, M3, M4) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s = buildBlock(builder)(s1, s2, s3, s4)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4])(combineMat: (M1, M2, M3, M4) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s = buildBlock(builder)(s1, s2, s3, s4)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 6.6.56")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5])(combineMat: (M1, M2, M3, M4, M5) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5])(combineMat: (M1, M2, M3, M4, M5) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 7.6.66")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6])(combineMat: (M1, M2, M3, M4, M5, M6) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6])(combineMat: (M1, M2, M3, M4, M5, M6) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 8.6.76")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7])(combineMat: (M1, M2, M3, M4, M5, M6, M7) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7])(combineMat: (M1, M2, M3, M4, M5, M6, M7) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 9.6.86")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 10.6.96")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 11.6.106")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 12.6.116")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 13.6.126")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 14.6.136")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 15.6.146")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 16.6.156")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 17.6.166")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 18.6.176")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 19.6.186")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17], g18: Graph[Shape, M18])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape, g18.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 20.6.196")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17], g18: Graph[Shape, M18], g19: Graph[Shape, M19])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape, g18.Shape, g19.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 21.6.206")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17], g18: Graph[Shape, M18], g19: Graph[Shape, M19], g20: Graph[Shape, M20])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape, g18.Shape, g19.Shape, g20.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S20 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], g20: Graph[S20, M20])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 22.6.216")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17], g18: Graph[Shape, M18], g19: Graph[Shape, M19], g20: Graph[Shape, M20], g21: Graph[Shape, M21])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape, g18.Shape, g19.Shape, g20.Shape, g21.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s21 = builder.add(g21, (f: M21 => Any, m21: M21) => f(m21))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S20 <: Shape, S21 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], g20: Graph[S20, M20], g21: Graph[S21, M21])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S21) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s21 = builder.add(g21, (f: M21 => Any, m21: M21) => f(m21))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21)

    createGraph(s, builder)
  }
  

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   *
   * Deprecated: this method signature does not work with Scala 3 type inference, kept for binary compatibility. Use createGraph instead.
   */
  @deprecated("Use createGraph instead", "Akka 23.6.226")
  def create[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M22](g1: Graph[Shape, M1], g2: Graph[Shape, M2], g3: Graph[Shape, M3], g4: Graph[Shape, M4], g5: Graph[Shape, M5], g6: Graph[Shape, M6], g7: Graph[Shape, M7], g8: Graph[Shape, M8], g9: Graph[Shape, M9], g10: Graph[Shape, M10], g11: Graph[Shape, M11], g12: Graph[Shape, M12], g13: Graph[Shape, M13], g14: Graph[Shape, M14], g15: Graph[Shape, M15], g16: Graph[Shape, M16], g17: Graph[Shape, M17], g18: Graph[Shape, M18], g19: Graph[Shape, M19], g20: Graph[Shape, M20], g21: Graph[Shape, M21], g22: Graph[Shape, M22])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M22) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (g1.Shape, g2.Shape, g3.Shape, g4.Shape, g5.Shape, g6.Shape, g7.Shape, g8.Shape, g9.Shape, g10.Shape, g11.Shape, g12.Shape, g13.Shape, g14.Shape, g15.Shape, g16.Shape, g17.Shape, g18.Shape, g19.Shape, g20.Shape, g21.Shape, g22.Shape) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s21 = builder.add(g21, (f: M21 => Any, m21: M21) => f(m21))
    val s22 = builder.add(g22, (f: M22 => Any, m22: M22) => f(m22))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22)

    createGraph(s, builder)
  }

  /**
   * Creates a new [[Graph]] by importing the given graphs and passing their [[Shape]]s
   * along with the [[GraphDSL.Builder]] to the given create function.
   */
  def createGraph[S <: Shape, Mat, M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M22, S1 <: Shape, S2 <: Shape, S3 <: Shape, S4 <: Shape, S5 <: Shape, S6 <: Shape, S7 <: Shape, S8 <: Shape, S9 <: Shape, S10 <: Shape, S11 <: Shape, S12 <: Shape, S13 <: Shape, S14 <: Shape, S15 <: Shape, S16 <: Shape, S17 <: Shape, S18 <: Shape, S19 <: Shape, S20 <: Shape, S21 <: Shape, S22 <: Shape](g1: Graph[S1, M1], g2: Graph[S2, M2], g3: Graph[S3, M3], g4: Graph[S4, M4], g5: Graph[S5, M5], g6: Graph[S6, M6], g7: Graph[S7, M7], g8: Graph[S8, M8], g9: Graph[S9, M9], g10: Graph[S10, M10], g11: Graph[S11, M11], g12: Graph[S12, M12], g13: Graph[S13, M13], g14: Graph[S14, M14], g15: Graph[S15, M15], g16: Graph[S16, M16], g17: Graph[S17, M17], g18: Graph[S18, M18], g19: Graph[S19, M19], g20: Graph[S20, M20], g21: Graph[S21, M21], g22: Graph[S22, M22])(combineMat: (M1, M2, M3, M4, M5, M6, M7, M8, M9, M10, M11, M12, M13, M14, M15, M16, M17, M18, M19, M20, M21, M22) => Mat)(buildBlock: GraphDSL.Builder[Mat] => (S1, S2, S3, S4, S5, S6, S7, S8, S9, S10, S11, S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22) => S): Graph[S, Mat] = {
    val builder = new GraphDSL.Builder
    val curried = combineMat.curried
    val s1 = builder.add(g1, (m1: M1) => curried(m1))
    val s2 = builder.add(g2, (f: M2 => Any, m2: M2) => f(m2))
    val s3 = builder.add(g3, (f: M3 => Any, m3: M3) => f(m3))
    val s4 = builder.add(g4, (f: M4 => Any, m4: M4) => f(m4))
    val s5 = builder.add(g5, (f: M5 => Any, m5: M5) => f(m5))
    val s6 = builder.add(g6, (f: M6 => Any, m6: M6) => f(m6))
    val s7 = builder.add(g7, (f: M7 => Any, m7: M7) => f(m7))
    val s8 = builder.add(g8, (f: M8 => Any, m8: M8) => f(m8))
    val s9 = builder.add(g9, (f: M9 => Any, m9: M9) => f(m9))
    val s10 = builder.add(g10, (f: M10 => Any, m10: M10) => f(m10))
    val s11 = builder.add(g11, (f: M11 => Any, m11: M11) => f(m11))
    val s12 = builder.add(g12, (f: M12 => Any, m12: M12) => f(m12))
    val s13 = builder.add(g13, (f: M13 => Any, m13: M13) => f(m13))
    val s14 = builder.add(g14, (f: M14 => Any, m14: M14) => f(m14))
    val s15 = builder.add(g15, (f: M15 => Any, m15: M15) => f(m15))
    val s16 = builder.add(g16, (f: M16 => Any, m16: M16) => f(m16))
    val s17 = builder.add(g17, (f: M17 => Any, m17: M17) => f(m17))
    val s18 = builder.add(g18, (f: M18 => Any, m18: M18) => f(m18))
    val s19 = builder.add(g19, (f: M19 => Any, m19: M19) => f(m19))
    val s20 = builder.add(g20, (f: M20 => Any, m20: M20) => f(m20))
    val s21 = builder.add(g21, (f: M21 => Any, m21: M21) => f(m21))
    val s22 = builder.add(g22, (f: M22 => Any, m22: M22) => f(m22))
    val s = buildBlock(builder)(s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19, s20, s21, s22)

    createGraph(s, builder)
  }

  private def createGraph[S <: Shape, Mat](shape: S, graphBuilder: GraphDSL.Builder[Mat]): Graph[S, Mat] =
    new GenericGraph(shape, graphBuilder.result(shape))
}
