// auto-generated by sbt-boilerplate
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * license agreements; and to You under the Apache License, version 2.0:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * This file is part of the Apache Pekko project, which was derived from Akka.
 */

/*
 * Copyright (C) 2009-2022 Lightbend Inc. <https://www.lightbend.com>
 */

package org.apache.pekko.stream.javadsl

import org.apache.pekko.stream._
import org.apache.pekko.stream.scaladsl
import org.apache.pekko.japi.function
import org.apache.pekko.japi.Pair
import org.apache.pekko.japi.tuple._
import org.apache.pekko.NotUsed

/**
 * Split one stream into several streams using a splitting function.
 *
 * '''Emits when''' all of the outputs stops backpressuring and there is an input element available
 *
 * '''Backpressures when''' any of the outputs backpressures
 *
 * '''Completes when''' upstream completes
 *
 * '''Cancels when''' any downstream cancels
 */
object UnzipWith {

  /**
   * Create a new `UnzipWith` vertex with the specified input type and unzipping-function `f`.
   *
   * @param f unzipping-function from the input value to the pair of output values
   */
  def create[In, A, B](f: function.Function[In, Pair[A, B]]):  Graph[FanOutShape2[In, A, B], NotUsed] =
    scaladsl.UnzipWith[In, A, B]((in: In) => f.apply(in) match { case Pair(a, b) => (a, b) })


  /** Create a new `UnzipWith` specialized for 3 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create3[In, T1, T2, T3](f: function.Function[In, Tuple3[T1, T2, T3]]): Graph[FanOutShape3[In, T1, T2, T3], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 4 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create4[In, T1, T2, T3, T4](f: function.Function[In, Tuple4[T1, T2, T3, T4]]): Graph[FanOutShape4[In, T1, T2, T3, T4], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 5 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create5[In, T1, T2, T3, T4, T5](f: function.Function[In, Tuple5[T1, T2, T3, T4, T5]]): Graph[FanOutShape5[In, T1, T2, T3, T4, T5], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 6 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create6[In, T1, T2, T3, T4, T5, T6](f: function.Function[In, Tuple6[T1, T2, T3, T4, T5, T6]]): Graph[FanOutShape6[In, T1, T2, T3, T4, T5, T6], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 7 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create7[In, T1, T2, T3, T4, T5, T6, T7](f: function.Function[In, Tuple7[T1, T2, T3, T4, T5, T6, T7]]): Graph[FanOutShape7[In, T1, T2, T3, T4, T5, T6, T7], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 8 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create8[In, T1, T2, T3, T4, T5, T6, T7, T8](f: function.Function[In, Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]]): Graph[FanOutShape8[In, T1, T2, T3, T4, T5, T6, T7, T8], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 9 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create9[In, T1, T2, T3, T4, T5, T6, T7, T8, T9](f: function.Function[In, Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]]): Graph[FanOutShape9[In, T1, T2, T3, T4, T5, T6, T7, T8, T9], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 10 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create10[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10](f: function.Function[In, Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]]): Graph[FanOutShape10[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 11 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create11[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11](f: function.Function[In, Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]]): Graph[FanOutShape11[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 12 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create12[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12](f: function.Function[In, Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]]): Graph[FanOutShape12[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 13 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create13[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13](f: function.Function[In, Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]]): Graph[FanOutShape13[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 14 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create14[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14](f: function.Function[In, Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]]): Graph[FanOutShape14[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 15 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create15[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15](f: function.Function[In, Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]]): Graph[FanOutShape15[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 16 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create16[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16](f: function.Function[In, Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]]): Graph[FanOutShape16[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 17 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create17[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17](f: function.Function[In, Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]]): Graph[FanOutShape17[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 18 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create18[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18](f: function.Function[In, Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]]): Graph[FanOutShape18[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 19 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create19[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19](f: function.Function[In, Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]]): Graph[FanOutShape19[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 20 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create20[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20](f: function.Function[In, Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]]): Graph[FanOutShape20[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 21 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create21[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21](f: function.Function[In, Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]]): Graph[FanOutShape21[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]((in: In) => f.apply(in).toScala)

  /** Create a new `UnzipWith` specialized for 22 outputs.
   *
   * @param f unzipping-function from the input value to the output values
   */
  def create22[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22](f: function.Function[In, Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]]): Graph[FanOutShape22[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22], NotUsed] =
    scaladsl.UnzipWith[In, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]((in: In) => f.apply(in).toScala)

}
