/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.http;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHttpRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiHttpRequest.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;

    public MultiHttpRequest(Executor executor, HttpConnectionManager connectionManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
    }

    public CompletionService<GetMethod> execute(List<String> urls, @Nullable Map<String, String> requestHeaders, int timeoutMs) {
        return this.execute(urls, requestHeaders, timeoutMs, "GET", GetMethod::new);
    }

    public <T extends HttpMethodBase> CompletionService<T> execute(List<String> urls, @Nullable Map<String, String> requestHeaders, int timeoutMs, String httpMethodName, Function<String, T> httpMethodSupplier) {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setConnectionManagerTimeout((long)timeoutMs);
        HttpClient client = new HttpClient(clientParams, this._connectionManager);
        ExecutorCompletionService<HttpMethodBase> completionService = new ExecutorCompletionService<HttpMethodBase>(this._executor);
        for (String url : urls) {
            completionService.submit(() -> {
                try {
                    HttpMethodBase httpMethod;
                    HttpMethodBase httpMethodBase = httpMethod = (HttpMethodBase)httpMethodSupplier.apply(url);
                    if (requestHeaders != null) {
                        requestHeaders.forEach((k, v) -> httpMethodBase.setRequestHeader(k, v));
                    }
                    httpMethodBase.getParams().setSoTimeout(timeoutMs);
                    client.executeMethod((HttpMethod)httpMethodBase);
                    return httpMethod;
                }
                catch (Exception e) {
                    LOGGER.warn("Caught '{}' while executing: {} on URL: {}", new Object[]{e, httpMethodName, url});
                    throw e;
                }
            });
        }
        return completionService;
    }
}

