/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.minion;

import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.utils.StringUtil;

public class MinionRequestURLBuilder {
    private final String _baseUrl;

    private MinionRequestURLBuilder(String baseUrl) {
        this._baseUrl = StringUtils.removeEnd((String)baseUrl, (String)"/");
    }

    public static MinionRequestURLBuilder baseUrl(String baseUrl) {
        return new MinionRequestURLBuilder(baseUrl);
    }

    public String forTaskSchedule(@Nullable String taskType, @Nullable String tableNameWithType) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks/schedule"});
        if (taskType != null && tableNameWithType != null) {
            return url + "?taskType=" + taskType + "&tableName=" + tableNameWithType;
        }
        if (taskType != null) {
            return url + "?taskType=" + taskType;
        }
        if (tableNameWithType != null) {
            return url + "?tableName=" + tableNameWithType;
        }
        return url;
    }

    public String forListAllTasks(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "tasks"});
    }

    public String forListAllTaskTypes() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks/tasktypes"});
    }

    public String forTaskTypeState(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "state"});
    }

    public String forTasksStates(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "taskstates"});
    }

    public String forTaskState(String taskName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks/task", taskName, "state"});
    }

    public String forTaskConfig(String taskName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks/task", taskName, "config"});
    }

    public String forTaskTypeCleanup(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "clenaup"});
    }

    public String forTaskTypeStop(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "stop"});
    }

    public String forTaskTypeResume(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType, "resume"});
    }

    public String forTaskTypeDelete(String taskType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks", taskType});
    }

    public String forTaskExecute() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tasks/execute"});
    }
}

