/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public interface DataTable {
    public static final String EXCEPTION_METADATA_KEY = "Exception";

    public void addException(ProcessingException var1);

    public void addException(int var1, String var2);

    public Map<Integer, String> getExceptions();

    public int getVersion();

    public byte[] toBytes() throws IOException;

    public Map<String, String> getMetadata();

    public DataSchema getDataSchema();

    public int getNumberOfRows();

    public int getInt(int var1, int var2);

    public long getLong(int var1, int var2);

    public float getFloat(int var1, int var2);

    public double getDouble(int var1, int var2);

    public BigDecimal getBigDecimal(int var1, int var2);

    public String getString(int var1, int var2);

    public ByteArray getBytes(int var1, int var2);

    public <T> T getObject(int var1, int var2);

    public int[] getIntArray(int var1, int var2);

    public long[] getLongArray(int var1, int var2);

    public float[] getFloatArray(int var1, int var2);

    public double[] getDoubleArray(int var1, int var2);

    public String[] getStringArray(int var1, int var2);

    @Nullable
    public RoaringBitmap getNullRowIds(int var1);

    public DataTable toMetadataOnlyDataTable();

    public DataTable toDataOnlyDataTable();

    public static final class MetadataKey
    extends Enum<MetadataKey> {
        public static final /* enum */ MetadataKey UNKNOWN;
        public static final /* enum */ MetadataKey TABLE;
        public static final /* enum */ MetadataKey NUM_DOCS_SCANNED;
        public static final /* enum */ MetadataKey NUM_ENTRIES_SCANNED_IN_FILTER;
        public static final /* enum */ MetadataKey NUM_ENTRIES_SCANNED_POST_FILTER;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_QUERIED;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_PROCESSED;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_MATCHED;
        public static final /* enum */ MetadataKey NUM_CONSUMING_SEGMENTS_QUERIED;
        public static final /* enum */ MetadataKey NUM_CONSUMING_SEGMENTS_PROCESSED;
        public static final /* enum */ MetadataKey NUM_CONSUMING_SEGMENTS_MATCHED;
        public static final /* enum */ MetadataKey MIN_CONSUMING_FRESHNESS_TIME_MS;
        public static final /* enum */ MetadataKey TOTAL_DOCS;
        public static final /* enum */ MetadataKey NUM_GROUPS_LIMIT_REACHED;
        public static final /* enum */ MetadataKey TIME_USED_MS;
        public static final /* enum */ MetadataKey TRACE_INFO;
        public static final /* enum */ MetadataKey REQUEST_ID;
        public static final /* enum */ MetadataKey NUM_RESIZES;
        public static final /* enum */ MetadataKey RESIZE_TIME_MS;
        public static final /* enum */ MetadataKey THREAD_CPU_TIME_NS;
        public static final /* enum */ MetadataKey SYSTEM_ACTIVITIES_CPU_TIME_NS;
        public static final /* enum */ MetadataKey RESPONSE_SER_CPU_TIME_NS;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_PRUNED_BY_SERVER;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_PRUNED_INVALID;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_PRUNED_BY_LIMIT;
        public static final /* enum */ MetadataKey NUM_SEGMENTS_PRUNED_BY_VALUE;
        public static final /* enum */ MetadataKey EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS;
        public static final /* enum */ MetadataKey EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS;
        private static final int MAX_ID = 27;
        private static final MetadataKey[] ID_TO_ENUM_KEY_MAP;
        private static final Map<String, MetadataKey> NAME_TO_ENUM_KEY_MAP;
        private final int _id;
        private final String _name;
        private final MetadataValueType _valueType;
        private static final /* synthetic */ MetadataKey[] $VALUES;

        public static MetadataKey[] values() {
            return (MetadataKey[])$VALUES.clone();
        }

        public static MetadataKey valueOf(String name) {
            return Enum.valueOf(MetadataKey.class, name);
        }

        private MetadataKey(int id, String name, MetadataValueType valueType) {
            this._id = id;
            this._name = name;
            this._valueType = valueType;
        }

        @Nullable
        public static MetadataKey getById(int id) {
            if (id >= 0 && id < ID_TO_ENUM_KEY_MAP.length) {
                return ID_TO_ENUM_KEY_MAP[id];
            }
            return null;
        }

        @Nullable
        public static MetadataKey getByName(String name) {
            return NAME_TO_ENUM_KEY_MAP.get(name);
        }

        public int getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }

        public MetadataValueType getValueType() {
            return this._valueType;
        }

        static {
            MetadataKey[] values;
            UNKNOWN = new MetadataKey(0, "unknown", MetadataValueType.STRING);
            TABLE = new MetadataKey(1, "table", MetadataValueType.STRING);
            NUM_DOCS_SCANNED = new MetadataKey(2, "numDocsScanned", MetadataValueType.LONG);
            NUM_ENTRIES_SCANNED_IN_FILTER = new MetadataKey(3, "numEntriesScannedInFilter", MetadataValueType.LONG);
            NUM_ENTRIES_SCANNED_POST_FILTER = new MetadataKey(4, "numEntriesScannedPostFilter", MetadataValueType.LONG);
            NUM_SEGMENTS_QUERIED = new MetadataKey(5, "numSegmentsQueried", MetadataValueType.INT);
            NUM_SEGMENTS_PROCESSED = new MetadataKey(6, "numSegmentsProcessed", MetadataValueType.INT);
            NUM_SEGMENTS_MATCHED = new MetadataKey(7, "numSegmentsMatched", MetadataValueType.INT);
            NUM_CONSUMING_SEGMENTS_QUERIED = new MetadataKey(8, "numConsumingSegmentsQueried", MetadataValueType.INT);
            NUM_CONSUMING_SEGMENTS_PROCESSED = new MetadataKey(26, "numConsumingSegmentsProcessed", MetadataValueType.INT);
            NUM_CONSUMING_SEGMENTS_MATCHED = new MetadataKey(27, "numConsumingSegmentsMatched", MetadataValueType.INT);
            MIN_CONSUMING_FRESHNESS_TIME_MS = new MetadataKey(9, "minConsumingFreshnessTimeMs", MetadataValueType.LONG);
            TOTAL_DOCS = new MetadataKey(10, "totalDocs", MetadataValueType.LONG);
            NUM_GROUPS_LIMIT_REACHED = new MetadataKey(11, "numGroupsLimitReached", MetadataValueType.STRING);
            TIME_USED_MS = new MetadataKey(12, "timeUsedMs", MetadataValueType.LONG);
            TRACE_INFO = new MetadataKey(13, "traceInfo", MetadataValueType.STRING);
            REQUEST_ID = new MetadataKey(14, "requestId", MetadataValueType.LONG);
            NUM_RESIZES = new MetadataKey(15, "numResizes", MetadataValueType.INT);
            RESIZE_TIME_MS = new MetadataKey(16, "resizeTimeMs", MetadataValueType.LONG);
            THREAD_CPU_TIME_NS = new MetadataKey(17, "threadCpuTimeNs", MetadataValueType.LONG);
            SYSTEM_ACTIVITIES_CPU_TIME_NS = new MetadataKey(18, "systemActivitiesCpuTimeNs", MetadataValueType.LONG);
            RESPONSE_SER_CPU_TIME_NS = new MetadataKey(19, "responseSerializationCpuTimeNs", MetadataValueType.LONG);
            NUM_SEGMENTS_PRUNED_BY_SERVER = new MetadataKey(20, "numSegmentsPrunedByServer", MetadataValueType.INT);
            NUM_SEGMENTS_PRUNED_INVALID = new MetadataKey(21, "numSegmentsPrunedByInvalid", MetadataValueType.INT);
            NUM_SEGMENTS_PRUNED_BY_LIMIT = new MetadataKey(22, "numSegmentsPrunedByLimit", MetadataValueType.INT);
            NUM_SEGMENTS_PRUNED_BY_VALUE = new MetadataKey(23, "numSegmentsPrunedByValue", MetadataValueType.INT);
            EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS = new MetadataKey(24, "explainPlanNumEmptyFilterSegments", MetadataValueType.INT);
            EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS = new MetadataKey(25, "explainPlanNumMatchAllFilterSegments", MetadataValueType.INT);
            $VALUES = new MetadataKey[]{UNKNOWN, TABLE, NUM_DOCS_SCANNED, NUM_ENTRIES_SCANNED_IN_FILTER, NUM_ENTRIES_SCANNED_POST_FILTER, NUM_SEGMENTS_QUERIED, NUM_SEGMENTS_PROCESSED, NUM_SEGMENTS_MATCHED, NUM_CONSUMING_SEGMENTS_QUERIED, NUM_CONSUMING_SEGMENTS_PROCESSED, NUM_CONSUMING_SEGMENTS_MATCHED, MIN_CONSUMING_FRESHNESS_TIME_MS, TOTAL_DOCS, NUM_GROUPS_LIMIT_REACHED, TIME_USED_MS, TRACE_INFO, REQUEST_ID, NUM_RESIZES, RESIZE_TIME_MS, THREAD_CPU_TIME_NS, SYSTEM_ACTIVITIES_CPU_TIME_NS, RESPONSE_SER_CPU_TIME_NS, NUM_SEGMENTS_PRUNED_BY_SERVER, NUM_SEGMENTS_PRUNED_INVALID, NUM_SEGMENTS_PRUNED_BY_LIMIT, NUM_SEGMENTS_PRUNED_BY_VALUE, EXPLAIN_PLAN_NUM_EMPTY_FILTER_SEGMENTS, EXPLAIN_PLAN_NUM_MATCH_ALL_FILTER_SEGMENTS};
            ID_TO_ENUM_KEY_MAP = new MetadataKey[28];
            NAME_TO_ENUM_KEY_MAP = new HashMap<String, MetadataKey>();
            for (MetadataKey key : values = MetadataKey.values()) {
                int id = key.getId();
                Preconditions.checkArgument((id >= 0 && id <= 27 ? 1 : 0) != 0, (String)"Invalid id: %s for MetadataKey: %s, must be in the range of [0, MAX_ID(%s)]", (Object)id, (Object)((Object)key), (Object)27);
                Preconditions.checkArgument((ID_TO_ENUM_KEY_MAP[id] == null ? 1 : 0) != 0, (String)"Duplicate id: %s defined for MetadataKey: %s and %s", (Object)id, (Object)((Object)ID_TO_ENUM_KEY_MAP[id]), (Object)((Object)key));
                MetadataKey.ID_TO_ENUM_KEY_MAP[id] = key;
                String name = key.getName();
                MetadataKey oldKey = NAME_TO_ENUM_KEY_MAP.put(name, key);
                Preconditions.checkArgument((oldKey == null ? 1 : 0) != 0, (String)"Duplicate name: %s defined for MetadataKey: %s and %s", (Object)name, (Object)((Object)oldKey), (Object)((Object)key));
            }
        }
    }

    public static enum MetadataValueType {
        INT,
        LONG,
        STRING;

    }
}

