/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

public class RegexpPatternConverterUtils {
    public static final String[] REGEXP_METACHARACTERS = new String[]{"\\", "^", "$", ".", "{", "}", "[", "]", "(", ")", "*", "+", "?", "|", "<", ">", "-", "&", "/"};

    private RegexpPatternConverterUtils() {
    }

    public static String likeToRegexpLike(String likePattern) {
        int start = 0;
        int end = likePattern.length();
        String prefix = "^";
        String suffix = "$";
        switch (likePattern.length()) {
            case 0: {
                return "^$";
            }
            case 1: {
                if (likePattern.charAt(0) != '%') break;
                return "";
            }
            default: {
                if (likePattern.charAt(0) == '%') {
                    start = RegexpPatternConverterUtils.indexOfFirstDifferent(likePattern, '%');
                    if (start == -1) {
                        return "";
                    }
                    prefix = "";
                }
                if (likePattern.charAt(likePattern.length() - 1) != '%') break;
                end = RegexpPatternConverterUtils.indexOfLastDifferent(likePattern, '%');
                if (end == -1) {
                    return "";
                }
                ++end;
                suffix = "";
            }
        }
        String escaped = RegexpPatternConverterUtils.escapeMetaCharacters(likePattern.substring(start, end));
        StringBuilder sb = new StringBuilder(escaped.length() + 2);
        sb.append(prefix);
        sb.append(escaped);
        sb.append(suffix);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '_') {
                sb.replace(i, i + 1, ".");
                continue;
            }
            if (c != '%') continue;
            sb.replace(i, i + 1, ".*");
            ++i;
        }
        return sb.toString();
    }

    private static int indexOfFirstDifferent(String str, char character) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == character) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfLastDifferent(String str, char character) {
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == character) continue;
            return i;
        }
        return -1;
    }

    private static String escapeMetaCharacters(String pattern) {
        for (String metaCharacter : REGEXP_METACHARACTERS) {
            if (!pattern.contains(metaCharacter)) continue;
            pattern = pattern.replace(metaCharacter, "\\" + metaCharacter);
        }
        return pattern;
    }

    public static String regexpLikeToLuceneRegExp(String regexpLikePattern) {
        if (regexpLikePattern.isEmpty()) {
            return regexpLikePattern;
        }
        regexpLikePattern = regexpLikePattern.charAt(0) == '^' ? regexpLikePattern.substring(1) : ".*" + regexpLikePattern;
        int length = regexpLikePattern.length();
        regexpLikePattern = regexpLikePattern.charAt(length - 1) == '$' ? regexpLikePattern.substring(0, length - 1) : regexpLikePattern + ".*";
        return regexpLikePattern;
    }
}

