/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.spi.config.user.AccessType;
import org.apache.pinot.spi.config.user.UserConfig;

public class AccessControlUserConfigUtils {
    private AccessControlUserConfigUtils() {
    }

    public static UserConfig fromZNRecord(ZNRecord znRecord) {
        Map simpleFields = znRecord.getSimpleFields();
        String username = (String)simpleFields.get("username");
        String password = (String)simpleFields.get("password");
        String component = (String)simpleFields.get("component");
        String role = (String)simpleFields.get("role");
        List tableList = znRecord.getListField("tables");
        List permissionListFromZNRecord = znRecord.getListField("permissions");
        List permissionList = null;
        if (permissionListFromZNRecord != null) {
            permissionList = permissionListFromZNRecord.stream().map(x -> AccessType.valueOf((String)x)).collect(Collectors.toList());
        }
        return new UserConfig(username, password, component, role, tableList, permissionList);
    }

    public static ZNRecord toZNRecord(UserConfig userConfig) throws JsonProcessingException {
        List permissionList;
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        simpleFields.put("username", userConfig.getUserName());
        simpleFields.put("password", userConfig.getPassword());
        simpleFields.put("component", userConfig.getComponentType().toString());
        simpleFields.put("role", userConfig.getRoleType().toString());
        HashMap listFields = new HashMap();
        List tableList = userConfig.getTables();
        if (tableList != null) {
            listFields.put("tables", userConfig.getTables());
        }
        if ((permissionList = userConfig.getPermissios()) != null) {
            listFields.put("permissions", userConfig.getPermissios().stream().map(e -> e.toString()).collect(Collectors.toList()));
        }
        ZNRecord znRecord = new ZNRecord(userConfig.getUserName());
        znRecord.setSimpleFields(simpleFields);
        znRecord.setListFields(listFields);
        return znRecord;
    }
}

