/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.helix;

import java.util.HashMap;
import java.util.Map;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.zookeeper.data.Stat;

public class FakePropertyStore
extends ZkHelixPropertyStore<ZNRecord> {
    private Map<String, ZNRecord> _contents = new HashMap<String, ZNRecord>();
    private IZkDataListener _listener = null;

    public FakePropertyStore() {
        super((ZkBaseDataAccessor)null, null, null);
    }

    public ZNRecord get(String path, Stat stat, int options) {
        return this._contents.get(path);
    }

    public boolean exists(String path, int options) {
        return this._contents.containsKey(path);
    }

    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this._listener = listener;
    }

    public boolean set(String path, ZNRecord stat, int expectedVersion, int options) {
        try {
            this.setContents(path, stat);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean set(String path, ZNRecord stat, int options) {
        try {
            this.setContents(path, stat);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean remove(String path, int options) {
        this._contents.remove(path);
        return true;
    }

    public void setContents(String path, ZNRecord contents) throws Exception {
        this._contents.put(path, contents);
        if (this._listener != null) {
            this._listener.handleDataChange(path, (Object)contents);
        }
    }

    public void start() {
    }
}

