/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.connector.presto.grpc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.utils.grpc.GrpcQueryClient;
import org.apache.pinot.common.utils.grpc.GrpcRequestBuilder;

public class PinotStreamingQueryClient {
    private final Map<String, GrpcQueryClient> _grpcQueryClientMap = new HashMap<String, GrpcQueryClient>();
    private final GrpcConfig _config;

    public PinotStreamingQueryClient(GrpcConfig config) {
        this._config = config;
    }

    public Iterator<Server.ServerResponse> submit(String host, int port, GrpcRequestBuilder requestBuilder) {
        GrpcQueryClient client = this.getOrCreateGrpcQueryClient(host, port);
        return client.submit(requestBuilder.build());
    }

    private GrpcQueryClient getOrCreateGrpcQueryClient(String host, int port) {
        String key = String.format("%s_%d", host, port);
        if (!this._grpcQueryClientMap.containsKey(key)) {
            this._grpcQueryClientMap.put(key, new GrpcQueryClient(host, port, this._config));
        }
        return this._grpcQueryClientMap.get(key);
    }
}

