/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.apache.pivot.io.IOTask;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.serialization.Serializer;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.web.QueryDictionary;
import org.apache.pivot.web.QueryException;
import org.apache.pivot.web.QueryListener;

public abstract class Query<V>
extends IOTask<V> {
    private URL locationContext = null;
    private HostnameVerifier hostnameVerifier = null;
    private Proxy proxy = null;
    private QueryDictionary parameters = new QueryDictionary(true);
    private QueryDictionary requestHeaders = new QueryDictionary(false);
    private QueryDictionary responseHeaders = new QueryDictionary(false);
    private int status = 0;
    private volatile long bytesExpected = -1L;
    private Serializer<?> serializer = new JSONSerializer();
    private QueryListenerList<V> queryListeners = new QueryListenerList();
    public static final int DEFAULT_PORT = -1;
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private static final String URL_ENCODING = "UTF-8";

    public Query(String hostname, int port, String path, boolean secure, ExecutorService executorService) {
        super(executorService);
        try {
            this.locationContext = new URL(secure ? HTTPS_PROTOCOL : HTTP_PROTOCOL, hostname, port, path);
        }
        catch (MalformedURLException exception) {
            throw new IllegalArgumentException("Unable to construct context URL.", exception);
        }
    }

    public abstract Method getMethod();

    public String getHostname() {
        return this.locationContext.getHost();
    }

    public String getPath() {
        return this.locationContext.getFile();
    }

    public int getPort() {
        return this.locationContext.getPort();
    }

    public boolean isSecure() {
        String protocol = this.locationContext.getProtocol();
        return protocol.equalsIgnoreCase(HTTPS_PROTOCOL);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public URL getLocation() {
        StringBuilder queryStringBuilder = new StringBuilder();
        for (String key : this.parameters) {
            for (int index = 0; index < this.parameters.getLength(key); ++index) {
                try {
                    if (queryStringBuilder.length() > 0) {
                        queryStringBuilder.append("&");
                    }
                    queryStringBuilder.append(URLEncoder.encode(key, URL_ENCODING) + "=" + URLEncoder.encode(this.parameters.get(key, index), URL_ENCODING));
                    continue;
                }
                catch (UnsupportedEncodingException exception) {
                    throw new IllegalStateException("Unable to construct query string.", exception);
                }
            }
        }
        URL location = null;
        try {
            String queryString = queryStringBuilder.length() > 0 ? "?" + queryStringBuilder.toString() : "";
            location = new URL(this.locationContext.getProtocol(), this.locationContext.getHost(), this.locationContext.getPort(), this.locationContext.getPath() + queryString);
        }
        catch (MalformedURLException exception) {
            throw new IllegalStateException("Unable to construct query URL.", exception);
        }
        return location;
    }

    public QueryDictionary getParameters() {
        return this.parameters;
    }

    public QueryDictionary getRequestHeaders() {
        return this.requestHeaders;
    }

    public QueryDictionary getResponseHeaders() {
        return this.responseHeaders;
    }

    public int getStatus() {
        return this.status;
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<?> serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("serializer is null.");
        }
        this.serializer = serializer;
    }

    public long getBytesSent() {
        return this.bytesSent;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    public long getBytesExpected() {
        return this.bytesExpected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Method method, Object value) throws QueryException {
        Object result = value;
        URL location = this.getLocation();
        HttpURLConnection connection = null;
        Serializer<?> serializerLocal = this.serializer;
        this.bytesSent = 0L;
        this.bytesReceived = 0L;
        this.bytesExpected = -1L;
        this.status = 0;
        String message = null;
        try {
            String key2;
            this.responseHeaders.clear();
            connection = this.proxy == null ? (HttpURLConnection)location.openConnection() : (HttpURLConnection)location.openConnection(this.proxy);
            connection.setRequestMethod(method.toString());
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            if (connection instanceof HttpsURLConnection && this.hostnameVerifier != null) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setHostnameVerifier(this.hostnameVerifier);
            }
            if (result != null) {
                connection.setRequestProperty("Content-Type", serializerLocal.getMIMEType(result));
            }
            for (String key2 : this.requestHeaders) {
                int n = this.requestHeaders.getLength(key2);
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        connection.setRequestProperty(key2, this.requestHeaders.get(key2, i));
                        continue;
                    }
                    connection.addRequestProperty(key2, this.requestHeaders.get(key2, i));
                }
            }
            connection.setDoInput(true);
            connection.setDoOutput(result != null);
            connection.connect();
            this.queryListeners.connected(this);
            if (result != null) {
                OutputStream outputStream = null;
                try {
                    outputStream = connection.getOutputStream();
                    serializerLocal.writeObject(result, (OutputStream)new IOTask.MonitoredOutputStream((IOTask)this, outputStream));
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            this.queryListeners.requestSent(this);
            this.status = connection.getResponseCode();
            message = connection.getResponseMessage();
            this.bytesExpected = connection.getContentLength();
            int i = 1;
            key2 = connection.getHeaderFieldKey(i);
            while (key2 != null) {
                this.responseHeaders.add(key2, connection.getHeaderField(i));
                key2 = connection.getHeaderFieldKey(++i);
            }
            int statusPrefix = this.status / 100;
            if (statusPrefix != 2) {
                throw new QueryException(this.status, message);
            }
            if (method == Method.GET && this.status == 200) {
                InputStream inputStream = null;
                try {
                    inputStream = connection.getInputStream();
                    result = serializerLocal.readObject((InputStream)new IOTask.MonitoredInputStream((IOTask)this, inputStream));
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            this.queryListeners.responseReceived(this);
        }
        catch (IOException exception) {
            this.queryListeners.failed(this);
            throw new QueryException(exception);
        }
        catch (SerializationException exception) {
            this.queryListeners.failed(this);
            throw new QueryException(exception);
        }
        catch (RuntimeException exception) {
            this.queryListeners.failed(this);
            throw exception;
        }
        return result;
    }

    public ListenerList<QueryListener<V>> getQueryListeners() {
        return this.queryListeners;
    }

    static {
        try {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class QueryListenerList<V>
    extends ListenerList<QueryListener<V>>
    implements QueryListener<V> {
        private QueryListenerList() {
        }

        public synchronized void add(QueryListener<V> listener) {
            super.add(listener);
        }

        public synchronized void remove(QueryListener<V> listener) {
            super.remove(listener);
        }

        @Override
        public synchronized void connected(Query<V> query) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                QueryListener listener = (QueryListener)i$.next();
                listener.connected(query);
            }
        }

        @Override
        public synchronized void requestSent(Query<V> query) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                QueryListener listener = (QueryListener)i$.next();
                listener.requestSent(query);
            }
        }

        @Override
        public synchronized void responseReceived(Query<V> query) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                QueryListener listener = (QueryListener)i$.next();
                listener.responseReceived(query);
            }
        }

        @Override
        public synchronized void failed(Query<V> query) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                QueryListener listener = (QueryListener)i$.next();
                listener.failed(query);
            }
        }
    }

    public static class Status {
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int NO_CONTENT = 204;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

