/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.web;

import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.HashMap;

public final class QueryDictionary
implements Dictionary<String, String>,
Iterable<String> {
    private boolean caseSensitiveKeys;
    private HashMap<String, ArrayList<String>> map = new HashMap();

    public QueryDictionary(boolean caseSensitiveKeys) {
        this.caseSensitiveKeys = caseSensitiveKeys;
    }

    public String get(String key) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) != null && list.getLength() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public String get(String key, int index) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return (String)list.get(index);
    }

    public String put(String key, String value) {
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        ArrayList list = new ArrayList();
        list.add((Object)value);
        ArrayList previous = (ArrayList)this.map.put((Object)searchKey, (Object)list);
        if (previous != null && previous.getLength() > 0) {
            return (String)previous.get(0);
        }
        return null;
    }

    public int add(String key, String value) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) == null) {
            this.put(searchKey, value);
            return 0;
        }
        list.add((Object)value);
        return list.getLength() - 1;
    }

    public void insert(String key, String value, int index) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        list.insert((Object)value, index);
    }

    public String remove(String key) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.remove((Object)searchKey)) != null && list.getLength() > 0) {
            return (String)list.get(0);
        }
        return null;
    }

    public String remove(String key, int index) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) == null || list.getLength() <= index) {
            throw new IndexOutOfBoundsException();
        }
        return (String)list.get(index);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(String key) {
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        return this.map.containsKey((Object)searchKey);
    }

    public int getLength(String key) {
        ArrayList list;
        String searchKey = key;
        if (!this.caseSensitiveKeys) {
            searchKey = searchKey.toLowerCase();
        }
        if ((list = (ArrayList)this.map.get((Object)searchKey)) == null) {
            return 0;
        }
        return list.getLength();
    }

    @Override
    public Iterator<String> iterator() {
        return this.map.iterator();
    }
}

