/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ColorChooserButton;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.WindowStateListener;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.ColorChooserButtonSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraColorChooserButtonSkin
extends ColorChooserButtonSkin {
    private WindowStateListener colorChooserPopupStateListener = new WindowStateListener.Adapter(){

        public void windowOpened(Window window) {
            int maximumHeight;
            int popupHeight;
            ColorChooserButton colorChooserButton = (ColorChooserButton)TerraColorChooserButtonSkin.this.getComponent();
            TerraColorChooserButtonSkin.this.colorChooser.setSelectedColor(colorChooserButton.getSelectedColor());
            Display display = colorChooserButton.getDisplay();
            Dimensions displaySize = display.getSize();
            Point buttonLocation = colorChooserButton.mapPointToAncestor((Container)display, 0, 0);
            window.setLocation(buttonLocation.x, buttonLocation.y + TerraColorChooserButtonSkin.this.getHeight() - 1);
            int width = TerraColorChooserButtonSkin.this.getWidth();
            window.setMinimumWidth(width - 10 - 1);
            int popupWidth = window.getPreferredWidth();
            if (buttonLocation.x + popupWidth > displaySize.width) {
                window.setX(buttonLocation.x + width - popupWidth);
            }
            if ((popupHeight = window.getPreferredHeight()) > (maximumHeight = displaySize.height - window.getY()) && buttonLocation.y > maximumHeight) {
                window.setY(buttonLocation.y - window.getPreferredHeight() + 1);
            }
            TerraColorChooserButtonSkin.this.repaintComponent();
        }

        public Vote previewWindowClose(final Window window) {
            Vote vote = Vote.APPROVE;
            if (TerraColorChooserButtonSkin.this.closeTransition == null) {
                TerraColorChooserButtonSkin.this.closeTransition = (Transition)new FadeWindowTransition((Component)window, TerraColorChooserButtonSkin.this.closeTransitionDuration, TerraColorChooserButtonSkin.this.closeTransitionRate, TerraColorChooserButtonSkin.this.dropShadowDecorator);
                TerraColorChooserButtonSkin.this.closeTransition.start(new TransitionListener(){

                    public void transitionCompleted(Transition transition) {
                        window.close();
                    }
                });
                vote = Vote.DEFER;
            } else {
                vote = TerraColorChooserButtonSkin.this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
            }
            return vote;
        }

        public void windowCloseVetoed(Window window, Vote reason) {
            if (reason == Vote.DENY && TerraColorChooserButtonSkin.this.closeTransition != null) {
                TerraColorChooserButtonSkin.this.closeTransition.stop();
                TerraColorChooserButtonSkin.this.closeTransition = null;
            }
            TerraColorChooserButtonSkin.this.repaintComponent();
        }

        public void windowClosed(Window window, Display display, Window owner) {
            TerraColorChooserButtonSkin.this.closeTransition = null;
            TerraColorChooserButtonSkin.this.repaintComponent();
        }
    };
    private Border colorChooserBorder;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private int closeTransitionDuration = 250;
    private int closeTransitionRate = 30;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private Transition closeTransition = null;
    private DropShadowDecorator dropShadowDecorator = null;
    private static final int CORNER_RADIUS = 4;
    private static final int TRIGGER_WIDTH = 10;
    private static final int DEFAULT_CLOSE_TRANSITION_DURATION = 250;
    private static final int DEFAULT_CLOSE_TRANSITION_RATE = 30;

    public TerraColorChooserButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(10);
        this.disabledBackgroundColor = theme.getColor(10);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.padding = new Insets(2, 3, 2, 3);
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.colorChooserPopup.getWindowStateListeners().add((Object)this.colorChooserPopupStateListener);
        this.colorChooserBorder = new Border((Component)this.colorChooser);
        this.colorChooserBorder.getStyles().put("color", (Object)this.borderColor);
        this.colorChooserBorder.getStyles().put("padding", (Object)2);
        this.colorChooserPopup.setContent((Component)this.colorChooserBorder);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        this.colorChooserPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public int getPreferredWidth(int height) {
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        Button.DataRenderer dataRenderer = colorChooserButton.getDataRenderer();
        dataRenderer.render(colorChooserButton.getButtonData(), (Button)colorChooserButton, false);
        int preferredWidth = dataRenderer.getPreferredWidth(-1) + 10 + this.padding.left + this.padding.right + 2;
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        Button.DataRenderer dataRenderer = colorChooserButton.getDataRenderer();
        dataRenderer.render(colorChooserButton.getButtonData(), (Button)colorChooserButton, false);
        int preferredHeight = dataRenderer.getPreferredHeight(-1) + this.padding.top + this.padding.bottom + 2;
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        Button.DataRenderer dataRenderer = colorChooserButton.getDataRenderer();
        dataRenderer.render(colorChooserButton.getButtonData(), (Button)colorChooserButton, false);
        Dimensions contentSize = dataRenderer.getPreferredSize();
        int preferredWidth = contentSize.width + 10 + this.padding.left + this.padding.right + 2;
        int preferredHeight = contentSize.height + this.padding.top + this.padding.bottom + 2;
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        Button.DataRenderer dataRenderer = colorChooserButton.getDataRenderer();
        dataRenderer.render(colorChooserButton.getButtonData(), (Button)colorChooserButton, false);
        int clientWidth = Math.max(width - (10 + this.padding.left + this.padding.right + 2), 0);
        int clientHeight = Math.max(height - (this.padding.top + this.padding.bottom + 2), 0);
        int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
        if (baseline != -1) {
            baseline += this.padding.top + 1;
        }
        return baseline;
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        BasicStroke dashStroke;
        ColorChooserButton colorChooserButton = (ColorChooserButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Color backgroundColorLocal = null;
        Color bevelColorLocal = null;
        Color borderColorLocal = null;
        if (colorChooserButton.isEnabled()) {
            backgroundColorLocal = this.backgroundColor;
            bevelColorLocal = this.pressed || this.colorChooserPopup.isOpen() && !this.colorChooserPopup.isClosing() ? this.pressedBevelColor : this.bevelColor;
            borderColorLocal = this.borderColor;
        } else {
            backgroundColorLocal = this.disabledBackgroundColor;
            bevelColorLocal = this.disabledBevelColor;
            borderColorLocal = this.disabledBorderColor;
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, bevelColorLocal, (float)width / 2.0f, (float)height / 2.0f, backgroundColorLocal));
        graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Bounds contentBounds = new Bounds(0, 0, Math.max(width - 10 - 1, 0), Math.max(height - 1, 0));
        Button.DataRenderer dataRenderer = colorChooserButton.getDataRenderer();
        dataRenderer.render(colorChooserButton.getButtonData(), (Button)colorChooserButton, false);
        dataRenderer.setSize(Math.max(contentBounds.width - (this.padding.left + this.padding.right + 2) + 1, 0), Math.max(contentBounds.height - (this.padding.top + this.padding.bottom + 2) + 1, 0));
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(this.padding.left + 1, this.padding.top + 1);
        contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (borderColorLocal != null) {
            graphics.setPaint(borderColorLocal);
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        }
        if (colorChooserButton.isFocused()) {
            dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics.setStroke(dashStroke);
            graphics.setColor(this.borderColor);
            graphics.draw(new RoundRectangle2D.Double(2.5, 2.5, Math.max(width - 5, 0), Math.max(height - 5, 0), 2.0, 2.0));
        }
        if (colorChooserButton.isFocused()) {
            dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics.setStroke(dashStroke);
            graphics.setColor(this.borderColor);
            graphics.draw(new RoundRectangle2D.Double(2.5, 2.5, Math.max(width - 5, 0), Math.max(height - 5, 0), 2.0, 2.0));
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GeneralPath triggerIconShape = new GeneralPath(0);
        triggerIconShape.moveTo(0.0f, 0.0f);
        triggerIconShape.lineTo(3.0f, 3.0f);
        triggerIconShape.lineTo(6.0f, 0.0f);
        triggerIconShape.closePath();
        Graphics2D triggerGraphics = (Graphics2D)graphics.create();
        triggerGraphics.setStroke(new BasicStroke(0.0f));
        triggerGraphics.setPaint(this.color);
        Bounds triggerBounds = new Bounds(Math.max(width - (this.padding.right + 10), 0), 0, 10, Math.max(height - (this.padding.top - this.padding.bottom), 0));
        int tx = triggerBounds.x + (triggerBounds.width - triggerIconShape.getBounds().width) / 2;
        int ty = triggerBounds.y + (triggerBounds.height - triggerIconShape.getBounds().height) / 2;
        triggerGraphics.translate(tx, ty);
        triggerGraphics.draw(triggerIconShape);
        triggerGraphics.fill(triggerIconShape);
        triggerGraphics.dispose();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraColorChooserButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.brighten(backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.colorChooserBorder.getStyles().put("color", (Object)borderColor);
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public int getCloseTransitionDuration() {
        return this.closeTransitionDuration;
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.closeTransitionDuration = closeTransitionDuration;
    }

    public int getCloseTransitionRate() {
        return this.closeTransitionRate;
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.closeTransitionRate = closeTransitionRate;
    }
}

