/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.FrameListener;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.TablePane;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.TerraPushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraFrameSkin
extends WindowSkin
implements FrameListener {
    private Image minimizeImage = new MinimizeImage();
    private Image maximizeImage = new MaximizeImage();
    private Image restoreImage = new RestoreImage();
    private Image closeImage = new CloseImage();
    private Image resizeImage = new ResizeImage();
    private TablePane titleBarTablePane = new TablePane();
    private BoxPane titleBoxPane = new BoxPane();
    private BoxPane buttonBoxPane = new BoxPane();
    private ImageView iconImageView = new ImageView();
    private Label titleLabel = new Label();
    private FrameButton minimizeButton = null;
    private FrameButton maximizeButton = null;
    private FrameButton closeButton = null;
    private ImageView resizeHandle = new ImageView(this.resizeImage);
    private DropShadowDecorator dropShadowDecorator = null;
    private Point dragOffset = null;
    private Point resizeOffset = null;
    private Color titleBarColor;
    private Color titleBarBackgroundColor;
    private Color titleBarBorderColor;
    private Color inactiveTitleBarColor;
    private Color inactiveTitleBarBackgroundColor;
    private Color inactiveTitleBarBorderColor;
    private Color contentBorderColor;
    private Insets padding;
    private boolean resizable;
    private boolean showContentBevel;
    private Color titleBarBevelColor;
    private Color inactiveTitleBarBevelColor;
    private Color contentBevelColor;
    private static final float INACTIVE_ICON_OPACITY = 0.5f;

    public TerraFrameSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(10));
        this.titleBarColor = theme.getColor(4);
        this.titleBarBackgroundColor = theme.getColor(14);
        this.titleBarBorderColor = theme.getColor(12);
        this.inactiveTitleBarColor = theme.getColor(7);
        this.inactiveTitleBarBackgroundColor = theme.getColor(9);
        this.inactiveTitleBarBorderColor = theme.getColor(7);
        this.contentBorderColor = theme.getColor(7);
        this.padding = new Insets(8);
        this.resizable = true;
        this.showContentBevel = true;
        this.titleBarBevelColor = TerraTheme.brighten(this.titleBarBackgroundColor);
        this.inactiveTitleBarBevelColor = TerraTheme.brighten(this.inactiveTitleBarBackgroundColor);
        this.titleBarTablePane.getColumns().add(new TablePane.Column(1, true));
        this.titleBarTablePane.getColumns().add(new TablePane.Column(-1));
        TablePane.Row titleRow = new TablePane.Row(-1);
        this.titleBarTablePane.getRows().add(titleRow);
        titleRow.add((Component)this.titleBoxPane);
        titleRow.add((Component)this.buttonBoxPane);
        this.titleBarTablePane.getStyles().put("padding", (Object)new Insets(2));
        this.titleBoxPane.add((Component)this.iconImageView);
        this.titleBoxPane.add((Component)this.titleLabel);
        this.titleBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.titleBoxPane.getStyles().put("padding", (Object)new Insets(0, 0, 0, 2));
        Font titleFont = theme.getFont().deriveFont(1);
        this.titleLabel.getStyles().put("font", (Object)titleFont);
        this.iconImageView.setPreferredSize(16, 16);
        this.iconImageView.getStyles().put("fill", (Object)true);
        this.iconImageView.getStyles().put("backgroundColor", null);
        this.buttonBoxPane.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
        this.buttonBoxPane.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
    }

    public void install(Component component) {
        super.install(component);
        Frame frame = (Frame)this.getComponent();
        this.dropShadowDecorator = new DropShadowDecorator();
        frame.getDecorators().add((Decorator)this.dropShadowDecorator);
        frame.add((Component)this.titleBarTablePane);
        this.minimizeButton = new FrameButton(this.minimizeImage);
        this.maximizeButton = new FrameButton(this.maximizeImage);
        this.closeButton = new FrameButton(this.closeImage);
        this.buttonBoxPane.add((Component)this.minimizeButton);
        this.buttonBoxPane.add((Component)this.maximizeButton);
        this.buttonBoxPane.add((Component)this.closeButton);
        ButtonPressListener buttonPressListener = new ButtonPressListener(){

            public void buttonPressed(Button button) {
                Frame frameLocal = (Frame)TerraFrameSkin.this.getComponent();
                if (button == TerraFrameSkin.this.minimizeButton) {
                    frameLocal.setVisible(false);
                } else if (button == TerraFrameSkin.this.maximizeButton) {
                    frameLocal.moveToFront();
                    frameLocal.setMaximized(!frameLocal.isMaximized());
                } else if (button == TerraFrameSkin.this.closeButton) {
                    frameLocal.close();
                }
            }
        };
        this.minimizeButton.getButtonPressListeners().add((Object)buttonPressListener);
        this.maximizeButton.getButtonPressListeners().add((Object)buttonPressListener);
        this.closeButton.getButtonPressListeners().add((Object)buttonPressListener);
        frame.add((Component)this.resizeHandle);
        this.iconAdded((Window)frame, null);
        this.titleChanged((Window)frame, null);
        this.activeChanged((Window)frame, null);
        this.maximizedChanged((Window)frame);
        this.setShowMinimizeButton(false);
    }

    public int getPreferredWidth(int height) {
        Component content;
        MenuBar menuBar;
        int preferredWidth = 0;
        Frame frame = (Frame)this.getComponent();
        Dimensions titleBarSize = this.titleBarTablePane.getPreferredSize();
        preferredWidth = Math.max(titleBarSize.width + 2, preferredWidth);
        if (height != -1) {
            height -= titleBarSize.height + 2;
        }
        if ((menuBar = frame.getMenuBar()) != null) {
            Dimensions menuBarSize = menuBar.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, menuBarSize.width);
            if (height != -1) {
                height -= menuBarSize.height;
            }
        }
        if ((content = frame.getContent()) != null) {
            if (height != -1) {
                height -= this.padding.top + this.padding.bottom + (this.showContentBevel ? 1 : 0) + 2;
                height = Math.max(height, 0);
            }
            preferredWidth = Math.max(preferredWidth, content.getPreferredWidth(height));
        }
        return preferredWidth += this.padding.left + this.padding.right + 2;
    }

    public int getPreferredHeight(int width) {
        Component content;
        int preferredHeight = 0;
        Frame frame = (Frame)this.getComponent();
        preferredHeight += this.titleBarTablePane.getPreferredHeight() + 2;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null) {
            preferredHeight += menuBar.getPreferredHeight();
        }
        if ((content = frame.getContent()) != null) {
            if (width != -1) {
                width -= this.padding.left + this.padding.right + 2;
                width = Math.max(width, 0);
            }
            preferredHeight += content.getPreferredHeight(width);
        }
        return preferredHeight += this.padding.top + this.padding.bottom + (this.showContentBevel ? 1 : 0) + 2;
    }

    public Dimensions getPreferredSize() {
        Component content;
        int preferredWidth = 0;
        int preferredHeight = 0;
        Frame frame = (Frame)this.getComponent();
        Dimensions titleBarSize = this.titleBarTablePane.getPreferredSize();
        preferredWidth = Math.max(preferredWidth, titleBarSize.width + 2);
        preferredHeight += titleBarSize.height + 2;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null) {
            Dimensions preferredMenuBarSize = menuBar.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, preferredMenuBarSize.width);
            preferredHeight += preferredMenuBarSize.height;
        }
        if ((content = frame.getContent()) != null) {
            Dimensions preferredContentSize = content.getPreferredSize();
            preferredWidth = Math.max(preferredWidth, preferredContentSize.width);
            preferredHeight += preferredContentSize.height;
        }
        return new Dimensions(preferredWidth += this.padding.left + this.padding.right + 2, preferredHeight += this.padding.top + this.padding.bottom + (this.showContentBevel ? 1 : 0) + 2);
    }

    public void layout() {
        Frame frame = (Frame)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean maximized = frame.isMaximized();
        if (!maximized || this.getShowWindowControls()) {
            Component content;
            int clientX = 1;
            int clientY = 1;
            int clientWidth = Math.max(width - 2, 0);
            int clientHeight = Math.max(height - 2, 0);
            this.titleBarTablePane.setLocation(clientX, clientY);
            this.titleBarTablePane.setSize(clientWidth, this.titleBarTablePane.getPreferredHeight());
            this.titleBarTablePane.setVisible(true);
            clientY += this.titleBarTablePane.getHeight() + (this.showContentBevel ? 1 : 0) + 2;
            this.resizeHandle.setSize(this.resizeHandle.getPreferredSize());
            this.resizeHandle.setLocation(clientWidth - this.resizeHandle.getWidth(), clientHeight - this.resizeHandle.getHeight());
            this.resizeHandle.setVisible(this.resizable && !maximized && (frame.isPreferredWidthSet() || frame.isPreferredHeightSet()));
            MenuBar menuBar = frame.getMenuBar();
            if (menuBar != null && menuBar.isVisible()) {
                menuBar.setLocation(clientX, clientY);
                menuBar.setSize(clientWidth, menuBar.getPreferredHeight());
                clientY += menuBar.getHeight();
            }
            if ((content = frame.getContent()) != null) {
                int contentX = clientX + this.padding.left;
                int contentY = clientY + this.padding.top;
                int contentWidth = Math.max(clientWidth - (this.padding.left + this.padding.right), 0);
                int contentHeight = Math.max(clientHeight - (clientY + this.padding.top + this.padding.bottom) + (this.showContentBevel ? 1 : 0), 0);
                content.setLocation(contentX, contentY);
                content.setSize(contentWidth, contentHeight);
            }
        } else {
            Component content;
            this.titleBarTablePane.setVisible(false);
            this.resizeHandle.setVisible(false);
            int clientY = 0;
            MenuBar menuBar = frame.getMenuBar();
            if (menuBar != null && menuBar.isVisible()) {
                menuBar.setLocation(0, clientY);
                menuBar.setSize(width, menuBar.getPreferredHeight());
                clientY += menuBar.getHeight();
            }
            if ((content = frame.getContent()) != null) {
                content.setLocation(this.padding.left, clientY + this.padding.top);
                content.setSize(Math.max(width - (this.padding.left + this.padding.right), 0), Math.max(height - (clientY + this.padding.top + this.padding.bottom), 0));
            }
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        Frame frame = (Frame)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        boolean maximized = frame.isMaximized();
        if (!maximized || this.getShowWindowControls()) {
            int titleBarHeight = this.titleBarTablePane.getHeight();
            Color titleBarBackgroundColorLocal = frame.isActive() ? this.titleBarBackgroundColor : this.inactiveTitleBarBackgroundColor;
            Color titleBarBorderColorLocal = frame.isActive() ? this.titleBarBorderColor : this.inactiveTitleBarBorderColor;
            Color titleBarBevelColorLocal = frame.isActive() ? this.titleBarBevelColor : this.inactiveTitleBarBevelColor;
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, titleBarBevelColorLocal, (float)width / 2.0f, titleBarHeight + 1, titleBarBackgroundColorLocal));
            graphics.fillRect(0, 0, width, titleBarHeight + 1);
            graphics.setPaint(titleBarBorderColorLocal);
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)(titleBarHeight + 2));
            Bounds contentAreaRectangle = new Bounds(0, titleBarHeight + 2, width, height - (titleBarHeight + 2));
            graphics.setPaint(this.contentBorderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)contentAreaRectangle.x, (int)contentAreaRectangle.y, (int)contentAreaRectangle.width, (int)contentAreaRectangle.height);
            if (this.showContentBevel) {
                graphics.setPaint(this.contentBevelColor);
                GraphicsUtilities.drawLine((Graphics2D)graphics, (int)(contentAreaRectangle.x + 1), (int)(contentAreaRectangle.y + 1), (int)(contentAreaRectangle.width - 2), (Orientation)Orientation.HORIZONTAL);
            }
        }
    }

    public Bounds getClientArea() {
        int width = this.getWidth();
        int height = this.getHeight();
        int titleBarHeight = this.titleBarTablePane.getHeight();
        Frame frame = (Frame)this.getComponent();
        boolean maximized = frame.isMaximized();
        Bounds clientArea = maximized && !this.getShowWindowControls() ? new Bounds(0, 0, width, height) : new Bounds(0, titleBarHeight + 2, width, height - (titleBarHeight + 2));
        return clientArea;
    }

    public void setBackgroundColor(Color backgroundColor) {
        super.setBackgroundColor(backgroundColor);
        this.contentBevelColor = TerraTheme.brighten(backgroundColor);
    }

    public final void setBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(color));
    }

    public boolean getShowMinimizeButton() {
        return this.minimizeButton.isVisible();
    }

    public void setShowMinimizeButton(boolean showMinimizeButton) {
        this.minimizeButton.setVisible(showMinimizeButton);
    }

    public boolean getShowMaximizeButton() {
        return this.maximizeButton.isVisible();
    }

    public void setShowMaximizeButton(boolean showMaximizeButton) {
        this.maximizeButton.setVisible(showMaximizeButton);
    }

    public boolean getShowCloseButton() {
        return this.closeButton.isVisible();
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.closeButton.setVisible(showCloseButton);
    }

    public boolean getShowWindowControls() {
        return this.getShowMinimizeButton() || this.getShowMaximizeButton() || this.getShowCloseButton();
    }

    public void setShowWindowControls(boolean showWindowControls) {
        this.setShowMinimizeButton(showWindowControls);
        this.setShowMaximizeButton(showWindowControls);
        this.setShowCloseButton(showWindowControls);
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        this.invalidateComponent();
    }

    public boolean getShowContentBevel() {
        return this.showContentBevel;
    }

    public void setShowContentBevel(boolean showContentBevel) {
        this.showContentBevel = showContentBevel;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            Frame frame = (Frame)this.getComponent();
            Display display = frame.getDisplay();
            Point location = frame.mapPointToAncestor((Container)display, x, y);
            location = new Point(Math.min(Math.max(location.x, 0), display.getWidth() - 1), Math.min(Math.max(location.y, 0), display.getHeight() - 1));
            if (this.dragOffset != null) {
                frame.setLocation(location.x - this.dragOffset.x, location.y - this.dragOffset.y);
            } else if (this.resizeOffset != null) {
                int preferredWidth = -1;
                int preferredHeight = -1;
                if (frame.isPreferredWidthSet()) {
                    preferredWidth = Math.max(location.x - frame.getX() + this.resizeOffset.x, this.titleBarTablePane.getPreferredWidth(-1) + 2);
                    preferredWidth = Math.min(preferredWidth, frame.getMaximumWidth());
                    preferredWidth = Math.max(preferredWidth, frame.getMinimumWidth());
                }
                if (frame.isPreferredHeightSet()) {
                    preferredHeight = Math.max(location.y - frame.getY() + this.resizeOffset.y, this.titleBarTablePane.getHeight() + this.resizeHandle.getHeight() + (this.showContentBevel ? 1 : 0) + 6);
                    preferredHeight = Math.min(preferredHeight, frame.getMaximumHeight());
                    preferredHeight = Math.max(preferredHeight, frame.getMinimumHeight());
                }
                frame.setPreferredSize(preferredWidth, preferredHeight);
            }
        } else {
            Cursor cursor = null;
            if (this.resizeHandle.isVisible() && x > this.resizeHandle.getX() && y > this.resizeHandle.getY()) {
                boolean preferredWidthSet = component.isPreferredWidthSet();
                boolean preferredHeightSet = component.isPreferredHeightSet();
                if (preferredWidthSet && preferredHeightSet) {
                    cursor = Cursor.RESIZE_SOUTH_EAST;
                } else if (preferredWidthSet) {
                    cursor = Cursor.RESIZE_EAST;
                } else if (preferredHeightSet) {
                    cursor = Cursor.RESIZE_SOUTH;
                }
            }
            component.setCursor(cursor);
        }
        return consumed;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        Frame frame = (Frame)this.getComponent();
        boolean maximized = frame.isMaximized();
        if (button == Mouse.Button.LEFT && !maximized) {
            Bounds titleBarBounds = this.titleBarTablePane.getBounds();
            if (titleBarBounds.contains(x, y)) {
                this.dragOffset = new Point(x, y);
                Mouse.capture((Component)component);
            } else if (this.resizable && x > this.resizeHandle.getX() && y > this.resizeHandle.getY()) {
                this.resizeOffset = new Point(this.getWidth() - x, this.getHeight() - y);
                Mouse.capture((Component)component);
            }
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            this.dragOffset = null;
            this.resizeOffset = null;
            Mouse.release();
        }
        return consumed;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        Frame frame = (Frame)component;
        MenuBar menuBar = frame.getMenuBar();
        if (menuBar != null && keyCode == 32 && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.ALT)) {
            MenuBar.Item activeItem = menuBar.getActiveItem();
            MenuBar.ItemSequence items = menuBar.getItems();
            if (activeItem == null && items.getLength() > 0) {
                items.get(0).setActive(true);
                consumed = true;
            }
        }
        return consumed;
    }

    public void titleChanged(Window window, String previousTitle) {
        String title = window.getTitle();
        this.titleLabel.setVisible(title != null);
        this.titleLabel.setText(title != null ? title : "");
    }

    public void iconAdded(Window window, Image addedIcon) {
        if (window.getIcons().getLength() > 0) {
            this.iconImageView.setVisible(true);
            this.iconImageView.setImage(window.getIcons().get(0));
        } else {
            this.iconImageView.setVisible(false);
            this.iconImageView.setImage((Image)null);
        }
    }

    public void iconsRemoved(Window window, int index, Sequence<Image> removed) {
        if (window.getIcons().getLength() > 0) {
            this.iconImageView.setVisible(true);
            this.iconImageView.setImage(window.getIcons().get(0));
        } else {
            this.iconImageView.setVisible(false);
            this.iconImageView.setImage((Image)null);
        }
    }

    public void activeChanged(Window window, Window obverseWindow) {
        boolean active = window.isActive();
        this.titleLabel.getStyles().put("color", (Object)(active ? this.titleBarColor : this.inactiveTitleBarColor));
        this.iconImageView.getStyles().put("opacity", (Object)Float.valueOf(active ? 1.0f : 0.5f));
        this.updateButtonStyles(this.minimizeButton, active);
        this.updateButtonStyles(this.maximizeButton, active);
        this.updateButtonStyles(this.closeButton, active);
        this.repaintComponent();
    }

    public void maximizedChanged(Window window) {
        super.maximizedChanged(window);
        this.maximizeButton.setButtonData(window.isMaximized() ? this.restoreImage : this.maximizeImage);
    }

    public void menuBarChanged(Frame frame, MenuBar previousMenuBar) {
        this.invalidateComponent();
    }

    private void updateButtonStyles(FrameButton frameButton, boolean active) {
        frameButton.getStyles().put("color", (Object)(active ? this.titleBarColor : this.inactiveTitleBarColor));
        frameButton.getStyles().put("backgroundColor", (Object)(active ? this.titleBarBackgroundColor : this.inactiveTitleBarBackgroundColor));
        frameButton.getStyles().put("borderColor", (Object)(active ? this.titleBarBorderColor : this.inactiveTitleBarBorderColor));
    }

    protected class ResizeImage
    extends Image {
        public static final int ALPHA = 64;

        protected ResizeImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics) {
            graphics.setPaint(new Color(0, 0, 0, 64));
            graphics.fillRect(3, 0, 2, 1);
            graphics.fillRect(0, 3, 2, 1);
            graphics.fillRect(3, 3, 2, 1);
            graphics.setPaint(new Color(TerraFrameSkin.this.contentBorderColor.getRed(), TerraFrameSkin.this.contentBorderColor.getGreen(), TerraFrameSkin.this.contentBorderColor.getBlue(), 64));
            graphics.fillRect(3, 1, 2, 1);
            graphics.fillRect(0, 4, 2, 1);
            graphics.fillRect(3, 4, 2, 1);
        }
    }

    protected class CloseImage
    extends ButtonImage {
        protected CloseImage() {
        }

        public void paint(Graphics2D graphics) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.draw(new Line2D.Double(0.5, 0.5, 7.5, 7.5));
            graphics.draw(new Line2D.Double(0.5, 7.5, 7.5, 0.5));
        }
    }

    protected class RestoreImage
    extends ButtonImage {
        protected RestoreImage() {
        }

        public void paint(Graphics2D graphics) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics.fillRect(1, 1, 6, 6);
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarBackgroundColor : TerraFrameSkin.this.inactiveTitleBarBackgroundColor);
            graphics.fillRect(3, 3, 2, 2);
        }
    }

    protected class MaximizeImage
    extends ButtonImage {
        protected MaximizeImage() {
        }

        public void paint(Graphics2D graphics) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics.fillRect(0, 0, 8, 8);
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarBackgroundColor : TerraFrameSkin.this.inactiveTitleBarBackgroundColor);
            graphics.fillRect(2, 2, 4, 4);
        }
    }

    protected class MinimizeImage
    extends ButtonImage {
        protected MinimizeImage() {
        }

        public void paint(Graphics2D graphics) {
            Frame frame = (Frame)TerraFrameSkin.this.getComponent();
            graphics.setPaint(frame.isActive() ? TerraFrameSkin.this.titleBarColor : TerraFrameSkin.this.inactiveTitleBarColor);
            graphics.fillRect(0, 6, 8, 2);
        }
    }

    protected abstract class ButtonImage
    extends Image {
        protected ButtonImage() {
        }

        public int getWidth() {
            return 8;
        }

        public int getHeight() {
            return 8;
        }
    }

    public static class FrameButtonSkin
    extends TerraPushButtonSkin {
        public FrameButtonSkin() {
            this.setPadding(3);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            super.mouseDown(component, button, x, y);
            return true;
        }
    }

    public static class FrameButton
    extends PushButton {
        public FrameButton(Object buttonData) {
            super(buttonData);
            this.installSkin(FrameButton.class);
        }
    }
}

