/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.MenuBar;
import org.apache.pivot.wtk.MenuBarListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuBarSkin
extends ContainerSkin
implements MenuBarListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color activeColor;
    private Color activeBackgroundColor;
    private int spacing;

    public TerraMenuBarSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont().deriveFont(1);
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.activeColor = theme.getColor(4);
        this.activeBackgroundColor = theme.getColor(14);
        this.spacing = 2;
    }

    public void install(Component component) {
        super.install(component);
        MenuBar menuBar = (MenuBar)component;
        menuBar.getMenuBarListeners().add((Object)this);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence items = menuBar.getItems();
        int j = 0;
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            MenuBar.Item item;
            if (j > 0) {
                preferredWidth += this.spacing;
            }
            if (!(item = items.get(i)).isVisible()) continue;
            preferredWidth += item.getPreferredWidth(height);
            ++j;
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence items = menuBar.getItems();
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            MenuBar.Item item = items.get(i);
            if (!item.isVisible()) continue;
            preferredHeight = Math.max(item.getPreferredHeight(width), preferredHeight);
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        MenuBar menuBar = (MenuBar)this.getComponent();
        MenuBar.ItemSequence items = menuBar.getItems();
        int j = 0;
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            MenuBar.Item item;
            if (j > 0) {
                preferredWidth += this.spacing;
            }
            if (!(item = items.get(i)).isVisible()) continue;
            preferredWidth += item.getPreferredWidth(-1);
            preferredHeight = Math.max(item.getPreferredHeight(-1), preferredHeight);
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public void layout() {
        MenuBar menuBar = (MenuBar)this.getComponent();
        int height = this.getHeight();
        int itemX = 0;
        for (MenuBar.Item item : menuBar.getItems()) {
            if (!item.isVisible()) continue;
            item.setSize(item.getPreferredWidth(height), height);
            item.setLocation(itemX, 0);
            itemX += item.getWidth() + this.spacing;
        }
    }

    public final void setBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(color));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuBarSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(color));
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color activeColor) {
        if (activeColor == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.activeColor = activeColor;
        this.repaintComponent();
    }

    public final void setActiveColor(String activeColor) {
        if (activeColor == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.setActiveColor(GraphicsUtilities.decodeColor((String)activeColor));
    }

    public final void setActiveColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setActiveColor(theme.getColor(color));
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    public void setActiveBackgroundColor(Color activeBackgroundColor) {
        if (activeBackgroundColor == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.activeBackgroundColor = activeBackgroundColor;
        this.repaintComponent();
    }

    public final void setActiveBackgroundColor(String activeBackgroundColor) {
        if (activeBackgroundColor == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.setActiveBackgroundColor(GraphicsUtilities.decodeColor((String)activeBackgroundColor));
    }

    public final void setActiveBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setActiveBackgroundColor(theme.getColor(color));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("Spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public void itemInserted(MenuBar menuBar, int index) {
        this.invalidateComponent();
    }

    public void itemsRemoved(MenuBar menuBar, int index, Sequence<MenuBar.Item> removed) {
        this.invalidateComponent();
    }

    public void activeItemChanged(MenuBar menuBar, MenuBar.Item previousActiveItem) {
    }
}

