/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBar;
import org.apache.pivot.wtk.ScrollBarListener;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraScrollBarSkin
extends ContainerSkin
implements ScrollBarListener,
ScrollBarValueListener {
    private static final int DEFAULT_THICKNESS = 15;
    private static final int DEFAULT_LENGTH = 100;
    private AutomaticScroller automaticScroller = new AutomaticScroller();
    private ScrollButton scrollUpButton = new ScrollButton(-1, new ScrollUpImage());
    private ScrollButton scrollDownButton = new ScrollButton(1, new ScrollDownImage());
    private Handle handle = new Handle();
    private int minimumHandleLength;
    private Color borderColor;
    private Color scrollButtonImageColor;
    private Color scrollButtonBackgroundColor;
    private Color scrollButtonDisabledBackgroundColor;
    private Color scrollButtonPressedBackgroundColor;
    private Color scrollButtonHighlightedBackgroundColor;

    public TerraScrollBarSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.minimumHandleLength = 31;
        this.borderColor = theme.getColor(7);
        this.scrollButtonImageColor = theme.getColor(1);
        this.scrollButtonBackgroundColor = theme.getColor(10);
        this.scrollButtonDisabledBackgroundColor = theme.getColor(10);
        this.scrollButtonPressedBackgroundColor = theme.getColor(9);
        this.scrollButtonHighlightedBackgroundColor = theme.getColor(11);
    }

    public void install(Component component) {
        super.install(component);
        ScrollBar scrollBar = (ScrollBar)component;
        scrollBar.getScrollBarListeners().add((Object)this);
        scrollBar.getScrollBarValueListeners().add((Object)this);
        scrollBar.add((Component)this.scrollUpButton);
        scrollBar.add((Component)this.scrollDownButton);
        scrollBar.add((Component)this.handle);
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        Color backgroundColor = theme.getColor(9);
        Color brightBackgroundColor = TerraTheme.brighten(backgroundColor);
        GradientPaint backgroundPaint = scrollBar.getOrientation() == Orientation.HORIZONTAL ? new GradientPaint(0.0f, 1.0f, backgroundColor, 0.0f, 13.0f, brightBackgroundColor) : new GradientPaint(1.0f, 0.0f, backgroundColor, 13.0f, 0.0f, brightBackgroundColor);
        this.setBackgroundPaint(backgroundPaint);
        this.enabledChanged((Component)scrollBar);
    }

    public int getPreferredWidth(int height) {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int preferredWidth = 0;
        preferredWidth = scrollBar.getOrientation() == Orientation.HORIZONTAL ? 100 : 15;
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int preferredHeight = 0;
        preferredHeight = scrollBar.getOrientation() == Orientation.HORIZONTAL ? 15 : 100;
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int preferredWidth = 0;
        int preferredHeight = 0;
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            preferredWidth = 100;
            preferredHeight = 15;
        } else {
            preferredWidth = 15;
            preferredHeight = 100;
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public void layout() {
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int start = scrollBar.getStart();
        int end = scrollBar.getEnd();
        int extent = scrollBar.getExtent();
        int value = scrollBar.getValue();
        int maxLegalRealValue = end - extent;
        int numLegalRealValues = maxLegalRealValue - start + 1;
        float extentPercentage = (float)extent / (float)(end - start);
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            this.scrollUpButton.setSize(this.scrollUpButton.getPreferredWidth(-1), height);
            this.scrollUpButton.setLocation(0, 0);
            this.scrollDownButton.setSize(this.scrollDownButton.getPreferredWidth(-1), height);
            this.scrollDownButton.setLocation(width - this.scrollDownButton.getWidth(), 0);
            if (scrollBar.isEnabled()) {
                int availableWidth = width - this.scrollUpButton.getWidth() - this.scrollDownButton.getWidth() + 2;
                int handleWidth = Math.max(this.minimumHandleLength, Math.round(extentPercentage * (float)availableWidth));
                int numLegalPixelValues = availableWidth - handleWidth + 1;
                float valueScale = (float)numLegalPixelValues / (float)numLegalRealValues;
                int handleX = (int)((float)(value - start) * valueScale) + this.scrollUpButton.getWidth() - 1;
                if (handleWidth > availableWidth) {
                    this.handle.setVisible(false);
                } else {
                    this.handle.setVisible(true);
                    this.handle.setSize(handleWidth, height);
                    this.handle.setLocation(handleX, 0);
                }
            } else {
                this.handle.setVisible(false);
            }
        } else {
            this.scrollUpButton.setSize(width, this.scrollUpButton.getPreferredHeight(-1));
            this.scrollUpButton.setLocation(0, 0);
            this.scrollDownButton.setSize(width, this.scrollDownButton.getPreferredHeight(-1));
            this.scrollDownButton.setLocation(0, height - this.scrollDownButton.getHeight());
            if (scrollBar.isEnabled()) {
                int availableHeight = height - this.scrollUpButton.getHeight() - this.scrollDownButton.getHeight() + 2;
                int handleHeight = Math.max(this.minimumHandleLength, Math.round(extentPercentage * (float)availableHeight));
                int numLegalPixelValues = availableHeight - handleHeight + 1;
                float valueScale = (float)numLegalPixelValues / (float)numLegalRealValues;
                int handleY = (int)((float)(value - start) * valueScale) + this.scrollUpButton.getHeight() - 1;
                if (handleHeight > availableHeight) {
                    this.handle.setVisible(false);
                } else {
                    this.handle.setVisible(true);
                    this.handle.setSize(width, handleHeight);
                    this.handle.setLocation(0, handleY);
                }
            } else {
                this.handle.setVisible(false);
            }
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setPaint(this.borderColor);
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            int scrollUpButtonWidth = this.scrollUpButton.getWidth();
            int scrollDownButtonWidth = this.scrollDownButton.getWidth();
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)scrollUpButtonWidth, (int)0, (int)(width - scrollDownButtonWidth - scrollUpButtonWidth), (Orientation)Orientation.HORIZONTAL);
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)scrollUpButtonWidth, (int)(height - 1), (int)(width - scrollDownButtonWidth - scrollUpButtonWidth), (Orientation)Orientation.HORIZONTAL);
        } else {
            int scrollUpButtonHeight = this.scrollUpButton.getHeight();
            int scrollDownButtonHeight = this.scrollDownButton.getHeight();
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)0, (int)scrollUpButtonHeight, (int)(height - scrollDownButtonHeight - scrollUpButtonHeight), (Orientation)Orientation.VERTICAL);
            GraphicsUtilities.drawLine((Graphics2D)graphics, (int)(width - 1), (int)scrollUpButtonHeight, (int)(height - scrollDownButtonHeight - scrollUpButtonHeight), (Orientation)Orientation.VERTICAL);
        }
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public int getMinimumHandleLength() {
        return this.minimumHandleLength;
    }

    public void setMinimumHandleLength(int minimumHandleLength) {
        if (minimumHandleLength <= 0) {
            throw new IllegalArgumentException("minimumHandleLength must be positive.");
        }
        if (minimumHandleLength != this.minimumHandleLength) {
            this.minimumHandleLength = minimumHandleLength;
            this.invalidateComponent();
        }
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getScrollButtonImageColor() {
        return this.scrollButtonImageColor;
    }

    public void setScrollButtonImageColor(Color scrollButtonImageColor) {
        if (scrollButtonImageColor == null) {
            throw new IllegalArgumentException("scrollButtonImageColor is null");
        }
        this.scrollButtonImageColor = scrollButtonImageColor;
        this.repaintComponent();
    }

    public final void setScrollButtonImageColor(String scrollButtonImageColor) {
        if (scrollButtonImageColor == null) {
            throw new IllegalArgumentException("scrollButtonImageColor is null");
        }
        this.setScrollButtonImageColor(GraphicsUtilities.decodeColor((String)scrollButtonImageColor));
    }

    public final void setScrollButtonImageColor(int scrollButtonImageColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonImageColor(theme.getColor(scrollButtonImageColor));
    }

    public Color getScrollButtonBackgroundColor() {
        return this.scrollButtonBackgroundColor;
    }

    public void setScrollButtonBackgroundColor(Color scrollButtonBackgroundColor) {
        if (scrollButtonBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonBackgroundColor is null");
        }
        this.scrollButtonBackgroundColor = scrollButtonBackgroundColor;
        this.repaintComponent();
    }

    public final void setScrollButtonBackgroundColor(String scrollButtonBackgroundColor) {
        if (scrollButtonBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonBackgroundColor is null");
        }
        this.setScrollButtonBackgroundColor(GraphicsUtilities.decodeColor((String)scrollButtonBackgroundColor));
    }

    public final void setScrollButtonBackgroundColor(int scrollButtonBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonBackgroundColor(theme.getColor(scrollButtonBackgroundColor));
    }

    public Color getScrollButtonDisabledBackgroundColor() {
        return this.scrollButtonDisabledBackgroundColor;
    }

    public void setScrollButtonDisabledBackgroundColor(Color scrollButtonDisabledBackgroundColor) {
        if (scrollButtonDisabledBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonDisabledBackgroundColor is null");
        }
        this.scrollButtonDisabledBackgroundColor = scrollButtonDisabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setScrollButtonDisabledBackgroundColor(String scrollButtonDisabledBackgroundColor) {
        if (scrollButtonDisabledBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonDisabledBackgroundColor is null");
        }
        this.setScrollButtonDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)scrollButtonDisabledBackgroundColor));
    }

    public final void setScrollButtonDisabledBackgroundColor(int scrollButtonDisabledBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonDisabledBackgroundColor(theme.getColor(scrollButtonDisabledBackgroundColor));
    }

    public Color getScrollButtonPressedBackgroundColor() {
        return this.scrollButtonPressedBackgroundColor;
    }

    public void setScrollButtonPressedBackgroundColor(Color scrollButtonPressedBackgroundColor) {
        if (scrollButtonPressedBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonPressedBackgroundColor is null");
        }
        this.scrollButtonPressedBackgroundColor = scrollButtonPressedBackgroundColor;
        this.repaintComponent();
    }

    public final void setScrollButtonPressedBackgroundColor(String scrollButtonPressedBackgroundColor) {
        if (scrollButtonPressedBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonPressedBackgroundColor is null");
        }
        this.setScrollButtonPressedBackgroundColor(GraphicsUtilities.decodeColor((String)scrollButtonPressedBackgroundColor));
    }

    public final void setScrollButtonPressedBackgroundColor(int scrollButtonPressedBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonPressedBackgroundColor(theme.getColor(scrollButtonPressedBackgroundColor));
    }

    public Color getScrollButtonHighlightedBackgroundColor() {
        return this.scrollButtonHighlightedBackgroundColor;
    }

    public void setScrollButtonHighlightedBackgroundColor(Color scrollButtonHighlightedBackgroundColor) {
        if (scrollButtonHighlightedBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonHighlightedBackgroundColor is null");
        }
        this.scrollButtonHighlightedBackgroundColor = scrollButtonHighlightedBackgroundColor;
        this.repaintComponent();
    }

    public final void setScrollButtonHighlightedBackgroundColor(String scrollButtonHighlightedBackgroundColor) {
        if (scrollButtonHighlightedBackgroundColor == null) {
            throw new IllegalArgumentException("scrollButtonHighlightedBackgroundColor is null");
        }
        this.setScrollButtonHighlightedBackgroundColor(GraphicsUtilities.decodeColor((String)scrollButtonHighlightedBackgroundColor));
    }

    public final void setScrollButtonHighlightedBackgroundColor(int scrollButtonHighlightedBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setScrollButtonHighlightedBackgroundColor(theme.getColor(scrollButtonHighlightedBackgroundColor));
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.automaticScroller.stop();
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        if (button == Mouse.Button.LEFT && this.handle.isVisible()) {
            int realStopValue;
            int direction;
            ScrollBar scrollBar = (ScrollBar)this.getComponent();
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                direction = x < this.handle.getX() ? -1 : 1;
                int pixelStopValue = x - this.scrollUpButton.getWidth() + 1;
                if (direction == 1) {
                    pixelStopValue -= this.handle.getWidth();
                }
                realStopValue = (int)((float)pixelStopValue / this.getValueScale());
            } else {
                direction = y < this.handle.getY() ? -1 : 1;
                int pixelStopValue = y - this.scrollUpButton.getHeight() + 1;
                if (direction == 1) {
                    pixelStopValue -= this.handle.getHeight();
                }
                realStopValue = (int)((float)pixelStopValue / this.getValueScale());
            }
            this.automaticScroller.start(direction, Mouse.ScrollType.BLOCK, realStopValue);
            consumed = true;
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (button == Mouse.Button.LEFT) {
            this.automaticScroller.stop();
        }
        return consumed;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        boolean consumed = false;
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int previousValue = scrollBar.getValue();
        int newValue = previousValue + scrollAmount * wheelRotation * scrollBar.getUnitIncrement();
        if (wheelRotation > 0) {
            int maxValue = scrollBar.getEnd() - scrollBar.getExtent();
            newValue = Math.min(newValue, maxValue);
            if (previousValue < maxValue) {
                consumed = true;
            }
        } else {
            newValue = Math.max(newValue, 0);
            if (previousValue > 0) {
                consumed = true;
            }
        }
        scrollBar.setValue(newValue);
        return consumed;
    }

    private float getValueScale() {
        int numLegalPixelValues;
        ScrollBar scrollBar = (ScrollBar)this.getComponent();
        int start = scrollBar.getStart();
        int end = scrollBar.getEnd();
        int extent = scrollBar.getExtent();
        int maxLegalRealValue = end - extent;
        int numLegalRealValues = maxLegalRealValue - start + 1;
        if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
            int availableWidth = this.getWidth() - this.scrollUpButton.getWidth() - this.scrollDownButton.getWidth() + 2;
            numLegalPixelValues = availableWidth - this.handle.getWidth() + 1;
        } else {
            int availableHeight = this.getHeight() - this.scrollUpButton.getHeight() - this.scrollDownButton.getHeight() + 2;
            numLegalPixelValues = availableHeight - this.handle.getHeight() + 1;
        }
        float valueScale = (float)numLegalPixelValues / ((float)numLegalRealValues - 1.0f);
        return valueScale;
    }

    public void enabledChanged(Component component) {
        boolean enabled = component.isEnabled();
        this.scrollUpButton.setEnabled(enabled);
        this.scrollDownButton.setEnabled(enabled);
        this.invalidateComponent();
    }

    public void orientationChanged(ScrollBar scrollBar, Orientation previousOrientation) {
        this.invalidateComponent();
    }

    public void scopeChanged(ScrollBar scrollBar, int previousStart, int previousEnd, int previousExtent) {
        this.invalidateComponent();
    }

    public void unitIncrementChanged(ScrollBar scrollBar, int previousUnitIncrement) {
    }

    public void blockIncrementChanged(ScrollBar scrollBar, int previousBlockIncrement) {
    }

    public void valueChanged(ScrollBar scrollBar, int previousValue) {
        if (this.handle.isVisible()) {
            int start = scrollBar.getStart();
            int value = scrollBar.getValue();
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                int handleX = (int)((float)(value - start) * this.getValueScale()) + this.scrollUpButton.getWidth() - 1;
                this.handle.setLocation(handleX, 0);
            } else {
                int handleY = (int)((float)(value - start) * this.getValueScale()) + this.scrollUpButton.getHeight() - 1;
                this.handle.setLocation(0, handleY);
            }
        }
    }

    protected class HandleSkin
    extends ComponentSkin {
        private int dragOffset;
        private boolean highlighted = false;

        protected HandleSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int height) {
            throw new UnsupportedOperationException();
        }

        public int getPreferredHeight(int width) {
            throw new UnsupportedOperationException();
        }

        public Dimensions getPreferredSize() {
            throw new UnsupportedOperationException();
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            int width = this.getWidth();
            int height = this.getHeight();
            Color backgroundColor = this.highlighted ? TerraScrollBarSkin.this.scrollButtonHighlightedBackgroundColor : TerraScrollBarSkin.this.scrollButtonBackgroundColor;
            Color brightBackgroundColor = TerraTheme.brighten(backgroundColor);
            Color darkBackgroundColor = TerraTheme.darken(backgroundColor);
            if (orientation == Orientation.HORIZONTAL) {
                graphics.setPaint(new GradientPaint(0.0f, 1.0f, brightBackgroundColor, 0.0f, height - 2, backgroundColor));
            } else {
                graphics.setPaint(new GradientPaint(1.0f, 0.0f, brightBackgroundColor, width - 2, 0.0f, backgroundColor));
            }
            graphics.fillRect(1, 1, width - 2, height - 2);
            graphics.setPaint(TerraScrollBarSkin.this.borderColor);
            graphics.setStroke(new BasicStroke());
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
            if (orientation == Orientation.HORIZONTAL) {
                int middle = width / 2;
                graphics.setPaint(darkBackgroundColor);
                graphics.drawLine(middle - 3, 4, middle - 3, height - 5);
                graphics.drawLine(middle, 4, middle, height - 5);
                graphics.drawLine(middle + 3, 4, middle + 3, height - 5);
                graphics.setPaint(brightBackgroundColor);
                graphics.drawLine(middle - 2, 4, middle - 2, height - 5);
                graphics.drawLine(middle + 1, 4, middle + 1, height - 5);
                graphics.drawLine(middle + 4, 4, middle + 4, height - 5);
            } else {
                int middle = height / 2;
                graphics.setPaint(darkBackgroundColor);
                graphics.drawLine(4, middle - 3, width - 5, middle - 3);
                graphics.drawLine(4, middle, width - 5, middle);
                graphics.drawLine(4, middle + 3, width - 5, middle + 3);
                graphics.setPaint(brightBackgroundColor);
                graphics.drawLine(4, middle - 2, width - 5, middle - 2);
                graphics.drawLine(4, middle + 1, width - 5, middle + 1);
                graphics.drawLine(4, middle + 4, width - 5, middle + 4);
            }
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseMove(Component component, int x, int y) {
            boolean consumed = super.mouseMove(component, x, y);
            if (Mouse.getCapturer() == component) {
                ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
                Orientation orientation = scrollBar.getOrientation();
                int pixelValue = orientation == Orientation.HORIZONTAL ? component.getX() - TerraScrollBarSkin.this.scrollUpButton.getWidth() + x - this.dragOffset : component.getY() - TerraScrollBarSkin.this.scrollUpButton.getHeight() + y - this.dragOffset;
                int realValue = (int)((float)pixelValue / TerraScrollBarSkin.this.getValueScale());
                int start = scrollBar.getStart();
                int end = scrollBar.getEnd();
                int extent = scrollBar.getExtent();
                realValue = Math.min(Math.max(realValue - start, start), end - extent);
                scrollBar.setValue(realValue);
            }
            return consumed;
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
                Orientation orientation = scrollBar.getOrientation();
                this.dragOffset = orientation == Orientation.HORIZONTAL ? x : y;
                Mouse.capture((Component)component);
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT && Mouse.getCapturer() == component) {
                Mouse.release();
            }
            return consumed;
        }
    }

    protected class Handle
    extends Component {
        public Handle() {
            this.setSkin((Skin)new HandleSkin());
        }
    }

    protected class ScrollDownImage
    extends ScrollButtonImage {
        protected ScrollDownImage() {
        }

        public void paint(Graphics2D graphics) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.setPaint(TerraScrollBarSkin.this.scrollButtonImageColor);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath arrow = new GeneralPath(0);
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                arrow.moveTo(0.0f, 0.0f);
                arrow.lineTo((float)width + 0.5f, (float)height / 2.0f);
                arrow.lineTo(0.0f, height);
            } else {
                arrow.moveTo(0.0f, 0.0f);
                arrow.lineTo((float)width / 2.0f, (float)height + 0.5f);
                arrow.lineTo(width, 0.0f);
            }
            arrow.closePath();
            graphics.fill(arrow);
        }
    }

    protected class ScrollUpImage
    extends ScrollButtonImage {
        protected ScrollUpImage() {
        }

        public void paint(Graphics2D graphics) {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.setPaint(TerraScrollBarSkin.this.scrollButtonImageColor);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath arrow = new GeneralPath(0);
            if (scrollBar.getOrientation() == Orientation.HORIZONTAL) {
                arrow.moveTo((float)width + 0.5f, 0.0f);
                arrow.lineTo(0.0f, (float)height / 2.0f);
                arrow.lineTo((float)width + 0.5f, height);
            } else {
                arrow.moveTo(0.0f, (float)height + 0.5f);
                arrow.lineTo((float)width / 2.0f, 0.0f);
                arrow.lineTo(width, (float)height + 0.5f);
            }
            arrow.closePath();
            graphics.fill(arrow);
        }
    }

    protected abstract class ScrollButtonImage
    extends Image {
        protected ScrollButtonImage() {
        }

        public int getWidth() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            return orientation == Orientation.HORIZONTAL ? 5 : 7;
        }

        public int getHeight() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            return orientation == Orientation.HORIZONTAL ? 7 : 5;
        }
    }

    protected class ScrollButtonSkin
    extends ComponentSkin {
        private boolean highlighted = false;
        private boolean pressed = false;

        protected ScrollButtonSkin() {
        }

        public boolean isFocusable() {
            return false;
        }

        public int getPreferredWidth(int height) {
            return 15;
        }

        public int getPreferredHeight(int width) {
            return 15;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            Color gradientEndColor;
            ScrollButton scrollButton = (ScrollButton)this.getComponent();
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            Orientation orientation = scrollBar.getOrientation();
            int width = this.getWidth();
            int height = this.getHeight();
            Color backgroundColor = scrollButton.isEnabled() ? (this.pressed ? TerraScrollBarSkin.this.scrollButtonPressedBackgroundColor : (this.highlighted ? TerraScrollBarSkin.this.scrollButtonHighlightedBackgroundColor : TerraScrollBarSkin.this.scrollButtonBackgroundColor)) : TerraScrollBarSkin.this.scrollButtonDisabledBackgroundColor;
            Color brightBackgroundColor = TerraTheme.brighten(backgroundColor);
            Color gradientStartColor = this.pressed ? backgroundColor : brightBackgroundColor;
            Color color = gradientEndColor = this.pressed ? brightBackgroundColor : backgroundColor;
            if (orientation == Orientation.HORIZONTAL) {
                graphics.setPaint(new GradientPaint(0.0f, 1.0f, gradientStartColor, 0.0f, height - 2, gradientEndColor));
            } else {
                graphics.setPaint(new GradientPaint(1.0f, 0.0f, gradientStartColor, width - 2, 0.0f, gradientEndColor));
            }
            graphics.fillRect(1, 1, width - 2, height - 2);
            graphics.setPaint(TerraScrollBarSkin.this.borderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
            ScrollButtonImage buttonImage = scrollButton.getButtonImage();
            int buttonImageWidth = buttonImage.getWidth();
            int buttonImageHeight = buttonImage.getHeight();
            Graphics2D imageGraphics = (Graphics2D)graphics.create();
            int buttonImageX = (width - buttonImageWidth) / 2;
            int buttonImageY = (height - buttonImageHeight) / 2;
            imageGraphics.translate(buttonImageX, buttonImageY);
            imageGraphics.clipRect(0, 0, buttonImageWidth, buttonImageHeight);
            buttonImage.paint(imageGraphics);
            imageGraphics.dispose();
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            TerraScrollBarSkin.this.automaticScroller.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            TerraScrollBarSkin.this.automaticScroller.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                ScrollButton scrollButton = (ScrollButton)this.getComponent();
                TerraScrollBarSkin.this.automaticScroller.start(scrollButton.getDirection(), Mouse.ScrollType.UNIT, -1);
                this.pressed = true;
                this.repaintComponent();
                consumed = true;
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                TerraScrollBarSkin.this.automaticScroller.stop();
                this.pressed = false;
                this.repaintComponent();
            }
            return consumed;
        }
    }

    protected class ScrollButton
    extends Component {
        private int direction;
        private ScrollButtonImage buttonImage;

        public ScrollButton(int direction, ScrollButtonImage buttonImage) {
            this.direction = direction;
            this.buttonImage = buttonImage;
            this.setSkin((Skin)new ScrollButtonSkin());
        }

        public int getDirection() {
            return this.direction;
        }

        public ScrollButtonImage getButtonImage() {
            return this.buttonImage;
        }
    }

    protected class AutomaticScroller {
        public int direction;
        public Mouse.ScrollType incrementType;
        public int stopValue;
        private ApplicationContext.ScheduledCallback scheduledScrollCallback = null;

        protected AutomaticScroller() {
        }

        public void start(int directionArgument, Mouse.ScrollType incrementTypeArgument, int stopValueArgument) {
            if (this.scheduledScrollCallback != null) {
                throw new IllegalStateException("Already running");
            }
            this.direction = directionArgument;
            this.incrementType = incrementTypeArgument;
            this.stopValue = stopValueArgument;
            this.scheduledScrollCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    AutomaticScroller.this.scroll();
                }
            }, (long)400L, (long)30L);
            this.scroll();
        }

        public void stop() {
            if (this.scheduledScrollCallback != null) {
                this.scheduledScrollCallback.cancel();
                this.scheduledScrollCallback = null;
            }
        }

        private void scroll() {
            ScrollBar scrollBar = (ScrollBar)TerraScrollBarSkin.this.getComponent();
            int start = scrollBar.getStart();
            int end = scrollBar.getEnd();
            int extent = scrollBar.getExtent();
            int value = scrollBar.getValue();
            int adjustment = this.incrementType == Mouse.ScrollType.UNIT ? this.direction * scrollBar.getUnitIncrement() : this.direction * scrollBar.getBlockIncrement();
            if (adjustment < 0) {
                int newValue = Math.max(value + adjustment, start);
                scrollBar.setValue(newValue);
                if (this.stopValue != -1 && newValue < this.stopValue) {
                    this.stop();
                }
                if (newValue == start) {
                    this.stop();
                }
            } else {
                int newValue = Math.min(value + adjustment, end - extent);
                scrollBar.setValue(newValue);
                if (this.stopValue != -1 && newValue > this.stopValue) {
                    this.stop();
                }
                if (newValue == end - extent) {
                    this.stop();
                }
            }
        }
    }
}

