/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.ListViewSelectionListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.SuggestionPopup;
import org.apache.pivot.wtk.SuggestionPopupListener;
import org.apache.pivot.wtk.SuggestionPopupSelectionListener;
import org.apache.pivot.wtk.SuggestionPopupStateListener;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;

public class TerraSuggestionPopupSkin
extends WindowSkin
implements SuggestionPopupListener,
SuggestionPopupSelectionListener,
SuggestionPopupStateListener {
    private Panorama listViewPanorama;
    private Border listViewBorder;
    private ListView listView = new ListView();
    private DropShadowDecorator dropShadowDecorator = null;
    private Transition closeTransition = null;
    private boolean returnFocusToTextInput = true;
    private int closeTransitionDuration = 150;
    private int closeTransitionRate = 30;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            SuggestionPopup suggestionPopup = (SuggestionPopup)TerraSuggestionPopupSkin.this.getComponent();
            TextInput textInput = suggestionPopup.getTextInput();
            Display display = (Display)container;
            Component descendant = display.getDescendantAt(x, y);
            if (!suggestionPopup.isAncestor(descendant) && descendant != textInput) {
                TerraSuggestionPopupSkin.this.returnFocusToTextInput = false;
                suggestionPopup.close(false);
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            return true;
        }
    };
    private ComponentStateListener textInputStateListener = new ComponentStateListener.Adapter(){

        public void focusedChanged(Component component, Component obverseComponent) {
            SuggestionPopup suggestionPopup = (SuggestionPopup)TerraSuggestionPopupSkin.this.getComponent();
            if (!component.isFocused() && !suggestionPopup.containsFocus()) {
                TerraSuggestionPopupSkin.this.returnFocusToTextInput = false;
                suggestionPopup.close();
            }
        }
    };
    private ComponentKeyListener textInputKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            boolean consumed = false;
            SuggestionPopup suggestionPopup = (SuggestionPopup)TerraSuggestionPopupSkin.this.getComponent();
            if (keyCode == 40) {
                if (TerraSuggestionPopupSkin.this.listView.getSelectedIndex() == -1 && TerraSuggestionPopupSkin.this.listView.getListData().getLength() > 0) {
                    TerraSuggestionPopupSkin.this.listView.setSelectedIndex(0);
                }
                suggestionPopup.requestFocus();
                consumed = true;
            } else if (keyCode == 27) {
                suggestionPopup.close(false);
                consumed = true;
            }
            return consumed;
        }
    };
    private ListViewSelectionListener listViewSelectionListener = new ListViewSelectionListener.Adapter(){

        public void selectedItemChanged(ListView listViewArgument, Object previousSelectedItem) {
            int index = listViewArgument.getSelectedIndex();
            SuggestionPopup suggestionPopup = (SuggestionPopup)TerraSuggestionPopupSkin.this.getComponent();
            suggestionPopup.setSelectedIndex(index);
        }
    };
    private ComponentKeyListener listViewKeyListener = new ComponentKeyListener.Adapter(){

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            SuggestionPopup suggestionPopup = (SuggestionPopup)TerraSuggestionPopupSkin.this.getComponent();
            TextInput textInput = suggestionPopup.getTextInput();
            switch (keyCode) {
                case 9: {
                    TerraSuggestionPopupSkin.this.returnFocusToTextInput = false;
                    suggestionPopup.close(true);
                    FocusTraversalDirection direction = Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
                    textInput.transferFocus(direction);
                    break;
                }
            }
            return false;
        }
    };
    private static final int DEFAULT_CLOSE_TRANSITION_DURATION = 150;
    private static final int DEFAULT_CLOSE_TRANSITION_RATE = 30;

    public TerraSuggestionPopupSkin() {
        this.listView.getStyles().put("variableItemHeight", (Object)true);
        this.listView.getListViewSelectionListeners().add((Object)this.listViewSelectionListener);
        this.listView.getComponentKeyListeners().add((Object)this.listViewKeyListener);
        this.listViewPanorama = new Panorama((Component)this.listView);
        this.listViewPanorama.getStyles().put("buttonBackgroundColor", this.listView.getStyles().get("backgroundColor"));
        this.listViewPanorama.getStyles().put("alwaysShowScrollButtons", (Object)true);
        this.listViewBorder = new Border((Component)this.listViewPanorama);
    }

    public void install(Component component) {
        super.install(component);
        SuggestionPopup suggestionPopup = (SuggestionPopup)component;
        suggestionPopup.getSuggestionPopupListeners().add((Object)this);
        suggestionPopup.getSuggestionPopupSelectionListeners().add((Object)this);
        suggestionPopup.getSuggestionPopupStateListeners().add((Object)this);
        suggestionPopup.setContent((Component)this.listViewBorder);
        this.listView.setListData(suggestionPopup.getSuggestionData());
        this.listView.setItemRenderer(suggestionPopup.getSuggestionRenderer());
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        suggestionPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public Font getFont() {
        return (Font)this.listView.getStyles().get("font");
    }

    public void setFont(Font font) {
        this.listView.getStyles().put("font", (Object)font);
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraSuggestionPopupSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return (Color)this.listView.getStyles().get("color");
    }

    public void setColor(Color color) {
        this.listView.getStyles().put("color", (Object)color);
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getBorderColor() {
        return (Color)this.listViewBorder.getStyles().get("color");
    }

    public void setBorderColor(Color borderColor) {
        this.listViewBorder.getStyles().put("color", (Object)borderColor);
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public int getCloseTransitionDuration() {
        return this.closeTransitionDuration;
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.closeTransitionDuration = closeTransitionDuration;
    }

    public int getCloseTransitionRate() {
        return this.closeTransitionRate;
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.closeTransitionRate = closeTransitionRate;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        SuggestionPopup suggestionPopup = (SuggestionPopup)this.getComponent();
        suggestionPopup.close(true);
        return true;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        SuggestionPopup suggestionPopup = (SuggestionPopup)this.getComponent();
        switch (keyCode) {
            case 10: {
                suggestionPopup.close(true);
                break;
            }
            case 27: {
                suggestionPopup.close(false);
                break;
            }
        }
        return false;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        SuggestionPopup suggestionPopup = (SuggestionPopup)window;
        int listSize = suggestionPopup.getListSize();
        if (listSize == -1) {
            this.listViewBorder.setPreferredHeight(-1);
        } else if (!this.listViewBorder.isPreferredHeightSet()) {
            ListView.ItemRenderer itemRenderer = this.listView.getItemRenderer();
            int borderHeight = itemRenderer.getPreferredHeight(-1) * listSize + 2;
            if (this.listViewBorder.getPreferredHeight() > borderHeight) {
                this.listViewBorder.setPreferredHeight(borderHeight);
            } else {
                this.listViewBorder.setPreferredHeight(-1);
            }
        }
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        this.dropShadowDecorator.setShadowOpacity(0.25f);
        this.returnFocusToTextInput = true;
        TextInput textInput = suggestionPopup.getTextInput();
        textInput.getComponentStateListeners().add((Object)this.textInputStateListener);
        textInput.getComponentKeyListeners().add((Object)this.textInputKeyListener);
        Point location = textInput.mapPointToAncestor((Container)textInput.getDisplay(), 0, 0);
        window.setLocation(location.x, location.y + textInput.getHeight() - 1);
        window.setMinimumWidth(textInput.getWidth());
        window.setMaximumHeight(display.getHeight() - window.getY());
    }

    public void windowCloseVetoed(Window window, Vote reason) {
        if (reason == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
            this.listViewBorder.setEnabled(true);
            this.closeTransition = null;
        }
    }

    public void windowClosed(Window window, Display display, Window owner) {
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        super.windowClosed(window, display, owner);
    }

    public void suggestionDataChanged(SuggestionPopup suggestionPopup, List<?> previousSuggestionData) {
        this.listView.setListData(suggestionPopup.getSuggestionData());
    }

    public void suggestionRendererChanged(SuggestionPopup suggestionPopup, ListView.ItemRenderer previousSuggestionRenderer) {
        this.listView.setItemRenderer(suggestionPopup.getSuggestionRenderer());
    }

    public void listSizeChanged(SuggestionPopup suggestionPopup, int previousListSize) {
    }

    public void selectedIndexChanged(SuggestionPopup suggestionPopup, int previousSelectedIndex) {
    }

    public void selectedSuggestionChanged(SuggestionPopup suggestionPopup, Object previousSelectedSuggestion) {
        TextInput textInput = suggestionPopup.getTextInput();
        Object suggestion = suggestionPopup.getSelectedSuggestion();
        if (suggestion != null) {
            ListView.ItemRenderer suggestionRenderer = suggestionPopup.getSuggestionRenderer();
            textInput.setText(suggestionRenderer.toString(suggestion));
        }
    }

    public Vote previewSuggestionPopupClose(final SuggestionPopup suggestionPopup, final boolean result) {
        if (this.closeTransition == null) {
            this.listViewBorder.setEnabled(false);
            this.closeTransition = new FadeWindowTransition((Component)suggestionPopup, this.closeTransitionDuration, this.closeTransitionRate, this.dropShadowDecorator);
            this.closeTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    suggestionPopup.close(result);
                }
            });
        }
        return this.closeTransition != null && this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
    }

    public void suggestionPopupCloseVetoed(SuggestionPopup suggestionPopup, Vote reason) {
        if (reason == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
            this.listViewBorder.setEnabled(true);
            this.closeTransition = null;
        }
    }

    public void suggestionPopupClosed(SuggestionPopup suggestionPopup) {
        suggestionPopup.clearFocusDescendant();
        TextInput textInput = suggestionPopup.getTextInput();
        textInput.getComponentStateListeners().remove((Object)this.textInputStateListener);
        textInput.getComponentKeyListeners().remove((Object)this.textInputKeyListener);
        if (this.returnFocusToTextInput) {
            textInput.requestFocus();
        }
        this.listViewBorder.setEnabled(true);
        this.closeTransition = null;
    }
}

