/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.text.CharacterIterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.text.CharSequenceCharacterIterator;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.TextInputListener;
import org.apache.pivot.wtk.TextInputSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;
import org.apache.pivot.wtk.validation.Validator;

public class TerraTextInputSkin
extends ComponentSkin
implements TextInput.Skin,
TextInputListener,
TextInputContentListener,
TextInputSelectionListener {
    private GlyphVector glyphVector = null;
    private int anchor = -1;
    private Rectangle caret = new Rectangle();
    private Rectangle selection = null;
    private int scrollLeft = 0;
    private boolean caretOn = true;
    private FocusTraversalDirection scrollDirection = null;
    private BlinkCaretCallback blinkCaretCallback = new BlinkCaretCallback();
    private ApplicationContext.ScheduledCallback scheduledBlinkCaretCallback = null;
    private ScrollSelectionCallback scrollSelectionCallback = new ScrollSelectionCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollSelectionCallback = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color promptColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color invalidColor;
    private Color invalidBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color bevelColor;
    private Color disabledBevelColor;
    private Color invalidBevelColor;
    private Insets padding;
    private HorizontalAlignment horizontalAlignment;
    private Dimensions averageCharacterSize;
    private static final int SCROLL_RATE = 50;
    private static final char BULLET = '\u2022';

    public TerraTextInputSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setFont(theme.getFont());
        this.color = theme.getColor(1);
        this.promptColor = theme.getColor(7);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(11);
        this.disabledBackgroundColor = theme.getColor(10);
        this.invalidColor = theme.getColor(4);
        this.invalidBackgroundColor = theme.getColor(22);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.padding = new Insets(2);
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.selectionColor = theme.getColor(4);
        this.selectionBackgroundColor = theme.getColor(14);
        this.inactiveSelectionColor = theme.getColor(1);
        this.inactiveSelectionBackgroundColor = theme.getColor(9);
        this.bevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
        this.invalidBevelColor = TerraTheme.darken(this.invalidBackgroundColor);
    }

    public void install(Component component) {
        super.install(component);
        TextInput textInput = (TextInput)component;
        textInput.getTextInputListeners().add((Object)this);
        textInput.getTextInputContentListeners().add((Object)this);
        textInput.getTextInputSelectionListeners().add((Object)this);
        textInput.setCursor(Cursor.TEXT);
        this.updateSelection();
    }

    public int getPreferredWidth(int height) {
        TextInput textInput = (TextInput)this.getComponent();
        int textSize = textInput.getTextSize();
        return this.averageCharacterSize.width * textSize + (this.padding.left + this.padding.right) + 2;
    }

    public int getPreferredHeight(int width) {
        return this.averageCharacterSize.height + (this.padding.top + this.padding.bottom) + 2;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
    }

    public int getBaseline(int width, int height) {
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        float textHeight = lm.getHeight();
        int baseline = Math.round(((float)height - textHeight) / 2.0f + ascent);
        return baseline;
    }

    public void layout() {
        TextInput textInput = (TextInput)this.getComponent();
        this.glyphVector = null;
        int n = textInput.getCharacterCount();
        if (n > 0) {
            CharSequence characters;
            if (textInput.isPassword()) {
                StringBuilder passwordBuilder = new StringBuilder(n);
                for (int i = 0; i < n; ++i) {
                    passwordBuilder.append('\u2022');
                }
                characters = passwordBuilder;
            } else {
                characters = textInput.getCharacters();
            }
            CharSequenceCharacterIterator ci = new CharSequenceCharacterIterator(characters);
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            this.glyphVector = this.font.createGlyphVector(fontRenderContext, (CharacterIterator)ci);
            Rectangle2D textBounds = this.glyphVector.getLogicalBounds();
            int textWidth = (int)textBounds.getWidth();
            int width = this.getWidth();
            if (textWidth - this.scrollLeft + this.padding.left + 1 < width - this.padding.right - 1) {
                this.scrollLeft = Math.max(textWidth + (this.padding.left + this.padding.right + 2) - width, 0);
            } else {
                int selectionStart = textInput.getSelectionStart();
                if (selectionStart <= n && textInput.isFocused()) {
                    this.scrollCharacterToVisible(selectionStart);
                }
            }
        }
        this.updateSelection();
        this.showCaret(textInput.isFocused() && textInput.getSelectionLength() == 0);
    }

    private int getAlignmentDeltaX() {
        int alignmentDeltaX = 0;
        switch (this.horizontalAlignment) {
            case LEFT: {
                break;
            }
            case CENTER: {
                TextInput textInput = (TextInput)this.getComponent();
                double txtWidth = this.glyphVector == null ? 0.0 : this.glyphVector.getLogicalBounds().getWidth();
                int availWidth = textInput.getWidth() - (this.padding.left + this.padding.right + 2);
                alignmentDeltaX = (int)((double)availWidth - txtWidth) / 2;
                break;
            }
            case RIGHT: {
                TextInput textInput = (TextInput)this.getComponent();
                double txtWidth = this.glyphVector == null ? 0.0 : this.glyphVector.getLogicalBounds().getWidth();
                int availWidth = textInput.getWidth() - (this.padding.left + this.padding.right + 2 + this.caret.width);
                alignmentDeltaX = (int)((double)availWidth - txtWidth);
                break;
            }
        }
        return alignmentDeltaX;
    }

    public void paint(Graphics2D graphics) {
        Color caretColor;
        Color borderColorLocal;
        Color bevelColorLocal;
        Color backgroundColorLocal;
        TextInput textInput = (TextInput)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        if (textInput.isEnabled()) {
            if (textInput.isTextValid()) {
                backgroundColorLocal = this.backgroundColor;
                bevelColorLocal = this.bevelColor;
            } else {
                backgroundColorLocal = this.invalidBackgroundColor;
                bevelColorLocal = this.invalidBevelColor;
            }
            borderColorLocal = this.borderColor;
        } else {
            backgroundColorLocal = this.disabledBackgroundColor;
            borderColorLocal = this.disabledBorderColor;
            bevelColorLocal = this.disabledBevelColor;
        }
        graphics.setStroke(new BasicStroke());
        graphics.setColor(backgroundColorLocal);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(bevelColorLocal);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)0, (int)0, (int)width, (Orientation)Orientation.HORIZONTAL);
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        float ascent = lm.getAscent();
        float textHeight = lm.getHeight();
        String prompt = textInput.getPrompt();
        int alignmentDeltaX = this.getAlignmentDeltaX();
        int xpos = this.padding.left - this.scrollLeft + 1 + alignmentDeltaX;
        if (this.glyphVector == null && prompt != null) {
            graphics.setFont(this.font);
            graphics.setColor(this.promptColor);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, fontRenderContext.getAntiAliasingHint());
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.getFractionalMetricsHint());
            graphics.drawString(prompt, (float)xpos, ((float)height - textHeight) / 2.0f + ascent);
            caretColor = this.color;
        } else {
            boolean textValid = textInput.isTextValid();
            Color colorLocal = textInput.isEnabled() ? (!textValid ? this.invalidColor : this.color) : this.disabledColor;
            caretColor = colorLocal;
            if (this.glyphVector != null) {
                graphics.setFont(this.font);
                if (this.selection == null) {
                    graphics.setColor(colorLocal);
                    graphics.drawGlyphVector(this.glyphVector, xpos, ((float)height - textHeight) / 2.0f + ascent);
                } else {
                    Color selectionBackgroundColorLocal;
                    Color selectionColorLocal;
                    Area unselectedArea = new Area();
                    unselectedArea.add(new Area(new Rectangle(0, 0, width, height)));
                    unselectedArea.subtract(new Area(this.selection));
                    Graphics2D textGraphics = (Graphics2D)graphics.create();
                    textGraphics.setColor(colorLocal);
                    textGraphics.clip(unselectedArea);
                    textGraphics.drawGlyphVector(this.glyphVector, xpos, ((float)height - textHeight) / 2.0f + ascent);
                    textGraphics.dispose();
                    if (textInput.isFocused() && textInput.isEditable()) {
                        selectionColorLocal = this.selectionColor;
                        selectionBackgroundColorLocal = this.selectionBackgroundColor;
                    } else {
                        selectionColorLocal = this.inactiveSelectionColor;
                        selectionBackgroundColorLocal = this.inactiveSelectionBackgroundColor;
                    }
                    graphics.setColor(selectionBackgroundColorLocal);
                    graphics.fill(this.selection);
                    Graphics2D selectedTextGraphics = (Graphics2D)graphics.create();
                    selectedTextGraphics.setColor(selectionColorLocal);
                    selectedTextGraphics.clip(this.selection.getBounds());
                    selectedTextGraphics.drawGlyphVector(this.glyphVector, xpos, ((float)height - textHeight) / 2.0f + ascent);
                    selectedTextGraphics.dispose();
                }
            }
        }
        if (this.selection == null && this.caretOn && textInput.isFocused()) {
            graphics.setColor(caretColor);
            graphics.fill(this.caret);
        }
        graphics.setColor(borderColorLocal);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
    }

    public int getInsertionPoint(int x) {
        int offset = -1;
        if (this.glyphVector == null) {
            offset = 0;
        } else {
            int xt = x - (this.padding.left - this.scrollLeft + 1 + this.getAlignmentDeltaX());
            Rectangle2D textBounds = this.glyphVector.getLogicalBounds();
            if (xt < 0) {
                offset = 0;
            } else if ((double)xt > textBounds.getWidth()) {
                offset = this.glyphVector.getNumGlyphs();
            } else {
                int n = this.glyphVector.getNumGlyphs();
                for (int i = 0; i < n; ++i) {
                    Shape glyphBounds = this.glyphVector.getGlyphLogicalBounds(i);
                    Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
                    float glyphX = (float)glyphBounds2D.getX();
                    float glyphWidth = (float)glyphBounds2D.getWidth();
                    if (!((float)xt >= glyphX) || !((float)xt < glyphX + glyphWidth)) continue;
                    if ((float)xt - glyphX > glyphWidth / 2.0f) {
                        ++i;
                    }
                    offset = i;
                    break;
                }
            }
        }
        return offset;
    }

    public Bounds getCharacterBounds(int index) {
        Bounds characterBounds = null;
        if (this.glyphVector != null) {
            int width;
            int x;
            if (index < this.glyphVector.getNumGlyphs()) {
                Shape glyphBounds = this.glyphVector.getGlyphLogicalBounds(index);
                Rectangle2D glyphBounds2D = glyphBounds.getBounds2D();
                x = (int)Math.floor(glyphBounds2D.getX());
                width = (int)Math.ceil(glyphBounds2D.getWidth());
            } else {
                Rectangle2D glyphVectorBounds = this.glyphVector.getLogicalBounds();
                x = (int)Math.floor(glyphVectorBounds.getWidth());
                width = 0;
            }
            characterBounds = new Bounds(x + this.padding.left - this.scrollLeft + 1 + this.getAlignmentDeltaX(), this.padding.top + 1, width, this.getHeight() - (this.padding.top + this.padding.bottom + 2));
        }
        return characterBounds;
    }

    private void setScrollLeft(int scrollLeft) {
        this.scrollLeft = scrollLeft;
        this.updateSelection();
        this.repaintComponent();
    }

    private void scrollCharacterToVisible(int offset) {
        int width = this.getWidth();
        Bounds characterBounds = this.getCharacterBounds(offset);
        if (characterBounds != null) {
            int glyphX = characterBounds.x - (this.padding.left + 1) + this.scrollLeft;
            if (characterBounds.x < this.padding.left + 1) {
                this.setScrollLeft(glyphX);
            } else if (characterBounds.x + characterBounds.width > width - (this.padding.right + 1)) {
                this.setScrollLeft(glyphX + (this.padding.left + this.padding.right + 2) + characterBounds.width - width);
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        int missingGlyphCode = font.getMissingGlyphCode();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        GlyphVector missingGlyphVector = font.createGlyphVector(fontRenderContext, new int[]{missingGlyphCode});
        Rectangle2D textBounds = missingGlyphVector.getLogicalBounds();
        Rectangle2D maxCharBounds = font.getMaxCharBounds(fontRenderContext);
        this.averageCharacterSize = new Dimensions((int)Math.ceil(textBounds.getWidth()), (int)Math.ceil(maxCharBounds.getHeight()));
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTextInputSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getPromptColor() {
        return this.promptColor;
    }

    public void setPromptColor(Color promptColor) {
        if (promptColor == null) {
            throw new IllegalArgumentException("promptColor is null.");
        }
        this.promptColor = promptColor;
        this.repaintComponent();
    }

    public final void setPromptColor(String promptColor) {
        if (promptColor == null) {
            throw new IllegalArgumentException("promptColor is null.");
        }
        this.setPromptColor(GraphicsUtilities.decodeColor((String)promptColor));
    }

    public final void setPromptColor(int promptColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setPromptColor(theme.getColor(promptColor));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(color));
    }

    public Color getInvalidColor() {
        return this.invalidColor;
    }

    public void setInvalidColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.invalidColor = color;
        this.repaintComponent();
    }

    public final void setInvalidColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setInvalidColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setInvalidColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInvalidColor(theme.getColor(color));
    }

    public Color getInvalidBackgroundColor() {
        return this.invalidBackgroundColor;
    }

    public void setInvalidBackgroundColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.invalidBackgroundColor = color;
        this.invalidBevelColor = TerraTheme.darken(color);
        this.repaintComponent();
    }

    public final void setInvalidBackgroundColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("invalidBackgroundColor is null.");
        }
        this.setInvalidBackgroundColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setInvalidBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInvalidBackgroundColor(theme.getColor(color));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public final void setDisabledBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(theme.getColor(color));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(color));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public final void setDisabledBorderColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(theme.getColor(color));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)selectionColor));
    }

    public final void setSelectionColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(theme.getColor(color));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)selectionBackgroundColor));
    }

    public final void setSelectionBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(theme.getColor(color));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)inactiveSelectionColor));
    }

    public final void setInactiveSelectionColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(theme.getColor(color));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)inactiveSelectionBackgroundColor));
    }

    public final void setInactiveSelectionBackgroundColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(theme.getColor(color));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final void setHorizontalAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("horizontalAlignment is null.");
        }
        this.horizontalAlignment = alignment;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            TextInput textInput = (TextInput)this.getComponent();
            int width = this.getWidth();
            if (x >= 0 && x < width) {
                if (this.scheduledScrollSelectionCallback != null) {
                    this.scheduledScrollSelectionCallback.cancel();
                    this.scheduledScrollSelectionCallback = null;
                }
                this.scrollDirection = null;
                int offset = this.getInsertionPoint(x);
                if (offset != -1) {
                    if (offset > this.anchor) {
                        textInput.setSelection(this.anchor, offset - this.anchor);
                    } else {
                        textInput.setSelection(offset, this.anchor - offset);
                    }
                }
            } else if (this.scheduledScrollSelectionCallback == null) {
                this.scrollDirection = x < 0 ? FocusTraversalDirection.BACKWARD : FocusTraversalDirection.FORWARD;
                this.scheduledScrollSelectionCallback = ApplicationContext.scheduleRecurringCallback((Runnable)this.scrollSelectionCallback, (long)50L);
                this.scrollSelectionCallback.run();
            }
        } else if (Mouse.isPressed((Mouse.Button)Mouse.Button.LEFT) && Mouse.getCapturer() == null && this.anchor != -1) {
            Mouse.capture((Component)component);
        }
        return consumed;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        if (button == Mouse.Button.LEFT) {
            TextInput textInput = (TextInput)this.getComponent();
            this.anchor = this.getInsertionPoint(x);
            if (this.anchor != -1) {
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    int selectionStart = textInput.getSelectionStart();
                    if (this.anchor > selectionStart) {
                        textInput.setSelection(selectionStart, this.anchor - selectionStart);
                    } else {
                        textInput.setSelection(this.anchor, selectionStart - this.anchor);
                    }
                } else {
                    textInput.setSelection(this.anchor, 0);
                    consumed = true;
                }
            }
            textInput.requestFocus();
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            if (this.scheduledScrollSelectionCallback != null) {
                this.scheduledScrollSelectionCallback.cancel();
                this.scheduledScrollSelectionCallback = null;
            }
            Mouse.release();
        }
        this.anchor = -1;
        return consumed;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        if (button == Mouse.Button.LEFT && count > 1) {
            TextInput textInput = (TextInput)this.getComponent();
            textInput.selectAll();
        }
        return super.mouseClick(component, button, x, y, count);
    }

    public boolean keyTyped(Component component, char character) {
        boolean consumed = super.keyTyped(component, character);
        TextInput textInput = (TextInput)this.getComponent();
        if (textInput.isEditable() && character > '\u001f' && character != '\u007f' && !Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.META)) {
            int selectionLength = textInput.getSelectionLength();
            if (textInput.getCharacterCount() - selectionLength + 1 > textInput.getMaximumLength()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                textInput.removeText(textInput.getSelectionStart(), selectionLength);
                textInput.insertText((CharSequence)Character.toString(character), textInput.getSelectionStart());
            }
        }
        return consumed;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        TextInput textInput = (TextInput)this.getComponent();
        Keyboard.Modifier commandModifier = Platform.getCommandModifier();
        Keyboard.Modifier wordNavigationModifier = Platform.getWordNavigationModifier();
        if (keyCode == 127 && textInput.isEditable()) {
            int index = textInput.getSelectionStart();
            if (index < textInput.getCharacterCount()) {
                int count = Math.max(textInput.getSelectionLength(), 1);
                textInput.removeText(index, count);
                consumed = true;
            }
        } else if (keyCode == 8 && textInput.isEditable()) {
            int index = textInput.getSelectionStart();
            int count = textInput.getSelectionLength();
            if (count == 0 && index > 0) {
                textInput.removeText(index - 1, 1);
                consumed = true;
            } else {
                textInput.removeText(index, count);
                consumed = true;
            }
        } else if (keyCode == 36 || keyCode == 37 && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.META)) {
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                textInput.setSelection(0, textInput.getSelectionStart());
            } else {
                textInput.setSelection(0, 0);
            }
            this.scrollCharacterToVisible(0);
            consumed = true;
        } else if (keyCode == 35 || keyCode == 39 && Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.META)) {
            int n = textInput.getCharacterCount();
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                int selectionStart = textInput.getSelectionStart();
                textInput.setSelection(selectionStart, n - selectionStart);
            } else {
                textInput.setSelection(n, 0);
            }
            this.scrollCharacterToVisible(n);
            consumed = true;
        } else if (keyCode == 37) {
            int selectionStart = textInput.getSelectionStart();
            int selectionLength = textInput.getSelectionLength();
            if (Keyboard.isPressed((Keyboard.Modifier)wordNavigationModifier)) {
                if (selectionStart > 0) {
                    int index;
                    for (index = selectionStart; index > 0 && Character.isWhitespace(textInput.getCharacterAt(index - 1)); --index) {
                    }
                    while (index > 0 && !Character.isWhitespace(textInput.getCharacterAt(index - 1))) {
                        --index;
                    }
                    selectionLength = Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) ? (selectionLength += selectionStart - index) : 0;
                    selectionStart = index;
                }
            } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                if (selectionStart > 0) {
                    --selectionStart;
                    ++selectionLength;
                }
            } else {
                if (selectionLength == 0 && selectionStart > 0) {
                    --selectionStart;
                }
                selectionLength = 0;
            }
            if (selectionStart >= 0) {
                textInput.setSelection(selectionStart, selectionLength);
                this.scrollCharacterToVisible(selectionStart);
                consumed = true;
            }
        } else if (keyCode == 39) {
            int selectionStart = textInput.getSelectionStart();
            int selectionLength = textInput.getSelectionLength();
            if (Keyboard.isPressed((Keyboard.Modifier)wordNavigationModifier)) {
                if (selectionStart < textInput.getCharacterCount()) {
                    int index;
                    for (index = selectionStart + selectionLength; index < textInput.getCharacterCount() && Character.isWhitespace(textInput.getCharacterAt(index)); ++index) {
                    }
                    while (index < textInput.getCharacterCount() && !Character.isWhitespace(textInput.getCharacterAt(index))) {
                        ++index;
                    }
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                        selectionLength = index - selectionStart;
                    } else {
                        selectionStart = index;
                        selectionLength = 0;
                    }
                }
            } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                ++selectionLength;
            } else {
                selectionStart = selectionLength == 0 ? ++selectionStart : (selectionStart += selectionLength);
                selectionLength = 0;
            }
            if (selectionStart + selectionLength <= textInput.getCharacterCount()) {
                textInput.setSelection(selectionStart, selectionLength);
                this.scrollCharacterToVisible(selectionStart + selectionLength);
                consumed = true;
            }
        } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier)) {
            if (keyCode == 65) {
                textInput.setSelection(0, textInput.getCharacterCount());
                consumed = true;
            } else if (keyCode == 88 && textInput.isEditable()) {
                if (textInput.isPassword()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    textInput.cut();
                }
                consumed = true;
            } else if (keyCode == 67) {
                if (textInput.isPassword()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    textInput.copy();
                }
                consumed = true;
            } else if (keyCode == 86 && textInput.isEditable()) {
                textInput.paste();
                consumed = true;
            } else if (keyCode == 90 && textInput.isEditable()) {
                if (!Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT)) {
                    textInput.undo();
                }
                consumed = true;
            }
        } else if (keyCode == 155) {
            if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && textInput.isEditable()) {
                textInput.paste();
                consumed = true;
            }
        } else {
            consumed = super.keyPressed(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        TextInput textInput = (TextInput)component;
        Window window = textInput.getWindow();
        if (component.isFocused()) {
            if ((obverseComponent == null || obverseComponent.getWindow() == window) && Mouse.getCapturer() != component) {
                textInput.selectAll();
            }
            if (textInput.getSelectionLength() == 0) {
                int selectionStart = textInput.getSelectionStart();
                if (selectionStart < textInput.getCharacterCount()) {
                    this.scrollCharacterToVisible(selectionStart);
                }
                this.showCaret(true);
            } else {
                this.showCaret(false);
            }
        } else {
            if (obverseComponent == null || obverseComponent.getWindow() == window) {
                textInput.clearSelection();
            }
            this.showCaret(false);
        }
        this.repaintComponent();
    }

    public void textSizeChanged(TextInput textInput, int previousTextSize) {
        this.invalidateComponent();
    }

    public void maximumLengthChanged(TextInput textInput, int previousMaximumLength) {
    }

    public void passwordChanged(TextInput textInput) {
        this.layout();
        this.repaintComponent();
    }

    public void promptChanged(TextInput textInput, String previousPrompt) {
        this.repaintComponent();
    }

    public void textValidatorChanged(TextInput textInput, Validator previousValidator) {
        this.repaintComponent();
    }

    public void strictValidationChanged(TextInput textInput) {
    }

    public void textValidChanged(TextInput textInput) {
        this.repaintComponent();
    }

    public Vote previewInsertText(TextInput textInput, CharSequence text, int index) {
        Validator validator;
        Vote vote = Vote.APPROVE;
        if (textInput.isStrictValidation() && (validator = textInput.getValidator()) != null) {
            StringBuilder textBuilder = new StringBuilder();
            textBuilder.append(textInput.getText(0, index));
            textBuilder.append(text);
            textBuilder.append(textInput.getText(index, textInput.getCharacterCount()));
            if (!validator.isValid(textBuilder.toString())) {
                vote = Vote.DENY;
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return vote;
    }

    public void insertTextVetoed(TextInput textInput, Vote reason) {
    }

    public void textInserted(TextInput textInput, int index, int count) {
    }

    public Vote previewRemoveText(TextInput textInput, int index, int count) {
        Validator validator;
        Vote vote = Vote.APPROVE;
        if (textInput.isStrictValidation() && (validator = textInput.getValidator()) != null) {
            StringBuilder textBuilder = new StringBuilder();
            textBuilder.append(textInput.getText(0, index));
            textBuilder.append(textInput.getText(index + count, textInput.getCharacterCount()));
            if (!validator.isValid(textBuilder.toString())) {
                vote = Vote.DENY;
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return vote;
    }

    public void setSize(int width, int height) {
        boolean invalidate = this.horizontalAlignment != HorizontalAlignment.LEFT && width != this.getWidth();
        super.setSize(width, height);
        if (invalidate) {
            this.updateSelection();
            this.invalidateComponent();
        }
    }

    public void removeTextVetoed(TextInput textInput, Vote reason) {
    }

    public void textRemoved(TextInput textInput, int index, int count) {
    }

    public void textChanged(TextInput textInput) {
        this.layout();
        this.repaintComponent();
    }

    public void editableChanged(TextInput textInput) {
        this.repaintComponent();
    }

    public void selectionChanged(TextInput textInput, int previousSelectionStart, int previousSelectionLength) {
        if (textInput.isValid()) {
            Rectangle bounds;
            if (this.caret != null) {
                textInput.repaint(this.caret.x, this.caret.y, this.caret.width, this.caret.height);
            }
            if (this.selection != null) {
                bounds = this.selection.getBounds();
                textInput.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            if (textInput.getSelectionLength() == 0) {
                this.updateSelection();
                this.showCaret(textInput.isFocused());
            } else {
                this.updateSelection();
                this.showCaret(false);
                bounds = this.selection.getBounds();
                textInput.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    private void updateSelection() {
        Bounds leadingSelectionBounds;
        TextInput textInput = (TextInput)this.getComponent();
        int height = this.getHeight();
        int selectionStart = textInput.getSelectionStart();
        int selectionLength = textInput.getSelectionLength();
        int n = textInput.getCharacterCount();
        if (selectionStart < n) {
            leadingSelectionBounds = this.getCharacterBounds(selectionStart);
        } else {
            int x;
            if (n == 0) {
                x = this.padding.left - this.scrollLeft + 1 + this.getAlignmentDeltaX();
            } else {
                Rectangle2D textBounds = this.glyphVector.getLogicalBounds();
                x = (int)Math.ceil(textBounds.getWidth()) + (this.padding.left - this.scrollLeft + 1 + this.getAlignmentDeltaX());
            }
            int y = this.padding.top + 1;
            leadingSelectionBounds = new Bounds(x, y, 0, height - (this.padding.top + this.padding.bottom + 2));
        }
        this.caret = leadingSelectionBounds.toRectangle();
        this.caret.width = 1;
        if (selectionLength > 0) {
            Bounds trailingSelectionBounds = this.getCharacterBounds(selectionStart + selectionLength - 1);
            this.selection = new Rectangle(leadingSelectionBounds.x, leadingSelectionBounds.y, trailingSelectionBounds.x + trailingSelectionBounds.width - leadingSelectionBounds.x, trailingSelectionBounds.y + trailingSelectionBounds.height - leadingSelectionBounds.y);
        } else {
            this.selection = null;
        }
    }

    public void showCaret(boolean show) {
        if (this.scheduledBlinkCaretCallback != null) {
            this.scheduledBlinkCaretCallback.cancel();
        }
        if (show) {
            this.caretOn = true;
            this.scheduledBlinkCaretCallback = ApplicationContext.scheduleRecurringCallback((Runnable)this.blinkCaretCallback, (long)Platform.getCursorBlinkRate());
            this.blinkCaretCallback.run();
        } else {
            this.scheduledBlinkCaretCallback = null;
        }
    }

    private class ScrollSelectionCallback
    implements Runnable {
        private ScrollSelectionCallback() {
        }

        @Override
        public void run() {
            TextInput textInput = (TextInput)TerraTextInputSkin.this.getComponent();
            int selectionStart = textInput.getSelectionStart();
            int selectionLength = textInput.getSelectionLength();
            int selectionEnd = selectionStart + selectionLength - 1;
            switch (TerraTextInputSkin.this.scrollDirection) {
                case FORWARD: {
                    if (selectionEnd >= textInput.getCharacterCount() - 1) break;
                    textInput.setSelection(selectionStart, ++selectionEnd - selectionStart + 1);
                    TerraTextInputSkin.this.scrollCharacterToVisible(selectionEnd);
                    break;
                }
                case BACKWARD: {
                    if (selectionStart <= 0) break;
                    textInput.setSelection(--selectionStart, selectionEnd - selectionStart + 1);
                    TerraTextInputSkin.this.scrollCharacterToVisible(selectionStart);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    private class BlinkCaretCallback
    implements Runnable {
        private BlinkCaretCallback() {
        }

        @Override
        public void run() {
            TerraTextInputSkin.this.caretOn = !TerraTextInputSkin.this.caretOn;
            if (TerraTextInputSkin.this.caret != null) {
                TextInput textInput = (TextInput)TerraTextInputSkin.this.getComponent();
                textInput.repaint(((TerraTextInputSkin)TerraTextInputSkin.this).caret.x, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.y, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.width, ((TerraTextInputSkin)TerraTextInputSkin.this).caret.height);
            }
        }
    }
}

