/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import java.awt.Color;
import java.awt.Font;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.content.ButtonData;
import org.apache.pivot.wtk.media.Image;

public class ButtonDataRenderer
extends BoxPane
implements Button.DataRenderer {
    protected ImageView imageView = new ImageView();
    protected Label label = new Label();

    public ButtonDataRenderer() {
        this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
        this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
        this.add(this.imageView);
        this.add(this.label);
        this.imageView.getStyles().put("backgroundColor", null);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    @Override
    public void render(Object data, Button button, boolean highlighted) {
        Image icon = null;
        String text = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            icon = buttonData.getIcon();
        } else if (data instanceof Image) {
            icon = (Image)data;
        }
        text = this.toString(data);
        if (icon == null) {
            this.imageView.setVisible(false);
            this.imageView.setImage(icon);
        } else {
            this.imageView.setVisible(true);
            this.imageView.setImage(icon);
            this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
            if (this.getFillIcon()) {
                int buttonWidth = button.getWidth();
                int buttonHeight = button.getHeight();
                Insets padding = (Insets)button.getStyles().get("padding");
                if (buttonWidth > 0) {
                    this.imageView.setPreferredWidth(Math.max(buttonWidth - (padding.left + padding.right + 2), 0));
                }
                if (buttonHeight > 0) {
                    this.imageView.setPreferredWidth(Math.max(buttonHeight - (padding.top + padding.bottom + 2), 0));
                }
            }
        }
        this.label.setText(text != null ? text : "");
        if (text == null || text.length() == 0 && this.getFillIcon()) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
            Font font = (Font)button.getStyles().get("font");
            this.label.getStyles().put("font", (Object)font);
            Color color = button.isEnabled() ? (Color)button.getStyles().get("color") : (Color)button.getStyles().get("disabledColor");
            this.label.getStyles().put("color", (Object)color);
        }
    }

    public int getIconWidth() {
        return this.imageView.getPreferredWidth(-1);
    }

    public void setIconWidth(int iconWidth) {
        this.imageView.setPreferredWidth(iconWidth);
    }

    public int getIconHeight() {
        return this.imageView.getPreferredHeight(-1);
    }

    public void setIconHeight(int iconHeight) {
        this.imageView.setPreferredHeight(iconHeight);
    }

    public boolean getShowIcon() {
        return this.imageView.isVisible();
    }

    public void setShowIcon(boolean showIcon) {
        this.imageView.setVisible(showIcon);
    }

    public boolean getFillIcon() {
        return (Boolean)this.imageView.getStyles().get("fill");
    }

    public void setFillIcon(boolean fillIcon) {
        this.imageView.getStyles().put("fill", (Object)fillIcon);
        this.getStyles().put("fill", (Object)fillIcon);
    }

    @Override
    public String toString(Object data) {
        String string = null;
        if (data instanceof ButtonData) {
            ButtonData buttonData = (ButtonData)data;
            string = buttonData.getText();
        } else if (!(data instanceof Image) && data != null) {
            string = data.toString();
        }
        return string;
    }
}

