/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.content;

import org.apache.pivot.collections.List;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ListItem;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

public class ListViewItemEditor
extends Window
implements ListView.ItemEditor {
    private ListView listView = null;
    private int itemIndex = -1;
    private TextInput textInput = new TextInput();
    private ContainerMouseListener displayMouseHandler = new ContainerMouseListener.Adapter(){

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (window != ListViewItemEditor.this) {
                ListViewItemEditor.this.endEdit(true);
            }
            return false;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            return window != ListViewItemEditor.this;
        }
    };

    public ListViewItemEditor() {
        this.setContent(this.textInput);
    }

    public ListView getListView() {
        return this.listView;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public TextInput getTextInput() {
        return this.textInput;
    }

    @Override
    public void beginEdit(ListView listViewArgument, int itemIndexArgument) {
        this.listView = listViewArgument;
        this.itemIndex = itemIndexArgument;
        List<?> listData = listViewArgument.getListData();
        ListItem listItem = (ListItem)listData.get(itemIndexArgument);
        String text = listItem.getText();
        this.textInput.setText(text != null ? text : "");
        this.textInput.selectAll();
        Bounds itemBounds = listViewArgument.getItemBounds(itemIndexArgument);
        int itemIndent = listViewArgument.getItemIndent();
        itemBounds = new Bounds(itemBounds.x + itemIndent, itemBounds.y, itemBounds.width - itemIndent, itemBounds.height);
        ListViewItemRenderer itemRenderer = (ListViewItemRenderer)listViewArgument.getItemRenderer();
        itemRenderer.render(listItem, itemIndexArgument, listViewArgument, false, false, false, false);
        itemRenderer.setSize(itemBounds.width, itemBounds.height);
        Bounds textBounds = itemRenderer.getTextBounds();
        Insets padding = (Insets)this.textInput.getStyles().get("padding");
        Bounds editBounds = new Bounds(itemBounds.x + textBounds.x - (padding.left + 1), itemBounds.y, itemBounds.width - textBounds.x + (padding.left + 1), itemBounds.height);
        listViewArgument.scrollAreaToVisible(editBounds.x, editBounds.y, textBounds.width + padding.left + 1, editBounds.height);
        editBounds = listViewArgument.getVisibleArea(editBounds);
        Point location = listViewArgument.mapPointToAncestor(listViewArgument.getDisplay(), editBounds.x, editBounds.y);
        this.textInput.setPreferredWidth(editBounds.width);
        this.setLocation(location.x, location.y + (editBounds.height - this.getPreferredHeight(-1)) / 2);
        this.open(listViewArgument.getWindow());
    }

    @Override
    public void endEdit(boolean result) {
        if (result) {
            String text = this.textInput.getText();
            List<?> listData = this.listView.getListData();
            ListItem listItem = (ListItem)listData.get(this.itemIndex);
            listItem.setText(text);
            if (listData.getComparator() == null) {
                listData.update(this.itemIndex, (Object)listItem);
            } else {
                listData.remove(this.itemIndex, 1);
                listData.add((Object)listItem);
                this.itemIndex = listData.indexOf((Object)listItem);
                this.listView.setSelectedIndex(this.itemIndex);
                this.listView.scrollAreaToVisible(this.listView.getItemBounds(this.itemIndex));
            }
        }
        this.getOwner().moveToFront();
        this.listView.requestFocus();
        this.listView = null;
        this.itemIndex = -1;
        this.close();
    }

    @Override
    public boolean isEditing() {
        return this.listView != null;
    }

    @Override
    public void open(Display display, Window owner) {
        if (this.listView == null) {
            throw new IllegalStateException();
        }
        super.open(display, owner);
        display.getContainerMouseListeners().add((Object)this.displayMouseHandler);
        this.requestFocus();
    }

    @Override
    public void close() {
        Display display = this.getDisplay();
        display.getContainerMouseListeners().remove((Object)this.displayMouseHandler);
        super.close();
    }

    @Override
    public boolean keyPressed(int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed;
        if (keyCode == 10) {
            this.endEdit(true);
            consumed = true;
        } else if (keyCode == 27) {
            this.endEdit(false);
            consumed = true;
        } else {
            consumed = false;
        }
        return consumed;
    }
}

