/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Cursor;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextAreaContentListener;
import org.apache.pivot.wtk.TextAreaListener;
import org.apache.pivot.wtk.TextAreaSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.TextAreaSkinParagraphView;

public class TextAreaSkin
extends ComponentSkin
implements TextArea.Skin,
TextAreaListener,
TextAreaContentListener,
TextAreaSelectionListener {
    private int caretX = 0;
    private Rectangle caret = new Rectangle();
    private Area selection = null;
    private boolean caretOn = false;
    private int anchor = -1;
    private TextArea.ScrollDirection scrollDirection = null;
    private int mouseX = -1;
    private BlinkCaretCallback blinkCaretCallback = new BlinkCaretCallback();
    private ApplicationContext.ScheduledCallback scheduledBlinkCaretCallback = null;
    private ScrollSelectionCallback scrollSelectionCallback = new ScrollSelectionCallback();
    private ApplicationContext.ScheduledCallback scheduledScrollSelectionCallback = null;
    private Font font;
    private Color color;
    private Color backgroundColor;
    private Color inactiveColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Insets margin;
    private boolean wrapText;
    private int tabWidth;
    private int lineWidth;
    private boolean acceptsEnter = true;
    private boolean acceptsTab = false;
    private Dimensions averageCharacterSize;
    private ArrayList<TextAreaSkinParagraphView> paragraphViews = new ArrayList();
    private static final int SCROLL_RATE = 30;

    public TextAreaSkin() {
        Theme theme = Theme.getTheme();
        this.font = theme.getFont();
        this.color = Color.BLACK;
        this.backgroundColor = null;
        this.inactiveColor = Color.GRAY;
        this.selectionColor = Color.LIGHT_GRAY;
        this.selectionBackgroundColor = Color.BLACK;
        this.inactiveSelectionColor = Color.LIGHT_GRAY;
        this.inactiveSelectionBackgroundColor = Color.BLACK;
        this.margin = new Insets(4);
        this.wrapText = true;
        this.tabWidth = 4;
    }

    @Override
    public void install(Component component) {
        super.install(component);
        TextArea textArea = (TextArea)component;
        textArea.getTextAreaListeners().add((Object)this);
        textArea.getTextAreaContentListeners().add((Object)this);
        textArea.getTextAreaSelectionListeners().add((Object)this);
        textArea.setCursor(Cursor.TEXT);
    }

    @Override
    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        if (this.lineWidth <= 0) {
            for (TextAreaSkinParagraphView paragraphView : this.paragraphViews) {
                paragraphView.setBreakWidth(Integer.MAX_VALUE);
                preferredWidth = Math.max(preferredWidth, paragraphView.getWidth());
            }
        } else {
            preferredWidth = this.averageCharacterSize.width * this.lineWidth;
        }
        return preferredWidth += this.margin.left + this.margin.right;
    }

    @Override
    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        int breakWidth = this.wrapText && width != -1 ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
        for (TextAreaSkinParagraphView paragraphView : this.paragraphViews) {
            paragraphView.setBreakWidth(breakWidth);
            preferredHeight += paragraphView.getHeight();
        }
        return preferredHeight += this.margin.top + this.margin.bottom;
    }

    @Override
    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        for (TextAreaSkinParagraphView paragraphView : this.paragraphViews) {
            paragraphView.setBreakWidth(Integer.MAX_VALUE);
            preferredWidth = Math.max(preferredWidth, paragraphView.getWidth());
            preferredHeight += paragraphView.getHeight();
        }
        return new Dimensions(preferredWidth += this.margin.left + this.margin.right, preferredHeight += this.margin.top + this.margin.bottom);
    }

    @Override
    public void layout() {
        TextArea textArea = (TextArea)this.getComponent();
        int width = this.getWidth();
        int breakWidth = this.wrapText ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
        int y = this.margin.top;
        int lastY = 0;
        int lastHeight = 0;
        int rowOffset = 0;
        int index = 0;
        for (TextAreaSkinParagraphView paragraphView : this.paragraphViews) {
            paragraphView.setBreakWidth(breakWidth);
            paragraphView.setX(this.margin.left);
            paragraphView.setY(y);
            lastY = y;
            y += paragraphView.getHeight();
            lastHeight = paragraphView.getHeight();
            paragraphView.setRowOffset(rowOffset);
            rowOffset += paragraphView.getRowCount();
            ++index;
        }
        this.updateSelection();
        this.caretX = this.caret.x;
        if (textArea.isFocused()) {
            this.scrollCharacterToVisible(textArea.getSelectionStart());
            this.showCaret(textArea.getSelectionLength() == 0);
        } else {
            this.showCaret(false);
        }
    }

    @Override
    public int getBaseline(int width, int height) {
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        LineMetrics lm = this.font.getLineMetrics("", fontRenderContext);
        return Math.round((float)this.margin.top + lm.getAscent());
    }

    @Override
    public void paint(Graphics2D graphics) {
        TextArea textArea = (TextArea)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        if (this.selection == null) {
            if (this.caretOn && textArea.isFocused()) {
                graphics.setColor(textArea.isEditable() ? this.color : this.inactiveColor);
                graphics.fill(this.caret);
            }
        } else {
            graphics.setColor(textArea.isFocused() && textArea.isEditable() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor);
            graphics.fill(this.selection);
        }
        graphics.setFont(this.font);
        graphics.translate(0, this.margin.top);
        int breakWidth = this.wrapText ? Math.max(width - (this.margin.left + this.margin.right), 0) : Integer.MAX_VALUE;
        int n = this.paragraphViews.getLength();
        for (int i = 0; i < n; ++i) {
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(i);
            paragraphView.setBreakWidth(breakWidth);
            paragraphView.validate();
            int x = paragraphView.getX();
            graphics.translate(x, 0);
            paragraphView.paint(graphics);
            graphics.translate(-x, 0);
            graphics.translate(0, paragraphView.getHeight());
        }
    }

    @Override
    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    @Override
    public int getInsertionPoint(int x, int y) {
        int index = -1;
        if (this.paragraphViews.getLength() > 0) {
            TextAreaSkinParagraphView lastParagraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(this.paragraphViews.getLength() - 1);
            if (y > lastParagraphView.getY() + lastParagraphView.getHeight()) {
                TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(this.paragraphViews.getLength() - 1);
                index = paragraphView.getNextInsertionPoint(x, -1, TextArea.ScrollDirection.UP) + paragraphView.getParagraph().getOffset();
            } else if (y < this.margin.top) {
                TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(0);
                index = paragraphView.getNextInsertionPoint(x, -1, TextArea.ScrollDirection.DOWN);
            } else {
                int n = this.paragraphViews.getLength();
                for (int i = 0; i < n; ++i) {
                    TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(i);
                    int paragraphViewY = paragraphView.getY();
                    if (y < paragraphViewY || y >= paragraphViewY + paragraphView.getHeight()) continue;
                    index = paragraphView.getInsertionPoint(x - paragraphView.getX(), y - paragraphViewY) + paragraphView.getParagraph().getOffset();
                    break;
                }
            }
        }
        return index;
    }

    @Override
    public int getNextInsertionPoint(int x, int from, TextArea.ScrollDirection direction) {
        int index = -1;
        if (this.paragraphViews.getLength() > 0) {
            if (from == -1) {
                int i = direction == TextArea.ScrollDirection.DOWN ? 0 : this.paragraphViews.getLength() - 1;
                TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(i);
                index = paragraphView.getNextInsertionPoint(x - paragraphView.getX(), -1, direction);
                if (index != -1) {
                    index += paragraphView.getParagraph().getOffset();
                }
            } else {
                TextArea textArea = (TextArea)this.getComponent();
                int i = textArea.getParagraphAt(from);
                TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(i);
                index = paragraphView.getNextInsertionPoint(x - paragraphView.getX(), from - paragraphView.getParagraph().getOffset(), direction);
                if (index == -1) {
                    if (direction == TextArea.ScrollDirection.DOWN) {
                        paragraphView = i < this.paragraphViews.getLength() - 1 ? (TextAreaSkinParagraphView)this.paragraphViews.get(i + 1) : null;
                    } else {
                        TextAreaSkinParagraphView textAreaSkinParagraphView = paragraphView = i > 0 ? (TextAreaSkinParagraphView)this.paragraphViews.get(i - 1) : null;
                    }
                    if (paragraphView != null) {
                        index = paragraphView.getNextInsertionPoint(x - paragraphView.getX(), -1, direction);
                    }
                }
                if (index != -1) {
                    index += paragraphView != null ? paragraphView.getParagraph().getOffset() : 0;
                }
            }
        }
        return index;
    }

    @Override
    public int getRowAt(int index) {
        int rowIndex = -1;
        if (this.paragraphViews.getLength() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(textArea.getParagraphAt(index));
            rowIndex = paragraphView.getRowAt(index - paragraphView.getParagraph().getOffset()) + paragraphView.getRowOffset();
        }
        return rowIndex;
    }

    @Override
    public int getRowOffset(int index) {
        int rowOffset = -1;
        if (this.paragraphViews.getLength() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(textArea.getParagraphAt(index));
            rowOffset = paragraphView.getRowOffset(index - paragraphView.getParagraph().getOffset()) + paragraphView.getParagraph().getOffset();
        }
        return rowOffset;
    }

    @Override
    public int getRowLength(int index) {
        int rowLength = -1;
        if (this.paragraphViews.getLength() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(textArea.getParagraphAt(index));
            rowLength = paragraphView.getRowLength(index - paragraphView.getParagraph().getOffset());
        }
        return rowLength;
    }

    @Override
    public int getRowCount() {
        int rowCount = 0;
        for (TextAreaSkinParagraphView paragraphView : this.paragraphViews) {
            rowCount += paragraphView.getRowCount();
        }
        return rowCount;
    }

    @Override
    public Bounds getCharacterBounds(int index) {
        Bounds characterBounds = null;
        if (this.paragraphViews.getLength() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(textArea.getParagraphAt(index));
            characterBounds = paragraphView.getCharacterBounds(index - paragraphView.getParagraph().getOffset());
            characterBounds = new Bounds(characterBounds.x + paragraphView.getX(), characterBounds.y + paragraphView.getY(), characterBounds.width, characterBounds.height);
        }
        return characterBounds;
    }

    public Area getSelection() {
        return this.selection;
    }

    private void scrollCharacterToVisible(int index) {
        Bounds characterBounds = this.getCharacterBounds(index);
        if (characterBounds != null) {
            TextArea textArea = (TextArea)this.getComponent();
            textArea.scrollAreaToVisible(characterBounds.x, characterBounds.y, characterBounds.width, characterBounds.height);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        int missingGlyphCode = font.getMissingGlyphCode();
        FontRenderContext fontRenderContext = Platform.getFontRenderContext();
        GlyphVector missingGlyphVector = font.createGlyphVector(fontRenderContext, new int[]{missingGlyphCode});
        Rectangle2D textBounds = missingGlyphVector.getLogicalBounds();
        Rectangle2D maxCharBounds = font.getMaxCharBounds(fontRenderContext);
        this.averageCharacterSize = new Dimensions((int)Math.ceil(textBounds.getWidth()), (int)Math.ceil(maxCharBounds.getHeight()));
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TextAreaSkin.decodeFont(font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(color));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor(backgroundColor));
    }

    public Color getInactiveColor() {
        return this.inactiveColor;
    }

    public void setInactiveColor(Color inactiveColor) {
        if (inactiveColor == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.inactiveColor = inactiveColor;
        this.repaintComponent();
    }

    public final void setInactiveColor(String inactiveColor) {
        if (inactiveColor == null) {
            throw new IllegalArgumentException("inactiveColor is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor(inactiveColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor(selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor(selectionBackgroundColor));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor(inactiveSelectionColor));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor(inactiveSelectionBackgroundColor));
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.margin = margin;
        this.invalidateComponent();
    }

    public final void setMargin(Dictionary<String, ?> margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(new Insets(margin));
    }

    public final void setMargin(int margin) {
        this.setMargin(new Insets(margin));
    }

    public final void setMargin(Number margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(margin.intValue());
    }

    public final void setMargin(String margin) {
        if (margin == null) {
            throw new IllegalArgumentException("margin is null.");
        }
        this.setMargin(Insets.decode(margin));
    }

    public boolean getWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
        this.invalidateComponent();
    }

    public boolean getAcceptsEnter() {
        return this.acceptsEnter;
    }

    public void setAcceptsEnter(boolean acceptsEnter) {
        this.acceptsEnter = acceptsEnter;
    }

    public boolean getAcceptsTab() {
        return this.acceptsTab;
    }

    public void setAcceptsTab(boolean acceptsTab) {
        this.acceptsTab = acceptsTab;
    }

    @Override
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        if (tabWidth < 0) {
            throw new IllegalArgumentException("tabWidth is negative.");
        }
        this.tabWidth = tabWidth;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        if (this.lineWidth != lineWidth) {
            this.lineWidth = lineWidth;
            int missingGlyphCode = this.font.getMissingGlyphCode();
            FontRenderContext fontRenderContext = Platform.getFontRenderContext();
            GlyphVector missingGlyphVector = this.font.createGlyphVector(fontRenderContext, new int[]{missingGlyphCode});
            Rectangle2D textBounds = missingGlyphVector.getLogicalBounds();
            Rectangle2D maxCharBounds = this.font.getMaxCharBounds(fontRenderContext);
            this.averageCharacterSize = new Dimensions((int)Math.ceil(textBounds.getWidth()), (int)Math.ceil(maxCharBounds.getHeight()));
            this.invalidateComponent();
        }
    }

    @Override
    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        if (Mouse.getCapturer() == component) {
            TextArea textArea = (TextArea)this.getComponent();
            Bounds visibleArea = textArea.getVisibleArea();
            visibleArea = new Bounds(visibleArea.x, visibleArea.y, visibleArea.width, visibleArea.height);
            if (y >= visibleArea.y && y < visibleArea.y + visibleArea.height) {
                if (this.scheduledScrollSelectionCallback != null) {
                    this.scheduledScrollSelectionCallback.cancel();
                    this.scheduledScrollSelectionCallback = null;
                }
                this.scrollDirection = null;
            } else if (this.scheduledScrollSelectionCallback == null) {
                this.scrollDirection = y < visibleArea.y ? TextArea.ScrollDirection.UP : TextArea.ScrollDirection.DOWN;
                this.scheduledScrollSelectionCallback = ApplicationContext.scheduleRecurringCallback(this.scrollSelectionCallback, 30L);
                this.scrollSelectionCallback.run();
            }
            int index = this.getInsertionPoint(x, y);
            if (index != -1) {
                if (index > this.anchor) {
                    textArea.setSelection(this.anchor, index - this.anchor);
                } else {
                    textArea.setSelection(index, this.anchor - index);
                }
            }
            this.mouseX = x;
        } else if (Mouse.isPressed(Mouse.Button.LEFT) && Mouse.getCapturer() == null && this.anchor != -1) {
            Mouse.capture(component);
        }
        return consumed;
    }

    @Override
    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        TextArea textArea = (TextArea)component;
        if (button == Mouse.Button.LEFT) {
            this.anchor = this.getInsertionPoint(x, y);
            if (this.anchor != -1) {
                if (Keyboard.isPressed(Keyboard.Modifier.SHIFT)) {
                    int selectionStart = textArea.getSelectionStart();
                    if (this.anchor > selectionStart) {
                        textArea.setSelection(selectionStart, this.anchor - selectionStart);
                    } else {
                        textArea.setSelection(this.anchor, selectionStart - this.anchor);
                    }
                } else {
                    textArea.setSelection(this.anchor, 0);
                    consumed = true;
                }
            }
            this.caretX = this.caret.x;
            textArea.requestFocus();
        }
        return consumed;
    }

    @Override
    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        if (Mouse.getCapturer() == component) {
            if (this.scheduledScrollSelectionCallback != null) {
                this.scheduledScrollSelectionCallback.cancel();
                this.scheduledScrollSelectionCallback = null;
            }
            Mouse.release();
        }
        this.scrollDirection = null;
        this.mouseX = -1;
        return consumed;
    }

    private void selectSpan(TextArea textArea, int start) {
        char ch;
        int rowLength;
        int rowStart = textArea.getRowOffset(start);
        if (start - rowStart >= (rowLength = textArea.getRowLength(start)) && ((ch = textArea.getCharacterAt(start = rowStart + rowLength - 1)) == '\r' || ch == '\n')) {
            --start;
        }
        ch = textArea.getCharacterAt(start);
        int selectionStart = start;
        int selectionLength = 1;
        if (Character.isWhitespace(ch)) {
            while (--selectionStart >= rowStart && Character.isWhitespace(textArea.getCharacterAt(selectionStart))) {
            }
            selectionLength = start - ++selectionStart;
            while (selectionStart + ++selectionLength - rowStart < rowLength && Character.isWhitespace(textArea.getCharacterAt(selectionStart + selectionLength))) {
            }
        } else if (Character.isJavaIdentifierPart(ch)) {
            while (--selectionStart >= rowStart && Character.isJavaIdentifierPart(textArea.getCharacterAt(selectionStart))) {
            }
            selectionLength = start - ++selectionStart;
            while (selectionStart + ++selectionLength - rowStart < rowLength && Character.isJavaIdentifierPart(textArea.getCharacterAt(selectionStart + selectionLength))) {
            }
        } else {
            return;
        }
        textArea.setSelection(selectionStart, selectionLength);
    }

    @Override
    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        int index;
        boolean consumed = super.mouseClick(component, button, x, y, count);
        TextArea textArea = (TextArea)component;
        if (button == Mouse.Button.LEFT && (index = this.getInsertionPoint(x, y)) != -1) {
            if (count == 2) {
                this.selectSpan(textArea, index);
            } else if (count == 3) {
                textArea.setSelection(textArea.getRowOffset(index), textArea.getRowLength(index));
            }
        }
        return consumed;
    }

    @Override
    public boolean keyTyped(Component component, char character) {
        TextArea textArea;
        boolean consumed = super.keyTyped(component, character);
        if (this.paragraphViews.getLength() > 0 && (textArea = (TextArea)this.getComponent()).isEditable() && character > '\u001f' && character != '\u007f' && !Keyboard.isPressed(Keyboard.Modifier.META)) {
            int selectionLength = textArea.getSelectionLength();
            if (textArea.getCharacterCount() - selectionLength + 1 > textArea.getMaximumLength()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                int selectionStart = textArea.getSelectionStart();
                textArea.removeText(selectionStart, selectionLength);
                textArea.insertText(Character.toString(character), selectionStart);
            }
            this.showCaret(true);
        }
        return consumed;
    }

    @Override
    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        if (this.paragraphViews.getLength() > 0) {
            TextArea textArea = (TextArea)this.getComponent();
            boolean commandPressed = Keyboard.isPressed(Platform.getCommandModifier());
            boolean wordNavPressed = Keyboard.isPressed(Platform.getWordNavigationModifier());
            boolean shiftPressed = Keyboard.isPressed(Keyboard.Modifier.SHIFT);
            boolean ctrlPressed = Keyboard.isPressed(Keyboard.Modifier.CTRL);
            boolean metaPressed = Keyboard.isPressed(Keyboard.Modifier.META);
            boolean isEditable = textArea.isEditable();
            if (keyCode == 10 && this.acceptsEnter && isEditable && Keyboard.getModifiers() == 0) {
                int index = textArea.getSelectionStart();
                textArea.removeText(index, textArea.getSelectionLength());
                textArea.insertText("\n", index);
                consumed = true;
            } else if (keyCode == 127 && isEditable) {
                int index = textArea.getSelectionStart();
                if (index < textArea.getCharacterCount()) {
                    int count = Math.max(textArea.getSelectionLength(), 1);
                    textArea.removeText(index, count);
                    consumed = true;
                }
            } else if (keyCode == 8 && isEditable) {
                int index = textArea.getSelectionStart();
                int count = textArea.getSelectionLength();
                if (count == 0 && index > 0) {
                    textArea.removeText(index - 1, 1);
                    consumed = true;
                } else {
                    textArea.removeText(index, count);
                    consumed = true;
                }
            } else if (keyCode == 9 && this.acceptsTab != ctrlPressed && isEditable) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                int rowOffset = textArea.getRowOffset(selectionStart);
                int linePos = selectionStart - rowOffset;
                StringBuilder tabBuilder = new StringBuilder(this.tabWidth);
                for (int i = 0; i < this.tabWidth - linePos % this.tabWidth; ++i) {
                    tabBuilder.append(" ");
                }
                if (textArea.getCharacterCount() - selectionLength + this.tabWidth > textArea.getMaximumLength()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    textArea.removeText(selectionStart, selectionLength);
                    textArea.insertText(tabBuilder, selectionStart);
                }
                this.showCaret(true);
                consumed = true;
            } else if (keyCode == 36 || keyCode == 37 && metaPressed) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                int start = ctrlPressed ? 0 : this.getRowOffset(selectionStart);
                selectionLength = shiftPressed ? (selectionLength += selectionStart - start) : 0;
                if (selectionStart >= 0) {
                    textArea.setSelection(start, selectionLength);
                    this.scrollCharacterToVisible(start);
                    this.caretX = this.caret.x;
                    consumed = true;
                }
            } else if (keyCode == 35 || keyCode == 39 && metaPressed) {
                int end;
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                int index = selectionStart + selectionLength;
                if (ctrlPressed) {
                    end = textArea.getCharacterCount();
                } else {
                    int rowOffset = this.getRowOffset(index);
                    int rowLength = this.getRowLength(index);
                    end = rowOffset + rowLength;
                }
                if (shiftPressed) {
                    selectionLength += end - index;
                } else {
                    selectionStart = end;
                    if (selectionStart < textArea.getCharacterCount() && textArea.getCharacterAt(selectionStart) != '\n') {
                        --selectionStart;
                    }
                    selectionLength = 0;
                }
                if (selectionStart + selectionLength <= textArea.getCharacterCount()) {
                    textArea.setSelection(selectionStart, selectionLength);
                    this.scrollCharacterToVisible(selectionStart + selectionLength);
                    this.caretX = this.caret.x;
                    if (this.selection != null) {
                        this.caretX = (int)((double)this.caretX + this.selection.getBounds2D().getWidth());
                    }
                    consumed = true;
                }
            } else if (keyCode == 37) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                if (wordNavPressed) {
                    if (selectionStart > 0) {
                        int index;
                        for (index = selectionStart; index > 0 && Character.isWhitespace(textArea.getCharacterAt(index - 1)); --index) {
                        }
                        while (index > 0 && !Character.isWhitespace(textArea.getCharacterAt(index - 1))) {
                            --index;
                        }
                        selectionLength = shiftPressed ? (selectionLength += selectionStart - index) : 0;
                        selectionStart = index;
                    }
                } else if (shiftPressed) {
                    if (this.anchor != -1) {
                        if (selectionStart < this.anchor) {
                            if (selectionStart > 0) {
                                --selectionStart;
                                ++selectionLength;
                            }
                        } else if (selectionLength > 0) {
                            --selectionLength;
                        } else {
                            --selectionStart;
                            ++selectionLength;
                        }
                    } else {
                        this.anchor = selectionStart;
                        if (selectionStart > 0) {
                            --selectionStart;
                            ++selectionLength;
                        }
                    }
                } else {
                    if (selectionLength == 0 && selectionStart > 0) {
                        --selectionStart;
                    }
                    this.anchor = -1;
                    selectionLength = 0;
                }
                if (selectionStart >= 0) {
                    textArea.setSelection(selectionStart, selectionLength);
                    this.scrollCharacterToVisible(selectionStart);
                    this.caretX = this.caret.x;
                    consumed = true;
                }
            } else if (keyCode == 39) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                if (wordNavPressed) {
                    if (selectionStart < textArea.getCharacterCount()) {
                        int index;
                        for (index = selectionStart + selectionLength; index < textArea.getCharacterCount() && Character.isWhitespace(textArea.getCharacterAt(index)); ++index) {
                        }
                        while (index < textArea.getCharacterCount() && !Character.isWhitespace(textArea.getCharacterAt(index))) {
                            ++index;
                        }
                        if (shiftPressed) {
                            selectionLength = index - selectionStart;
                        } else {
                            selectionStart = index;
                            selectionLength = 0;
                        }
                    }
                } else if (shiftPressed) {
                    if (this.anchor != -1) {
                        if (selectionStart < this.anchor) {
                            ++selectionStart;
                            --selectionLength;
                        } else {
                            ++selectionLength;
                        }
                    } else {
                        this.anchor = selectionStart;
                        ++selectionLength;
                    }
                } else {
                    selectionStart = selectionLength == 0 ? ++selectionStart : (selectionStart += selectionLength);
                    this.anchor = -1;
                    selectionLength = 0;
                }
                if (selectionStart + selectionLength <= textArea.getCharacterCount()) {
                    textArea.setSelection(selectionStart, selectionLength);
                    this.scrollCharacterToVisible(selectionStart + selectionLength);
                    this.caretX = this.caret.x;
                    if (this.selection != null) {
                        this.caretX = (int)((double)this.caretX + this.selection.getBounds2D().getWidth());
                    }
                    consumed = true;
                }
            } else if (keyCode == 38) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                int index = -1;
                if (shiftPressed) {
                    if (this.anchor == -1) {
                        this.anchor = selectionStart;
                        index = this.getNextInsertionPoint(this.caretX, selectionStart, TextArea.ScrollDirection.UP);
                        if (index != -1) {
                            selectionLength = selectionStart - index;
                        }
                    } else if (selectionStart < this.anchor) {
                        index = this.getNextInsertionPoint(this.caretX, selectionStart, TextArea.ScrollDirection.UP);
                        if (index != -1) {
                            selectionLength = selectionStart + selectionLength - index;
                        }
                    } else {
                        Bounds trailingSelectionBounds = this.getCharacterBounds(selectionStart + selectionLength - 1);
                        int x = trailingSelectionBounds.x + trailingSelectionBounds.width;
                        index = this.getNextInsertionPoint(x, selectionStart + selectionLength - 1, TextArea.ScrollDirection.UP);
                        if (index != -1) {
                            if (index < this.anchor) {
                                selectionLength = this.anchor - index;
                            } else {
                                selectionLength = index - selectionStart;
                                index = selectionStart;
                            }
                        }
                    }
                } else {
                    index = this.getNextInsertionPoint(this.caretX, selectionStart, TextArea.ScrollDirection.UP);
                    if (index != -1) {
                        selectionLength = 0;
                    }
                    this.anchor = -1;
                }
                if (index != -1) {
                    textArea.setSelection(index, selectionLength);
                    this.scrollCharacterToVisible(index);
                    this.caretX = this.caret.x;
                }
                consumed = true;
            } else if (keyCode == 40) {
                int selectionStart = textArea.getSelectionStart();
                int selectionLength = textArea.getSelectionLength();
                if (shiftPressed) {
                    if (this.anchor == -1) {
                        this.anchor = selectionStart;
                        int index = this.getNextInsertionPoint(this.caretX, selectionStart, TextArea.ScrollDirection.DOWN);
                        if (index != -1) {
                            selectionLength = index - selectionStart;
                        }
                    } else if (selectionStart < this.anchor) {
                        int x = this.caretX;
                        int from = selectionStart;
                        int index = this.getNextInsertionPoint(x, from, TextArea.ScrollDirection.DOWN);
                        if (index != -1) {
                            if (index < this.anchor) {
                                selectionStart = index;
                                selectionLength = this.anchor - index;
                            } else {
                                selectionStart = this.anchor;
                                selectionLength = index - this.anchor;
                            }
                            textArea.setSelection(selectionStart, selectionLength);
                            this.scrollCharacterToVisible(selectionStart);
                        }
                    } else {
                        int from = selectionStart + selectionLength - 1;
                        Bounds trailingSelectionBounds = this.getCharacterBounds(from);
                        int x = trailingSelectionBounds.x + trailingSelectionBounds.width;
                        int index = this.getNextInsertionPoint(x, from, TextArea.ScrollDirection.DOWN);
                        if (index != -1) {
                            if (index < textArea.getCharacterCount() - 1 && textArea.getCharacterAt(index) == '\n') {
                                ++index;
                            }
                            textArea.setSelection(selectionStart, index - selectionStart);
                            this.scrollCharacterToVisible(index);
                        }
                    }
                } else {
                    int from = selectionLength == 0 ? selectionStart : selectionStart + selectionLength - 1;
                    int index = this.getNextInsertionPoint(this.caretX, from, TextArea.ScrollDirection.DOWN);
                    if (index != -1) {
                        textArea.setSelection(index, 0);
                        this.scrollCharacterToVisible(index);
                        this.caretX = this.caret.x;
                    }
                    this.anchor = -1;
                }
                consumed = true;
            } else if (commandPressed) {
                if (keyCode == 65) {
                    textArea.setSelection(0, textArea.getCharacterCount());
                    consumed = true;
                } else if (keyCode == 88 && isEditable) {
                    textArea.cut();
                    consumed = true;
                } else if (keyCode == 67) {
                    textArea.copy();
                    consumed = true;
                } else if (keyCode == 86 && isEditable) {
                    textArea.paste();
                    consumed = true;
                } else if (keyCode == 90 && isEditable) {
                    if (!shiftPressed) {
                        textArea.undo();
                    }
                    consumed = true;
                } else if (keyCode == 9) {
                    consumed = super.keyPressed(component, keyCode, keyLocation);
                }
            } else if (keyCode == 155) {
                if (shiftPressed && isEditable) {
                    textArea.paste();
                    consumed = true;
                }
            } else {
                consumed = super.keyPressed(component, keyCode, keyLocation);
            }
        }
        return consumed;
    }

    @Override
    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    @Override
    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        TextArea textArea = (TextArea)this.getComponent();
        if (textArea.isFocused() && textArea.getSelectionLength() == 0) {
            if (textArea.isValid()) {
                this.scrollCharacterToVisible(textArea.getSelectionStart());
            }
            this.showCaret(true);
        } else {
            this.showCaret(false);
        }
        this.repaintComponent();
    }

    @Override
    public void maximumLengthChanged(TextArea textArea, int previousMaximumLength) {
    }

    @Override
    public void editableChanged(TextArea textArea) {
    }

    @Override
    public void paragraphInserted(TextArea textArea, int index) {
        TextArea.Paragraph paragraph = textArea.getParagraphs().get(index);
        TextAreaSkinParagraphView paragraphView = new TextAreaSkinParagraphView(this, paragraph);
        paragraph.getParagraphListeners().add((Object)paragraphView);
        this.paragraphViews.insert((Object)paragraphView, index);
        this.invalidateComponent();
    }

    @Override
    public void paragraphsRemoved(TextArea textArea, int index, Sequence<TextArea.Paragraph> removed) {
        int count = removed.getLength();
        for (int i = 0; i < count; ++i) {
            TextArea.Paragraph paragraph = (TextArea.Paragraph)removed.get(i);
            TextAreaSkinParagraphView paragraphView = (TextAreaSkinParagraphView)this.paragraphViews.get(i + index);
            paragraph.getParagraphListeners().remove((Object)paragraphView);
        }
        this.paragraphViews.remove(index, count);
        this.invalidateComponent();
    }

    @Override
    public void textChanged(TextArea textArea) {
    }

    @Override
    public void selectionChanged(TextArea textArea, int previousSelectionStart, int previousSelectionLength) {
        if (textArea.isValid()) {
            Rectangle bounds;
            if (this.selection == null) {
                textArea.repaint(this.caret.x, this.caret.y, this.caret.width, this.caret.height);
            } else {
                bounds = this.selection.getBounds();
                textArea.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
            this.updateSelection();
            if (this.selection == null) {
                this.showCaret(textArea.isFocused());
            } else {
                this.showCaret(false);
                bounds = this.selection.getBounds();
                textArea.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
            }
        }
    }

    private void updateSelection() {
        TextArea textArea = (TextArea)this.getComponent();
        if (this.paragraphViews.getLength() > 0) {
            int selectionStart = textArea.getSelectionStart();
            Bounds leadingSelectionBounds = this.getCharacterBounds(selectionStart);
            this.caret = leadingSelectionBounds.toRectangle();
            this.caret.width = 1;
            int selectionLength = textArea.getSelectionLength();
            if (selectionLength > 0) {
                int lastRowIndex;
                int selectionEnd = selectionStart + selectionLength - 1;
                Bounds trailingSelectionBounds = this.getCharacterBounds(selectionEnd);
                this.selection = new Area();
                int firstRowIndex = this.getRowAt(selectionStart);
                if (firstRowIndex == (lastRowIndex = this.getRowAt(selectionEnd))) {
                    this.selection.add(new Area(new Rectangle(leadingSelectionBounds.x, leadingSelectionBounds.y, trailingSelectionBounds.x + trailingSelectionBounds.width - leadingSelectionBounds.x, trailingSelectionBounds.y + trailingSelectionBounds.height - leadingSelectionBounds.y)));
                } else {
                    int width = this.getWidth();
                    this.selection.add(new Area(new Rectangle(leadingSelectionBounds.x, leadingSelectionBounds.y, width - this.margin.right - leadingSelectionBounds.x, leadingSelectionBounds.height)));
                    if (lastRowIndex - firstRowIndex > 0) {
                        this.selection.add(new Area(new Rectangle(this.margin.left, leadingSelectionBounds.y + leadingSelectionBounds.height, width - (this.margin.left + this.margin.right), trailingSelectionBounds.y - (leadingSelectionBounds.y + leadingSelectionBounds.height))));
                    }
                    this.selection.add(new Area(new Rectangle(this.margin.left, trailingSelectionBounds.y, trailingSelectionBounds.x + trailingSelectionBounds.width - this.margin.left, trailingSelectionBounds.height)));
                }
            } else {
                this.selection = null;
            }
        } else {
            this.caret = new Rectangle();
            this.selection = null;
        }
    }

    private void showCaret(boolean show) {
        if (this.scheduledBlinkCaretCallback != null) {
            this.scheduledBlinkCaretCallback.cancel();
        }
        if (show) {
            this.caretOn = true;
            this.scheduledBlinkCaretCallback = ApplicationContext.scheduleRecurringCallback(this.blinkCaretCallback, Platform.getCursorBlinkRate());
            this.blinkCaretCallback.run();
        } else {
            this.scheduledBlinkCaretCallback = null;
        }
    }

    private class ScrollSelectionCallback
    implements Runnable {
        private ScrollSelectionCallback() {
        }

        @Override
        public void run() {
            TextArea textArea = (TextArea)TextAreaSkin.this.getComponent();
            int selectionStart = textArea.getSelectionStart();
            int selectionLength = textArea.getSelectionLength();
            int selectionEnd = selectionStart + selectionLength - 1;
            switch (TextAreaSkin.this.scrollDirection) {
                case UP: {
                    int index = TextAreaSkin.this.getNextInsertionPoint(TextAreaSkin.this.mouseX, selectionStart, TextAreaSkin.this.scrollDirection);
                    if (index == -1) break;
                    textArea.setSelection(index, selectionEnd - index + 1);
                    TextAreaSkin.this.scrollCharacterToVisible(index + 1);
                    break;
                }
                case DOWN: {
                    int index = TextAreaSkin.this.getNextInsertionPoint(TextAreaSkin.this.mouseX, selectionEnd, TextAreaSkin.this.scrollDirection);
                    if (index == -1) break;
                    if (index < textArea.getCharacterCount() && textArea.getCharacterAt(index) == '\n') {
                        ++index;
                    }
                    textArea.setSelection(selectionStart, index - selectionStart);
                    TextAreaSkin.this.scrollCharacterToVisible(index - 1);
                    break;
                }
            }
        }
    }

    private class BlinkCaretCallback
    implements Runnable {
        private BlinkCaretCallback() {
        }

        @Override
        public void run() {
            TextAreaSkin.this.caretOn = !TextAreaSkin.this.caretOn;
            if (TextAreaSkin.this.selection == null) {
                TextArea textArea = (TextArea)TextAreaSkin.this.getComponent();
                textArea.repaint(((TextAreaSkin)TextAreaSkin.this).caret.x, ((TextAreaSkin)TextAreaSkin.this).caret.y, ((TextAreaSkin)TextAreaSkin.this).caret.width, ((TextAreaSkin)TextAreaSkin.this).caret.height);
            }
        }
    }
}

