/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.BulletedListListener;
import org.apache.pivot.wtk.text.List;

public class BulletedList
extends List {
    private Style style = Style.CIRCLE;
    private BulletedListListenerList bulletedListListeners = new BulletedListListenerList();

    public BulletedList() {
    }

    public BulletedList(BulletedList bulletedList, boolean recursive) {
        super(bulletedList, recursive);
        this.style = bulletedList.style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style is null.");
        }
        Style previousStyle = this.style;
        if (previousStyle != style) {
            this.style = style;
            this.bulletedListListeners.styleChanged(this, previousStyle);
        }
    }

    @Override
    public BulletedList duplicate(boolean recursive) {
        return new BulletedList(this, recursive);
    }

    public ListenerList<BulletedListListener> getBulletedListListeners() {
        return this.bulletedListListeners;
    }

    private static class BulletedListListenerList
    extends ListenerList<BulletedListListener>
    implements BulletedListListener {
        private BulletedListListenerList() {
        }

        @Override
        public void styleChanged(BulletedList bulletedList, Style previousStyle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                BulletedListListener listener = (BulletedListListener)i$.next();
                listener.styleChanged(bulletedList, previousStyle);
            }
        }
    }

    public static enum Style {
        CIRCLE,
        CIRCLE_OUTLINE;

    }
}

