/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.text.List;
import org.apache.pivot.wtk.text.NumberedListListener;

public class NumberedList
extends List {
    private Style style = Style.DECIMAL;
    private NumberedListListenerList numberedListListeners = new NumberedListListenerList();

    public NumberedList() {
    }

    public NumberedList(NumberedList numberedList, boolean recursive) {
        super(numberedList, recursive);
        this.style = numberedList.style;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("style is null.");
        }
        Style previousStyle = this.style;
        if (previousStyle != style) {
            this.style = style;
            this.numberedListListeners.styleChanged(this, previousStyle);
        }
    }

    @Override
    public NumberedList duplicate(boolean recursive) {
        return new NumberedList(this, recursive);
    }

    public ListenerList<NumberedListListener> getNumberedListListeners() {
        return this.numberedListListeners;
    }

    private static class NumberedListListenerList
    extends ListenerList<NumberedListListener>
    implements NumberedListListener {
        private NumberedListListenerList() {
        }

        @Override
        public void styleChanged(NumberedList numberedList, Style previousStyle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                NumberedListListener listener = (NumberedListListener)i$.next();
                listener.styleChanged(numberedList, previousStyle);
            }
        }
    }

    public static enum Style {
        DECIMAL,
        LOWER_ALPHA,
        UPPER_ALPHA,
        LOWER_ROMAN,
        UPPER_ROMAN;

    }
}

