/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.text;

import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.text.Block;
import org.apache.pivot.wtk.text.Node;
import org.apache.pivot.wtk.text.TextNode;

public class Paragraph
extends Block {
    public Paragraph() {
    }

    public Paragraph(String text) {
        this.add(new TextNode(text));
    }

    public Paragraph(Paragraph paragraph, boolean recursive) {
        super(paragraph, recursive);
    }

    @Override
    public Node removeRange(int offset, int characterCount) {
        if (offset + characterCount == this.getCharacterCount()) {
            return super.removeRange(offset, characterCount - 1);
        }
        return super.removeRange(offset, characterCount);
    }

    @Override
    public Paragraph getRange(int offset, int characterCount) {
        if (offset + characterCount == this.getCharacterCount()) {
            return (Paragraph)super.getRange(offset, characterCount - 1);
        }
        return (Paragraph)super.getRange(offset, characterCount);
    }

    @Override
    public char getCharacterAt(int offset) {
        char c = offset == this.getCharacterCount() - 1 ? (char)'\n' : (char)super.getCharacterAt(offset);
        return c;
    }

    @Override
    public int getCharacterCount() {
        return super.getCharacterCount() + 1;
    }

    public int add(String text) {
        return this.add(new TextNode(text));
    }

    @Override
    public void insert(Node node, int index) {
        if (node instanceof Block) {
            throw new IllegalArgumentException("Child node must not be an instance of " + Block.class.getName());
        }
        super.insert(node, index);
    }

    @Override
    public Sequence<Integer> getPathAt(int offset) {
        ArrayList path = offset < super.getCharacterCount() ? super.getPathAt(offset) : new ArrayList();
        return path;
    }

    @Override
    public Node getDescendantAt(int offset) {
        Node descendant = offset < super.getCharacterCount() ? super.getDescendantAt(offset) : this;
        return descendant;
    }

    @Override
    public Paragraph duplicate(boolean recursive) {
        return new Paragraph(this, recursive);
    }
}

