/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.types;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum PlcValueType {
    NULL(0, null),
    BOOL(1, Boolean.class),
    BYTE(2, Byte.class),
    WORD(3, Short.class),
    DWORD(4, Integer.class),
    LWORD(5, Long.class),
    USINT(17, Short.class),
    UINT(18, Integer.class),
    UDINT(19, Long.class),
    ULINT(20, BigInteger.class),
    SINT(33, Byte.class),
    INT(34, Short.class),
    DINT(35, Integer.class),
    LINT(36, Long.class),
    REAL(49, Float.class),
    LREAL(50, Double.class),
    CHAR(65, Character.class),
    WCHAR(66, Short.class),
    STRING(67, String.class),
    WSTRING(68, String.class),
    TIME(81, Duration.class),
    LTIME(82, Duration.class),
    DATE(83, LocalDate.class),
    LDATE(84, LocalDate.class),
    TIME_OF_DAY(85, LocalTime.class),
    LTIME_OF_DAY(86, LocalTime.class),
    DATE_AND_TIME(87, LocalDateTime.class),
    LDATE_AND_TIME(88, LocalDateTime.class),
    Struct(97, HashMap.class),
    List(98, ArrayList.class),
    RAW_BYTE_ARRAY(113, Byte.class);

    private static final Map<Short, PlcValueType> map;
    private final short value;
    private final Class<?> defaultJavaType;

    static {
        map = new HashMap<Short, PlcValueType>();
        PlcValueType[] plcValueTypeArray = PlcValueType.values();
        int n = plcValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlcValueType value = plcValueTypeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private PlcValueType(short value, Class<?> defaultJavaType) {
        this.value = value;
        this.defaultJavaType = defaultJavaType;
    }

    public short getValue() {
        return this.value;
    }

    public Class<?> getDefaultJavaType() {
        return this.defaultJavaType;
    }

    public static PlcValueType enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

